/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.init.data;

import cofh.lib.util.Utils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class BlockStateProviderCoFH
extends BlockStateProvider {
    public BlockStateProviderCoFH(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected String name(Supplier<? extends Block> block) {
        return Utils.getName(block.get());
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = Utils.getRegistryName(block.get());
        return new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block, String subfolder) {
        ResourceLocation base = Utils.getRegistryName(block.get());
        return new ResourceLocation(base.m_135827_(), "block/" + subfolder + "/" + base.m_135815_());
    }

    protected ResourceLocation modBlockLoc(String texture) {
        return this.modLoc("block/" + texture);
    }

    protected ResourceLocation modBlockLoc(String texture, String subfolder) {
        return this.modLoc("block/" + subfolder + "/" + texture);
    }

    protected ModelFile cubeAll(Supplier<? extends Block> block) {
        return this.cubeAll(block.get());
    }

    protected ModelFile cubeAll(Supplier<? extends Block> block, String subfolder) {
        return this.models().cubeAll(this.name(block), this.blockTexture(block, subfolder));
    }

    protected void simpleBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    protected void simpleBlock(Supplier<? extends Block> block, ModelFile model) {
        this.simpleBlock(block.get(), model);
    }

    protected void simpleBlock(Supplier<? extends Block> block, Function<ModelFile, ConfiguredModel[]> expander) {
        this.simpleBlock(block.get(), expander);
    }

    protected void axisBlock(Supplier<? extends Block> block, String texture) {
        this.axisBlock((RotatedPillarBlock)block.get(), this.modBlockLoc(texture));
    }

    protected void axisBlock(Supplier<? extends Block> block, String texture, String subfolder) {
        this.axisBlock((RotatedPillarBlock)block.get(), this.modBlockLoc(texture, subfolder));
    }

    protected void stairsBlock(Supplier<? extends StairBlock> block, String name) {
        this.stairsBlock(block, name, name);
    }

    protected void stairsBlock(Supplier<? extends StairBlock> block, String side, String topBottom) {
        this.stairsBlock(block.get(), this.modBlockLoc(side), this.modBlockLoc(topBottom), this.modBlockLoc(topBottom));
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab) {
        this.slabBlock(block, doubleslab, this.name(doubleslab));
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab, String texture) {
        this.slabBlock(block, doubleslab, texture, texture);
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab, String side, String end) {
        this.slabBlock(block.get(), Utils.getRegistryName(doubleslab.get()), this.modBlockLoc(side), this.modBlockLoc(end), this.modBlockLoc(end));
    }

    protected void doorBlock(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.modBlockLoc(this.name(block) + "_bottom"), this.modBlockLoc(this.name(block) + "_top"));
    }

    protected void trapdoorBlock(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.blockTexture(block), true);
    }
}

