/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.util;

import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.resource.util.TextureIndexes;

public class ResourceHelper {
    protected static String[] defNames = new String[]{"mob_littlemaid0.png", "mob_littlemaid1.png", "mob_littlemaid2.png", "mob_littlemaid3.png", "mob_littlemaid4.png", "mob_littlemaid5.png", "mob_littlemaid6.png", "mob_littlemaid7.png", "mob_littlemaid8.png", "mob_littlemaid9.png", "mob_littlemaida.png", "mob_littlemaidb.png", "mob_littlemaidc.png", "mob_littlemaidd.png", "mob_littlemaide.png", "mob_littlemaidf.png", "mob_littlemaidw.png", "mob_littlemaid_a00.png", "mob_littlemaid_a01.png"};
    private static final int OLD_WILD = 16;
    private static final int OLD_ARMOR_1 = 17;
    private static final int OLD_ARMOR_2 = 18;

    public static String getFileName(String path, boolean isArchive) {
        int lastSplitter;
        String name = path;
        if (!isArchive) {
            name = name.replace("\\", "/");
        }
        if ((lastSplitter = name.lastIndexOf("/")) == -1) {
            return name;
        }
        return name.substring(lastSplitter + 1);
    }

    public static Optional<String> getTexturePackName(String path, boolean isArchive) {
        String name = path;
        if (!isArchive) {
            name = name.replace("\\", "/");
        }
        if (path.contains("/littlemaid/") || path.contains("littleMaid")) {
            int lmFolderIndex = path.lastIndexOf("/littlemaid/");
            if (lmFolderIndex == -1) {
                lmFolderIndex = path.lastIndexOf("/littleMaid/");
            }
            if (lmFolderIndex == -1) {
                return ResourceHelper.getParentFolderName(path, isArchive);
            }
            int lastSplitter = (name = name.substring(lmFolderIndex + "/littlemaid/".length())).lastIndexOf("/");
            if (lastSplitter == -1) {
                return ResourceHelper.getParentFolderName(path, isArchive);
            }
            return Optional.of(name.substring(0, lastSplitter).replace("/", "."));
        }
        return ResourceHelper.getParentFolderName(path, isArchive);
    }

    public static String getModelName(String textureName) {
        int lastSplitter = textureName.lastIndexOf("_");
        if (lastSplitter == -1) {
            return "default";
        }
        textureName = textureName.substring(lastSplitter + 1);
        return textureName;
    }

    public static Optional<String> getParentFolderName(String path, boolean isArchive) {
        int lastSplitter;
        String name = path;
        if (!isArchive) {
            name = name.replace("\\", "/");
        }
        if ((lastSplitter = name.lastIndexOf("/")) == -1) {
            return Optional.empty();
        }
        if ((lastSplitter = (name = name.substring(0, lastSplitter)).lastIndexOf("/")) != -1) {
            name = name.substring(lastSplitter + 1);
        }
        return Optional.of(name);
    }

    public static int getIndex(String path) {
        int index = -1;
        for (int i = 0; i < defNames.length; ++i) {
            if (!path.endsWith(defNames[i])) continue;
            index = i;
            break;
        }
        if (index == -1) {
            String name = path.toLowerCase();
            int lastDot = name.lastIndexOf(".");
            if (lastDot == -1) {
                return -1;
            }
            int lastSplitter = (name = name.substring(0, lastDot)).lastIndexOf("_");
            if (lastSplitter == -1) {
                return -1;
            }
            name = name.substring(lastSplitter + 1);
            try {
                index = Integer.decode("0x" + name);
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (index == 17) {
            index = TextureIndexes.ARMOR_1_DAMAGED.getIndexMin();
        }
        if (index == 18) {
            index = TextureIndexes.ARMOR_2_DAMAGED.getIndexMin();
        }
        if (index == 16) {
            index = TextureIndexes.COLOR_WILD.getIndexMin() + TextureColors.BROWN.getIndex();
        }
        return index;
    }

    public static String removeNameLastIndex(String fileName) {
        String removed = fileName;
        while (!removed.isEmpty()) {
            int subLength = removed.length() - 1;
            String temp = removed.substring(subLength);
            try {
                Integer.valueOf(temp);
            }
            catch (NumberFormatException e) {
                break;
            }
            removed = removed.substring(0, subLength);
        }
        return removed;
    }

    public static String removeExtension(String fileName) {
        int lastSplitter = fileName.lastIndexOf(".");
        if (lastSplitter == -1) {
            return fileName;
        }
        return fileName.substring(0, lastSplitter);
    }

    public static Optional<String> getFirstParentName(String path, Path homePath, boolean isArchive) {
        if (isArchive) {
            String zipName = homePath.getFileName().toString();
            return Optional.of(zipName.substring(0, zipName.lastIndexOf(".")));
        }
        int firstSplitter = (path = path.substring(1)).indexOf("\\");
        if (firstSplitter == -1) {
            return Optional.empty();
        }
        return Optional.of(path.substring(0, firstSplitter));
    }

    public static ResourceLocation getLocation(String packName, String fileName) {
        packName = packName.toLowerCase().replaceAll("[^a-z0-9/._\\-]", "-");
        fileName = fileName.toLowerCase().replaceAll("[^a-z0-9/._\\-]", "-");
        return new ResourceLocation("littlemaidmodelloader", packName + "/" + fileName);
    }

    public static ResourceLocation getLocation(String prefix, String packName, String fileName) {
        packName = packName.toLowerCase().replaceAll("[^a-z0-9/._\\-]", "-");
        fileName = fileName.toLowerCase().replaceAll("[^a-z0-9/._\\-]", "-");
        return new ResourceLocation("littlemaidmodelloader", prefix + "/" + packName + "/" + fileName);
    }
}

