/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;

public class ArmorSets<T> {
    private final Object[] parts = new Object[4];

    public void setArmor(T type, IHasMultiModel.Part part) {
        this.parts[part.getIndex()] = type;
    }

    public Optional<T> getArmor(IHasMultiModel.Part part) {
        return Optional.ofNullable(this.parts[part.getIndex()]);
    }

    public <M> ArmorSets<M> convert(Function<T, M> converter) {
        ArmorSets armorSets = new ArmorSets();
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            this.getArmor(part).ifPresent(type -> armorSets.setArmor(converter.apply(type), part));
        }
        return armorSets;
    }

    public void foreach(BiConsumer<IHasMultiModel.Part, T> consumer) {
        Object[] parts = this.parts;
        if (parts[0] != null) {
            consumer.accept(IHasMultiModel.Part.FEET, (IHasMultiModel.Part)((Object)parts[0]));
        }
        if (parts[1] != null) {
            consumer.accept(IHasMultiModel.Part.LEGS, (IHasMultiModel.Part)((Object)parts[1]));
        }
        if (parts[2] != null) {
            consumer.accept(IHasMultiModel.Part.BODY, (IHasMultiModel.Part)((Object)parts[2]));
        }
        if (parts[3] != null) {
            consumer.accept(IHasMultiModel.Part.HEAD, (IHasMultiModel.Part)((Object)parts[3]));
        }
    }

    public void clear() {
        this.parts[0] = null;
        this.parts[1] = null;
        this.parts[2] = null;
        this.parts[3] = null;
    }

    public boolean isEmpty() {
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            if (!this.getArmor(part).isPresent()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArmorSets that = (ArmorSets)o;
        return Arrays.equals(this.parts, that.parts);
    }

    public int hashCode() {
        return Arrays.hashCode(this.parts);
    }
}

