/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.manager;

import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.sistr.littlemaidmodelloader.LMMLMod;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.util.ResourceHelper;
import net.sistr.littlemaidmodelloader.resource.util.TextureIndexes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMTextureManager {
    public static final LMTextureManager INSTANCE = new LMTextureManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, TextureHolder> textures = new HashMap<String, TextureHolder>();

    public void addTexture(String fileName, String textureName, String modelName, int index, ResourceLocation texturePath) {
        TextureHolder textureHolder = this.textures.computeIfAbsent(textureName.toLowerCase(), k -> new TextureHolder(textureName, modelName));
        if (TextureIndexes.getTextureIndexes(index).isArmor()) {
            textureHolder.addArmorTexture(this.getArmorName(fileName), index, texturePath);
        } else {
            textureHolder.addTexture(index, texturePath);
        }
        if (LMMLMod.getConfig().isDebugMode()) {
            LOGGER.debug("Loaded Texture : " + String.valueOf(texturePath));
        }
    }

    public String getArmorName(String fileName) {
        String name = fileName.substring(0, fileName.indexOf(95));
        if (name.contains("chainmail")) {
            return name;
        }
        return name.replace("chain", "chainmail");
    }

    public Optional<TextureHolder> getTexture(String textureName) {
        TextureHolder textureHolder = this.textures.get(textureName.toLowerCase());
        if (Platform.getEnv() == Dist.DEDICATED_SERVER && textureHolder == null) {
            TextureHolder serverHolder = new TextureHolder(textureName, ResourceHelper.getModelName(textureName));
            this.textures.put(textureName.toLowerCase(), serverHolder);
            return Optional.of(serverHolder);
        }
        return Optional.ofNullable(textureHolder);
    }

    public Collection<TextureHolder> getAllTextures() {
        return this.textures.values();
    }
}

