/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.manager;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;

public class LMConfigManager {
    public static final LMConfigManager INSTANCE = new LMConfigManager();
    public static final ConfigHolder EMPTY_CONFIG = new ConfigHolder("empty", "", "", (Map<String, String>)ImmutableMap.of());
    private final Map<String, ConfigHolder> configs = new HashMap<String, ConfigHolder>();

    public void addConfig(String packName, String parentName, String fileName, Map<String, String> settings) {
        ConfigHolder config = new ConfigHolder(packName, parentName, fileName, settings);
        this.configs.put(config.getName().toLowerCase(), config);
    }

    public Optional<ConfigHolder> getConfig(String configName) {
        return Optional.ofNullable(this.configs.get(configName.toLowerCase()));
    }

    public Optional<ConfigHolder> getTextureSoundConfig(String texturePackName) {
        return this.configs.values().stream().filter(configHolder -> configHolder.getFileName().equalsIgnoreCase(texturePackName)).findAny();
    }

    public ConfigHolder getAnyConfig() {
        List<ConfigHolder> configHolderList = this.configs.values().stream().filter(configHolder -> configHolder.getFileName().equalsIgnoreCase("littlemaidmob")).toList();
        if (configHolderList.isEmpty()) {
            return EMPTY_CONFIG;
        }
        return configHolderList.get(ThreadLocalRandom.current().nextInt(configHolderList.size()));
    }

    public List<ConfigHolder> getAllConfig() {
        List<ConfigHolder> list = this.configs.values().stream().sorted(Comparator.comparing(ConfigHolder::getName, String::compareTo)).collect(Collectors.toList());
        list.add(EMPTY_CONFIG);
        return list;
    }
}

