/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.multimodel.layer;

import com.google.common.collect.ImmutableBiMap;
import net.minecraft.world.entity.Pose;

public class MMPose {
    private static final ImmutableBiMap<Pose, MMPose> POSE_MAP;
    public static final MMPose STANDING;
    public static final MMPose FALL_FLYING;
    public static final MMPose SLEEPING;
    public static final MMPose SWIMMING;
    public static final MMPose SPIN_ATTACK;
    public static final MMPose CROUCHING;
    public static final MMPose DYING;
    private final String name;

    public MMPose(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static MMPose convertPose(Pose pose) {
        return (MMPose)POSE_MAP.getOrDefault((Object)pose, (Object)STANDING);
    }

    public static Pose convertPose(MMPose pose) {
        return (Pose)POSE_MAP.inverse().getOrDefault((Object)pose, (Object)Pose.STANDING);
    }

    static {
        STANDING = new MMPose("Standing");
        FALL_FLYING = new MMPose("FallFlying");
        SLEEPING = new MMPose("Sleeping");
        SWIMMING = new MMPose("Swimming");
        SPIN_ATTACK = new MMPose("SpinAttack");
        CROUCHING = new MMPose("Crouching");
        DYING = new MMPose("Dying");
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        builder.put((Object)Pose.STANDING, (Object)STANDING);
        builder.put((Object)Pose.FALL_FLYING, (Object)FALL_FLYING);
        builder.put((Object)Pose.SLEEPING, (Object)SLEEPING);
        builder.put((Object)Pose.SWIMMING, (Object)SWIMMING);
        builder.put((Object)Pose.SPIN_ATTACK, (Object)SPIN_ATTACK);
        builder.put((Object)Pose.CROUCHING, (Object)CROUCHING);
        builder.put((Object)Pose.DYING, (Object)DYING);
        POSE_MAP = builder.build();
    }
}

