/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.maidmodel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.Constructor;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.maidmodel.ModelBase;
import net.sistr.littlemaidmodelloader.maidmodel.ModelBox;
import net.sistr.littlemaidmodelloader.maidmodel.ModelBoxBase;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMultiBase;
import net.sistr.littlemaidmodelloader.maidmodel.ModelPlate;
import net.sistr.littlemaidmodelloader.maidmodel.compat.GLCompat;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMMatrixStack;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMVertexConsumer;
import org.lwjgl.BufferUtils;

public class ModelRenderer {
    public float scale = 0.0625f;
    public static PoseStack matrixStack;
    public static VertexConsumer buffer;
    public static int light;
    public static int overlay;
    public static float red;
    public static float green;
    public static float blue;
    public static float alpha;
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    protected boolean compiled = false;
    protected int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean isHidden = false;
    public boolean isRendering = true;
    public List<ModelBoxBase> cubeList = new ArrayList<ModelBoxBase>();
    public List<ModelRenderer> childModels;
    public final String boxName;
    protected ModelBase baseModel;
    public ModelRenderer pearent;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public static final float radFactor = 57.295776f;
    public static final float degFactor = (float)Math.PI / 180;
    public int rotatePriority;
    public static final int RotXYZ = 0;
    public static final int RotXZY = 1;
    public static final int RotYXZ = 2;
    public static final int RotYZX = 3;
    public static final int RotZXY = 4;
    public static final int RotZYX = 5;
    protected ItemStack itemstack;
    public boolean adjust;
    public FloatBuffer matrix;
    public boolean isInvertX;

    public static void setParam(MMMatrixStack matrixStack, MMVertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha) {
        ModelRenderer.matrixStack = matrixStack.getVanillaMatrixStack();
        ModelRenderer.buffer = buffer.getVanillaVertexConsumer();
        ModelRenderer.light = light;
        ModelRenderer.overlay = overlay;
        ModelRenderer.red = red;
        ModelRenderer.green = green;
        ModelRenderer.blue = blue;
        ModelRenderer.alpha = alpha;
    }

    public ModelRenderer(ModelBase pModelBase, String pName) {
        this.baseModel = pModelBase;
        pModelBase.boxList.add(this);
        this.boxName = pName;
        this.setTextureSize(pModelBase.textureWidth, pModelBase.textureHeight);
        this.rotatePriority = 0;
        this.itemstack = null;
        this.adjust = true;
        this.matrix = BufferUtils.createFloatBuffer((int)16);
        this.isInvertX = false;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.pearent = null;
    }

    public ModelRenderer(ModelBase pModelBase, int px, int py) {
        this(pModelBase, null);
        this.setTextureOffset(px, py);
    }

    public ModelRenderer(ModelBase pModelBase) {
        this(pModelBase, null);
    }

    public ModelRenderer(ModelBase pModelBase, int px, int py, float pScaleX, float pScaleY, float pScaleZ) {
        this(pModelBase, px, py);
        this.scaleX = pScaleX;
        this.scaleY = pScaleY;
        this.scaleZ = pScaleZ;
    }

    public ModelRenderer(ModelBase pModelBase, float pScaleX, float pScaleY, float pScaleZ) {
        this(pModelBase);
        this.scaleX = pScaleX;
        this.scaleY = pScaleY;
        this.scaleZ = pScaleZ;
    }

    public void addChild(ModelRenderer pModelRenderer) {
        if (this.childModels == null) {
            this.childModels = new ArrayList<ModelRenderer>();
        }
        this.childModels.add(pModelRenderer);
        pModelRenderer.pearent = this;
    }

    public ModelRenderer setTextureOffset(int pOffsetX, int pOffsetY) {
        this.textureOffsetX = pOffsetX;
        this.textureOffsetY = pOffsetY;
        return this;
    }

    public ModelRenderer addBox(String pName, float pX, float pY, float pZ, int pWidth, int pHeight, int pDepth) {
        this.addParts(ModelBox.class, pName, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pDepth, Float.valueOf(0.0f));
        return this;
    }

    public ModelRenderer addBox(float pX, float pY, float pZ, int pWidth, int pHeight, int pDepth) {
        this.addParts(ModelBox.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pDepth, Float.valueOf(0.0f));
        return this;
    }

    public ModelRenderer addBox(float pX, float pY, float pZ, int pWidth, int pHeight, int pDepth, float pSizeAdjust) {
        this.addParts(ModelBox.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pDepth, Float.valueOf(pSizeAdjust));
        return this;
    }

    public ModelRenderer setRotationPoint(float pX, float pY, float pZ) {
        this.rotationPointX = pX;
        this.rotationPointY = pY;
        this.rotationPointZ = pZ;
        return this;
    }

    public void render(float par1, boolean pIsRender) {
        GLCompat.modelRenderer = this;
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(par1);
        }
        GLCompat.glPushMatrix();
        GLCompat.glTranslatef(this.offsetX, this.offsetY, this.offsetZ);
        if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GLCompat.glTranslatef(this.rotationPointX * par1, this.rotationPointY * par1, this.rotationPointZ * par1);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            this.setRotation();
        }
        this.renderObject(par1, pIsRender);
        GLCompat.glPopMatrix();
    }

    public void render(float par1) {
        this.render(par1, true);
    }

    public void renderWithRotation(float par1) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(par1);
        }
        GLCompat.glPushMatrix();
        GLCompat.glTranslatef(this.rotationPointX * par1, this.rotationPointY * par1, this.rotationPointZ * par1);
        this.setRotation();
        GLCompat.glCallList(this.displayList);
        GLCompat.glPopMatrix();
    }

    public void postRender(float par1) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(par1);
        }
        if (this.pearent != null) {
            this.pearent.postRender(par1);
        }
        GLCompat.glTranslatef(this.offsetX, this.offsetY, this.offsetZ);
        if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GLCompat.glTranslatef(this.rotationPointX * par1, this.rotationPointY * par1, this.rotationPointZ * par1);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            this.setRotation();
        }
    }

    protected void compileDisplayList(float par1) {
        this.compiled = true;
        this.scale = par1;
    }

    public ModelRenderer setTextureSize(int pWidth, int pHeight) {
        this.textureWidth = pWidth;
        this.textureHeight = pHeight;
        return this;
    }

    public ModelRenderer addCubeList(ModelBoxBase pModelBoxBase) {
        this.cubeList.add(pModelBoxBase);
        return this;
    }

    protected ModelBoxBase getModelBoxBase(Class<? extends ModelBoxBase> pModelBoxBase, Object ... pArg) {
        try {
            Constructor<? extends ModelBoxBase> lconstructor = pModelBoxBase.getConstructor(ModelRenderer.class, Object[].class);
            return lconstructor.newInstance(this, pArg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object[] getArg(Object ... pArg) {
        Object[] lobject = new Object[pArg.length + 2];
        lobject[0] = this.textureOffsetX;
        lobject[1] = this.textureOffsetY;
        System.arraycopy(pArg, 0, lobject, 2, pArg.length);
        return lobject;
    }

    public ModelRenderer addParts(Class<? extends ModelBoxBase> pModelBoxBase, String pName, Object ... pArg) {
        pName = this.boxName + "." + (String)pName;
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, this.getArg(pArg)).setBoxName((String)pName));
        return this;
    }

    public ModelRenderer addParts(Class<? extends ModelBoxBase> pModelBoxBase, Object ... pArg) {
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, this.getArg(pArg)));
        return this;
    }

    public ModelRenderer addPartsTexture(Class<? extends ModelBoxBase> pModelBoxBase, String pName, Object ... pArg) {
        pName = this.boxName + "." + (String)pName;
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, pArg).setBoxName((String)pName));
        return this;
    }

    public ModelRenderer addPartsTexture(Class<? extends ModelBoxBase> pModelBoxBase, Object ... pArg) {
        this.addCubeList(this.getModelBoxBase(pModelBoxBase, pArg));
        return this;
    }

    public ModelRenderer addPlate(float pX, float pY, float pZ, int pWidth, int pHeight, int pFacePlane) {
        this.addParts(ModelPlate.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pFacePlane, Float.valueOf(0.0f));
        return this;
    }

    public ModelRenderer addPlate(float pX, float pY, float pZ, int pWidth, int pHeight, int pFacePlane, float pSizeAdjust) {
        this.addParts(ModelPlate.class, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pFacePlane, Float.valueOf(pSizeAdjust));
        return this;
    }

    public ModelRenderer addPlate(String pName, float pX, float pY, float pZ, int pWidth, int pHeight, int pFacePlane) {
        this.addParts(ModelPlate.class, pName, Float.valueOf(pX), Float.valueOf(pY), Float.valueOf(pZ), pWidth, pHeight, pFacePlane, Float.valueOf(0.0f));
        return this;
    }

    public void clearCubeList() {
        this.cubeList.clear();
        this.compiled = false;
        if (this.childModels != null) {
            this.childModels.clear();
        }
    }

    public boolean renderItems(ModelMultiBase pModelMulti, IModelCaps pEntityCaps, boolean pRealBlock, int pIndex) {
        return true;
    }

    public void renderItemsHead(ModelMultiBase pModelMulti, IModelCaps pEntityCaps) {
    }

    public void setRotatePriority(int pValue) {
        this.rotatePriority = pValue;
    }

    protected void setRotation() {
        switch (this.rotatePriority) {
            case 0: {
                if (this.rotateAngleZ != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252403_.m_252961_(this.rotateAngleZ));
                }
                if (this.rotateAngleY != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252436_.m_252961_(this.rotateAngleY));
                }
                if (this.rotateAngleX == 0.0f) break;
                matrixStack.m_252781_(Axis.f_252529_.m_252961_(this.rotateAngleX));
                break;
            }
            case 1: {
                if (this.rotateAngleY != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252436_.m_252961_(this.rotateAngleY));
                }
                if (this.rotateAngleZ != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252403_.m_252961_(this.rotateAngleZ));
                }
                if (this.rotateAngleX == 0.0f) break;
                matrixStack.m_252781_(Axis.f_252529_.m_252961_(this.rotateAngleX));
                break;
            }
            case 2: {
                if (this.rotateAngleZ != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252403_.m_252961_(this.rotateAngleZ));
                }
                if (this.rotateAngleX != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252961_(this.rotateAngleX));
                }
                if (this.rotateAngleY == 0.0f) break;
                matrixStack.m_252781_(Axis.f_252436_.m_252961_(this.rotateAngleY));
                break;
            }
            case 3: {
                if (this.rotateAngleX != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252961_(this.rotateAngleX));
                }
                if (this.rotateAngleZ != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252403_.m_252961_(this.rotateAngleZ));
                }
                if (this.rotateAngleY == 0.0f) break;
                matrixStack.m_252781_(Axis.f_252436_.m_252961_(this.rotateAngleY));
                break;
            }
            case 4: {
                if (this.rotateAngleY != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252436_.m_252961_(this.rotateAngleY));
                }
                if (this.rotateAngleX != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252961_(this.rotateAngleX));
                }
                if (this.rotateAngleZ == 0.0f) break;
                matrixStack.m_252781_(Axis.f_252403_.m_252961_(this.rotateAngleZ));
                break;
            }
            case 5: {
                if (this.rotateAngleX != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252961_(this.rotateAngleX));
                }
                if (this.rotateAngleY != 0.0f) {
                    matrixStack.m_252781_(Axis.f_252436_.m_252961_(this.rotateAngleY));
                }
                if (this.rotateAngleZ == 0.0f) break;
                matrixStack.m_252781_(Axis.f_252403_.m_252961_(this.rotateAngleZ));
            }
        }
    }

    protected void renderObject(float par1, boolean pRendering) {
        GLCompat.glGetFloat(2982, this.matrix);
        if (pRendering && this.isRendering) {
            GLCompat.glPushMatrix();
            GLCompat.glScalef(this.scaleX, this.scaleY, this.scaleZ);
            GLCompat.glCallList(this.displayList);
            GLCompat.glPopMatrix();
        }
        if (this.childModels != null) {
            for (ModelRenderer childModel : this.childModels) {
                childModel.render(par1, pRendering);
            }
        }
    }

    public ModelRenderer loadMatrix() {
        GLCompat.glLoadMatrix(this.matrix);
        if (this.isInvertX) {
            GLCompat.glScalef(-1.0f, 1.0f, 1.0f);
        }
        return this;
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public ModelRenderer setMirror(boolean flag) {
        this.mirror = flag;
        return this;
    }

    public boolean getVisible() {
        return this.showModel;
    }

    public void setVisible(boolean flag) {
        this.showModel = flag;
    }

    public float getRotateAngleX() {
        return this.rotateAngleX;
    }

    public float getRotateAngleDegX() {
        return this.rotateAngleX * 57.295776f;
    }

    public float setRotateAngleX(float value) {
        this.rotateAngleX = value;
        return this.rotateAngleX;
    }

    public float setRotateAngleDegX(float value) {
        this.rotateAngleX = value * ((float)Math.PI / 180);
        return this.rotateAngleX;
    }

    public float addRotateAngleX(float value) {
        return this.rotateAngleX += value;
    }

    public float addRotateAngleDegX(float value) {
        return this.rotateAngleX += value * ((float)Math.PI / 180);
    }

    public float getRotateAngleY() {
        return this.rotateAngleY;
    }

    public float getRotateAngleDegY() {
        return this.rotateAngleY * 57.295776f;
    }

    public float setRotateAngleY(float value) {
        this.rotateAngleY = value;
        return this.rotateAngleY;
    }

    public float setRotateAngleDegY(float value) {
        this.rotateAngleY = value * ((float)Math.PI / 180);
        return this.rotateAngleY;
    }

    public float addRotateAngleY(float value) {
        return this.rotateAngleY += value;
    }

    public float addRotateAngleDegY(float value) {
        return this.rotateAngleY += value * ((float)Math.PI / 180);
    }

    public float getRotateAngleZ() {
        return this.rotateAngleZ;
    }

    public float getRotateAngleDegZ() {
        return this.rotateAngleZ * 57.295776f;
    }

    public float setRotateAngleZ(float value) {
        this.rotateAngleZ = value;
        return this.rotateAngleZ;
    }

    public float setRotateAngleDegZ(float value) {
        this.rotateAngleZ = value * ((float)Math.PI / 180);
        return this.rotateAngleZ;
    }

    public float addRotateAngleZ(float value) {
        return this.rotateAngleZ += value;
    }

    public float addRotateAngleDegZ(float value) {
        return this.rotateAngleZ += value * ((float)Math.PI / 180);
    }

    public ModelRenderer setRotateAngle(float x, float y, float z) {
        this.rotateAngleX = x;
        this.rotateAngleY = y;
        this.rotateAngleZ = z;
        return this;
    }

    public ModelRenderer setRotateAngleDeg(float x, float y, float z) {
        this.rotateAngleX = x * ((float)Math.PI / 180);
        this.rotateAngleY = y * ((float)Math.PI / 180);
        this.rotateAngleZ = z * ((float)Math.PI / 180);
        return this;
    }

    public float getRotationPointX() {
        return this.rotationPointX;
    }

    public float setRotationPointX(float value) {
        this.rotationPointX = value;
        return this.rotationPointX;
    }

    public float addRotationPointX(float value) {
        return this.rotationPointX += value;
    }

    public float getRotationPointY() {
        return this.rotationPointY;
    }

    public float setRotationPointY(float value) {
        this.rotationPointY = value;
        return this.rotationPointY;
    }

    public float addRotationPointY(float value) {
        return this.rotationPointY += value;
    }

    public float getRotationPointZ() {
        return this.rotationPointZ;
    }

    public float setRotationPointZ(float value) {
        this.rotationPointZ = value;
        return this.rotationPointZ;
    }

    public float addRotationPointZ(float value) {
        return this.rotationPointZ += value;
    }

    public ModelRenderer setScale(float pX, float pY, float pZ) {
        this.scaleX = pX;
        this.scaleY = pY;
        this.scaleZ = pZ;
        return this;
    }

    public float setScaleX(float pValue) {
        this.scaleX = pValue;
        return this.scaleX;
    }

    public float setScaleY(float pValue) {
        this.scaleY = pValue;
        return this.scaleY;
    }

    public float setScaleZ(float pValue) {
        this.scaleZ = pValue;
        return this.scaleZ;
    }
}

