/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.maidmodel;

import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.maidmodel.ModelBase;
import net.sistr.littlemaidmodelloader.maidmodel.ModelCapsHelper;
import net.sistr.littlemaidmodelloader.maidmodel.ModelRenderer;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMMatrixStack;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMPose;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMRenderContext;

public abstract class ModelMultiBase
extends ModelBase
implements IModelCaps,
IMultiModel {
    public float[] heldItem = new float[]{0.0f, 0.0f};
    public boolean aimedBow = false;
    public boolean isSneak = false;
    public boolean isWait;
    public ModelRenderer mainFrame;
    public ModelRenderer HeadMount;
    public ModelRenderer HeadTop;
    public ModelRenderer[] Arms;
    public ModelRenderer[] HardPoint;
    public float entityIdFactor;
    public int entityTicksExisted;
    public float scaleFactor = 0.9375f;
    private final Map<String, Integer> fcapsmap = new HashMap<String, Integer>(){
        {
            this.put("onGround", 1);
            this.put("isRiding", 2);
            this.put("isSneak", 19);
            this.put("isWait", 263);
            this.put("isChild", 3);
            this.put("heldItemLeft", 16);
            this.put("heldItemRight", 17);
            this.put("aimedBow", 20);
            this.put("ScaleFactor", 512);
            this.put("entityIdFactor", 288);
            this.put("dominantArm", 293);
        }
    };
    private IModelCaps caps;
    private float limbSwing;
    private float limbSwingAmount;
    private float ageInTicks;
    private float netHeadYaw;
    private float headPitch;

    public ModelMultiBase() {
        this(0.0f);
    }

    public ModelMultiBase(float pSizeAdjust) {
        this(pSizeAdjust, 0.0f, 64, 32);
    }

    public ModelMultiBase(float pSizeAdjust, float pYOffset, int pTextureWidth, int pTextureHeight) {
        this.textureWidth = pTextureWidth;
        this.textureHeight = pTextureHeight;
        if (Platform.getEnv() == Dist.CLIENT) {
            this.Arms = new ModelRenderer[2];
            this.HeadMount = new ModelRenderer(this, "HeadMount");
            this.HeadTop = new ModelRenderer(this, "HeadTop");
            this.initModel(pSizeAdjust, pYOffset);
        }
    }

    @Override
    public void setupTransform(IModelCaps caps, MMMatrixStack matrices, float animationProgress, float bodyYaw, float tickDelta) {
        float leaningPitch = ModelCapsHelper.getCapsValueFloat(caps, 1538, new Object[0]);
        if (ModelCapsHelper.getCapsValueBoolean(caps, 1541, new Object[0])) {
            float roll = (float)ModelCapsHelper.getCapsValueInt(caps, 1537, new Object[0]) + tickDelta;
            float k = Mth.m_14036_((float)(roll * roll / 100.0f), (float)0.0f, (float)1.0f);
            if (!ModelCapsHelper.getCapsValueBoolean(caps, 1540, new Object[0])) {
                matrices.rotateXDeg(k * (-90.0f - ModelCapsHelper.getCapsValueFloat(caps, 106, new Object[0])));
            }
            Vec3 lookFor = this.getRotationVec(caps, tickDelta);
            Vec3 velocity = new Vec3(ModelCapsHelper.getCapsValueDouble(caps, 100, new Object[0]), ModelCapsHelper.getCapsValueDouble(caps, 101, new Object[0]), ModelCapsHelper.getCapsValueDouble(caps, 102, new Object[0]));
            double d = velocity.m_165925_();
            double e = lookFor.m_165925_();
            if (d > 0.0 && e > 0.0) {
                double l = (velocity.f_82479_ * lookFor.f_82479_ + velocity.f_82481_ * lookFor.f_82481_) / Math.sqrt(d * e);
                double m = velocity.f_82479_ * lookFor.f_82481_ - velocity.f_82481_ * lookFor.f_82479_;
                matrices.rotateYRad((float)(Math.signum(m) * Math.acos(l)));
            }
        } else if (leaningPitch > 0.0f) {
            float roll = ModelCapsHelper.getCapsValueBoolean(caps, 55, new Object[0]) ? -90.0f - ModelCapsHelper.getCapsValueFloat(caps, 106, new Object[0]) : -90.0f;
            float k = Mth.m_14179_((float)leaningPitch, (float)0.0f, (float)roll);
            matrices.rotateXDeg(k);
            if (ModelCapsHelper.getCapsValueBoolean(caps, 1536, new Object[0])) {
                matrices.translate(0.0, -1.0, 0.3);
            }
        }
    }

    private Vec3 getRotationVec(IModelCaps caps, float tickDelta) {
        float yaw = ModelCapsHelper.getCapsValueFloat(caps, 105, new Object[0]);
        float prevYaw = ModelCapsHelper.getCapsValueFloat(caps, 107, new Object[0]);
        float pitch = ModelCapsHelper.getCapsValueFloat(caps, 106, new Object[0]);
        float prevPitch = ModelCapsHelper.getCapsValueFloat(caps, 108, new Object[0]);
        return this.getRotationVector(Mth.m_14179_((float)tickDelta, (float)prevPitch, (float)pitch), Mth.m_14179_((float)tickDelta, (float)prevYaw, (float)yaw));
    }

    private Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    @Override
    public void animateModel(IModelCaps caps, float limbAngle, float limbDistance, float tickDelta) {
        this.setLivingAnimations(caps, limbAngle, limbDistance, tickDelta);
    }

    @Override
    public void setAngles(IModelCaps caps, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.caps = caps;
        this.limbSwing = limbAngle;
        this.limbSwingAmount = limbDistance;
        this.ageInTicks = animationProgress;
        this.netHeadYaw = headYaw;
        this.headPitch = headPitch;
        this.setRotationAngles(limbAngle, limbDistance, animationProgress, headYaw, headPitch, 0.0625f, caps);
    }

    @Override
    public void render(MMRenderContext context) {
        context.render(ModelRenderer::setParam);
        this.render(this.caps, this.limbSwing, this.limbSwingAmount, this.ageInTicks, this.netHeadYaw, this.headPitch, 0.0625f, true);
    }

    @Override
    public void adjustHandItem(MMMatrixStack matrices, boolean isLeft) {
        ModelRenderer.matrixStack = matrices.getVanillaMatrixStack();
        this.Arms[isLeft ? 1 : 0].postRender(0.0625f);
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    public float getInnerArmorSize() {
        return this.getArmorModelsSize()[0];
    }

    @Override
    public float getOuterArmorSize() {
        return this.getArmorModelsSize()[1];
    }

    public float getEyeHeight(IModelCaps caps) {
        return this.getEyeHeight(caps, MMPose.STANDING);
    }

    @Override
    public float getEyeHeight(IModelCaps caps, MMPose pose) {
        return this.getHeight(caps, pose) * 0.85f;
    }

    public abstract void initModel(float var1, float var2);

    public String getUsingTexture() {
        return null;
    }

    @Deprecated
    public abstract float getHeight();

    public float getHeight(IModelCaps pEntityCaps) {
        return this.getHeight();
    }

    @Override
    public float getHeight(IModelCaps pEntityCaps, MMPose pose) {
        if (pose == MMPose.FALL_FLYING || pose == MMPose.SWIMMING || pose == MMPose.SPIN_ATTACK) {
            return Math.min(this.getHeight(pEntityCaps), this.getWidth(pEntityCaps, pose));
        }
        if (pose == MMPose.SLEEPING || pose == MMPose.DYING) {
            return 0.2f;
        }
        if (pose == MMPose.CROUCHING) {
            return Math.max(0.2f, this.getHeight(pEntityCaps) - 0.3f);
        }
        return this.getHeight(pEntityCaps);
    }

    @Deprecated
    public abstract float getWidth();

    public float getWidth(IModelCaps pEntityCaps) {
        return this.getWidth();
    }

    @Override
    public float getWidth(IModelCaps pEntityCaps, MMPose pose) {
        if (pose == MMPose.SLEEPING || pose == MMPose.DYING) {
            return 0.2f;
        }
        return this.getWidth();
    }

    @Deprecated
    public abstract float getyOffset();

    @Override
    public float getyOffset(IModelCaps pEntityCaps) {
        return this.getyOffset();
    }

    @Deprecated
    public abstract float getMountedYOffset();

    @Override
    public float getMountedYOffset(IModelCaps pEntityCaps) {
        return this.getMountedYOffset();
    }

    @Override
    public float getLeashOffset(IModelCaps pEntityCaps) {
        return 0.4f;
    }

    @Deprecated
    public boolean isItemHolder() {
        return false;
    }

    public boolean isItemHolder(IModelCaps pEntityCaps) {
        return this.isItemHolder();
    }

    public void showAllParts() {
    }

    @Override
    public void showAllParts(IModelCaps pEntityCaps) {
        this.showAllParts();
    }

    @Override
    public int showArmorParts(int parts, int index) {
        return -1;
    }

    @Override
    public abstract void renderItems(IModelCaps var1);

    @Override
    public abstract void renderFirstPersonHand(IModelCaps var1);

    @Override
    public Map<String, Integer> getModelCaps() {
        return this.fcapsmap;
    }

    @Override
    public Object getCapsValue(int pIndex, Object ... pArg) {
        switch (pIndex) {
            case 1: {
                return this.onGrounds;
            }
            case 2: {
                return this.isRiding;
            }
            case 19: {
                return this.isSneak;
            }
            case 263: {
                return this.isWait;
            }
            case 3: {
                return this.isChild;
            }
            case 16: {
                return Float.valueOf(this.heldItem[1]);
            }
            case 17: {
                return Float.valueOf(this.heldItem[0]);
            }
            case 20: {
                return this.aimedBow;
            }
            case 288: {
                return Float.valueOf(this.entityIdFactor);
            }
            case 34: {
                return this.entityTicksExisted;
            }
            case 512: {
                return Float.valueOf(this.scaleFactor);
            }
            case 293: {
                return this.dominantArm;
            }
            case 1025: {
                return this.motionSitting;
            }
        }
        return null;
    }

    @Override
    public boolean setCapsValue(int pIndex, Object ... pArg) {
        switch (pIndex) {
            case 1: {
                for (int li = 0; li < this.onGrounds.length && li < pArg.length; ++li) {
                    this.onGrounds[li] = ((Float)pArg[li]).floatValue();
                }
                return true;
            }
            case 2: {
                this.isRiding = (Boolean)pArg[0];
                return true;
            }
            case 19: {
                this.isSneak = (Boolean)pArg[0];
                return true;
            }
            case 263: {
                this.isWait = (Boolean)pArg[0];
                return true;
            }
            case 3: {
                this.isChild = (Boolean)pArg[0];
                return true;
            }
            case 16: {
                this.heldItem[1] = pArg[0] instanceof Float ? ((Float)pArg[0]).floatValue() : 0.0f;
                return true;
            }
            case 17: {
                this.heldItem[0] = pArg[0] instanceof Float ? ((Float)pArg[0]).floatValue() : 0.0f;
                return true;
            }
            case 20: {
                this.aimedBow = (Boolean)pArg[0];
                return true;
            }
            case 288: {
                this.entityIdFactor = ((Float)pArg[0]).floatValue();
                return true;
            }
            case 34: {
                this.entityTicksExisted = (Integer)pArg[0];
                return true;
            }
            case 512: {
                this.scaleFactor = ((Float)pArg[0]).floatValue();
                return true;
            }
            case 293: {
                this.dominantArm = (Integer)pArg[0];
                return true;
            }
            case 1025: {
                this.motionSitting = (Boolean)pArg[0];
                return true;
            }
        }
        return false;
    }

    public static float mh_sqrt_float(float f) {
        return Mth.m_14116_((float)f);
    }

    public static float mh_sqrt_double(double d) {
        return Mth.m_14116_((float)((float)d));
    }

    public static int mh_floor_float(float f) {
        return Mth.m_14143_((float)f);
    }

    public static int mh_floor_double(double d) {
        return Mth.m_14107_((double)d);
    }

    public static long mh_floor_double_long(double d) {
        return Mth.m_14107_((double)d);
    }
}

