/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.maidmodel;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMPose;

public class EntityCaps
implements IModelCaps {
    protected static final Setter EMPTY_SETTER = (entity, arg) -> false;
    private static final Map<String, Integer> caps = new HashMap<String, Integer>();
    private static final Int2ObjectOpenHashMap<Getter> capGetter = new Int2ObjectOpenHashMap();
    private static final Int2ObjectOpenHashMap<Setter> capSetter = new Int2ObjectOpenHashMap();
    protected LivingEntity owner;

    private static void register(String name, int index, Getter getter) {
        EntityCaps.register(name, index, getter, EMPTY_SETTER);
    }

    private static void register(String name, int index, Getter getter, Setter setter) {
        caps.putIfAbsent(name, index);
        capGetter.put(index, (Object)getter);
        capSetter.put(index, (Object)setter);
    }

    public EntityCaps(LivingEntity pOwner) {
        this.owner = pOwner;
    }

    @Override
    public Map<String, Integer> getModelCaps() {
        return caps;
    }

    @Override
    public Object getCapsValue(int index, Object ... arg) {
        return ((Getter)capGetter.computeIfAbsent(index, i -> (entity, arg1) -> null)).get(this.owner, arg);
    }

    @Override
    public boolean setCapsValue(int index, Object ... arg) {
        return ((Setter)capSetter.computeIfAbsent(index, i -> (entity, arg1) -> false)).set(this.owner, arg);
    }

    static {
        EntityCaps.register("onGround", 1, (entity, arg) -> entity.m_20096_());
        EntityCaps.register("isRiding", 2, (entity, arg) -> entity.m_20159_());
        EntityCaps.register("isChild", 3, (entity, arg) -> entity.m_6162_());
        EntityCaps.register("heldItemLeft", 16, (entity, arg) -> Float.valueOf(0.0f));
        EntityCaps.register("heldItemRight", 17, (entity, arg) -> Float.valueOf(0.0f));
        EntityCaps.register("heldItems", 18, (entity, arg) -> new float[]{0.0f, 0.0f});
        EntityCaps.register("isSneak", 19, (entity, arg) -> entity.m_6144_());
        EntityCaps.register("aimedBow", 20, (entity, arg) -> 0 < entity.m_21252_());
        EntityCaps.register("Entity", 32, (entity, arg) -> entity);
        EntityCaps.register("health", 33, (entity, arg) -> (int)entity.m_21223_());
        EntityCaps.register("ticksExisted", 34, (entity, arg) -> entity.f_19797_);
        EntityCaps.register("currentEquippedItem", 35, (entity, arg) -> {
            ArrayList items = Lists.newArrayList((Iterable)entity.m_20158_());
            ItemStack item = (ItemStack)items.get((Integer)arg[0]);
            if (item.m_41619_()) {
                item = null;
            }
            return item;
        });
        EntityCaps.register("currentArmor", 36, (entity, arg) -> {
            ArrayList armors = Lists.newArrayList((Iterable)entity.m_6168_());
            ItemStack armor = (ItemStack)armors.get((Integer)arg[0]);
            if (armor.m_41619_()) {
                armor = null;
            }
            return armor;
        });
        EntityCaps.register("healthFloat", 37, (entity, arg) -> Float.valueOf(entity.m_21223_()));
        EntityCaps.register("currentLeftHandItem", 39, (entity, arg) -> entity.m_5737_() == HumanoidArm.LEFT ? entity.m_21205_() : entity.m_21206_());
        EntityCaps.register("currentRightHandItem", 40, (entity, arg) -> entity.m_5737_() == HumanoidArm.RIGHT ? entity.m_21205_() : entity.m_21206_());
        EntityCaps.register("isWet", 48, (entity, arg) -> entity.m_20071_());
        EntityCaps.register("isDead", 49, (entity, arg) -> !entity.m_6084_());
        EntityCaps.register("isInWeb", 51, (entity, arg) -> {
            AABB box = entity.m_20191_();
            BlockPos min = BlockPos.m_274561_((double)(box.f_82288_ + 1.0E-7), (double)(box.f_82289_ + 1.0E-7), (double)(box.f_82290_ + 1.0E-7));
            BlockPos max = BlockPos.m_274561_((double)(box.f_82291_ - 1.0E-7), (double)(box.f_82292_ - 1.0E-7), (double)(box.f_82293_ - 1.0E-7));
            if (entity.m_9236_().m_46832_(min, max)) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (int i = min.m_123341_(); i <= max.m_123341_(); ++i) {
                    for (int j = min.m_123342_(); j <= max.m_123342_(); ++j) {
                        int k = min.m_123343_();
                        if (k > max.m_123343_()) continue;
                        mutable.m_122178_(i, j, k);
                        BlockState blockState = entity.m_9236_().m_8055_((BlockPos)mutable);
                        return blockState.m_60734_() instanceof WebBlock;
                    }
                }
            }
            return false;
        });
        EntityCaps.register("isSwingInProgress", 52, (entity, arg) -> 0.0f < entity.f_20921_);
        EntityCaps.register("isBurning", 54, (entity, arg) -> entity.m_6060_());
        EntityCaps.register("isInWater", 55, (entity, arg) -> entity.m_20069_());
        EntityCaps.register("isInvisible", 56, (entity, arg) -> entity.m_20145_());
        EntityCaps.register("isSprinting", 57, (entity, arg) -> entity.m_20142_());
        EntityCaps.register("getRidingName", 59, (entity, arg) -> entity.m_20202_() == null ? "" : EntityType.m_20613_((EntityType)entity.m_20202_().m_6095_()).toString());
        EntityCaps.register("getRidingType", 60, (entity, arg) -> {
            Entity vehicle = entity.m_20202_();
            if (vehicle == null) {
                return "null";
            }
            if (vehicle instanceof Player) {
                return "player";
            }
            if (vehicle instanceof Animal) {
                return "animal";
            }
            if (vehicle instanceof Mob) {
                return "mob";
            }
            return "entity";
        });
        EntityCaps.register("entityName", 61, (entity, arg) -> entity.m_7755_().getString());
        EntityCaps.register("posX", 96, (entity, arg) -> entity.m_20185_());
        EntityCaps.register("posY", 97, (entity, arg) -> entity.m_20186_());
        EntityCaps.register("posZ", 98, (entity, arg) -> entity.m_20189_());
        EntityCaps.register("pos", 99, (entity, arg) -> {
            if (arg == null) {
                return new Double[]{entity.m_20185_(), entity.m_20186_(), entity.m_20189_()};
            }
            return (Integer)arg[0] == 0 ? entity.m_20185_() : ((Integer)arg[0] == 1 ? entity.m_20186_() : entity.m_20189_());
        });
        EntityCaps.register("motionX", 100, (entity, arg) -> entity.m_20184_().m_7096_());
        EntityCaps.register("motionY", 101, (entity, arg) -> entity.m_20184_().m_7098_());
        EntityCaps.register("motionZ", 102, (entity, arg) -> entity.m_20184_().m_7094_());
        EntityCaps.register("motion", 103, (entity, arg) -> {
            Vec3 vec = entity.m_20184_();
            if (arg == null) {
                return new Double[]{vec.m_7096_(), vec.m_7098_(), vec.m_7094_()};
            }
            return (Integer)arg[0] == 0 ? vec.m_7096_() : ((Integer)arg[0] == 1 ? vec.m_7098_() : vec.m_7094_());
        });
        EntityCaps.register("boundingBox", 104, (entity, arg) -> {
            if (arg == null) {
                return entity.m_20191_();
            }
            switch ((Integer)arg[0]) {
                case 0: {
                    return entity.m_20191_().f_82291_;
                }
                case 1: {
                    return entity.m_20191_().f_82292_;
                }
                case 2: {
                    return entity.m_20191_().f_82293_;
                }
                case 3: {
                    return entity.m_20191_().f_82288_;
                }
                case 4: {
                    return entity.m_20191_().f_82289_;
                }
                case 5: {
                    return entity.m_20191_().f_82290_;
                }
            }
            return null;
        });
        EntityCaps.register("rotationYaw", 105, (entity, arg) -> Float.valueOf(entity.m_146908_()));
        EntityCaps.register("rotationPitch", 106, (entity, arg) -> Float.valueOf(entity.m_146909_()));
        EntityCaps.register("prevRotationYaw", 107, (entity, arg) -> Float.valueOf(entity.f_19859_));
        EntityCaps.register("prevRotationPitch", 108, (entity, arg) -> Float.valueOf(entity.f_19860_));
        EntityCaps.register("renderYawOffset", 109, (entity, arg) -> Float.valueOf(entity.f_20883_));
        EntityCaps.register("renderRidingYOffset", 110, (entity, arg) -> entity.m_6048_());
        EntityCaps.register("PosBlockID", 129, (entity, arg) -> entity.m_20193_().m_8055_(new BlockPos(Mth.m_14107_((double)(entity.m_20185_() + (Double)arg[0])), Mth.m_14107_((double)(entity.m_20186_() + (Double)arg[1])), Mth.m_14107_((double)(entity.m_20189_() + (Double)arg[2])))).m_60734_());
        EntityCaps.register("PosBlockState", 130, (entity, arg) -> entity.m_20193_().m_8055_(new BlockPos(Mth.m_14107_((double)(entity.m_20185_() + (Double)arg[0])), Mth.m_14107_((double)(entity.m_20186_() + (Double)arg[1])), Mth.m_14107_((double)(entity.m_20189_() + (Double)arg[2])))));
        EntityCaps.register("PosBlockAir", 131, (entity, arg) -> {
            BlockPos pos = new BlockPos(Mth.m_14107_((double)(entity.m_20185_() + (Double)arg[0])), Mth.m_14107_((double)(entity.m_20186_() + (Double)arg[1])), Mth.m_14107_((double)(entity.m_20189_() + (Double)arg[2])));
            BlockState state = entity.m_20193_().m_8055_(pos);
            return state.m_60812_((BlockGetter)entity.m_9236_(), pos).m_83281_();
        });
        EntityCaps.register("PosBlockLight", 132, (entity, arg) -> entity.m_20193_().m_46803_(new BlockPos(Mth.m_14107_((double)(entity.m_20185_() + (Double)arg[0])), Mth.m_14107_((double)(entity.m_20186_() + (Double)arg[1])), Mth.m_14107_((double)(entity.m_20189_() + (Double)arg[2])))));
        EntityCaps.register("PosBlockPower", 133, (entity, arg) -> entity.m_20193_().m_46859_(new BlockPos(Mth.m_14107_((double)(entity.m_20185_() + (Double)arg[0])), Mth.m_14107_((double)(entity.m_20186_() + (Double)arg[1])), Mth.m_14107_((double)(entity.m_20189_() + (Double)arg[2])))));
        EntityCaps.register("isRidingPlayer", 134, (entity, arg) -> entity.m_20202_() instanceof Player);
        EntityCaps.register("WorldTotalTime", 65280, (entity, arg) -> entity.m_20193_().m_46467_());
        EntityCaps.register("WorldTime", 65281, (entity, arg) -> entity.m_20193_().m_46468_());
        EntityCaps.register("MoonPhase", 65282, (entity, arg) -> entity.m_20193_().m_46941_());
        EntityCaps.register("height", 289, (entity, arg) -> Float.valueOf(entity.m_20206_()));
        EntityCaps.register("width", 290, (entity, arg) -> Float.valueOf(entity.m_20205_()));
        EntityCaps.register("YOffset", 291, (entity, arg) -> entity.m_6049_());
        EntityCaps.register("mountedYOffset", 292, (entity, arg) -> entity.m_6048_());
        EntityCaps.register("dominantArm", 293, (entity, arg) -> entity.m_5737_() == HumanoidArm.LEFT ? 0 : 1);
        EntityCaps.register("isSwimming", 1536, (entity, arg) -> entity.m_6069_());
        EntityCaps.register("roll", 1537, (entity, arg) -> entity.m_21256_());
        EntityCaps.register("leaningPitch", 1538, (entity, arg) -> Float.valueOf(entity.m_20998_(1.0f)));
        EntityCaps.register("lastLeaningPitch", 1539, (entity, arg) -> Float.valueOf(entity.m_20998_(0.0f)));
        EntityCaps.register("isUsingRiptide", 1540, (entity, arg) -> entity.m_21209_());
        EntityCaps.register("isFallFlying", 1541, (entity, arg) -> entity.m_21255_());
        EntityCaps.register("pose", 1792, (entity, arg) -> MMPose.convertPose(entity.m_20089_()));
        EntityCaps.register("isPoseStanding", 1793, (entity, arg) -> entity.m_20089_() == Pose.STANDING);
        EntityCaps.register("isPoseFallFlying", 1794, (entity, arg) -> entity.m_20089_() == Pose.FALL_FLYING);
        EntityCaps.register("isPoseSleeping", 1795, (entity, arg) -> entity.m_20089_() == Pose.SLEEPING);
        EntityCaps.register("isPoseSwimming", 1796, (entity, arg) -> entity.m_20089_() == Pose.SWIMMING);
        EntityCaps.register("isPoseSpinAttack", 1797, (entity, arg) -> entity.m_20089_() == Pose.SPIN_ATTACK);
        EntityCaps.register("isPoseCrouching", 1798, (entity, arg) -> entity.m_20089_() == Pose.CROUCHING);
        EntityCaps.register("isPoseDying", 1799, (entity, arg) -> entity.m_21224_());
        EntityCaps.register("isPoseDying", 1799, (entity, arg) -> entity.m_21259_());
    }

    public static interface Setter {
        public boolean set(LivingEntity var1, Object ... var2);
    }

    public static interface Getter {
        public Object get(LivingEntity var1, Object ... var2);
    }
}

