/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.entity.compound;

import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.sistr.littlemaidmodelloader.client.resource.manager.LMSoundManager;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.network.LMSoundPacket;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;

public class SoundPlayableCompound
implements SoundPlayable {
    private final Entity entity;
    private final Supplier<String> packName;
    private ConfigHolder configHolder;

    public SoundPlayableCompound(Entity entity, Supplier<String> packName) {
        this.entity = entity;
        this.packName = packName;
        this.update();
    }

    public void update() {
        LMConfigManager configManager = LMConfigManager.INSTANCE;
        this.configHolder = configManager.getTextureSoundConfig(this.getPackName()).orElse(configManager.getAnyConfig());
    }

    public String getPackName() {
        return this.packName.get();
    }

    @Override
    public void setConfigHolder(ConfigHolder configHolder) {
        this.configHolder = configHolder;
    }

    @Override
    public ConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    @Override
    public void play(String soundName) {
        if (this.entity.m_9236_().f_46443_) {
            this.configHolder.getSoundFileName(soundName.toLowerCase()).ifPresent(soundFileName -> LMSoundManager.INSTANCE.play((String)soundFileName, this.entity.m_5720_(), this.entity.m_20185_(), this.entity.m_20188_(), this.entity.m_20189_()));
        } else {
            LMSoundPacket.sendS2CPacket(this.entity, soundName);
        }
    }
}

