/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.resource.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.LMMLMod;
import net.sistr.littlemaidmodelloader.client.resource.LMSoundInstance;

@OnlyIn(value=Dist.CLIENT)
public class LMSoundManager {
    public static final LMSoundManager INSTANCE = new LMSoundManager();
    private final Map<String, WeighedSoundEvents> soundPaths = new HashMap<String, WeighedSoundEvents>();

    public void addSound(String packName, String parentName, String fileName, ResourceLocation location) {
        WeighedSoundEvents soundSet = this.soundPaths.computeIfAbsent((packName + "." + parentName + "." + fileName).toLowerCase(), k -> new WeighedSoundEvents(location, packName + "." + fileName));
        soundSet.m_120451_((Weighted)new Sound(location.toString(), rand -> 1.0f, rand -> 1.0f, 1, Sound.Type.FILE, false, false, 16){

            public ResourceLocation m_119790_() {
                return this.m_119787_();
            }
        });
    }

    public Optional<WeighedSoundEvents> getSound(String soundFileLocation) {
        if (soundFileLocation.contains(":")) {
            return Optional.ofNullable(Minecraft.m_91087_().m_91106_().m_120384_(new ResourceLocation(soundFileLocation.toLowerCase())));
        }
        WeighedSoundEvents soundSet = this.soundPaths.get(soundFileLocation);
        return Optional.ofNullable(soundSet);
    }

    public void play(String soundFileName, SoundSource soundCategory, double x, double y, double z) {
        this.getSound(soundFileName).ifPresent(soundSet -> Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new LMSoundInstance((WeighedSoundEvents)soundSet, soundCategory, LMMLMod.getConfig().getVoiceVolume(), x, y, z)));
    }
}

