/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModel;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelArmorLayer;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelHeldItemLayer;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelLightLayer;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMultiBase;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMMatrixStack;

@OnlyIn(value=Dist.CLIENT)
public class MultiModelRenderer<T extends LivingEntity>
extends LivingEntityRenderer<T, MultiModel<T>> {
    private static final ResourceLocation NULL_TEXTURE = new ResourceLocation("littlemaidmodelloader", "null");

    public MultiModelRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new MultiModel(), 0.5f);
        this.m_115326_(new MultiModelArmorLayer(this));
        this.m_115326_(new MultiModelHeldItemLayer(this));
        this.m_115326_(new MultiModelLightLayer(this));
    }

    protected boolean m_6512_(T mobEntity) {
        return super.m_6512_(mobEntity) && (mobEntity.m_6052_() || mobEntity.m_8077_() && mobEntity == this.f_114476_.f_114359_);
    }

    protected void m_7523_(T entity, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_(entity, matrices, animationProgress, bodyYaw, tickDelta);
        ((IHasMultiModel)entity).getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).ifPresent(model -> model.setupTransform(((IHasMultiModel)entity).getCaps(), new MMMatrixStack(matrices), animationProgress, bodyYaw, tickDelta));
    }

    protected void m_7546_(T entity, PoseStack matrices, float amount) {
        ((IHasMultiModel)entity).getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).filter(model -> model instanceof ModelMultiBase).map(model -> Float.valueOf(((Float)((ModelMultiBase)model).getCapsValue(512, new Object[0])).floatValue())).ifPresent(scale -> matrices.m_85841_(scale.floatValue(), scale.floatValue(), scale.floatValue()));
    }

    public void m_7392_(T livingEntity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("littlemaidmodelloader:mm");
        ((IHasMultiModel)livingEntity).getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).filter(model -> model instanceof ModelMultiBase).ifPresent(model -> this.syncCaps(livingEntity, (ModelMultiBase)model, partialTicks));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            ((IHasMultiModel)livingEntity).getModel(IHasMultiModel.Layer.INNER, part).filter(model -> model instanceof ModelMultiBase).ifPresent(model -> this.syncCaps(livingEntity, (ModelMultiBase)model, partialTicks));
            ((IHasMultiModel)livingEntity).getModel(IHasMultiModel.Layer.OUTER, part).filter(model -> model instanceof ModelMultiBase).ifPresent(model -> this.syncCaps(livingEntity, (ModelMultiBase)model, partialTicks));
        }
        super.m_7392_(livingEntity, entityYaw, partialTicks, matrixStack, vertexConsumerProvider, light);
        profiler.m_7238_();
    }

    public void syncCaps(T entity, ModelMultiBase model, float partialTicks) {
        float swingProgress = entity.m_21324_(partialTicks);
        float right = 0.0f;
        float left = 0.0f;
        if (((LivingEntity)entity).f_20912_ == InteractionHand.MAIN_HAND) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                right = swingProgress;
            } else {
                left = swingProgress;
            }
        } else if (entity.m_5737_() != HumanoidArm.RIGHT) {
            right = swingProgress;
        } else {
            left = swingProgress;
        }
        model.setCapsValue(1, Float.valueOf(right), Float.valueOf(left));
        model.setCapsValue(2, entity.m_20159_());
        model.setCapsValue(19, entity.m_6144_());
        model.setCapsValue(3, entity.m_6162_());
        model.setCapsValue(16, Float.valueOf(0.0f));
        model.setCapsValue(17, Float.valueOf(0.0f));
        model.setCapsValue(20, false);
        model.setCapsValue(288, Float.valueOf(0.0f));
        model.setCapsValue(34, ((LivingEntity)entity).f_19797_);
    }

    public ResourceLocation getTexture(T entity) {
        return ((IHasMultiModel)entity).getTexture(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD, false).orElse(NULL_TEXTURE);
    }
}

