/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader;

import com.google.common.collect.ImmutableMap;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.resource.loader.LMSoundLoader;
import net.sistr.littlemaidmodelloader.client.resource.manager.LMSoundManager;
import net.sistr.littlemaidmodelloader.config.LMMLConfig;
import net.sistr.littlemaidmodelloader.entity.MultiModelEntity;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Archetype;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Aug;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Beverly7;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Chloe2;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Elsa5;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Orign;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_SR2;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMulti_Classic64;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMulti_Slim64;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMulti_Stef;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMulti_Steve;
import net.sistr.littlemaidmodelloader.resource.classloader.MultiModelClassLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMConfigLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMFileLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMMultiModelLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMTextureLoader;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ResourceHelper;
import net.sistr.littlemaidmodelloader.setup.Registration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMMLMod {
    public static final String MODID = "littlemaidmodelloader";
    public static final Logger LOGGER = LogManager.getLogger();
    private static ConfigHolder<LMMLConfig> CONFIG_HOLDER;

    public static void init() {
        AutoConfig.register(LMMLConfig.class, GsonConfigSerializer::new);
        CONFIG_HOLDER = AutoConfig.getConfigHolder(LMMLConfig.class);
        LMMLMod.initFileLoader();
        LMMLMod.initModelLoader();
        if (Platform.getEnv() == Dist.CLIENT) {
            LMMLMod.addGhastMaidVoice();
            LMMLMod.initTextureLoader();
            LMMLMod.initSoundLoader();
            ClientLifecycleEvent.CLIENT_STARTED.register(cs -> {
                Set resourceLocations = cs.m_91098_().m_214159_("textures/entity/littlemaid", s -> true).keySet();
                resourceLocations.forEach(resourcePath -> {
                    String path = resourcePath.m_135815_();
                    ResourceHelper.getTexturePackName(path, false).ifPresent(textureName -> {
                        String modelName = ResourceHelper.getModelName(textureName);
                        int index = ResourceHelper.getIndex(path);
                        if (index != -1) {
                            LMTextureManager.INSTANCE.addTexture(ResourceHelper.getFileName(path, false), (String)textureName, modelName, index, (ResourceLocation)resourcePath);
                        }
                    });
                });
            });
        }
        Registration.init();
        LMMLMod.registerAttribute();
        LMFileLoader.INSTANCE.load();
    }

    public static void initFileLoader() {
        LMFileLoader fileLoader = LMFileLoader.INSTANCE;
        fileLoader.addLoadFolderPath(Paths.get(Platform.getGameFolder().toString(), "LMMLResources"));
        fileLoader.addLoader(new LMMultiModelLoader(LMModelManager.INSTANCE, new MultiModelClassLoader(fileLoader.getFolderPaths())));
        fileLoader.addLoader(new LMConfigLoader(LMConfigManager.INSTANCE));
    }

    public static void initModelLoader() {
        LMModelManager modelManager = LMModelManager.INSTANCE;
        modelManager.addModel("Default", ModelLittleMaid_Orign.class);
        modelManager.addModel("SR2", ModelLittleMaid_SR2.class);
        modelManager.addModel("Aug", ModelLittleMaid_Aug.class);
        modelManager.addModel("Archetype", ModelLittleMaid_Archetype.class);
        modelManager.addModel("Steve", ModelMulti_Steve.class);
        modelManager.addModel("Stef", ModelMulti_Stef.class);
        modelManager.addModel("Classic64", ModelMulti_Classic64.class);
        modelManager.addModel("Slim64", ModelMulti_Slim64.class);
        modelManager.addModel("Beverly7", ModelLittleMaid_Beverly7.class);
        modelManager.addModel("Chloe2", ModelLittleMaid_Chloe2.class);
        modelManager.addModel("Elsa5", ModelLittleMaid_Elsa5.class);
        modelManager.setDefaultModel(modelManager.getModel("Default", IHasMultiModel.Layer.SKIN).orElseThrow(RuntimeException::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initTextureLoader() {
        LMFileLoader fileLoader = LMFileLoader.INSTANCE;
        LMTextureLoader textureProcessor = new LMTextureLoader(LMTextureManager.INSTANCE);
        textureProcessor.addPathConverter("assets/", "");
        textureProcessor.addPathConverter("mob/", "minecraft/textures/entity/");
        fileLoader.addLoader(textureProcessor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initSoundLoader() {
        LMFileLoader.INSTANCE.addLoader(new LMSoundLoader(LMSoundManager.INSTANCE));
    }

    public static void registerAttribute() {
        EntityAttributeRegistry.register(Registration.MULTI_MODEL_ENTITY, MultiModelEntity::createMobAttributes);
        EntityAttributeRegistry.register(Registration.DUMMY_MODEL_ENTITY, MultiModelEntity::createMobAttributes);
    }

    public static LMMLConfig getConfig() {
        return (LMMLConfig)CONFIG_HOLDER.getConfig();
    }

    public static void addGhastMaidVoice() {
        String packName = "DefaultGhast";
        ImmutableMap.Builder configMap = new ImmutableMap.Builder();
        LMMLMod.addVoice("se_hurt", SoundEvents.f_11921_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_hurt_fire", SoundEvents.f_11921_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_hurt_fall", SoundEvents.f_11921_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_death", SoundEvents.f_11920_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_attack", SoundEvents.f_11924_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_attack_bloodsuck", SoundEvents.f_11924_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_shoot", SoundEvents.f_11924_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_shoot_burst", SoundEvents.f_11924_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_daytime", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_morning", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_night", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_whine", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_rain", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_snow", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_cold", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMMLMod.addVoice("se_living_hot", SoundEvents.f_11919_, (ImmutableMap.Builder<String, String>)configMap);
        LMConfigManager.INSTANCE.addConfig(packName, "", "littlemaidmob", (Map<String, String>)configMap.build());
    }

    private static void addVoice(String soundName, SoundEvent soundId, ImmutableMap.Builder<String, String> configMap) {
        configMap.put((Object)soundName, (Object)soundId.m_11660_().toString());
    }
}

