/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.me.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.key.EMCKey;
import java.math.BigInteger;
import java.util.ArrayList;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class TransmutationPattern
implements IPatternDetails {
    private static final String NBT_ITEM = "item";
    private static final String NBT_AMOUNT = "amount";
    private static final String NBT_TIER = "tier";
    private final AEItemKey item;
    private final long amount;
    private final int tier;
    private final AEItemKey definition;

    public TransmutationPattern(AEItemKey item, long amount) {
        this.tier = 1;
        CompoundTag tag = new CompoundTag();
        this.item = item;
        tag.m_128365_(NBT_ITEM, (Tag)this.item.toTag());
        this.amount = amount;
        tag.m_128356_(NBT_AMOUNT, this.amount);
        this.definition = AEItemKey.of((ItemLike)((ItemLike)AppliedE.DUMMY_EMC_ITEM.get()), (CompoundTag)tag);
    }

    public TransmutationPattern(int tier) {
        this.item = null;
        this.amount = 1L;
        CompoundTag tag = new CompoundTag();
        this.tier = tier;
        tag.m_128405_(NBT_TIER, this.tier);
        this.definition = AEItemKey.of((ItemLike)((ItemLike)AppliedE.DUMMY_EMC_ITEM.get()), (CompoundTag)tag);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        if (this.item == null) {
            return new IPatternDetails.IInput[]{new Input(1L, this.tier)};
        }
        ArrayList<Input> inputs = new ArrayList<Input>();
        long itemEmc = IEMCProxy.INSTANCE.getValue(this.item.toStack());
        BigInteger totalEmc = BigInteger.valueOf(itemEmc).multiply(BigInteger.valueOf(this.amount));
        int currentTier = 1;
        while (totalEmc.divide(AppliedE.TIER_LIMIT).signum() == 1) {
            inputs.add(new Input(totalEmc.remainder(AppliedE.TIER_LIMIT).longValue(), currentTier));
            totalEmc = totalEmc.divide(AppliedE.TIER_LIMIT);
            ++currentTier;
        }
        inputs.add(new Input(totalEmc.longValue(), currentTier));
        return inputs.toArray(new IPatternDetails.IInput[0]);
    }

    public GenericStack[] getOutputs() {
        return new GenericStack[]{this.item != null ? new GenericStack((AEKey)this.item, this.amount) : new GenericStack((AEKey)EMCKey.tier(this.tier - 1), AppliedE.TIER_LIMIT.longValue())};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TransmutationPattern)) return false;
        TransmutationPattern pattern = (TransmutationPattern)obj;
        if (!pattern.definition.equals((Object)this.definition)) return false;
        return true;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    private record Input(long amount, int tier) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)EMCKey.tier(this.tier), this.amount)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

