/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntitySpawnLamp;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.items.ModItems;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class LevelData
implements ILevelData {
    public final ListMultimap<ResourceLocation, Tuple<Vec3, Integer>> effectPowders = ArrayListMultimap.create();
    public final Long2ObjectOpenHashMap<AuraChunk> auraChunksWithSpots = new Long2ObjectOpenHashMap();
    public final List<BlockPos> recentlyConvertedMossStones = new ArrayList<BlockPos>();
    public final Set<BlockEntitySpawnLamp> spawnLamps = new HashSet<BlockEntitySpawnLamp>();
    private final Map<String, ItemStackHandlerNA> enderStorages = new HashMap<String, ItemStackHandlerNA>();
    private final LazyOptional<LevelData> lazyThis = LazyOptional.of(() -> this);

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == NaturesAuraAPI.CAP_LEVEL_DATA ? this.lazyThis.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag storages = new ListTag();
        for (Map.Entry<String, ItemStackHandlerNA> entry : this.enderStorages.entrySet()) {
            ItemStackHandlerNA handler = entry.getValue();
            if (Helper.isEmpty((IItemHandler)handler)) continue;
            CompoundTag storageComp = handler.serializeNBT();
            storageComp.m_128359_("name", entry.getKey());
            storages.add((Object)storageComp);
        }
        compound.m_128365_("storages", (Tag)storages);
        ListTag moss = new ListTag();
        for (BlockPos pos : this.recentlyConvertedMossStones) {
            moss.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        }
        compound.m_128365_("converted_moss", (Tag)moss);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.enderStorages.clear();
        for (Tag base : compound.m_128437_("storages", 10)) {
            CompoundTag storageComp = (CompoundTag)base;
            ItemStackHandlerNA storage = this.getEnderStorage(storageComp.m_128461_("name"));
            storage.deserializeNBT(storageComp);
        }
        this.recentlyConvertedMossStones.clear();
        for (Tag base : compound.m_128437_("converted_moss", 4)) {
            this.recentlyConvertedMossStones.add(BlockPos.m_122022_((long)((LongTag)base).m_7046_()));
        }
    }

    public ItemStackHandlerNA getEnderStorage(String name) {
        return this.enderStorages.computeIfAbsent(name, n -> new ItemStackHandlerNA(27));
    }

    @Override
    public boolean isEnderStorageLocked(String name) {
        ItemStackHandlerNA handler = this.getEnderStorage(name);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != ModItems.TOKEN_TERROR) continue;
            return true;
        }
        return false;
    }

    public void addMossStone(BlockPos pos) {
        this.recentlyConvertedMossStones.add(pos);
        if (this.recentlyConvertedMossStones.size() > 512) {
            this.recentlyConvertedMossStones.remove(0);
        }
    }
}

