/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.tag;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class ECTags {
    private ECTags() {
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_SOURCE_ALTAR = Biomes.createTag("has_structure/source_altar");
        public static final TagKey<Biome> HAS_INERT_CRYSTAL = Biomes.createTag("has_inert_crystal");
        public static final TagKey<Biome> HAS_SOURCE_ALL = Biomes.createTag("has_sources/all");
        public static final TagKey<Biome> HAS_SOURCE_ICY = Biomes.createTag("has_sources/icy");
        public static final TagKey<Biome> HAS_SOURCE_JUNGLE = Biomes.createTag("has_sources/jungle");
        public static final TagKey<Biome> HAS_SOURCE_MUSHROOM = Biomes.createTag("has_sources/mushroom");
        public static final TagKey<Biome> HAS_SOURCE_NETHER = Biomes.createTag("has_sources/nether");
        public static final TagKey<Biome> HAS_SOURCE_NETHER_ALL = Biomes.createTag("has_sources/nether/all");
        public static final TagKey<Biome> HAS_SOURCE_NETHER_FOREST = Biomes.createTag("has_sources/nether/forest");
        public static final TagKey<Biome> HAS_SOURCE_OCEAN = Biomes.createTag("has_sources/ocean");
        public static final TagKey<Biome> HAS_SOURCE_PLAIN = Biomes.createTag("has_sources/plain");
        public static final TagKey<Biome> HAS_SOURCE_WET = Biomes.createTag("has_sources/wet");
        public static final TagKey<Biome> HAS_SOURCE_DRY = Biomes.createTag("has_sources/dry");
        public static final TagKey<Biome> HAS_SOURCE_MOUNTAIN = Biomes.createTag("has_sources/mountain");
        public static final TagKey<Biome> HAS_SOURCE_HILL = Biomes.createTag("has_sources/hill");
        public static final TagKey<Biome> HAS_SOURCE_FOREST = Biomes.createTag("has_sources/forest");
        public static final TagKey<Biome> HAS_SOURCE_END = Biomes.createTag("has_sources/end");
        public static final TagKey<Biome> HAS_SOURCE_LUSH_CAVE = Biomes.createTag("has_sources/lush_cave");
        public static final TagKey<Biome> HAS_SOURCE_DRIPSTONE_CAVE = Biomes.createTag("has_sources/dripstone_cave");
        public static final TagKey<Biome> HAS_SOURCE_DEEP_DARK = Biomes.createTag("has_sources/deep_dark");
        public static final TagKey<Biome> HAS_SOURCE_UNDERGROUND = Biomes.createTag("has_sources/underground");
        public static final TagKey<Biome> HAS_SOURCE_SKY = Biomes.createTag("has_sources/sky");

        private Biomes() {
        }

        private static TagKey<Biome> createTag(String name) {
            return Biomes.createTag("elementalcraft", name);
        }

        private static TagKey<Biome> createForgeTag(String name) {
            return Biomes.createTag("forge", name);
        }

        private static TagKey<Biome> createTag(String modId, String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(modId, name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> SMALL_CONTAINER_COMPATIBLES = Blocks.createTag("small_container_compatibles");
        public static final TagKey<Block> PUREROCKS = Blocks.createTag("purerocks");
        public static final TagKey<Block> PIPES = Blocks.createTag("pipes");
        public static final TagKey<Block> SHRINES = Blocks.createTag("shrines");
        public static final TagKey<Block> SHRINE_UPGRADES = Blocks.createTag("shrine_upgrades");
        public static final TagKey<Block> INSTRUMENTS = Blocks.createTag("instruments");
        public static final TagKey<Block> CONTAINER_TOOLS = Blocks.createTag("container_tools");
        public static final TagKey<Block> PEDESTALS = Blocks.createTag("pedestals");
        public static final TagKey<Block> RUNE_AFFECTED_SPEED = Blocks.createTag("rune_affected/speed");
        public static final TagKey<Block> RUNE_AFFECTED_PRESERVATION = Blocks.createTag("rune_affected/preservation");
        public static final TagKey<Block> RUNE_AFFECTED_OPTIMIZATION = Blocks.createTag("rune_affected/optimization");
        public static final TagKey<Block> RUNE_AFFECTED_LUCK = Blocks.createTag("rune_affected/luck");
        public static final TagKey<Block> SHRINES_LAVA_LIQUIFIABLES = Blocks.createTag("shrines/lava/liquifiables");
        public static final TagKey<Block> SHRINES_GROWTH_BLACKLIST = Blocks.createTag("shrines/growth/blacklist");
        public static final TagKey<Block> SHRINES_ORE_HARVESTABLE_CRYSTALS = Blocks.createTag("shrines/ore/harvestable_crystals");
        public static final TagKey<Block> SHRINES_HARVEST_HARVESTABLE_TALL_PLANTS = Blocks.createTag("shrines/harvest/harvestable_tall_plants");
        public static final TagKey<Block> SHRINES_UPGRADABLES_ACCELERATION = Blocks.createTag("shrines/upgradables/acceleration");
        public static final TagKey<Block> SHRINES_UPGRADABLES_RANGE = Blocks.createTag("shrines/upgradables/range");
        public static final TagKey<Block> SHRINES_UPGRADABLES_STRENGTH = Blocks.createTag("shrines/upgradables/strength");
        public static final TagKey<Block> SHRINES_UPGRADABLES_PROTECTION = Blocks.createTag("shrines/upgradables/protection");
        public static final TagKey<Block> SHRINES_UPGRADABLES_PLANTING = Blocks.createTag("shrines/upgradables/planting");
        public static final TagKey<Block> SHRINES_UPGRADABLES_FORTUNE = Blocks.createTag("shrines/upgradables/fortune");
        public static final TagKey<Block> SHRINES_UPGRADABLES_SILK_TOUCH = Blocks.createTag("shrines/upgradables/silk_touch");
        public static final TagKey<Block> SHRINES_UPGRADABLES_CRYSTAL_HARVEST = Blocks.createTag("shrines/upgradables/crystal_harvest");
        public static final TagKey<Block> SHRINES_UPGRADABLES_SILK_TOUCH_ATTACHED = Blocks.createTag("shrines/upgradables/silk_touch/attached");
        public static final TagKey<Block> TREE_PARTS = Blocks.createTag("tree_parts");
        public static final TagKey<Block> STORAGE_BLOCKS_DRENCHED_IRON = Blocks.createForgeTag("storage_blocks/drenched_iron");
        public static final TagKey<Block> STORAGE_BLOCKS_SWIFT_ALLOY = Blocks.createForgeTag("storage_blocks/swift_alloy");
        public static final TagKey<Block> STORAGE_BLOCKS_FIREITE = Blocks.createForgeTag("storage_blocks/fireite");
        public static final TagKey<Block> ORES_INERT_CRYSTAL = Blocks.createForgeTag("ores/inert_crystal");
        public static final TagKey<Block> BUDDING = Blocks.createForgeTag("budding");
        public static final TagKey<Block> BUDS = Blocks.createForgeTag("buds");
        public static final TagKey<Block> CLUSTERS = Blocks.createForgeTag("clusters");
        public static final TagKey<Block> BAG_OF_YURTING_BLACKLIST = Blocks.createTag("bagofyurting", "blacklist");
        public static final TagKey<Block> STRIPPED_OAK = Blocks.createTag("stripped_oak");
        public static final TagKey<Block> STRIPPED_DARK_OAK = Blocks.createTag("stripped_dark_oak");
        public static final TagKey<Block> STRIPPED_BIRCH = Blocks.createTag("stripped_birch");
        public static final TagKey<Block> STRIPPED_ACACIA = Blocks.createTag("stripped_acacia");
        public static final TagKey<Block> STRIPPED_JUNGLE = Blocks.createTag("stripped_jungle");
        public static final TagKey<Block> STRIPPED_SPRUCE = Blocks.createTag("stripped_spruce");
        public static final TagKey<Block> STRIPPED_MANGROVE = Blocks.createTag("stripped_mangrove");
        public static final TagKey<Block> STRIPPED_CRIMSON = Blocks.createTag("stripped_crimson");
        public static final TagKey<Block> STRIPPED_WARPED = Blocks.createTag("stripped_warped");
        public static final TagKey<Block> STRIPPED_CHERRY = Blocks.createTag("stripped_cherry");

        private Blocks() {
        }

        private static TagKey<Block> createTag(String name) {
            return Blocks.createTag("elementalcraft", name);
        }

        private static TagKey<Block> createForgeTag(String name) {
            return Blocks.createTag("forge", name);
        }

        private static TagKey<Block> createTag(String modId, String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation(modId, name));
        }

        public static HolderSet.Named<Block> getTag(ResourceLocation loc) {
            return Blocks.getTag((TagKey<Block> t) -> t.f_203868_().equals((Object)loc));
        }

        public static HolderSet.Named<Block> getTag(TagKey<Block> key) {
            return Blocks.getTag((TagKey<Block> t) -> t.equals((Object)key));
        }

        public static HolderSet.Named<Block> getTag(Predicate<TagKey<Block>> predicate) {
            return BuiltInRegistries.f_256975_.m_203612_().filter(p -> predicate.test((TagKey)p.getFirst())).map(Pair::getSecond).findFirst().orElse(null);
        }
    }

    public static class Items {
        public static final TagKey<Item> SPELL_CAST_TOOLS = Items.createTag("spell_cast_tools");
        public static final TagKey<Item> INFUSABLE_FOCUS = Items.createTag("infusable/focus");
        public static final TagKey<Item> INFUSABLE_STAVES = Items.createTag("infusable/staves");
        public static final TagKey<Item> INFUSABLE_SWORDS = Items.createTag("infusable/swords");
        public static final TagKey<Item> INFUSABLE_PICKAXES = Items.createTag("infusable/pickaxes");
        public static final TagKey<Item> INFUSABLE_AXES = Items.createTag("infusable/axes");
        public static final TagKey<Item> INFUSABLE_SHOVELS = Items.createTag("infusable/shovels");
        public static final TagKey<Item> INFUSABLE_HOES = Items.createTag("infusable/hoes");
        public static final TagKey<Item> INFUSABLE_PAXELS = Items.createTag("infusable/paxels");
        public static final TagKey<Item> INFUSABLE_SHILDS = Items.createTag("infusable/shields");
        public static final TagKey<Item> INFUSABLE_BOWS = Items.createTag("infusable/bows");
        public static final TagKey<Item> INFUSABLE_CROSSBOWS = Items.createTag("infusable/crossbows");
        public static final TagKey<Item> INFUSABLE_FISHING_RODS = Items.createTag("infusable/fishing_rods");
        public static final TagKey<Item> INFUSABLE_TRIDENTS = Items.createTag("infusable/tridents");
        public static final TagKey<Item> INFUSABLE_HELMETS = Items.createTag("infusable/helmets");
        public static final TagKey<Item> INFUSABLE_CHESTPLATES = Items.createTag("infusable/chestplates");
        public static final TagKey<Item> INFUSABLE_LEGGINGS = Items.createTag("infusable/leggings");
        public static final TagKey<Item> INFUSABLE_BOOTS = Items.createTag("infusable/boots");
        public static final TagKey<Item> SPELL_HOLDERS = Items.createTag("spell_holders");
        public static final TagKey<Item> ELEMENTAL_CRYSTALS = Items.createTag("crystals/elemental");
        public static final TagKey<Item> CRYSTALS = Items.createTag("crystals");
        public static final TagKey<Item> LENSES = Items.createTag("lenses");
        public static final TagKey<Item> SHARDS = Items.createTag("shards");
        public static final TagKey<Item> DEFAULT_SHARDS = Items.createTag("shards/default");
        public static final TagKey<Item> POWERFUL_SHARDS = Items.createTag("shards/powerful");
        public static final TagKey<Item> FIRE_SHARDS = Items.createTag("shards/fire");
        public static final TagKey<Item> WATER_SHARDS = Items.createTag("shards/water");
        public static final TagKey<Item> EARTH_SHARDS = Items.createTag("shards/earth");
        public static final TagKey<Item> AIR_SHARDS = Items.createTag("shards/air");
        public static final TagKey<Item> CRUDE_FIRE_GEMS = Items.createTag("gems/crude_fire");
        public static final TagKey<Item> CRUDE_WATER_GEMS = Items.createTag("gems/crude_water");
        public static final TagKey<Item> CRUDE_EARTH_GEMS = Items.createTag("gems/crude_earth");
        public static final TagKey<Item> CRUDE_AIR_GEMS = Items.createTag("gems/crude_air");
        public static final TagKey<Item> FINE_FIRE_GEMS = Items.createTag("gems/fine_fire");
        public static final TagKey<Item> FINE_WATER_GEMS = Items.createTag("gems/fine_water");
        public static final TagKey<Item> FINE_EARTH_GEMS = Items.createTag("gems/fine_earth");
        public static final TagKey<Item> FINE_AIR_GEMS = Items.createTag("gems/fine_air");
        public static final TagKey<Item> PRISTINE_FIRE_GEMS = Items.createTag("gems/pristine_fire");
        public static final TagKey<Item> PRISTINE_WATER_GEMS = Items.createTag("gems/pristine_water");
        public static final TagKey<Item> PRISTINE_EARTH_GEMS = Items.createTag("gems/pristine_earth");
        public static final TagKey<Item> PRISTINE_AIR_GEMS = Items.createTag("gems/pristine_air");
        public static final TagKey<Item> INPUT_FIRE_GEMS = Items.createTag("gems/input_fire");
        public static final TagKey<Item> INPUT_WATER_GEMS = Items.createTag("gems/input_water");
        public static final TagKey<Item> INPUT_EARTH_GEMS = Items.createTag("gems/input_earth");
        public static final TagKey<Item> INPUT_AIR_GEMS = Items.createTag("gems/input_air");
        public static final TagKey<Item> INPUT_GEMS = Items.createTag("gems/input");
        public static final TagKey<Item> RUNE_SLATES = Items.createTag("rune_slates");
        public static final TagKey<Item> PUREROCKS = Items.createTag("purerocks");
        public static final TagKey<Item> PIPES = Items.createTag("pipes");
        public static final TagKey<Item> PIPES_UPGRADES = Items.createTag("pipes_upgrades");
        public static final TagKey<Item> PIPE_COVER_HIDING = Items.createTag("pipe_cover_hiding");
        public static final TagKey<Item> SHRINES = Items.createTag("shrines");
        public static final TagKey<Item> SHRINE_UPGRADES = Items.createTag("shrine_upgrades");
        public static final TagKey<Item> SMALL_CONTAINER_COMPATIBLES = Items.createTag("small_container_compatibles");
        public static final TagKey<Item> INSTRUMENTS = Items.createTag("instruments");
        public static final TagKey<Item> CONTAINER_TOOLS = Items.createTag("container_tools");
        public static final TagKey<Item> STAFF_CRAFT_SWORD = Items.createTag("staff_craft_sword");
        public static final TagKey<Item> PURE_ORES_SOURCE_ORES = Items.createTag("pure_ores/sources/ores");
        public static final TagKey<Item> PURE_ORES_SOURCE_RAW_MATERIALS = Items.createTag("pure_ores/sources/raw_materials");
        public static final TagKey<Item> PURE_ORES_SOURCE_RAW_MATERIAL_BLOCKS = Items.createTag("pure_ores/sources/raw_material_blocks");
        public static final TagKey<Item> PURE_ORES_SOURCE_GEORE_SHARDS = Items.createTag("pure_ores/sources/geore_shards");
        public static final TagKey<Item> PURE_ORES_SOURCE_GEORE_BLOCKS = Items.createTag("pure_ores/sources/geore_blocks");
        public static final TagKey<Item> PURE_ORES_SOURCE_RESONANT_ORE = Items.createTag("pure_ores/sources/resonant_ore");
        public static final TagKey<Item> PURE_ORES_SOURCE_RAW_URANINITE = Items.createTag("pure_ores/sources/raw_uraninite");
        public static final TagKey<Item> PURE_ORES_SOURCE_POOR_URANINITE = Items.createTag("pure_ores/sources/poor_uraninite");
        public static final TagKey<Item> PURE_ORES_SOURCE_URANINITE = Items.createTag("pure_ores/sources/uraninite");
        public static final TagKey<Item> PURE_ORES_SOURCE_DENSE_URANINITE = Items.createTag("pure_ores/sources/dense_uraninite");
        public static final TagKey<Item> PURE_ORES_SPECIFICS = Items.createTag("pure_ores/specifics");
        public static final TagKey<Item> PURE_ORES_MOD_PROCESSING_BLACKLIST = Items.createTag("pure_ores/mod_processing_blacklist");
        public static final TagKey<Item> JEWEL_SOCKETABLES = Items.createTag("jewel_socketables");
        public static final TagKey<Item> SOURCE_SEEDS = Items.createTag("source_seeds");
        public static final TagKey<Item> NATURAL_SOURCE_SEEDS = Items.createTag("source_seeds/natural");
        public static final TagKey<Item> ARTIFICIAL_SOURCE_SEEDS = Items.createTag("source_seeds/artificial");
        public static final TagKey<Item> GROVE_SHRINE_FLOWERS = Items.createTag("grove_shrine_flowers");
        public static final TagKey<Item> GROVE_SHRINE_BLACKLIST = Items.createTag("grove_shrine_blacklist");
        public static final TagKey<Item> MYSTICAL_GROVE_FLOWERS = Items.createTag("mystical_grove_flowers");
        public static final TagKey<Item> INGOTS_DRENCHED_IRON = Items.createForgeTag("ingots/drenched_iron");
        public static final TagKey<Item> INGOTS_SWIFT_ALLOY = Items.createForgeTag("ingots/swift_alloy");
        public static final TagKey<Item> INGOTS_FIREITE = Items.createForgeTag("ingots/fireite");
        public static final TagKey<Item> NUGGETS_DRENCHED_IRON = Items.createForgeTag("nuggets/drenched_iron");
        public static final TagKey<Item> NUGGETS_SWIFT_ALLOY = Items.createForgeTag("nuggets/swift_alloy");
        public static final TagKey<Item> NUGGETS_FIREITE = Items.createForgeTag("nuggets/fireite");
        public static final TagKey<Item> STORAGE_BLOCKS_DRENCHED_IRON = Items.createForgeTag("storage_blocks/drenched_iron");
        public static final TagKey<Item> STORAGE_BLOCKS_SWIFT_ALLOY = Items.createForgeTag("storage_blocks/swift_alloy");
        public static final TagKey<Item> STORAGE_BLOCKS_FIREITE = Items.createForgeTag("storage_blocks/fireite");
        public static final TagKey<Item> STORAGE_BLOCKS_RAW_MATERIALS = Items.createForgeTag("storage_blocks/raw_materials");
        public static final TagKey<Item> ORES_INERT_CRYSTAL = Items.createForgeTag("ores/inert_crystal");
        public static final TagKey<Item> HARDENED_RODS = Items.createForgeTag("rods/hardened");
        public static final TagKey<Item> TOOLS_PAXELS = Items.createForgeTag("tools/paxels");
        public static final TagKey<Item> TOOLS_AIOTS = Items.createForgeTag("tools/aiots");
        public static final TagKey<Item> CURIOS_ELEMENT_HOLDER = Items.createTag("curios", "element_holder");
        public static final TagKey<Item> STRIPPED_OAK = Items.createTag("stripped_oak");
        public static final TagKey<Item> STRIPPED_DARK_OAK = Items.createTag("stripped_dark_oak");
        public static final TagKey<Item> STRIPPED_BIRCH = Items.createTag("stripped_birch");
        public static final TagKey<Item> STRIPPED_ACACIA = Items.createTag("stripped_acacia");
        public static final TagKey<Item> STRIPPED_JUNGLE = Items.createTag("stripped_jungle");
        public static final TagKey<Item> STRIPPED_SPRUCE = Items.createTag("stripped_spruce");
        public static final TagKey<Item> STRIPPED_MANGROVE = Items.createTag("stripped_mangrove");
        public static final TagKey<Item> STRIPPED_CRIMSON = Items.createTag("stripped_crimson");
        public static final TagKey<Item> STRIPPED_WARPED = Items.createTag("stripped_warped");
        public static final TagKey<Item> STRIPPED_CHERRY = Items.createTag("stripped_cherry");
        public static final TagKey<Item> WHITE_FLOWERS = Items.createForgeTag("flowers/white");
        public static final TagKey<Item> ORANGE_FLOWERS = Items.createForgeTag("flowers/orange");
        public static final TagKey<Item> MAGENTA_FLOWERS = Items.createForgeTag("flowers/magenta");
        public static final TagKey<Item> LIGHT_BLUE_FLOWERS = Items.createForgeTag("flowers/light_blue");
        public static final TagKey<Item> YELLOW_FLOWERS = Items.createForgeTag("flowers/yellow");
        public static final TagKey<Item> LIME_FLOWERS = Items.createForgeTag("flowers/lime");
        public static final TagKey<Item> PINK_FLOWERS = Items.createForgeTag("flowers/pink");
        public static final TagKey<Item> GRAY_FLOWERS = Items.createForgeTag("flowers/gray");
        public static final TagKey<Item> LIGHT_GRAY_FLOWERS = Items.createForgeTag("flowers/light_gray");
        public static final TagKey<Item> CYAN_FLOWERS = Items.createForgeTag("flowers/cyan");
        public static final TagKey<Item> PURPLE_FLOWERS = Items.createForgeTag("flowers/purple");
        public static final TagKey<Item> BLUE_FLOWERS = Items.createForgeTag("flowers/blue");
        public static final TagKey<Item> BROWN_FLOWERS = Items.createForgeTag("flowers/brown");
        public static final TagKey<Item> GREEN_FLOWERS = Items.createForgeTag("flowers/green");
        public static final TagKey<Item> BLACK_FLOWERS = Items.createForgeTag("flowers/black");
        public static final TagKey<Item> RED_FLOWERS = Items.createForgeTag("flowers/red");

        private Items() {
        }

        private static TagKey<Item> createTag(String name) {
            return Items.createTag("elementalcraft", name);
        }

        private static TagKey<Item> createTag(String namespace, String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation(namespace, name));
        }

        private static TagKey<Item> createForgeTag(String name) {
            return Items.createTag("forge", name);
        }

        public static HolderSet.Named<Item> getTag(ResourceLocation loc) {
            return Items.getTag((TagKey<Item> t) -> t.f_203868_().equals((Object)loc));
        }

        public static HolderSet.Named<Item> getTag(TagKey<Item> key) {
            return Items.getTag((TagKey<Item> t) -> t.equals((Object)key));
        }

        public static HolderSet.Named<Item> getTag(Predicate<TagKey<Item>> predicate) {
            return BuiltInRegistries.f_257033_.m_203612_().filter(p -> predicate.test((TagKey)p.getFirst())).map(Pair::getSecond).findFirst().orElse(null);
        }
    }
}

