/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.ArrayDeque;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.tag.ECTags;

public class TreeFallSpell
extends Spell {
    public static final String NAME = "tree_fall";

    public TreeFallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private boolean isValidBlock(BlockState state) {
        return state.m_204336_(ECTags.Blocks.TREE_PARTS);
    }

    private void cutTree(Entity sender, Level world, BlockPos target) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        float rangeSq = this.getRange(sender);
        rangeSq *= rangeSq;
        queue.offer(target);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            BlockState state = world.m_8055_(pos);
            if (!this.isValidBlock(state) || !(pos.m_123331_((Vec3i)target) <= (double)rangeSq)) continue;
            world.m_46961_(pos, true);
            Stream.of(Direction.values()).filter(d -> d != Direction.DOWN).forEach(d -> queue.offer(pos.m_121945_(d)));
        }
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        Level world = sender.m_9236_();
        if (!world.f_46443_ && this.isValidBlock(world.m_8055_(target))) {
            this.cutTree(sender, world, target);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

