/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class CrystallizationRecipe
extends AbstractInstrumentRecipe<CrystallizerBlockEntity> {
    public static final String NAME = "crystallization";
    private final NonNullList<Ingredient> ingredients;
    private final List<ResultEntry> outputs;
    private final int elementAmount;

    public CrystallizationRecipe(ResourceLocation id, ElementType type, int elementAmount, List<ResultEntry> outputs, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.outputs = ImmutableList.copyOf(outputs);
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(@Nonnull CrystallizerBlockEntity crystallizer, @Nonnull Level level) {
        if (crystallizer.getContainerElementType() == this.getElementType() && crystallizer.getItemCount() >= 2) {
            for (int i = 0; i < 2; ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(crystallizer.getInventory().m_8020_(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registry) {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public List<ResultEntry> getOutputs() {
        return this.outputs;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ECRecipeTypes.CRYSTALLIZATION.get();
    }

    @Override
    @NotNull
    public ItemStack assemble(@Nonnull CrystallizerBlockEntity instrument, @Nonnull RegistryAccess registry) {
        return this.assemble(instrument.getInventory().m_8020_(0), instrument, 0.0f);
    }

    public ItemStack assemble(ItemStack gem, CrystallizerBlockEntity instrument, float luck) {
        int index = IntStream.range(0, this.outputs.size()).filter(i -> ItemHandlerHelper.canItemStacksStack((ItemStack)this.outputs.get((int)i).result, (ItemStack)gem)).findFirst().orElse(0);
        int size = this.outputs.size();
        List<ResultEntry> list = index >= 0 && index < size ? this.outputs.subList(index, size) : this.outputs;
        int weight = this.getTotalWeight(list, luck);
        if (weight > 0) {
            int roll = Math.min(instrument.m_58904_().f_46441_.m_188503_(weight), weight - 1);
            for (ResultEntry entry : list) {
                if ((roll -= entry.getEffectiveWeight(luck)) >= 0) continue;
                return entry.getResult();
            }
        }
        return gem.m_41777_();
    }

    public int getTotalWeight() {
        return this.getTotalWeight(this.outputs, 0.0f);
    }

    public int getTotalWeight(List<ResultEntry> list, float luck) {
        return list.stream().mapToInt(result -> result.getEffectiveWeight(luck)).sum();
    }

    public float getWeight(ItemStack stack) {
        return this.outputs.stream().filter(r -> ItemHandlerHelper.canItemStacksStack((ItemStack)r.result, (ItemStack)stack)).findAny().map(r -> Float.valueOf(r.weight)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializers.CRYSTALLIZATION.get();
    }

    public static ResultEntry createResult(ItemStack result, float weight) {
        return CrystallizationRecipe.createResult(result, weight, 1.0f);
    }

    public static ResultEntry createResult(ItemStack result, float weight, float quality) {
        return new ResultEntry(result, weight, quality);
    }

    public boolean isValidShard(ItemStack stack) {
        return ((Ingredient)this.ingredients.get(2)).test(stack);
    }

    public static class ResultEntry {
        public static final Codec<ResultEntry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.f_41582_.fieldOf("result").forGetter(r -> r.result), (App)Codec.FLOAT.fieldOf("weight").forGetter(r -> Float.valueOf(r.weight)), (App)Codec.FLOAT.optionalFieldOf("quality", (Object)Float.valueOf(1.0f)).forGetter(r -> Float.valueOf(r.quality))).apply((Applicative)builder, ResultEntry::new));
        public static final Codec<List<ResultEntry>> LIST_CODEC = CODEC.listOf();
        private final float weight;
        private final float quality;
        private final ItemStack result;

        private ResultEntry(ItemStack result, float weight, float quality) {
            this.result = result;
            this.weight = weight;
            this.quality = quality;
        }

        public ItemStack getResult() {
            return this.result.m_41777_();
        }

        public int getEffectiveWeight(float luck) {
            return Math.max(Mth.m_14143_((float)(this.weight + this.quality * luck)), 0);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrystallizationRecipe> {
        private static final Codec<List<ResultEntry>> OUTPUT_CODEC = ResultEntry.LIST_CODEC.fieldOf("outputs").codec();

        @Nonnull
        public CrystallizationRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ElementType type = ElementType.byName(GsonHelper.m_13906_((JsonObject)json, (String)"element_type"));
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(GsonHelper.m_13930_((JsonObject)json, (String)"ingredients"));
            List outputs = (List)CodecHelper.decode(ResultEntry.LIST_CODEC, (JsonElement)json.get("outputs"));
            return new CrystallizationRecipe(recipeId, type, elementAmount, outputs, (List<Ingredient>)ingredients);
        }

        public static NonNullList<Ingredient> readIngredients(JsonObject json) {
            NonNullList list = NonNullList.m_122779_();
            list.add((Object)RecipeHelper.deserializeIngredient(json, "gem"));
            list.add((Object)RecipeHelper.deserializeIngredient(json, "crystal"));
            list.add((Object)RecipeHelper.deserializeIngredient(json, "shard"));
            return list;
        }

        public CrystallizationRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.m_130277_());
            int elementAmount = buffer.readInt();
            List outputs = (List)CodecHelper.decode(OUTPUT_CODEC, (FriendlyByteBuf)buffer);
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new CrystallizationRecipe(recipeId, type, elementAmount, outputs, (List<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrystallizationRecipe recipe) {
            buffer.m_130070_(recipe.getElementType().m_7912_());
            buffer.writeInt(recipe.getElementAmount());
            CodecHelper.encode(OUTPUT_CODEC, recipe.outputs, (FriendlyByteBuf)buffer);
            buffer.writeInt(recipe.m_7527_().size());
            recipe.m_7527_().forEach(ingredient -> ingredient.m_43923_(buffer));
        }
    }
}

