/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.loader;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.loader.AbstractPureOreLoader;

public class PatternPureOreLoader
extends AbstractPureOreLoader {
    public static final Codec<PatternPureOreLoader> CODEC = RecordCodecBuilder.create(builder -> {
        Products.P6 b1 = AbstractPureOreLoader.codec(builder);
        return new Products.P10(b1.t1(), b1.t2(), b1.t3(), b1.t4(), b1.t5(), b1.t6(), (App)Codecs.PATTERN.fieldOf("tag_pattern").forGetter(l -> l.tagPattern), (App)Codecs.PATTERN.listOf().optionalFieldOf("patterns", Collections.emptyList()).forGetter(l -> l.patterns), (App)Codec.STRING.optionalFieldOf("namespace", (Object)"forge").forGetter(l -> l.namespace), (App)Codecs.PATTERN.optionalFieldOf("namespace_pattern").forGetter(l -> l.namespacePattern)).apply((Applicative)builder, PatternPureOreLoader::new);
    });
    final Pattern tagPattern;
    final List<Pattern> patterns;
    final String namespace;
    final Optional<Pattern> namespacePattern;

    public PatternPureOreLoader(HolderSet<Item> source, int elementConsumption, int inputSize, int outputSize, double luckRatio, int order, Pattern tagPattern, List<Pattern> patterns, String namespace, Optional<Pattern> namespacePattern) {
        super(source, elementConsumption, inputSize, outputSize, luckRatio, order);
        this.tagPattern = tagPattern;
        this.patterns = patterns;
        this.namespace = namespace;
        this.namespacePattern = namespacePattern;
    }

    public Codec<PatternPureOreLoader> codec() {
        return CODEC;
    }

    @Override
    protected AbstractPureOreLoader.GeneratedPureOre load(Map<ResourceLocation, PureOre> pureOres, Item ore) {
        Pattern np = this.namespacePattern.orElseGet(() -> Pattern.compile("^" + this.namespace + "$"));
        ResourceLocation id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ore));
        List<TagKey<Item>> tags = ore.m_204114_().m_203616_().filter(t -> {
            ResourceLocation location = t.f_203868_();
            return np.matcher(location.m_135827_()).find() && this.tagPattern.matcher(location.m_135815_()).find();
        }).toList();
        if (!tags.isEmpty()) {
            if (tags.size() > 1) {
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = () -> ((ResourceLocation)id).toString();
                supplierArray[1] = np::pattern;
                supplierArray[2] = this.tagPattern::pattern;
                supplierArray[3] = () -> tags.stream().map(t -> t.f_203868_().toString()).collect(Collectors.joining(", "));
                ElementalCraftApi.LOGGER.warn("Item {} has multiple tags matching \"{}:{}\":\r\n\t{}", supplierArray);
            }
            id = new ResourceLocation(this.namespace, this.cleanPath(this.tagPattern.matcher(tags.get(0).f_203868_().m_135815_()).replaceAll("")));
        } else {
            id = new ResourceLocation(id.m_135827_(), this.cleanPath(id.m_135815_()));
        }
        return new AbstractPureOreLoader.GeneratedPureOre(id, tags);
    }

    private String cleanPath(String path) {
        for (Pattern pattern : this.patterns) {
            path = pattern.matcher(path).replaceAll("");
        }
        return path;
    }
}

