/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.loader;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.util.Supplier;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.loader.IPureOreLoader;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractPureOreLoader
implements IPureOreLoader {
    final HolderSet<Item> source;
    final int elementConsumption;
    final int inputSize;
    final int outputSize;
    final double luckRatio;
    private final int order;

    protected AbstractPureOreLoader(HolderSet<Item> source, int elementConsumption, int inputSize, int outputSize, double luckRatio, int order) {
        this.source = source;
        this.elementConsumption = elementConsumption;
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.luckRatio = luckRatio;
        this.order = order;
    }

    protected static <U extends AbstractPureOreLoader> Products.P6<RecordCodecBuilder.Mu<U>, HolderSet<Item>, Integer, Integer, Integer, Double, Integer> codec(RecordCodecBuilder.Instance<U> builder) {
        return builder.group((App)RegistryCodecs.m_206277_((ResourceKey)ForgeRegistries.Keys.ITEMS).fieldOf("source").forGetter(l -> l.source), (App)Codec.INT.optionalFieldOf("element_consumption", (Object)2500).forGetter(l -> l.elementConsumption), (App)Codec.INT.optionalFieldOf("input_size", (Object)1).forGetter(l -> l.inputSize), (App)Codec.INT.optionalFieldOf("output_size", (Object)2).forGetter(l -> l.outputSize), (App)Codec.DOUBLE.optionalFieldOf("luck_ratio", (Object)0.0).forGetter(l -> l.luckRatio), (App)Codec.INT.optionalFieldOf("order", (Object)Integer.MAX_VALUE).forGetter(AbstractPureOreLoader::getOrder));
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public List<PureOre> generate(RegistryAccess registry, Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> injectors) {
        return List.copyOf(this.generatePureOres(registry, injectors).values());
    }

    private Map<ResourceLocation, PureOre> generatePureOres(RegistryAccess registry, Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> injectors) {
        List<Holder<Item>> list = this.streamSource().toList();
        ResourceLocation id = this.getId();
        if (list.isEmpty()) {
            ElementalCraftApi.LOGGER.debug("No source items found for {}", (Object)id);
            return Collections.emptyMap();
        }
        HashMap<ResourceLocation, PureOre> pureOres = new HashMap<ResourceLocation, PureOre>();
        ElementalCraftApi.LOGGER.info("Loading pure ores: {}.\r\n\tSource ores: {}", new Supplier[]{() -> id, () -> this.streamSource().mapMulti(ElementalCraftUtils.cast(Holder.Reference.class)).map(r -> r.m_205785_().m_135782_().toString()).collect(Collectors.joining(", "))});
        list.forEach(holder -> {
            Item ore = (Item)holder.m_203334_();
            PureOre entry = this.findOrCreateEntry(pureOres, ore);
            boolean isInBlacklist = holder.m_203656_(ECTags.Items.PURE_ORES_MOD_PROCESSING_BLACKLIST);
            injectors.forEach(injector -> {
                if (!injector.isModProcessing() || !isInBlacklist) {
                    injector.getRecipe(ore).ifPresent(i -> entry.addRecipe(registry, i));
                }
            });
        });
        return pureOres;
    }

    @Nonnull
    public ResourceLocation getId() {
        return ElementalCraft.PURE_ORE_LOADERS_MANAGER.getId((Object)this);
    }

    @Nonnull
    public Stream<Holder<Item>> streamSource() {
        return this.source.m_203614_();
    }

    private PureOre findOrCreateEntry(Map<ResourceLocation, PureOre> pureOres, Item ore) {
        for (PureOre pureOre : pureOres.values()) {
            if (!pureOre.contains(ore)) continue;
            return pureOre;
        }
        GeneratedPureOre generated = this.load(pureOres, ore);
        PureOre entry = pureOres.computeIfAbsent(generated.id(), i -> new PureOre((ResourceLocation)i, this.elementConsumption, this.inputSize, this.outputSize, this.luckRatio));
        entry.getOres().add(ore);
        generated.tags().forEach(entry::addTag);
        return entry;
    }

    protected abstract GeneratedPureOre load(Map<ResourceLocation, PureOre> var1, Item var2);

    public record GeneratedPureOre(ResourceLocation id, List<TagKey<Item>> tags) {
    }
}

