/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import sirttas.elementalcraft.ElementalCraft;

@Mod.EventBusSubscriber(modid="elementalcraft")
public final class LootHandler {
    private static final List<String> BLACKLIST = List.of("dispenser");
    public static final List<EntityType<?>> INJECT_LIST = List.of(EntityType.f_20501_, EntityType.f_20530_, EntityType.f_20524_, EntityType.f_20497_, EntityType.f_20523_, EntityType.f_20460_, EntityType.f_20525_, EntityType.f_20558_, EntityType.f_20453_, EntityType.f_20551_, EntityType.f_20458_, EntityType.f_20468_, EntityType.f_20531_, EntityType.f_20500_, EntityType.f_20562_, EntityType.f_20455_, EntityType.f_20563_, EntityType.f_20526_, EntityType.f_20481_, EntityType.f_20480_, EntityType.f_147034_, EntityType.f_147035_, EntityType.f_147039_, EntityType.f_20514_, EntityType.f_20559_, EntityType.f_20556_, EntityType.f_20519_, EntityType.f_20489_, EntityType.f_20516_, EntityType.f_20566_, EntityType.f_20479_, EntityType.f_20554_, EntityType.f_20509_, EntityType.f_20521_);

    private LootHandler() {
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        ResourceLocation name = evt.getName();
        ResourceLocation injectName = ElementalCraft.createRL("inject/" + name.m_135815_());
        if (INJECT_LIST.stream().anyMatch(t -> StringUtils.equals((CharSequence)t.m_20677_().m_135815_(), (CharSequence)name.m_135815_()))) {
            evt.getTable().addPool(LootHandler.getInjectPool(injectName));
        } else if (name.toString().startsWith("minecraft:chests/")) {
            if (BLACKLIST.stream().anyMatch(name.toString()::contains)) {
                evt.getTable().addPool(LootHandler.getInjectPool(ElementalCraft.createRL("chests/inject")));
            }
        }
    }

    public static LootPool getInjectPool(ResourceLocation name) {
        return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)name).m_79707_(1)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("elementalcraft_inject").m_79082_();
    }
}

