/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.ToolActionSpell;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public abstract class AbstractSpellHolderItem
extends ECItem
implements ISpellHolder {
    protected AbstractSpellHolderItem(Item.Properties properties) {
        super(properties);
    }

    protected void addAttributeTooltip(List<Component> tooltip, Spell spell) {
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237110_((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{spell.getElementType().getDisplayName()}).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.elementalcraft.cooldown", (Object[])new Object[]{spell.getCooldown() / 20}).m_130940_(ChatFormatting.YELLOW));
        spell.addInformation(tooltip);
        AbstractSpellHolderItem.addAttributeMultiMapToTooltip(tooltip, spell.getOnUseAttributeModifiers(), (Component)Component.m_237115_((String)"tooltip.elementalcraft.on_spell_use").m_130940_(ChatFormatting.GRAY));
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return SpellHelper.getSpell(stack).getUseDuration();
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return SpellHelper.getSpell(stack).getUseAnimation();
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return new InteractionResultHolder(this.tick(level, player, hand, stack, true), (Object)stack);
    }

    public void m_5929_(@Nonnull Level level, @Nonnull LivingEntity entity, @Nonnull ItemStack stack, int count) {
        block3: {
            block2: {
                if (!(entity instanceof Player)) break block2;
                Player player = (Player)entity;
                if (this.tick(entity.m_9236_(), player, entity.m_7655_(), stack, false) == InteractionResult.CONSUME) break block3;
            }
            entity.m_21253_();
        }
    }

    public void m_5551_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving, int timeLeft) {
        this.m_5922_(stack, level, entityLiving);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, Level level, @Nonnull LivingEntity entityLiving) {
        block2: {
            block3: {
                if (level.f_46443_) break block2;
                if (!(entityLiving instanceof Player)) break block3;
                Player player = (Player)entityLiving;
                if (player.m_150110_().f_35937_) break block2;
            }
            SpellTickHelper.startCooldown((ICapabilityProvider)entityLiving, SpellHelper.getSpell(stack));
        }
        return stack;
    }

    private InteractionResult tick(Level level, Player player, InteractionHand hand, ItemStack stack, boolean doChannel) {
        InteractionResult result;
        Spell spell = SpellHelper.getSpell(stack);
        Multimap<Attribute, AttributeModifier> attributes = spell.getOnUseAttributeModifiers();
        player.m_21204_().m_22178_(attributes);
        InteractionResult interactionResult = result = Boolean.TRUE.equals(ECConfig.COMMON.spellConsumeOnFail.get()) || spell.consume((Entity)player, true) ? this.castSpell(player, spell) : InteractionResult.FAIL;
        if (result.m_19077_()) {
            if (this.doConsume(player, hand, stack, spell)) {
                result = InteractionResult.SUCCESS;
            }
            if (result.m_19080_() && !player.m_150110_().f_35937_) {
                if (!level.f_46443_) {
                    SpellTickHelper.startCooldown((ICapabilityProvider)player, spell);
                }
                player.m_21253_();
            } else if (doChannel && spell.isChannelable()) {
                player.m_6672_(hand);
            }
        } else {
            player.m_21253_();
        }
        player.m_21204_().m_22161_(attributes);
        return result;
    }

    private InteractionResult castSpell(Player player, Spell spell) {
        if (SpellTickHelper.hasCooldown((ICapabilityProvider)player, spell)) {
            return InteractionResult.PASS;
        }
        InteractionResult result = InteractionResult.PASS;
        HitResult ray = EntityHelper.rayTrace((Entity)player);
        HitResult.Type rayType = ray.m_6662_();
        if (rayType == HitResult.Type.ENTITY && ray instanceof EntityHitResult) {
            EntityHitResult entityRay = (EntityHitResult)ray;
            result = spell.castOnEntity((Entity)player, entityRay.m_82443_());
        }
        if (rayType == HitResult.Type.BLOCK && !result.m_19077_() && ray instanceof BlockHitResult) {
            BlockHitResult blockRay = (BlockHitResult)ray;
            result = spell.castOnBlock((Entity)player, blockRay.m_82425_(), blockRay);
        }
        if (!result.m_19077_()) {
            result = spell.castOnSelf((Entity)player);
        }
        return result;
    }

    private boolean doConsume(Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        if (!player.m_150110_().f_35937_ && !spell.consume((Entity)player, false)) {
            this.consume(stack);
            player.m_21190_(hand);
            return true;
        }
        return false;
    }

    protected abstract void consume(ItemStack var1);

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        ToolActionSpell toolActionSpell;
        Spell spell = SpellHelper.getSpell(stack);
        return spell instanceof ToolActionSpell && (toolActionSpell = (ToolActionSpell)spell).getActions().contains(toolAction);
    }
}

