/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion.tool.effect;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.elementalcraft.api.infusion.tool.effect.IToolInfusionEffect;
import sirttas.elementalcraft.api.infusion.tool.effect.ToolInfusionEffectType;
import sirttas.elementalcraft.infusion.tool.effect.ToolInfusionEffectTypes;
import sirttas.elementalcraft.item.ECItem;

public record AttributeToolInfusionEffect(List<EquipmentSlot> slots, Attribute attribute, AttributeModifier modifier) implements IToolInfusionEffect
{
    public static final String NAME = "attribute";
    public static final Codec<AttributeToolInfusionEffect> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codecs.EQUIPMENT_SLOT_TYPE.listOf().fieldOf("slot").forGetter(i -> i.slots), (App)Codecs.ATTRIBUTE.fieldOf(NAME).forGetter(i -> i.attribute), (App)Codecs.ATTRIBUTE_MODIFIER.fieldOf("modifier").forGetter(i -> i.modifier)).apply((Applicative)builder, AttributeToolInfusionEffect::new));

    public AttributeToolInfusionEffect(List<EquipmentSlot> slots, Attribute attribute, AttributeModifier modifier) {
        this.slots = ImmutableList.copyOf(slots);
        this.attribute = attribute;
        this.modifier = modifier;
    }

    @Override
    public Component getDescription() {
        return ECItem.getAttributeTooltip(this.attribute, this.modifier).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public ToolInfusionEffectType<? extends IToolInfusionEffect> getType() {
        return (ToolInfusionEffectType)ToolInfusionEffectTypes.ATTRIBUTE.get();
    }
}

