/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.mana;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.synthesizer.mana.ManaSynthesizerManaReceiver;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.interaction.ECinteractions;
import vazkii.botania.api.BotaniaForgeCapabilities;

public class ManaSynthesizerBlockEntity
extends SolarSynthesizerBlockEntity {
    private final ManaSynthesizerManaReceiver manaReceiver = new ManaSynthesizerManaReceiver(this);

    public ManaSynthesizerBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.MANA_SYNTHESIZER, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ManaSynthesizerBlockEntity manaSynthesizer) {
        Double ratio = (Double)ECConfig.COMMON.manaElementRatio.get();
        int mana = Math.min((Integer)ECConfig.COMMON.manaSynthesizerManaCapacity.get() / 20, manaSynthesizer.manaReceiver.getCurrentMana());
        if (mana > 0) {
            int synthesized = manaSynthesizer.handleSynthesis((float)((double)mana * ratio));
            if (synthesized > 0) {
                manaSynthesizer.manaReceiver.receiveMana(-((int)Math.round((double)synthesized / ratio)));
                manaSynthesizer.breakLens(level, pos);
            }
        } else {
            manaSynthesizer.working = false;
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.manaReceiver.setMana(compound.m_128451_("mana"));
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("mana", this.manaReceiver.getCurrentMana());
    }

    @Override
    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            if (ECinteractions.isBotaniaActive() && cap == BotaniaForgeCapabilities.MANA_RECEIVER) {
                return LazyOptional.of((NonNullSupplier)(this.manaReceiver != null ? () -> this.manaReceiver : null)).cast();
            }
            if (cap == ElementalCraftCapabilities.ELEMENT_STORAGE) {
                return this.getElementStorage((Integer)ECConfig.COMMON.manaSynthesizerLensElementMultiplier.get());
            }
        }
        return super.getCapability(cap, side);
    }
}

