/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.block.source.trait.value.LinearSourceTraitValueProvider;
import sirttas.elementalcraft.block.source.trait.value.SourceTraitValueProviderTypes;

public class RangeBasedSourceTraitValueProvider
extends LinearSourceTraitValueProvider {
    public static final String NAME = "range_based";
    public static final Codec<RangeBasedSourceTraitValueProvider> CODEC = RecordCodecBuilder.create(builder -> RangeBasedSourceTraitValueProvider.codec(builder).and((App)Codec.FLOAT.fieldOf("weight").forGetter(p -> Float.valueOf(p.weight))).apply((Applicative)builder, RangeBasedSourceTraitValueProvider::new));
    private final float weight;

    public RangeBasedSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float end, float weight) {
        this(translationKey, types, 0.0f, end, weight);
    }

    public RangeBasedSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float start, float end, float weight) {
        this(translationKey, types, start, end, 1.0f, weight);
    }

    public RangeBasedSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float start, float end, float luckRatio, float weight) {
        super(translationKey, types, start, end, luckRatio);
        this.weight = weight;
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        BlockPos blockPos;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockPos = serverLevel.m_220360_();
        } else {
            blockPos = BlockPos.f_121853_;
        }
        BlockPos spawn = blockPos;
        double rangeSq = new BlockPos(spawn.m_123341_(), 0, spawn.m_123343_()).m_123331_((Vec3i)new BlockPos(pos.m_123341_(), 0, pos.m_123343_()));
        float newStart = Math.min(this.start + context.luck() * this.luckRatio, this.end);
        return this.createValue(newStart + (float)(rangeSq / (rangeSq + (double)(context.random().m_188501_() * this.weight * this.weight))) * (this.end - newStart));
    }

    @Nonnull
    public SourceTraitValueProviderType<RangeBasedSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.RANGE_BASED.get();
    }
}

