/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.block.source.breeder.SourceBreederItemContainer;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlockEntity;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.tag.ECTags;

public class SourceBreederBlockEntity
extends AbstractECContainerBlockEntity
implements IElementTypeProvider {
    private final SourceBreederItemContainer container;
    private final RuneHandler runeHandler;
    private final Map<Direction, PedestalWrapper> pedestalWrappers;
    private final int baseCost;

    public SourceBreederBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOURCE_BREEDER, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.sourceBreederMaxRunes.get(), this::m_6596_);
        this.baseCost = (Integer)ECConfig.COMMON.sourceBreedingBaseCost.get();
        this.container = new SourceBreederItemContainer(this::m_6596_);
        this.pedestalWrappers = new EnumMap<Direction, PedestalWrapper>(Direction.class);
        this.pedestalWrappers.put(Direction.NORTH, new PedestalWrapper());
        this.pedestalWrappers.put(Direction.SOUTH, new PedestalWrapper());
        this.pedestalWrappers.put(Direction.WEST, new PedestalWrapper());
        this.pedestalWrappers.put(Direction.EAST, new PedestalWrapper());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SourceBreederBlockEntity breeder) {
        breeder.refreshPedestals();
        breeder.makeProgress();
    }

    private void refreshPedestals() {
        this.pedestalWrappers.forEach((d, w) -> {
            if (w.isRemoved()) {
                w.progress = 0;
                w.lookupPedestal((Direction)d);
            }
        });
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.container;
    }

    @Override
    public ElementType getElementType() {
        ItemStack stack = this.container.m_8020_(0);
        if (!stack.m_204117_(ECTags.Items.SOURCE_SEEDS)) {
            return ElementType.NONE;
        }
        Item item = stack.m_41720_();
        if (item instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)item;
            return provider.getElementType();
        }
        return ElementType.NONE;
    }

    private void makeProgress() {
        ElementType type = this.getElementType();
        List<PedestalWrapper> activeWrappers = this.pedestalWrappers.values().stream().filter(w -> !w.isRemoved()).toList();
        if (!this.container.m_8020_(0).m_204117_(ECTags.Items.SOURCE_SEEDS) || activeWrappers.size() != 2 || !activeWrappers.stream().allMatch(w -> w.pedestal.hasSource() && w.getElementType() == type)) {
            this.resetProgress();
            return;
        }
        activeWrappers.forEach(this::transfer);
        if (activeWrappers.stream().allMatch(w -> (float)w.progress >= w.getCost())) {
            this.container.m_6836_(0, this.breed(type, activeWrappers.get(0).getTraitHolder(), activeWrappers.get(1).getTraitHolder()));
            RetrieverBlock.sendOutputToRetriever(this.f_58857_, this.f_58858_, this.getInventory(), 0);
            RetrieverBlock.sendOutputToRetriever(this.f_58857_, this.f_58858_.m_7494_(), this.getInventory(), 0);
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.pedestalWrappers.values().forEach(w -> {
            w.progress = 0;
        });
    }

    private void transfer(PedestalWrapper wrapper) {
        float cost = wrapper.getCost();
        int oldProgress = wrapper.progress;
        float transferAmount = Math.min(this.getTransferSpeed(wrapper.pedestal), cost - (float)wrapper.progress);
        if (transferAmount > 0.0f) {
            float preservation = this.runeHandler.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + wrapper.pedestal.getRuneHandler().getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
            wrapper.progress = Math.round((float)wrapper.progress + (float)Math.max(1, wrapper.pedestal.getElementStorage().extractElement(Math.round(transferAmount / preservation), false)) * preservation);
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && wrapper.progress > oldProgress && this.f_58857_.f_46441_.m_188500_() < 0.2) {
            ParticleHelper.createElementFlowParticle(wrapper.getElementType(), this.f_58857_, Vec3.m_82512_((Vec3i)wrapper.pedestal.m_58899_()).m_231075_(Direction.UP, 0.4), Vec3.m_82512_((Vec3i)this.f_58858_).m_231075_(Direction.UP, 1.7), this.f_58857_.f_46441_);
        } else if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    private float getTransferSpeed(SourceBreederPedestalBlockEntity pedestal) {
        return (float)((Integer)ECConfig.COMMON.sourceBreederTransferSpeed.get()).intValue() * (this.runeHandler.getBonus(Rune.BonusType.SPEED) + pedestal.getRuneHandler().getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    private ItemStack breed(ElementType elementType, ISourceTraitHolder source1, ISourceTraitHolder source2) {
        return ReceptacleHelper.create(elementType, SourceTraitHelper.breed(this.f_58857_.f_46441_, this.runeHandler.getBonus(Rune.BonusType.LUCK), this.container.m_8020_(0).m_204117_(ECTags.Items.NATURAL_SOURCE_SEEDS), source1.getTraits(), source2.getTraits()));
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128385_("progress", this.pedestalWrappers.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Direction)e.getKey()).m_122416_())).mapToInt(e -> ((PedestalWrapper)e.getValue()).progress).toArray());
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ElementalCraftCapabilities.RUNE_HANDLE) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }

    public List<Direction> getPedestalsDirections() {
        return this.pedestalWrappers.entrySet().stream().filter(e -> !((PedestalWrapper)e.getValue()).isRemoved()).map(Map.Entry::getKey).toList();
    }

    private class PedestalWrapper
    implements IElementTypeProvider {
        private SourceBreederPedestalBlockEntity pedestal = null;
        private int progress = 0;

        public boolean isRemoved() {
            return this.pedestal == null || this.pedestal.m_58901_();
        }

        @Override
        public ElementType getElementType() {
            return this.isRemoved() ? ElementType.NONE : this.pedestal.getElementType();
        }

        public void lookupPedestal(Direction direction) {
            SourceBreederPedestalBlockEntity p;
            BlockEntity te = SourceBreederBlockEntity.this.f_58857_ != null ? SourceBreederBlockEntity.this.f_58857_.m_7702_(SourceBreederBlockEntity.this.f_58858_.m_5484_(direction, 2)) : null;
            this.pedestal = te instanceof SourceBreederPedestalBlockEntity ? (p = (SourceBreederPedestalBlockEntity)te) : null;
        }

        public ISourceTraitHolder getTraitHolder() {
            return this.pedestal.getTraitHolder();
        }

        public float getCost() {
            return (float)SourceBreederBlockEntity.this.baseCost * this.getTraitHolder().getBreedingCost();
        }

        public void setPedestalInventory(ItemStack stack) {
            if (this.isRemoved()) {
                return;
            }
            this.pedestal.getInventory().m_6836_(0, stack);
            this.pedestal.m_6596_();
        }
    }
}

