/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.DoubleStream;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.properties.ShrineRange;

public record ShrineProperties(ElementType elementType, double period, int consumption, int capacity, ShrineRange range, List<Double> strength) implements IElementTypeProvider
{
    public static final ShrineProperties DEFAULT = new ShrineProperties(ElementType.NONE, 1.0, 0, 1000000, ShrineRange.DEFAULT, Collections.emptyList());
    public static final Codec<ShrineProperties> CODEC = RecordCodecBuilder.create(builder -> builder.group(ElementType.forGetter(ShrineProperties::getElementType), (App)Codec.DOUBLE.optionalFieldOf("periode", (Object)0.0).forGetter(ShrineProperties::period), (App)Codec.INT.optionalFieldOf("element_consumption", (Object)0).forGetter(ShrineProperties::consumption), (App)Codec.INT.optionalFieldOf("element_capacity", (Object)0).forGetter(ShrineProperties::capacity), (App)ShrineRange.CODEC.optionalFieldOf("range", (Object)ShrineRange.DEFAULT).forGetter(ShrineProperties::range), (App)Codec.DOUBLE.listOf().optionalFieldOf("strength", Collections.emptyList()).forGetter(ShrineProperties::strength)).apply((Applicative)builder, ShrineProperties::new));

    public static Builder builder(ElementType elementType) {
        return new Builder(elementType);
    }

    public static Builder builder(AbstractShrineBlock<?> block) {
        return ShrineProperties.builder(block.getElementType());
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public static class Builder {
        public static final Encoder<Builder> ENCODER = CODEC.comap(builder -> new ShrineProperties(builder.elementType, builder.period, builder.consumption, builder.capacity, builder.range, builder.strength));
        private double period;
        private int consumption;
        private int capacity;
        private ShrineRange range;
        private List<Double> strength;
        private final ElementType elementType;

        private Builder(ElementType elementType) {
            this.elementType = elementType;
            this.consumption = 0;
            this.period = 1.0;
            this.range = ShrineRange.DEFAULT;
            this.capacity = 10000;
            this.strength = Collections.emptyList();
        }

        public Builder consumption(int consumeAmount) {
            this.consumption = consumeAmount;
            return this;
        }

        public Builder period(double period) {
            if (period <= 0.0) {
                throw new IllegalArgumentException("Shrine period should be greater than 0");
            }
            this.period = period;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder range(ShrineRange.Builder builder) {
            return this.range(builder.build());
        }

        public Builder range(ShrineRange range) {
            this.range = range;
            return this;
        }

        public Builder strength(double ... strength) {
            this.strength = DoubleStream.of(strength).boxed().toList();
            return this;
        }
    }
}

