/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.rune.handler;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.Rune;

@AutoRegisterCapability
public interface IRuneHandler {
    public void addRune(Rune var1);

    public void removeRune(Rune var1);

    public int getMaxRunes();

    default public void clear() {
        this.getRunes().forEach(this::removeRune);
    }

    public List<Rune> getRunes();

    default public int getRuneCount() {
        return this.getRunes().size();
    }

    default public int getRuneCount(Rune rune) {
        List<Rune> runes = this.getRunes();
        return runes == null ? 0 : (int)runes.stream().filter(rune::equals).count();
    }

    default public int getRuneCount(ResourceKey<Rune> rune) {
        List<Rune> runes = this.getRunes();
        return runes == null ? 0 : (int)runes.stream().filter(r -> r.is(rune)).count();
    }

    public float getBonus(Rune.BonusType var1);

    default public float getTransferSpeed(float baseTransferSpeed) {
        return baseTransferSpeed * (this.getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    default public float getElementPreservation() {
        return this.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
    }

    default public int handleElementTransfer(IElementStorage from, IElementStorage to, ElementType type, float amount) {
        return from.transferTo(to, type, this.getTransferSpeed(amount), this.getElementPreservation());
    }

    default public int handleElementTransfer(ISingleElementStorage from, IElementStorage to, float amount) {
        return this.handleElementTransfer(from, to, from.getElementType(), amount);
    }

    public static ListTag writeNBT(IRuneHandler handler) {
        return handler.getRunes().stream().map(rune -> StringTag.m_129297_((String)rune.getId().toString())).collect(Collectors.toCollection(ListTag::new));
    }

    public static void readNBT(IRuneHandler handler, ListTag nbtTagList) {
        handler.clear();
        nbtTagList.forEach(nbt -> {
            String name = nbt.m_7916_();
            Rune rune = (Rune)ElementalCraftApi.RUNE_MANAGER.get(new ResourceLocation(name));
            if (rune != null) {
                handler.addRune(rune);
            } else {
                ElementalCraftApi.LOGGER.warn("Rune not fount with id: {}", (Object)name);
            }
        });
    }
}

