/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.pureore.injector;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import sirttas.elementalcraft.api.pureore.PureOreException;

public abstract class AbstractPureOreRecipeInjector<C extends Container, T extends Recipe<C>> {
    public static final IForgeRegistry<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> REGISTRY = RegistryManager.ACTIVE.getRegistry(new ResourceLocation("elementalcraft", "pure_ore_recipe_injector"));
    private final Lazy<RecipeType<T>> recipeType;
    private final boolean modProcessing;
    private Map<ResourceLocation, T> recipes;

    protected AbstractPureOreRecipeInjector(@Nonnull RecipeType<T> recipeType) {
        this(() -> recipeType, true);
    }

    protected AbstractPureOreRecipeInjector(@Nonnull RecipeType<T> recipeType, boolean modProcessing) {
        this(() -> recipeType, modProcessing);
    }

    protected AbstractPureOreRecipeInjector(@Nonnull Supplier<RecipeType<T>> recipeType) {
        this(recipeType, true);
    }

    protected AbstractPureOreRecipeInjector(@Nonnull Supplier<RecipeType<T>> recipeType, boolean modProcessing) {
        this.recipeType = Lazy.of(recipeType);
        this.recipes = null;
        this.modProcessing = modProcessing;
    }

    public static ResourceLocation buildRecipeId(@Nonnull ResourceLocation source) {
        return new ResourceLocation("elementalcraft", "pure_ore/" + source.m_135827_() + "/" + source.m_135815_());
    }

    public void init(@Nonnull RecipeManager recipeManager) {
        this.recipes = recipeManager.m_44054_((RecipeType)this.recipeType.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean filter(T recipe, ItemStack stack) {
        try {
            return ((Ingredient)recipe.m_7527_().get(0)).test(stack);
        }
        catch (Exception e) {
            throw new PureOreException(MessageFormat.format("Error while reading ingredients for recipe {0}. Please setup a custom filter for {1}", recipe.m_6423_(), this), e);
        }
    }

    public ItemStack getRecipeOutput(@Nonnull RegistryAccess registry, @Nonnull T recipe) {
        return recipe.m_8043_(registry);
    }

    public abstract T build(@Nonnull RegistryAccess var1, @Nonnull T var2, @Nonnull Ingredient var3);

    public Map<ResourceLocation, T> getRecipes() {
        return this.recipes;
    }

    public Optional<T> getRecipe(@Nonnull Item ore) {
        return this.getRecipes().values().stream().filter(recipe -> this.filter(recipe, new ItemStack((ItemLike)ore))).min(Comparator.comparing(Recipe::m_6423_));
    }

    public RecipeType<T> getRecipeType() {
        return (RecipeType)this.recipeType.get();
    }

    public ResourceLocation getRecipeTypeRegistryName() {
        return ForgeRegistries.RECIPE_TYPES.getKey((Object)((RecipeType)this.recipeType.get()));
    }

    public String toString() {
        return this.getRecipeTypeRegistryName().toString();
    }

    public boolean isModProcessing() {
        return this.modProcessing;
    }
}

