/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.storage.IElementStorage;

public class ElementStorageHelper {
    private ElementStorageHelper() {
    }

    @Nonnull
    public static LazyOptional<IElementStorage> get(ICapabilityProvider provider) {
        return ElementStorageHelper.get(provider, null);
    }

    @Nonnull
    public static LazyOptional<IElementStorage> get(ICapabilityProvider provider, Direction side) {
        return ElementalCraftCapabilities.ELEMENT_STORAGE != null && provider != null ? provider.getCapability(ElementalCraftCapabilities.ELEMENT_STORAGE, side) : LazyOptional.empty();
    }

    @Nullable
    public static <T extends Tag, S extends IElementStorage & INBTSerializable<T>> ICapabilityProvider createProvider(S storage) {
        return ElementalCraftCapabilities.ELEMENT_STORAGE != null ? new CapabilityProvider(storage) : null;
    }

    private record CapabilityProvider<T extends Tag, S extends IElementStorage & INBTSerializable<T>>(S storage) implements ICapabilitySerializable<T>
    {
        @NotNull
        public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
            return ElementalCraftCapabilities.ELEMENT_STORAGE.orEmpty(cap, LazyOptional.of(() -> this.storage));
        }

        public T serializeNBT() {
            return (T)((INBTSerializable)this.storage).serializeNBT();
        }

        public void deserializeNBT(T nbt) {
            ((INBTSerializable)this.storage).deserializeNBT(nbt);
        }
    }
}

