/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import java.util.Optional;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class VehicleStatusScreenModule
implements IScreenModule<IModuleDataString> {
    private ResourceKey<Level> dim = Level.f_46428_;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private String label = "";
    private String vehicle = "";

    public IModuleDataString getData(IScreenDataHelper helper, Level level, long millis) {
        String mover = VehicleStatusScreenModule.getMoverController(level, this.dim, this.coordinate).map(c -> {
            MoverTileEntity m = c.findVehicle(this.vehicle);
            if (m != null) {
                return m.getName();
            }
            return "<unknown>";
        }).orElse("<unknown>");
        return helper.createString(mover);
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            this.vehicle = tagCompound.m_128461_("vehicle");
            this.label = tagCompound.m_128461_("label");
        }
    }

    private void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            this.coordinate = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
        }
    }

    public int getRfPerTick() {
        return (Integer)MoverConfiguration.VEHICLE_STATUS_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }

    public static Optional<MoverControllerTileEntity> getMoverController(Level worldObj, ResourceKey<Level> dim, BlockPos coordinate) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, dim);
        if (world == null) {
            return Optional.empty();
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)coordinate)) {
            return Optional.empty();
        }
        BlockEntity te = world.m_7702_(coordinate);
        if (te == null) {
            return Optional.empty();
        }
        if (!(te instanceof MoverControllerTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((MoverControllerTileEntity)te);
    }
}

