/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BrowAnimPacket {
    int sourceId;
    OwlEntity.BrowAnim browAnim;
    int duration;
    boolean happyAnim;

    public BrowAnimPacket(Entity entity, OwlEntity.BrowAnim browAnim, int duration) {
        this.sourceId = entity.m_19879_();
        this.browAnim = browAnim;
        this.duration = duration;
        this.happyAnim = false;
    }

    public BrowAnimPacket(Entity entity, OwlEntity.BrowAnim browAnim, int duration, boolean happyAnim) {
        this.sourceId = entity.m_19879_();
        this.browAnim = browAnim;
        this.duration = duration;
        this.happyAnim = happyAnim;
    }

    public BrowAnimPacket(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.browAnim = (OwlEntity.BrowAnim)buf.m_130066_(OwlEntity.BrowAnim.class);
        this.duration = buf.readInt();
        this.happyAnim = buf.readBoolean();
    }

    public static void encode(BrowAnimPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.m_130068_((Enum)object.browAnim);
        buffer.writeInt(object.duration);
        buffer.writeBoolean(object.happyAnim);
    }

    public static BrowAnimPacket decode(FriendlyByteBuf buffer) {
        return new BrowAnimPacket(buffer);
    }

    public static void consume(BrowAnimPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity patt2336$temp;
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            if (world.m_6815_(packet.sourceId) != null && (patt2336$temp = world.m_6815_(packet.sourceId)) instanceof OwlEntity) {
                OwlEntity owl = (OwlEntity)patt2336$temp;
                if (packet.happyAnim) {
                    owl.browHappyAnimation.start();
                    owl.browHappyAnimation.activeTimer = packet.duration;
                    owl.browHappyAnimation.setBrowAnim(packet.browAnim);
                } else {
                    owl.browAnimation.start();
                    owl.browAnimation.activeTimer = packet.duration;
                    owl.browAnimation.setBrowAnim(packet.browAnim);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

