/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.EmitParticlesPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CandleDipperTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public float numberOfCandles;
    public static int DRYING_START_TICKS = 60;
    public List<DipperSlot> dipperSlots = new ArrayList<DipperSlot>(3);
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public CandleDipperTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.dipperSlots.add(new DipperSlot(0, new Vec3(0.5, (double)0.4f, 0.5), DipperState.NON, 200, 60, 3, 100, ItemStack.f_41583_));
        this.dipperSlots.add(new DipperSlot(1, new Vec3(0.5, (double)0.4f, 0.5), DipperState.NON, 200, 60, 3, 100, ItemStack.f_41583_));
        this.dipperSlots.add(new DipperSlot(2, new Vec3(0.5, (double)0.4f, 0.5), DipperState.NON, 200, 60, 3, 100, ItemStack.f_41583_));
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public CandleDipperTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get(), blockPos, blockState);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            itemStack.m_41764_(1);
            this.items.set(index, (Object)itemStack);
            this.dipperSlots.get((int)index).dryingTicks = DRYING_START_TICKS;
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
        }
        this.m_6596_();
    }

    public ItemStack m_7407_(int index, int p_59614_) {
        this.m_59640_(null);
        ItemStack itemstack = ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)p_59614_);
        if (!itemstack.m_41619_()) {
            this.dipperSlots.get((int)index).state = DipperState.NON;
            this.m_6596_();
        }
        return itemstack;
    }

    public void craft() {
        SimpleContainer inv = new SimpleContainer(3);
        for (int i = 0; i < 3; ++i) {
            inv.m_6836_(i, (ItemStack)this.items.get(i));
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        AtomicBoolean[] matchesRecipe = new AtomicBoolean[3];
        for (int i = 0; i < matchesRecipe.length; ++i) {
            matchesRecipe[i] = new AtomicBoolean(false);
        }
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldronTile = (MixingCauldronTile)blockEntity;
            List<DipperRecipe> recipes = this.f_58857_.m_7465_().m_44056_((RecipeType)DipperRecipe.Type.INSTANCE, (Container)inv, this.f_58857_).stream().filter(dipperRecipe -> {
                FluidStack tileFluid = mixingCauldronTile.getFluidStack();
                FluidStack recipeFluid = dipperRecipe.getLiquid();
                CompoundTag tag = tileFluid.hasTag() ? tileFluid.getOrCreateTag() : new CompoundTag();
                CompoundTag tag2 = recipeFluid.hasTag() ? recipeFluid.getOrCreateTag() : new CompoundTag();
                return NbtUtils.m_129235_((Tag)tag2, (Tag)tag, (boolean)true);
            }).toList();
            recipes.forEach(iRecipe -> {
                boolean flag;
                ItemStack output = iRecipe.m_8043_(this.f_58857_.m_9598_());
                ItemStack input = ((Ingredient)iRecipe.m_7527_().get(0)).m_43908_()[0];
                boolean matchesFluid = iRecipe.getLiquid().getFluid().m_6212_(mixingCauldronTile.getFluidStack().getFluid()) && iRecipe.getFluidLevelsConsumed() <= mixingCauldronTile.getFluidStack().getAmount();
                boolean hasFluidTag = iRecipe.getLiquid().hasTag();
                if (hasFluidTag && !mixingCauldronTile.getFluidStack().isEmpty() && !mixingCauldronTile.getFluidStack().getOrCreateTag().equals((Object)iRecipe.getLiquid().getOrCreateTag())) {
                    matchesFluid = false;
                }
                ResourceLocation fl2 = ForgeRegistries.FLUIDS.getKey((Object)mixingCauldronTile.getFluidStack().getFluid());
                CompoundTag fluidTag = mixingCauldronTile.getFluidStack().isEmpty() ? new CompoundTag() : mixingCauldronTile.getFluidStack().copy().getOrCreateTag();
                ResourceLocation fl1 = ForgeRegistries.FLUIDS.getKey((Object)iRecipe.getLiquid().getFluid());
                if (!matchesFluid && fl1 != null && fl2 != null && fl1.m_135815_().equals(fl2.m_135815_()) && (flag = NbtUtils.m_129235_((Tag)iRecipe.getLiquid().copy().getOrCreateTag(), (Tag)fluidTag, (boolean)true))) {
                    matchesFluid = true;
                }
                boolean useInputItemAsOutput = iRecipe.getUseInputItemAsOutput();
                CompoundTag tag = input.m_41784_();
                for (int i = 0; i < matchesRecipe.length; ++i) {
                    CompoundTag tag2 = ((ItemStack)this.items.get(i)).m_41784_();
                    boolean compare = NbtUtils.m_129235_((Tag)tag, (Tag)tag2, (boolean)true);
                    DipperSlot dipperSlot = this.dipperSlots.get(i);
                    if (input.m_41720_() == ((ItemStack)this.items.get(i)).m_41720_() && compare && !matchesRecipe[i].get()) {
                        if (!matchesFluid) continue;
                        matchesRecipe[i].set(true);
                        if (!dipperSlot.isNon()) continue;
                        dipperSlot.state = DipperState.DRYING;
                        dipperSlot.output = output.m_41777_();
                        if (useInputItemAsOutput) {
                            ItemStack stack = ((ItemStack)this.items.get(i)).m_41777_();
                            stack.m_41784_().m_128391_(output.m_41784_());
                            dipperSlot.output = stack;
                        }
                        dipperSlot.fluidConsumptionAmount = iRecipe.getFluidLevelsConsumed();
                        dipperSlot.timesDipped = 0;
                        dipperSlot.timesDippedMax = iRecipe.getNumberOfDips();
                        dipperSlot.dryingTicksMax = iRecipe.getDryingTime();
                        dipperSlot.dryingTicks = DRYING_START_TICKS;
                        dipperSlot.dippingTicks = dipperSlot.dippingTicksMax = iRecipe.getDippingTime();
                        this.m_6596_();
                        continue;
                    }
                    if (!matchesFluid || !dipperSlot.isCrafting()) continue;
                    dipperSlot.state = DipperState.NON;
                    this.m_6596_();
                }
            });
            for (int i = 0; i < matchesRecipe.length; ++i) {
                if (matchesRecipe[i].get() || !this.dipperSlots.get(i).isCrafting()) continue;
                this.dipperSlots.get((int)i).state = DipperState.NON;
                this.dipperSlots.get((int)i).dryingTicks = DRYING_START_TICKS;
                this.m_6596_();
            }
            for (DipperSlot slot : this.dipperSlots) {
                if (slot.isDrying() && slot.timesDipped < slot.timesDippedMax) {
                    --slot.dryingTicks;
                    if (slot.dryingTicks > 0) continue;
                    slot.dryingTicks = slot.dryingTicksMax;
                    slot.state = DipperState.DUNKING;
                    this.m_6596_();
                    continue;
                }
                if (!slot.isDunking()) continue;
                if (mixingCauldronTile.getFluidStack().getAmount() > 0) {
                    --slot.dippingTicks;
                }
                if (slot.dippingTicks > 0) continue;
                slot.dippingTicks = slot.dippingTicksMax;
                slot.state = DipperState.DRYING;
                slot.dryingTicks = slot.dryingTicksMax;
                ++slot.timesDipped;
                this.decreaseFluid(slot.fluidConsumptionAmount);
                if (slot.timesDipped >= slot.timesDippedMax) {
                    slot.state = DipperState.FINISHED;
                    slot.timesDipped = 0;
                    slot.dippingTicks = slot.dippingTicksMax;
                    slot.dryingTicks = slot.dryingTicksMax;
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                    this.items.set(slot.index, (Object)slot.output);
                }
                this.m_6596_();
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
        if (nbt.m_128441_("slot0")) {
            this.dipperSlots.get(0).load(nbt.m_128469_("slot0"));
        }
        if (nbt.m_128441_("slot1")) {
            this.dipperSlots.get(1).load(nbt.m_128469_("slot1"));
        }
        if (nbt.m_128441_("slot2")) {
            this.dipperSlots.get(2).load(nbt.m_128469_("slot2"));
        }
        super.m_142466_(nbt);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hexerei.dipper");
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128365_("slot0", (Tag)this.dipperSlots.get(0).save());
        compound.m_128365_("slot1", (Tag)this.dipperSlots.get(1).save());
        compound.m_128365_("slot2", (Tag)this.dipperSlots.get(2).save());
    }

    public CompoundTag save(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128365_("slot0", (Tag)this.dipperSlots.get(0).save());
        compound.m_128365_("slot1", (Tag)this.dipperSlots.get(1).save());
        compound.m_128365_("slot2", (Tag)this.dipperSlots.get(2).save());
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)this.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)1.0E-4f + (double)0.15f * Math.abs(pos - posTo));
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.m_82546_(vector3dCenter);
        newVec = newVec.m_82524_(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.m_82549_(vector3dCenter);
        return newVec;
    }

    public int putItems(int slot, @Nonnull ItemStack stack) {
        if (((ItemStack)this.items.get(slot)).m_41619_()) {
            ItemStack stack1 = stack.m_41777_();
            stack1.m_41764_(1);
            this.items.set(slot, (Object)stack1);
            this.m_6596_();
            stack.m_41774_(1);
            return 1;
        }
        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.items.get(slot)))) {
            return 0;
        }
        return 1;
    }

    public int interactDipper(Player player, BlockHitResult hit) {
        if (this.f_58857_ == null) {
            return 0;
        }
        if (!player.m_6144_()) {
            if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                Random rand = new Random();
                for (int i = 0; i < 3; ++i) {
                    if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
                    this.putItems(i, player.m_21120_(InteractionHand.MAIN_HAND));
                    this.dipperSlots.get((int)i).dryingTicks = DRYING_START_TICKS;
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    return 1;
                }
            }
            for (int i = 0; i < 3; ++i) {
                DipperSlot dipperSlot = this.dipperSlots.get(i);
                if (!dipperSlot.isFinished()) continue;
                dipperSlot.timesDipped = 0;
                dipperSlot.dippingTicks = dipperSlot.dippingTicksMax;
                dipperSlot.state = DipperState.NON;
                dipperSlot.dryingTicks = dipperSlot.dryingTicksMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(i)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(i, (Object)ItemStack.f_41583_);
                dipperSlot.output = ItemStack.f_41583_;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                DipperSlot dipperSlot = this.dipperSlots.get(i);
                if (((ItemStack)this.items.get(i)).m_41619_() || dipperSlot.isCrafting()) continue;
                dipperSlot.timesDipped = 0;
                dipperSlot.dippingTicks = dipperSlot.dippingTicksMax;
                dipperSlot.state = DipperState.NON;
                dipperSlot.dryingTicks = dipperSlot.dryingTicksMax;
                player.f_36093_.m_150079_(((ItemStack)this.items.get(i)).m_41777_());
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
                this.items.set(i, (Object)ItemStack.f_41583_);
                dipperSlot.output = ItemStack.f_41583_;
            }
        }
        return 0;
    }

    public void tick() {
        BlockEntity blockEntity;
        if (this.f_58857_ instanceof ServerLevel) {
            this.craft();
        }
        for (DipperSlot slot : this.dipperSlots) {
            slot.posLast = slot.pos;
        }
        this.numberOfCandles = 0.0f;
        Vec3[] targetPos = new Vec3[]{new Vec3(0.25, 0.0, 0.0625), new Vec3(0.5, 0.0, 0.0625), new Vec3(0.75, 0.0, 0.0625)};
        if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof MixingCauldronTile) {
            Direction dir;
            MixingCauldronTile cauldronTile = (MixingCauldronTile)blockEntity;
            float fillPercentage = 0.0f;
            FluidStack fluidStack = cauldronTile.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                fillPercentage = Math.min(1.0f, (float)fluidStack.getAmount() / (float)cauldronTile.getTankCapacity(0));
            }
            float height = 0.25f + 0.6875f * fillPercentage - 1.0f + 0.0625f;
            DipperSlot dipperSlot = this.dipperSlots.get(0);
            if (dipperSlot.isDrying() || !((ItemStack)this.items.get(0)).m_41619_()) {
                targetPos[0] = new Vec3(targetPos[0].m_7096_(), 0.3125 + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isDunking()) {
                targetPos[0] = new Vec3(targetPos[0].m_7096_(), (double)height + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isFinished()) {
                targetPos[0] = new Vec3(targetPos[0].m_7096_(), 0.625 + Math.sin((float)this.f_58857_.m_46467_() / 16.0f) / 32.0, 0.5);
            }
            if ((dipperSlot = this.dipperSlots.get(1)).isDrying() || !((ItemStack)this.items.get(1)).m_41619_()) {
                targetPos[1] = new Vec3(targetPos[1].m_7096_(), 0.3125 + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isDunking()) {
                targetPos[1] = new Vec3(targetPos[1].m_7096_(), (double)height + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isFinished()) {
                targetPos[1] = new Vec3(targetPos[1].m_7096_(), 0.625 + Math.sin(((float)this.f_58857_.m_46467_() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if ((dipperSlot = this.dipperSlots.get(2)).isDrying() || !((ItemStack)this.items.get(2)).m_41619_()) {
                targetPos[2] = new Vec3(targetPos[2].m_7096_(), 0.3125 + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isDunking()) {
                targetPos[2] = new Vec3(targetPos[2].m_7096_(), (double)height + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isFinished()) {
                targetPos[2] = new Vec3(targetPos[2].m_7096_(), 0.625 + Math.sin(((float)this.f_58857_.m_46467_() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            int rot = (dir = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) == Direction.NORTH ? 180 : (dir == Direction.SOUTH ? 0 : (dir == Direction.EAST ? 90 : 270));
            for (int i = 0; i < this.dipperSlots.size(); ++i) {
                targetPos[i] = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), rot, targetPos[i]);
                DipperSlot slot = this.dipperSlots.get(i);
                slot.pos = new Vec3((double)HexereiUtil.moveTo((float)slot.pos.f_82479_, (float)targetPos[i].m_7096_(), this.getSpeed((float)slot.pos.f_82479_, targetPos[i].m_7096_())), (double)HexereiUtil.moveTo((float)slot.pos.f_82480_, (float)targetPos[i].m_7098_(), 0.75f * this.getSpeed((float)slot.pos.f_82480_, targetPos[i].m_7098_())), (double)HexereiUtil.moveTo((float)slot.pos.f_82481_, (float)targetPos[i].m_7094_(), this.getSpeed((float)slot.pos.f_82481_, targetPos[i].m_7094_())));
            }
        }
    }

    private void decreaseFluid(int amount) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile cauldronTile = (MixingCauldronTile)blockEntity;
            if (!this.f_58857_.m_5776_()) {
                cauldronTile.getFluidStack().shrink(amount);
                cauldronTile.m_6596_();
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitParticlesPacket(this.f_58858_.m_7495_(), 10, false));
            }
        }
    }

    public int[] m_7071_(Direction p_19238_) {
        return new int[]{0, 1, 2};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return ((ItemStack)this.items.get(index)).m_41619_();
    }

    public boolean m_7157_(int index, ItemStack p_19240_, Direction p_19241_) {
        return !this.dipperSlots.get(index).isCrafting();
    }

    public int m_6643_() {
        return this.items.size();
    }

    public static class DipperSlot {
        public int index;
        public Vec3 pos;
        public Vec3 posLast;
        public DipperState state;
        public int dippingTicks;
        public int dippingTicksMax;
        public int dryingTicks;
        public int dryingTicksMax;
        public int timesDipped;
        public int timesDippedMax;
        public int fluidConsumptionAmount;
        public ItemStack output;

        public DipperSlot(int index, Vec3 pos, DipperState state, int dippingTicksMax, int dryingTicksMax, int timesDippedMax, int fluidConsumptionAmount, ItemStack output) {
            this.index = index;
            this.pos = pos;
            this.posLast = pos;
            this.state = state;
            this.dippingTicks = dippingTicksMax;
            this.dippingTicksMax = dippingTicksMax;
            this.dryingTicks = dryingTicksMax;
            this.dryingTicksMax = dryingTicksMax;
            this.timesDipped = 0;
            this.timesDippedMax = timesDippedMax;
            this.fluidConsumptionAmount = fluidConsumptionAmount;
            this.output = output;
        }

        public boolean isCrafting() {
            return this.state != DipperState.NON && this.state != DipperState.FINISHED;
        }

        public boolean isDrying() {
            return this.state == DipperState.DRYING;
        }

        public boolean isDunking() {
            return this.state == DipperState.DUNKING;
        }

        public boolean isFinished() {
            return this.state == DipperState.FINISHED;
        }

        public boolean isNon() {
            return this.state == DipperState.NON;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("state", this.state.ordinal());
            tag.m_128405_("dippingTicks", this.dippingTicks);
            tag.m_128405_("dippingTicksMax", this.dippingTicksMax);
            tag.m_128405_("dryingTicks", this.dryingTicks);
            tag.m_128405_("dryingTicksMax", this.dryingTicksMax);
            tag.m_128405_("timesDipped", this.timesDipped);
            tag.m_128405_("timesDippedMax", this.timesDippedMax);
            tag.m_128405_("fluidConsumptionAmount", this.fluidConsumptionAmount);
            tag.m_128365_("output", (Tag)this.output.m_41739_(new CompoundTag()));
            return tag;
        }

        public void load(CompoundTag tag) {
            this.state = DipperState.byId(tag.m_128451_("state"));
            this.dippingTicks = tag.m_128451_("dippingTicks");
            this.dippingTicksMax = tag.m_128451_("dippingTicksMax");
            this.dryingTicks = tag.m_128451_("dryingTicks");
            this.dryingTicksMax = tag.m_128451_("dryingTicksMax");
            this.timesDipped = tag.m_128451_("timesDipped");
            this.timesDippedMax = tag.m_128451_("timesDippedMax");
            this.fluidConsumptionAmount = tag.m_128451_("fluidConsumptionAmount");
            this.output = ItemStack.m_41712_((CompoundTag)tag.m_128469_("output"));
        }
    }

    public static enum DipperState {
        DRYING,
        DUNKING,
        FINISHED,
        NON;


        public static DipperState byId(int id) {
            DipperState[] type = DipperState.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }
    }
}

