/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import mezz.jei.api.runtime.IRecipesGui;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.data.books.BookBlocks;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookHyperlink;
import net.joefoxe.hexerei.data.books.BookImage;
import net.joefoxe.hexerei.data.books.BookImageEffect;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookNonItemTooltip;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.joefoxe.hexerei.data.books.BookParagraph;
import net.joefoxe.hexerei.data.books.BookParagraphElements;
import net.joefoxe.hexerei.integration.HexereiModNameTooltipCompat;
import net.joefoxe.hexerei.integration.jei.HexereiJei;
import net.joefoxe.hexerei.integration.jei.HexereiJeiCompat;
import net.joefoxe.hexerei.screen.tooltip.HexereiBookTooltip;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.ClientProxy;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PageDrawing {
    public float lineWidth = 0.0f;
    public float lineHeight = 0.0f;
    public float tick = 0.0f;
    public ItemStack tooltipStack = ItemStack.f_41583_;
    public List<Component> tooltipText = new ArrayList<Component>();
    public BookImage slotOverlay = new BookImage(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 20.0f, 20.0f, 20.0f, 20.0f, 1.0f, "hexerei:textures/book/slot_hover.png", new ArrayList<BookImageEffect>());
    public boolean drawTooltip;
    public boolean drawTooltipStack = false;
    public boolean drawTooltipStackFlag = false;
    public boolean drawTooltipTextFlag = false;
    public float drawTooltipScale = 0.0f;
    public float drawTooltipScaleOld;
    public boolean drawTooltipText = false;
    public boolean drawSlotOverlay = false;
    public PageOn slotOverlayPageOn = PageOn.LEFT_PAGE;
    public boolean isRightPressedOld = false;
    public boolean isLeftPressedOld = false;
    public static ItemRenderer itemRenderer;
    public double mouseXOld;
    public double mouseYOld;
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final NumberFormat nf;
    public static final ResourceLocation SLOT_ATLAS;
    public static final ResourceLocation SLOT;
    public static final ResourceLocation TITLE;
    public static final float CORNERS;
    public static final float MIN_Y = 0.25f;
    public static final float MAX_Y = 0.9375f;
    protected static final Quaternionf ITEM_LIGHT_ROTATION_3D;
    protected static final Quaternionf BLOCK_LIGHT_ROTATION_3D;
    protected static final Quaternionf ITEM_LIGHT_ROTATION_FLAT;

    public PageDrawing() {
        itemRenderer = Hexerei.proxy.getLevel() == null ? null : (Hexerei.proxy.getLevel().f_46443_ ? Minecraft.m_91087_().m_91291_() : null);
        this.mouseXOld = 0.0;
        this.mouseYOld = 0.0;
    }

    public static ItemStack getTagStack(TagKey<Item> key) {
        ITagManager itemTags = ForgeRegistries.ITEMS.tags();
        if (itemTags != null) {
            ITag itemITag = itemTags.getTag(key);
            float[] fl = new float[1];
            DistExecutor.runForDist(() -> () -> {
                fl[0] = Hexerei.getClientTicks();
                return null;
            }, () -> () -> {
                fl[0] = 0.0f;
                return null;
            });
            Optional optional = itemITag.getRandomElement(RandomSource.m_216335_((long)((long)(fl[0] * 1000.0f))));
            return optional.orElse(Items.f_41852_).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public static Block getTagBlock(TagKey<Block> key) {
        ITagManager blockTags = ForgeRegistries.BLOCKS.tags();
        if (blockTags != null) {
            ITag blockITag = blockTags.getTag(key);
            float[] fl = new float[1];
            DistExecutor.runForDist(() -> () -> {
                fl[0] = Hexerei.getClientTicksWithoutPartial();
                return null;
            }, () -> () -> {
                fl[0] = 0.0f;
                return null;
            });
            Optional optional = blockITag.getRandomElement(RandomSource.m_216335_((long)((long)fl[0])));
            return optional.orElse(Blocks.f_50016_);
        }
        return Blocks.f_50016_;
    }

    public static Optional<Item> getTagStackStatic(TagKey<Item> key) {
        ITagManager itemTags = ForgeRegistries.ITEMS.tags();
        if (itemTags != null) {
            ITag itemITag = itemTags.getTag(key);
            float[] fl = new float[1];
            DistExecutor.runForDist(() -> () -> {
                fl[0] = Hexerei.getClientTicks();
                return null;
            }, () -> () -> {
                fl[0] = 0.0f;
                return null;
            });
            return itemITag.getRandomElement(RandomSource.m_216335_((long)((long)(fl[0] * 1000.0f))));
        }
        return Optional.of(Items.f_41852_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItem(BookOfShadowsAltarTile tileEntityIn, @NotNull BookItemsAndFluids itemStackElement, PoseStack matrixStackIn, MultiBufferSource buffer, float xIn, float yIn, float zLevel, int combinedLight, int combinedOverlay, PageOn pageOn, boolean isItem) {
        ItemStack itemStack = itemStackElement.item;
        if (itemStackElement.type.equals("tag")) {
            int mod = (int)Hexerei.getClientTicks() % 60;
            if (itemStackElement.item.m_41619_()) {
                itemStackElement.item = itemStack = PageDrawing.getTagStack(itemStackElement.key);
                itemStackElement.refreshTag = false;
            }
            if ((mod == 59 || mod == 58) && itemStackElement.refreshTag) {
                itemStack = PageDrawing.getTagStack(itemStackElement.key);
                if (itemStack.m_150930_(itemStackElement.item.m_41720_())) {
                    itemStack = PageDrawing.getTagStack(itemStackElement.key);
                }
                if (itemStack.m_150930_(itemStackElement.item.m_41720_())) {
                    itemStack = PageDrawing.getTagStack(itemStackElement.key);
                }
                itemStackElement.item = itemStack;
                itemStackElement.refreshTag = false;
                itemStackElement.modelCache = itemRenderer.m_174264_(itemStack, null, null, 0);
            }
            if (mod == 1 || mod == 2) {
                itemStackElement.refreshTag = true;
            }
        }
        matrixStackIn.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        }
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStackIn.m_252880_(-0.5f, 0.34375f, -0.0013125f);
        matrixStackIn.m_85841_(0.049f, 0.049f, 0.001f);
        matrixStackIn.m_252880_(yIn * 1.259f, -xIn * 1.259f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
        matrixStackIn.m_252880_(-0.59375f, -0.5625f, 0.0f);
        matrixStackIn.m_85841_(0.065f, 0.065f, 0.05f);
        PageDrawing.renderGuiItemDecorations(buffer, Minecraft.m_91087_().f_91062_, itemStack, matrixStackIn, 0.0f, 0.0f, combinedOverlay, combinedLight);
        matrixStackIn.m_252880_(1.4423077f, 0.9615385f, 0.0f);
        matrixStackIn.m_85841_(0.965f, 0.965f, 0.965f);
        PageDrawing.renderGuiItemCount(buffer, Minecraft.m_91087_().f_91062_, itemStack, matrixStackIn, 0.0f, 0.0f, combinedOverlay, combinedLight);
        matrixStackIn.m_85849_();
        Vector3f[] shaderLightDirections = new Vector3f[]{new Vector3f((Vector3fc)RenderSystem.shaderLightDirections[0]), new Vector3f((Vector3fc)RenderSystem.shaderLightDirections[1])};
        int[] originalLightmap = (int[])Util.m_137537_(() -> {
            int[] vals = new int[12];
            for (int i = 0; i < 12; ++i) {
                vals[i] = RenderSystem.getShaderTexture((int)i);
            }
            return vals;
        });
        try {
            if (itemRenderer == null) {
                itemRenderer = Minecraft.m_91087_().m_91291_();
            }
            if (itemStackElement.modelCache == null) {
                itemStackElement.modelCache = itemRenderer.m_174264_(itemStack, null, null, 0);
            }
            if (itemStackElement.modelCache.m_7539_()) {
                matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D);
            } else {
                matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT);
            }
            itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, matrixStackIn, buffer, combinedLight, combinedOverlay, itemStackElement.modelCache);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.m_109911_();
        }
        for (int i = 0; i < 12; ++i) {
            RenderSystem.setShaderTexture((int)i, (int)originalLightmap[i]);
        }
        ShaderInstance shaderinstance = RenderSystem.getShader();
        RenderSystem.setShaderLights((Vector3f)shaderLightDirections[0], (Vector3f)shaderLightDirections[1]);
        RenderSystem.setupShaderLights((ShaderInstance)shaderinstance);
        matrixStackIn.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlock(BookOfShadowsAltarTile tileEntityIn, @NotNull BookBlocks blockElement, PoseStack matrixStackIn, MultiBufferSource buffer, float xIn, float yIn, float zLevel, int combinedLight, int combinedOverlay, PageOn pageOn) {
        BlockState blockState = blockElement.blockState;
        if (blockElement.type.equals("tag")) {
            int mod = (int)Hexerei.getClientTicks() % 60;
            if (blockState.m_60713_(Blocks.f_50016_)) {
                blockElement.blockState = blockState = PageDrawing.getTagBlock(blockElement.key).m_49966_();
            }
            if ((mod == 59 || mod == 58) && blockElement.refreshTag) {
                blockState = PageDrawing.getTagBlock(blockElement.key).m_49966_();
                if (blockState.equals(blockElement.blockState)) {
                    blockState = PageDrawing.getTagBlock(blockElement.key).m_49966_();
                }
                if (blockState.equals(blockElement.blockState)) {
                    blockState = PageDrawing.getTagBlock(blockElement.key).m_49966_();
                }
                blockElement.blockState = blockState;
                blockElement.refreshTag = false;
            }
            if (mod == 1 || mod == 2) {
                blockElement.refreshTag = true;
            }
        }
        matrixStackIn.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStackIn, false, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStackIn, false, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStackIn, false, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStackIn, false, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStackIn, false, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStackIn, false, ItemDisplayContext.NONE);
        }
        float scale = 0.62f;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStackIn.m_252880_(-0.5f, 0.348125f, -0.0013125f);
        matrixStackIn.m_85841_(0.049f * scale, 0.049f * scale, 0.001f);
        matrixStackIn.m_252880_(yIn * 1.259f * (1.0f / scale), -xIn * 1.259f * (1.0f / scale), 0.0f);
        matrixStackIn.m_252880_(0.25f, 0.25f, 0.25f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        matrixStackIn.m_252880_(-0.25f, -0.25f, -0.25f);
        try {
            Block block = blockState.m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                matrixStackIn.m_85850_().m_252943_().set((Matrix3fc)matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)BLOCK_LIGHT_ROTATION_3D));
                PageDrawing.renderFluidBlockGUI(matrixStackIn, buffer, new FluidStack((Fluid)liquidBlock.getFluid(), 2000), 1.0f, combinedLight, combinedOverlay);
                if (buffer instanceof MultiBufferSource.BufferSource) {
                    MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                    bufferSource.m_109911_();
                }
            } else {
                matrixStackIn.m_85850_().m_252943_().set((Matrix3fc)matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)BLOCK_LIGHT_ROTATION_3D));
                Minecraft.m_91087_().m_91289_().renderSingleBlock(blockState, matrixStackIn, buffer, combinedLight, OverlayTexture.f_118083_, ModelData.EMPTY, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStackIn.m_85849_();
    }

    public static void renderFluidBlockGUI(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(RenderType.m_110466_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        PageDrawing.renderQuadsBlock(matrixStack.m_85850_().m_252922_(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, combinedLight, combinedOverlay);
    }

    private static void renderQuadsBlock(Matrix4f matrix, VertexConsumer vertexBuilder, TextureAtlasSprite sprite, float r, float g, float b, float alpha, int light, int overlay) {
        float height = 0.75f;
        float minU = sprite.m_118367_((double)(CORNERS * 16.0f));
        float maxU = sprite.m_118367_((double)((1.0f - CORNERS) * 16.0f));
        float minV = sprite.m_118393_((double)(CORNERS * 16.0f));
        float maxV = sprite.m_118393_((double)((1.0f - CORNERS) * 16.0f));
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, 1.0f - CORNERS / 5.0f, height, CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        float shading = 0.75f;
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, 0.0f, CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        shading = 0.45f;
        vertexBuilder.m_252986_(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, 1.0f - CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiItemDecorations(MultiBufferSource bufferSource, Font font, ItemStack itemStack, PoseStack matrixStackIn, float xIn, float yIn, int overlay, int light) {
        if (itemStack.m_150947_()) {
            matrixStackIn.m_85836_();
            int i = itemStack.m_150948_();
            int j = itemStack.m_150949_();
            PageDrawing.fillRect(matrixStackIn, bufferSource, xIn + 2.75f, yIn + 13.75f, 0.0f, 13.0f, 1.5f, 0, 0, 0, 255, overlay, light);
            PageDrawing.fillRect(matrixStackIn, bufferSource, xIn + 2.75f, yIn + 13.75f, -0.5f, i, 1.0f, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255, overlay, light);
            matrixStackIn.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiItemCount(MultiBufferSource bufferSource, Font font, ItemStack itemStack, PoseStack matrixStackIn, float xIn, float yIn, int overlay, int light) {
        if (itemStack.m_41613_() > 1) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, 0.0f, -7.0f);
            String s = String.valueOf(itemStack.m_41613_());
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            font.m_271703_(s, xIn + 19.0f - 2.0f - (float)font.m_92895_(s) + 1.0f, yIn + 6.0f + 3.0f + 1.0f, HexereiUtil.getColorValueAlpha(0.245f, 0.245f, 0.245f, 1.0f), false, matrixStackIn.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, overlay, light);
            matrixStackIn.m_252880_(0.0f, 0.0f, -6.0f);
            font.m_271703_(s, xIn + 19.0f - 2.0f - (float)font.m_92895_(s), yIn + 6.0f + 3.0f, 0xFFFFFF, false, matrixStackIn.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, overlay, light);
            multibuffersource$buffersource.m_109911_();
            matrixStackIn.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiItem(MultiBufferSource bufferSource, Font font, ItemStack itemStack, PoseStack matrixStackIn, float xIn, float yIn, int overlay, int light) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        matrixStackIn.m_85841_(16.0f, 16.0f, 1.0f);
        matrixStackIn.m_252880_(yIn * 1.25f * 2.0f / 40.0f + 0.55f, -xIn * 1.25f * 2.0f / 40.0f - 0.55f, -2.0f);
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        try {
            BakedModel itemModel = itemRenderer.m_174264_(itemStack, null, null, 0);
            if (itemModel.m_7539_()) {
                matrixStackIn.m_85850_().m_252943_().set((Matrix3fc)matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D));
            } else {
                matrixStackIn.m_85850_().m_252943_().set((Matrix3fc)matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT));
            }
            itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, matrixStackIn, bufferSource, light, overlay, itemModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStackIn.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void fillRect(PoseStack poseStack, MultiBufferSource p_115153_, float xIn, float yIn, float zIn, float widthIn, float heightIn, int p_115158_, int p_115159_, int p_115160_, int p_115161_, int overlay, int light) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, -4.15f);
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        boolean u = false;
        boolean v = false;
        boolean imageWidth = true;
        boolean imageHeight = true;
        boolean width = true;
        boolean height = true;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        VertexConsumer buffer = p_115153_.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("hexerei:textures/book/blank.png")));
        buffer.m_252986_(matrix4f, xIn + 0.0f, yIn + 0.0f, zIn).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xIn + 0.0f, yIn + heightIn, zIn).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xIn + widthIn, yIn + heightIn, zIn).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, xIn + widthIn, yIn + 0.0f, zIn).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPageUnder(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        matrixStack.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        if (!isItem) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
        }
        if (isItem && transformType != ItemDisplayContext.NONE) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
        matrixStack.m_252880_(0.0f, 0.03125f, 0.0f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f)));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * -tileEntityIn.pageTwoRotationRender));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (tileEntityIn.pageOneRotationRender / 16.0f)));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
        matrixStack.m_252880_(0.0f, -0.3828125f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPage(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        matrixStack.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        if (!isItem) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
        }
        if (isItem && transformType != ItemDisplayContext.NONE) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
        }
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 33.0f);
        matrixStack.m_252880_(0.0f, 0.03125f, 0.0f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f)));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * -tileEntityIn.pageTwoRotationRender));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (tileEntityIn.pageOneRotationRender / 16.0f)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPageUnder(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        matrixStack.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        if (!isItem) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
        }
        if (isItem && transformType != ItemDisplayContext.NONE) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
        }
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
        matrixStack.m_252880_(0.0f, 0.03125f, 0.0f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(80.0f - tileEntityIn.degreesOpenedRender / 1.12f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * -tileEntityIn.pageOneRotationRender));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (tileEntityIn.pageTwoRotationRender / 16.0f)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPage(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        matrixStack.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        if (!isItem) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
        }
        if (isItem && transformType != ItemDisplayContext.NONE) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
        }
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
        matrixStack.m_252880_(0.0f, 0.03125f, 0.0f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(80.0f - tileEntityIn.degreesOpenedRender / 1.12f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * -tileEntityIn.pageOneRotationRender));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (tileEntityIn.pageTwoRotationRender / 16.0f)));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
        matrixStack.m_252880_(0.0f, -0.3828125f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPagePrevious(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStackIn, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        if (tileEntityIn.turnPage != 2 && tileEntityIn.turnPage != -1) {
            matrixStackIn.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_((float)Math.sin((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f) / 32.0f, 0.0f, (float)Math.cos((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            if (!isItem) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            } else {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
            }
            if (isItem && transformType != ItemDisplayContext.NONE) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(tileEntityIn.degreesOpenedRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -0.5f * (tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, (float)Math.sin(tileEntityIn.degreesFloppedRender / 57.1f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        } else {
            matrixStackIn.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            if (!isItem) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            } else {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
            }
            if (isItem && transformType != ItemDisplayContext.NONE) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f)));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-(80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (-tileEntityIn.pageTwoRotationRender / 16.0f + 11.25f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPagePrevious(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStackIn, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        if (tileEntityIn.turnPage != 1 && tileEntityIn.turnPage != -1) {
            matrixStackIn.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_(-((float)Math.sin((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f)) / 32.0f, 0.0f, -((float)Math.cos((tileEntityIn.degreesSpunRender + 90.0f) / 57.1f)) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            if (!isItem) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            } else {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
            }
            if (isItem && transformType != ItemDisplayContext.NONE) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-tileEntityIn.degreesOpenedRender));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, -0.5f * (tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, -((float)Math.sin(tileEntityIn.degreesFloppedRender / 57.1f)) / 32.0f);
            matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            matrixStackIn.m_252880_(0.0f, -0.3828125f, 0.0f);
        } else {
            matrixStackIn.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
            matrixStackIn.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
            if (!isItem) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
            } else {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 10.0f)));
            }
            if (isItem && transformType != ItemDisplayContext.NONE) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
            matrixStackIn.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.m_252880_(0.0f, 0.03125f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(80.0f - tileEntityIn.degreesOpenedRender / 1.12f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((80.0f - tileEntityIn.degreesOpenedRender / 1.12f) / 90.0f * (-tileEntityIn.pageOneRotationRender / 16.0f + 11.25f)));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
            matrixStackIn.m_252880_(0.0f, -0.3828125f, 0.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void translateToMiddleButton(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, boolean isItem, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        matrixStack.m_252880_(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        if (!isItem) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f - 13.0f)));
        }
        if (isItem && transformType != ItemDisplayContext.NONE) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-55.0f));
        }
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(degreesOpened));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        matrixStack.m_252880_(0.04609375f, 0.44375f, 0.34375f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-180.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPage(BookPage page, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, boolean isItem, ItemDisplayContext transformType) throws CommandSyntaxException {
        this.drawPage(page, tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, pageOn, isItem, transformType, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPage(BookPage page, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, boolean isItem, ItemDisplayContext transformType, int pageNum) throws CommandSyntaxException {
        if (page != null) {
            Vec3 intersectionVec;
            AABB aabb;
            Vec3 vec;
            BlockPos blockPos;
            Entity vector3f_1;
            Vector3f vector3f;
            BookEntries bookEntries;
            BookParagraph bookParagraph;
            ArrayList<BookParagraphElements> list;
            BookParagraphElements bookParagraphElements;
            int pageOnNum;
            BookEntries bookEntries2;
            int i;
            Player playerIn = Hexerei.proxy.getPlayer();
            double reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
            Vec3 planeNormalRight = this.planeNormal(tileEntityIn, PageOn.RIGHT_PAGE);
            Vec3 planeNormalLeft = this.planeNormal(tileEntityIn, PageOn.LEFT_PAGE);
            for (i = 0; i < page.paragraph.size(); ++i) {
                this.drawString((BookParagraph)page.paragraph.toArray()[i], tileEntityIn, matrixStackIn, bufferIn, 0.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
            }
            if ((pageOn == PageOn.LEFT_PAGE || pageOn == PageOn.LEFT_PAGE_PREV || pageOn == PageOn.RIGHT_PAGE_UNDER) && (bookEntries2 = BookManager.getBookEntries()) != null) {
                pageOnNum = pageNum + 1 - bookEntries2.chapterList.get((int)0).endPage;
                bookParagraphElements = new BookParagraphElements(14.3f, 19.25f, 1.0f, 30.0f, "top");
                list = new ArrayList<BookParagraphElements>();
                list.add(bookParagraphElements);
                bookParagraph = pageOnNum > 0 ? new BookParagraph(list, String.valueOf(pageOnNum), "left") : new BookParagraph(list, HexereiUtil.intToRoman(pageNum + 1), "left");
                bookParagraph.paragraphElements.get((int)0).x -= (float)Minecraft.m_91087_().f_91062_.m_92895_(bookParagraph.passage) / 8.0f;
                this.drawString(bookParagraph, tileEntityIn, matrixStackIn, bufferIn, 0.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
            }
            if ((pageOn == PageOn.RIGHT_PAGE || pageOn == PageOn.RIGHT_PAGE_PREV || pageOn == PageOn.LEFT_PAGE_UNDER) && (bookEntries = BookManager.getBookEntries()) != null) {
                pageOnNum = pageNum + 1 - bookEntries.chapterList.get((int)0).endPage;
                bookParagraphElements = new BookParagraphElements(0.0f, 19.25f, 1.0f, 30.0f, "top");
                list = new ArrayList();
                list.add(bookParagraphElements);
                bookParagraph = pageOnNum > 0 ? new BookParagraph(list, String.valueOf(pageOnNum), "left") : new BookParagraph(list, HexereiUtil.intToRoman(pageNum + 1), "left");
                this.drawString(bookParagraph, tileEntityIn, matrixStackIn, bufferIn, 0.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
            }
            for (i = 0; i < page.itemList.size(); ++i) {
                BookItemsAndFluids bookItemStackInSlot = (BookItemsAndFluids)page.itemList.toArray()[i];
                this.drawItemInSlot(tileEntityIn, bookItemStackInSlot, matrixStackIn, bufferIn, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
            }
            for (i = 0; i < page.blockList.size(); ++i) {
                BookBlocks bookBlocks = (BookBlocks)page.blockList.toArray()[i];
                this.drawBlock(tileEntityIn, bookBlocks, matrixStackIn, bufferIn, bookBlocks.x, bookBlocks.y, 0.0f, combinedLightIn, combinedOverlayIn, pageOn);
            }
            if (transformType == ItemDisplayContext.NONE) {
                ArrayList<BookImageEffect> effects;
                for (i = 0; i < page.itemList.size(); ++i) {
                    BookItemsAndFluids bookItemStackInSlot = (BookItemsAndFluids)page.itemList.toArray()[i];
                    if (pageOn == PageOn.LEFT_PAGE) {
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - bookItemStackInSlot.x * 0.06f, 0.5f - bookItemStackInSlot.y * 0.061f, -0.03f);
                        blockPos = tileEntityIn.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                        aabb = new AABB(vec.m_82520_((double)-0.03f, (double)-0.03f, (double)-0.03f), vec.m_82520_((double)0.03f, (double)0.03f, (double)0.03f));
                        intersectionVec = PageDrawing.intersectPoint(bookItemStackInSlot.x, bookItemStackInSlot.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                        if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                            if (bookItemStackInSlot.item != null) {
                                if (!bookItemStackInSlot.item.m_41619_()) {
                                    this.tooltipStack = bookItemStackInSlot.item;
                                    this.tooltipText = bookItemStackInSlot.extra_tooltips;
                                    this.drawTooltipStack = true;
                                }
                            } else {
                                this.tooltipText = this.getFluidTooltip(bookItemStackInSlot);
                                this.tooltipStack = ItemStack.f_41583_;
                                this.drawTooltipText = true;
                            }
                            this.slotOverlay.x = bookItemStackInSlot.x;
                            this.slotOverlay.y = bookItemStackInSlot.y;
                            effects = new ArrayList<BookImageEffect>();
                            effects.add(new BookImageEffect("scale", 20.0f, 1.1f));
                            this.slotOverlay.effects = effects;
                            this.slotOverlayPageOn = pageOn;
                            this.drawSlotOverlay = true;
                            break;
                        }
                        if (this.drawTooltipStack) break;
                    }
                    if (pageOn != PageOn.RIGHT_PAGE) continue;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f - bookItemStackInSlot.x * 0.06f, 0.5f - bookItemStackInSlot.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)-0.03f, (double)-0.03f, (double)-0.03f), vec.m_82520_((double)0.03f, (double)0.03f, (double)0.03f));
                    intersectionVec = PageDrawing.intersectPoint(bookItemStackInSlot.x, bookItemStackInSlot.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        if (bookItemStackInSlot.item != null) {
                            if (!bookItemStackInSlot.item.m_41619_()) {
                                this.tooltipStack = bookItemStackInSlot.item;
                                this.tooltipText = bookItemStackInSlot.extra_tooltips;
                                this.drawTooltipStack = true;
                            }
                        } else {
                            this.tooltipText = this.getFluidTooltip(bookItemStackInSlot);
                            this.tooltipStack = ItemStack.f_41583_;
                            this.drawTooltipText = true;
                        }
                        this.slotOverlay.x = bookItemStackInSlot.x;
                        this.slotOverlay.y = bookItemStackInSlot.y;
                        effects = new ArrayList();
                        effects.add(new BookImageEffect("scale", 20.0f, 1.1f));
                        this.slotOverlay.effects = effects;
                        this.slotOverlayPageOn = pageOn;
                        this.drawSlotOverlay = true;
                        break;
                    }
                    if (this.drawTooltipStack) break;
                }
                for (i = 0; i < page.blockList.size(); ++i) {
                    ArrayList<Component> tooltipList;
                    BookBlocks bookBlock = (BookBlocks)page.blockList.toArray()[i];
                    if (pageOn == PageOn.LEFT_PAGE) {
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - bookBlock.x * 0.06f, 0.5f - bookBlock.y * 0.061f, -0.03f);
                        blockPos = tileEntityIn.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                        aabb = new AABB(vec.m_82520_((double)-0.03f, (double)-0.03f, (double)-0.03f), vec.m_82520_((double)0.03f, (double)0.03f, (double)0.03f));
                        intersectionVec = PageDrawing.intersectPoint(bookBlock.x, bookBlock.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                        if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                            if (!bookBlock.blockState.m_60713_(Blocks.f_50016_)) {
                                tooltipList = new ArrayList<Component>(bookBlock.extra_tooltips);
                                tooltipList.add(0, (Component)bookBlock.blockState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE));
                                this.tooltipText = tooltipList;
                                this.drawTooltipText = true;
                                this.tooltipStack = ItemStack.f_41583_;
                            }
                            this.slotOverlay.x = bookBlock.x;
                            this.slotOverlay.y = bookBlock.y;
                            effects = new ArrayList();
                            effects.add(new BookImageEffect("scale", 20.0f, 1.1f));
                            this.slotOverlay.effects = effects;
                            this.slotOverlayPageOn = pageOn;
                            this.drawSlotOverlay = true;
                            break;
                        }
                        if (this.drawTooltipText) break;
                    }
                    if (pageOn != PageOn.RIGHT_PAGE) continue;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f - bookBlock.x * 0.06f, 0.5f - bookBlock.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)-0.03f, (double)-0.03f, (double)-0.03f), vec.m_82520_((double)0.03f, (double)0.03f, (double)0.03f));
                    intersectionVec = PageDrawing.intersectPoint(bookBlock.x, bookBlock.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        if (!bookBlock.blockState.m_60713_(Blocks.f_50016_)) {
                            tooltipList = new ArrayList<Component>(bookBlock.extra_tooltips);
                            tooltipList.add(0, (Component)bookBlock.blockState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE));
                            this.tooltipText = tooltipList;
                            this.drawTooltipText = true;
                            this.tooltipStack = ItemStack.f_41583_;
                        }
                        this.slotOverlay.x = bookBlock.x;
                        this.slotOverlay.y = bookBlock.y;
                        effects = new ArrayList();
                        effects.add(new BookImageEffect("scale", 20.0f, 1.1f));
                        this.slotOverlay.effects = effects;
                        this.slotOverlayPageOn = pageOn;
                        this.drawSlotOverlay = true;
                        break;
                    }
                    if (this.drawTooltipText) break;
                }
                for (i = 0; i < page.entityList.size(); ++i) {
                    BookImage bookImage2;
                    BookImage bookImage;
                    MouseHandler handler;
                    BookEntity bookEntity = (BookEntity)page.entityList.toArray()[i];
                    if (bookEntity.entity != null) {
                        bookEntity.entity.f_19797_ = (int)Hexerei.getClientTicksWithoutPartial();
                    }
                    if (pageOn == PageOn.LEFT_PAGE) {
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - (bookEntity.x + bookEntity.offset.x) * 0.06f, 0.5f - (bookEntity.y + bookEntity.offset.y) * 0.061f, -0.03f);
                        blockPos = tileEntityIn.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                        aabb = new AABB(vec.m_82520_(-0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale), vec.m_82520_(0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale));
                        intersectionVec = PageDrawing.intersectPoint(bookEntity.x, bookEntity.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                        if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                            bookEntity.hoverTick = this.moveTo(bookEntity.hoverTick, 1.0f, 0.04f);
                            handler = Minecraft.m_91087_().f_91067_;
                            if (handler.m_91584_() && !this.isRightPressedOld && tileEntityIn.slotClicked == -1) {
                                Hexerei.entityClicked = true;
                            }
                            if (Hexerei.entityClicked) {
                                bookEntity.toRotate = (float)((double)bookEntity.toRotate + (this.mouseXOld - handler.m_91589_()));
                            }
                        } else {
                            bookEntity.hoverTick = this.moveTo(bookEntity.hoverTick, 0.0f, 0.08f);
                        }
                        if (bookEntity.hoverTick > 0.0f) {
                            handler = Minecraft.m_91087_().f_91067_;
                            bookImage = new BookImage(bookEntity.x, bookEntity.y + 0.5f, 0.0f, 0.0f, 0.0f, 64.0f, 32.0f, 64.0f, 32.0f, 0.75f * bookEntity.hoverTick, "hexerei:textures/book/rotate_entity.png", new ArrayList<BookImageEffect>());
                            this.drawImage(bookImage, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                            if (handler.m_91584_()) {
                                bookImage2 = new BookImage(bookEntity.x - (bookEntity.toRotate > 0.0f ? Math.min(bookEntity.toRotate / 2000.0f, 0.8f) : Math.max(bookEntity.toRotate / 2000.0f, -0.8f)), bookEntity.y + 0.85f - Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * 2.25f, 1.0f, 0.0f, 0.0f, 32.0f, 48.0f, 32.0f, 48.0f, 0.45f * bookEntity.hoverTick, "hexerei:textures/book/right_click_icon_hover.png", new ArrayList<BookImageEffect>());
                                this.drawImage(bookImage2, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                            } else {
                                bookImage2 = new BookImage(bookEntity.x - (bookEntity.toRotate > 0.0f ? Math.min(bookEntity.toRotate / 2000.0f, 0.8f) : Math.max(bookEntity.toRotate / 2000.0f, -0.8f)), bookEntity.y + 0.85f - Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * 2.25f, 1.0f, 0.0f, 0.0f, 32.0f, 48.0f, 32.0f, 48.0f, 0.45f * bookEntity.hoverTick, "hexerei:textures/book/right_click_icon.png", new ArrayList<BookImageEffect>());
                                this.drawImage(bookImage2, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                            }
                        }
                        if (bookEntity.toRotate == 0.0f) continue;
                        bookEntity.rot = bookEntity.toRotate > 0.0f ? (bookEntity.rot += Math.max(Math.abs(bookEntity.toRotate) / 100.0f, 0.01f) / 3.0f) : (bookEntity.rot -= Math.max(Math.abs(bookEntity.toRotate) / 100.0f, 0.01f) / 3.0f);
                        bookEntity.toRotate = this.moveTo(bookEntity.toRotate, 0.0f, Math.max(Math.abs(bookEntity.toRotate) / 100.0f, 0.01f));
                        continue;
                    }
                    if (pageOn != PageOn.RIGHT_PAGE) continue;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f + -(bookEntity.x + bookEntity.offset.x) * 0.06f, 0.5f - (bookEntity.y + bookEntity.offset.y) * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_(-0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale), vec.m_82520_(0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale));
                    intersectionVec = PageDrawing.intersectPoint(bookEntity.x, bookEntity.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                    handler = Minecraft.m_91087_().f_91067_;
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        bookEntity.hoverTick = this.moveTo(bookEntity.hoverTick, 1.0f, 0.04f);
                        if (handler.m_91584_() && !this.isRightPressedOld && tileEntityIn.slotClicked == -1) {
                            Hexerei.entityClicked = true;
                        }
                        if (Hexerei.entityClicked) {
                            bookEntity.toRotate = (float)((double)bookEntity.toRotate + (this.mouseXOld - handler.m_91589_()));
                        }
                    } else {
                        bookEntity.hoverTick = this.moveTo(bookEntity.hoverTick, 0.0f, 0.08f);
                    }
                    if (bookEntity.hoverTick > 0.0f) {
                        bookImage = new BookImage(bookEntity.x, bookEntity.y + 0.5f, 0.0f, 0.0f, 0.0f, 64.0f, 32.0f, 64.0f, 32.0f, 0.75f * bookEntity.hoverTick, "hexerei:textures/book/rotate_entity.png", new ArrayList<BookImageEffect>());
                        this.drawImage(bookImage, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                        if (handler.m_91584_()) {
                            bookImage2 = new BookImage(bookEntity.x - (bookEntity.toRotate > 0.0f ? Math.min(bookEntity.toRotate / 2000.0f, 0.8f) : Math.max(bookEntity.toRotate / 2000.0f, -0.8f)), bookEntity.y + 0.85f - Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * 2.25f, 1.0f, 0.0f, 0.0f, 32.0f, 48.0f, 32.0f, 48.0f, 0.45f * bookEntity.hoverTick, "hexerei:textures/book/right_click_icon_hover.png", new ArrayList<BookImageEffect>());
                            this.drawImage(bookImage2, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                        } else {
                            bookImage2 = new BookImage(bookEntity.x - (bookEntity.toRotate > 0.0f ? Math.min(bookEntity.toRotate / 2000.0f, 0.8f) : Math.max(bookEntity.toRotate / 2000.0f, -0.8f)), bookEntity.y + 0.85f - Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * Math.min(Math.abs(bookEntity.toRotate) / 4000.0f, 0.4f) * 2.25f, 1.0f, 0.0f, 0.0f, 32.0f, 48.0f, 32.0f, 48.0f, 0.45f * bookEntity.hoverTick, "hexerei:textures/book/right_click_icon.png", new ArrayList<BookImageEffect>());
                            this.drawImage(bookImage2, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                        }
                    }
                    if (bookEntity.toRotate == 0.0f) continue;
                    bookEntity.rot = bookEntity.toRotate > 0.0f ? (bookEntity.rot += Math.max(Math.abs(bookEntity.toRotate) / 100.0f, 0.01f) / 3.0f) : (bookEntity.rot -= Math.max(Math.abs(bookEntity.toRotate) / 100.0f, 0.01f) / 3.0f);
                    bookEntity.toRotate = this.moveTo(bookEntity.toRotate, 0.0f, Math.max(Math.abs(bookEntity.toRotate) / 100.0f, 0.01f));
                }
                for (i = 0; i < page.nonItemTooltipList.size(); ++i) {
                    BookNonItemTooltip bookNonItemTooltip = (BookNonItemTooltip)page.nonItemTooltipList.toArray()[i];
                    if (pageOn == PageOn.LEFT_PAGE) {
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - bookNonItemTooltip.x * 0.06f, 0.5f - bookNonItemTooltip.y * 0.061f, -0.03f);
                        blockPos = tileEntityIn.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                        aabb = new AABB(vec.m_82520_((double)(-bookNonItemTooltip.width), (double)(-bookNonItemTooltip.height), (double)(-bookNonItemTooltip.width)), vec.m_82520_((double)bookNonItemTooltip.width, (double)bookNonItemTooltip.height, (double)bookNonItemTooltip.width));
                        intersectionVec = PageDrawing.intersectPoint(bookNonItemTooltip.x, bookNonItemTooltip.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                        if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                            this.tooltipText = bookNonItemTooltip.textComponentsList;
                            this.tooltipStack = ItemStack.f_41583_;
                            this.drawTooltipText = true;
                        }
                        if (!this.drawTooltipText) continue;
                        break;
                    }
                    if (pageOn != PageOn.RIGHT_PAGE) continue;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f + -bookNonItemTooltip.x * 0.06f, 0.5f - bookNonItemTooltip.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)(-bookNonItemTooltip.width), (double)(-bookNonItemTooltip.height), (double)(-bookNonItemTooltip.width)), vec.m_82520_((double)bookNonItemTooltip.width, (double)bookNonItemTooltip.height, (double)bookNonItemTooltip.width));
                    intersectionVec = PageDrawing.intersectPoint(bookNonItemTooltip.x, bookNonItemTooltip.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        ArrayList components = new ArrayList();
                        this.tooltipText = bookNonItemTooltip.textComponentsList;
                        this.tooltipStack = ItemStack.f_41583_;
                        this.drawTooltipText = true;
                    }
                    if (this.drawTooltipText) break;
                }
            }
            for (i = 0; i < page.imageList.size(); ++i) {
                BookImage bookImage = (BookImage)page.imageList.toArray()[i];
                this.drawImage(bookImage, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                if (bookImage.extra_tooltips == null || bookImage.extra_tooltips.size() < 1) continue;
                if (pageOn == PageOn.LEFT_PAGE) {
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(0.35f - bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                    intersectionVec = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                    if (!aabb.m_82390_(intersectionVec) || !(intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                    this.tooltipText = bookImage.extra_tooltips;
                    this.tooltipStack = ItemStack.f_41583_;
                    this.drawTooltipText = true;
                    continue;
                }
                if (pageOn != PageOn.RIGHT_PAGE) continue;
                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                vector3f_1 = new Vector3f(-0.05f + -bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                blockPos = tileEntityIn.m_58899_();
                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                vector3f.add((Vector3fc)vector3f_1);
                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                aabb = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                intersectionVec = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                if (!aabb.m_82390_(intersectionVec) || !(intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                this.tooltipText = bookImage.extra_tooltips;
                this.tooltipStack = ItemStack.f_41583_;
                this.drawTooltipText = true;
            }
            if (this.drawSlotOverlay) {
                this.drawImage(this.slotOverlay, tileEntityIn, matrixStackIn, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, this.slotOverlayPageOn, isItem);
            }
            if (page.showTitle.equals("Hexerei")) {
                this.drawTitle(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, pageOn, isItem);
            }
            for (i = 0; i < page.entityList.size(); ++i) {
                CompoundTag stringTag;
                String tag2;
                CompoundTag tag;
                CompoundTag stringTag2;
                String tag22;
                CompoundTag tag3;
                BookEntity bookEntity = (BookEntity)page.entityList.toArray()[i];
                vector3f_1 = bookEntity.entity;
                if (vector3f_1 instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)vector3f_1;
                    if (bookEntity.entityTagsList.size() > 0 && tileEntityIn.tickCount > (float)(bookEntity.entityTagsLastChange + 40)) {
                        bookEntity.entityTagsLastChange = (int)tileEntityIn.tickCount;
                        ++bookEntity.entityTagsListOn;
                        if (bookEntity.entityTagsListOn >= bookEntity.entityTagsList.size()) {
                            bookEntity.entityTagsListOn = 0;
                        }
                        int on = bookEntity.entityTagsListOn;
                        if (bookEntity.entityTagsListOnSet != bookEntity.entityTagsListOn && !bookEntity.entityTagsList.get(on).equals("")) {
                            tag3 = TagParser.m_129359_((String)bookEntity.entityTagsList.get(on));
                            tag22 = tag3.m_128461_("CustomName");
                            stringTag2 = TagParser.m_129359_((String)tag22);
                            livingEntity.m_6593_((Component)Component.m_237115_((String)stringTag2.m_128461_("text")));
                            livingEntity.m_20258_(tag3);
                            if (livingEntity instanceof TamableAnimal) {
                                ((TamableAnimal)livingEntity).m_7105_(true);
                            }
                            bookEntity.entityTagsListOnSet = bookEntity.entityTagsListOn;
                            if (livingEntity instanceof TamableAnimal) {
                                TamableAnimal tamableAnimal = (TamableAnimal)livingEntity;
                                tamableAnimal.m_21837_(true);
                                tamableAnimal.m_21839_(true);
                                tamableAnimal.m_6853_(true);
                                tamableAnimal.m_8119_();
                                if (tamableAnimal instanceof CrowEntity) {
                                    CrowEntity crowEntity = (CrowEntity)tamableAnimal;
                                    crowEntity.setCommandSit();
                                    crowEntity.m_8119_();
                                }
                                bookEntity.entity = tamableAnimal;
                            }
                        }
                    }
                    this.drawLivingEntity(tileEntityIn, matrixStackIn, bufferIn, bookEntity.scale, bookEntity.x, bookEntity.y, bookEntity.rot, 20, 107.0f, 58.0f, livingEntity, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                    continue;
                }
                if (bookEntity.entity != null) {
                    if (bookEntity.entityTagsList.size() > 0 && tileEntityIn.tickCount > (float)(bookEntity.entityTagsLastChange + 40)) {
                        int on;
                        bookEntity.entityTagsLastChange = (int)tileEntityIn.tickCount;
                        ++bookEntity.entityTagsListOn;
                        if (bookEntity.entityTagsListOn >= bookEntity.entityTagsList.size()) {
                            bookEntity.entityTagsListOn = 0;
                        }
                        if (bookEntity.entityTagsListOnSet != (on = bookEntity.entityTagsListOn) && !bookEntity.entityTagsList.get(on).equals("")) {
                            tag3 = TagParser.m_129359_((String)bookEntity.entityTagsList.get(on));
                            tag22 = tag3.m_128461_("CustomName");
                            stringTag2 = TagParser.m_129359_((String)tag22);
                            bookEntity.entity.m_6593_((Component)Component.m_237115_((String)stringTag2.m_128461_("text")));
                            bookEntity.entity.m_20258_(tag3);
                            bookEntity.entityTagsListOnSet = bookEntity.entityTagsListOn;
                        }
                    }
                    this.drawEntity(tileEntityIn, matrixStackIn, bufferIn, bookEntity.scale, bookEntity.x, bookEntity.y, bookEntity.rot, 20, 107.0f, 58.0f, bookEntity.entity, combinedLightIn, combinedOverlayIn, pageOn, isItem);
                    continue;
                }
                Optional optionalEntityType = EntityType.m_20632_((String)bookEntity.entityType);
                if (!optionalEntityType.isPresent()) continue;
                Entity entity = ((EntityType)optionalEntityType.get()).m_20615_(Hexerei.proxy.getLevel());
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    bookEntity.entity = entity;
                    if (!bookEntity.entityTags.equals("") && entity != null) {
                        tag = TagParser.m_129359_((String)bookEntity.entityTags);
                        tag2 = tag.m_128461_("CustomName");
                        stringTag = TagParser.m_129359_((String)tag2);
                        livingEntity.m_6593_((Component)Component.m_237115_((String)stringTag.m_128461_("text")));
                        livingEntity.m_7378_(tag);
                        if (livingEntity instanceof TamableAnimal) {
                            ((TamableAnimal)livingEntity).m_7105_(true);
                        }
                    }
                    if (!(livingEntity instanceof TamableAnimal)) continue;
                    TamableAnimal tamableAnimal = (TamableAnimal)livingEntity;
                    tamableAnimal.m_21837_(true);
                    tamableAnimal.m_21839_(true);
                    tamableAnimal.m_6853_(true);
                    tamableAnimal.m_8119_();
                    if (tamableAnimal instanceof CrowEntity) {
                        CrowEntity crowEntity = (CrowEntity)tamableAnimal;
                        crowEntity.setCommandSit();
                        crowEntity.m_8119_();
                    }
                    bookEntity.entity = tamableAnimal;
                    continue;
                }
                bookEntity.entity = entity;
                if (bookEntity.entityTags.equals("") || entity == null) continue;
                tag = TagParser.m_129359_((String)bookEntity.entityTags);
                tag2 = tag.m_128461_("CustomName");
                stringTag = TagParser.m_129359_((String)tag2);
                entity.m_6593_((Component)Component.m_237115_((String)stringTag.m_128461_("text")));
                entity.m_20258_(tag);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLivingEntity(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, float scale, float xIn, float yIn, float rot, int p_98853_, float p_98854_, float p_98855_, LivingEntity livingEntity, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, boolean isItem) {
        TamableAnimal tamableAnimal;
        matrixStackIn.m_85836_();
        if (livingEntity instanceof TamableAnimal && !(tamableAnimal = (TamableAnimal)livingEntity).m_21825_()) {
            tamableAnimal.m_21837_(true);
            tamableAnimal.m_6853_(true);
        }
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        }
        matrixStackIn.m_252880_(-0.001953125f, 0.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStackIn.m_252880_(-0.5f, 0.34375f, -0.0025f);
        matrixStackIn.m_85841_(0.049f * scale, 0.049f * scale, 0.003f);
        matrixStackIn.m_252880_(yIn * 1.25f / scale, -xIn * 1.25f / scale, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        float $$6 = (float)Math.atan(p_98854_ / 40.0f);
        float $$7 = (float)Math.atan(p_98855_ / 40.0f);
        Quaternionf $$10 = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf $$11 = Axis.f_252529_.m_252977_($$7 * 20.0f);
        $$10.mul((Quaternionfc)$$11);
        float $$12 = livingEntity.f_20883_;
        float $$13 = livingEntity.m_146908_();
        float $$15 = livingEntity.f_20886_;
        float $$16 = livingEntity.f_20885_;
        livingEntity.f_20883_ = rot * 0.6f + (float)livingEntity.m_19879_();
        livingEntity.m_146922_(rot * 0.6f + (float)livingEntity.m_19879_());
        livingEntity.f_20885_ = livingEntity.m_146908_();
        livingEntity.f_20886_ = livingEntity.m_146908_();
        EntityRenderDispatcher $$17 = Minecraft.m_91087_().m_91290_();
        $$11.conjugate();
        $$17.m_252923_($$11);
        $$17.m_114468_(false);
        MultiBufferSource.BufferSource $$18 = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> $$17.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStackIn, (MultiBufferSource)$$18, combinedLightIn));
        $$18.m_109911_();
        $$17.m_114468_(true);
        livingEntity.f_20883_ = $$12;
        livingEntity.m_146922_($$13);
        livingEntity.f_20886_ = $$15;
        livingEntity.f_20885_ = $$16;
        matrixStackIn.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawEntity(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, float scale, float xIn, float yIn, float rot, int p_98853_, float p_98854_, float p_98855_, Entity entity, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, boolean isItem) {
        matrixStackIn.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStackIn, isItem, ItemDisplayContext.NONE);
        }
        matrixStackIn.m_252880_(-0.001953125f, 0.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStackIn.m_252880_(-0.5f, 0.34375f, -0.0025f);
        matrixStackIn.m_85841_(0.049f * scale, 0.049f * scale, 0.003f);
        matrixStackIn.m_252880_(yIn * 1.25f / scale, -xIn * 1.25f / scale, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        float $$7 = (float)Math.atan(p_98855_ / 40.0f);
        Quaternionf $$10 = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf $$11 = Axis.f_252529_.m_252977_($$7 * 20.0f);
        $$10.mul((Quaternionfc)$$11);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-(rot * 0.6f + (float)entity.m_19879_())));
        EntityRenderDispatcher $$17 = Minecraft.m_91087_().m_91290_();
        $$11.conjugate();
        $$17.m_252923_($$11);
        $$17.m_114468_(false);
        MultiBufferSource.BufferSource $$18 = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> $$17.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStackIn, (MultiBufferSource)$$18, combinedLightIn));
        $$18.m_109911_();
        $$17.m_114468_(true);
        matrixStackIn.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPages(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int overlay, float partialTicks) throws CommandSyntaxException {
        this.drawPages(tileEntityIn, matrixStack, bufferSource, light, overlay, false, ItemDisplayContext.NONE, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltips(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int overlay, float partialTicks) throws CommandSyntaxException {
        this.drawTooltip = tileEntityIn.turnPage == 0;
        this.drawTooltipScaleOld = this.drawTooltipScale = Mth.m_14179_((float)partialTicks, (float)tileEntityIn.tooltipScaleOld, (float)tileEntityIn.tooltipScale);
        if (this.drawTooltipStack && tileEntityIn.turnPage == 0) {
            tileEntityIn.drawTooltip = true;
            this.drawTooltipStackFlag = true;
            this.drawTooltipTextFlag = false;
        } else if (this.drawTooltipText && tileEntityIn.turnPage == 0) {
            tileEntityIn.drawTooltip = true;
            this.drawTooltipTextFlag = true;
            this.drawTooltipStackFlag = false;
        } else {
            tileEntityIn.drawTooltip = false;
            if (this.drawTooltipScale == 0.0f) {
                this.drawTooltipStackFlag = false;
                this.drawTooltipTextFlag = false;
            }
        }
        if (this.drawTooltipScale > 0.0f) {
            if (this.drawTooltipStackFlag) {
                this.drawTooltipImage(this.tooltipStack, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, false);
            } else {
                this.drawTooltipText(tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPages(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int overlay, boolean isItem, ItemDisplayContext transformType, float partialTicks) throws CommandSyntaxException {
        this.tick += 1.0f;
        if (ClientProxy.keys == null) {
            ClientProxy.keys = Minecraft.m_91087_().f_91066_.f_92059_;
        }
        this.drawSlotOverlay = false;
        this.drawTooltipStack = false;
        this.drawTooltipText = false;
        BookEntries bookEntries = BookManager.getBookEntries();
        if (bookEntries == null) {
            return;
        }
        ItemStack stack = tileEntityIn.itemHandler.getStackInSlot(0);
        CompoundTag tag = stack.m_41784_();
        tileEntityIn.pageOneRotationRender = Mth.m_14179_((float)partialTicks, (float)tileEntityIn.pageOneRotationLast, (float)tileEntityIn.pageOneRotation);
        tileEntityIn.pageTwoRotationRender = Mth.m_14179_((float)partialTicks, (float)tileEntityIn.pageTwoRotationLast, (float)tileEntityIn.pageTwoRotation);
        String location1 = "";
        String location2 = "";
        String location1_back = "";
        String location2_back = "";
        String location1_next = "";
        String location2_next = "";
        int location1_p = 0;
        int location2_p = 0;
        int location1_back_p = 0;
        int location2_back_p = 0;
        int location1_next_p = 0;
        int location2_next_p = 0;
        int chapter = 0;
        int page = 0;
        if (tag.m_128441_("chapter")) {
            BookPageEntry pageEntry2;
            BookPageEntry pageEntry;
            BookPageEntry pageEntry3;
            chapter = tag.m_128451_("chapter");
            page = tag.m_128451_("page");
            if (page % 2 == 1) {
                --page;
            }
            if (page < bookEntries.chapterList.get((int)chapter).pages.size() && page >= 0) {
                pageEntry3 = bookEntries.chapterList.get((int)chapter).pages.get(page);
                location1 = pageEntry3.location;
                location1_p = pageEntry3.pageNum;
            }
            if (bookEntries.chapterList.get((int)chapter).pages.size() > page + 1) {
                pageEntry3 = bookEntries.chapterList.get((int)chapter).pages.get(page + 1);
                location2 = pageEntry3.location;
                location2_p = pageEntry3.pageNum;
            }
            int next_page_chapter = chapter;
            int next_page_page = page;
            int back_page_chapter = chapter;
            int back_page_page = page;
            if (next_page_page < BookManager.getBookEntries().chapterList.get((int)chapter).pages.size() - 2) {
                next_page_page += 2;
            } else if (chapter < BookManager.getBookEntries().chapterList.size() - 1) {
                ++next_page_chapter;
                next_page_page = 0;
            } else {
                next_page_chapter = -1;
            }
            if (next_page_chapter != -1 && next_page_chapter < bookEntries.chapterList.size() && next_page_page < bookEntries.chapterList.get((int)next_page_chapter).pages.size()) {
                pageEntry = bookEntries.chapterList.get((int)next_page_chapter).pages.get(next_page_page);
                location1_next = pageEntry.location;
                location1_next_p = pageEntry.pageNum;
                if (bookEntries.chapterList.get((int)next_page_chapter).pages.size() > next_page_page + 1) {
                    pageEntry2 = bookEntries.chapterList.get((int)next_page_chapter).pages.get(next_page_page + 1);
                    location2_next = pageEntry2.location;
                    location2_next_p = pageEntry2.pageNum;
                }
            }
            if (back_page_page - 2 >= 0) {
                back_page_page -= 2;
            } else if (back_page_chapter > 0) {
                back_page_page = BookManager.getBookEntries().chapterList.get((int)(--back_page_chapter)).pages.size() - 1;
                if (back_page_page % 2 == 1) {
                    --back_page_page;
                }
            } else {
                back_page_chapter = -1;
            }
            if (back_page_chapter != -1 && back_page_chapter < bookEntries.chapterList.size() && back_page_page < bookEntries.chapterList.get((int)back_page_chapter).pages.size()) {
                pageEntry = bookEntries.chapterList.get((int)back_page_chapter).pages.get(back_page_page);
                location1_back = pageEntry.location;
                location1_back_p = pageEntry.pageNum;
                if (bookEntries.chapterList.get((int)back_page_chapter).pages.size() > back_page_page + 1) {
                    pageEntry2 = bookEntries.chapterList.get((int)back_page_chapter).pages.get(back_page_page + 1);
                    location2_back = pageEntry2.location;
                    location2_back_p = pageEntry2.pageNum;
                }
            }
        }
        if (transformType != ItemDisplayContext.GUI) {
            page1 = BookManager.getBookPages(new ResourceLocation(location1));
            BookPage page2 = BookManager.getBookPages(new ResourceLocation(location2));
            this.drawPage(page1, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.LEFT_PAGE, isItem, transformType, location1_p);
            this.drawPage(page2, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE, isItem, transformType, location2_p);
            BookPage page1_under = BookManager.getBookPages(new ResourceLocation(location2_back));
            BookPage page1_prev = BookManager.getBookPages(new ResourceLocation(location1_back));
            BookPage page2_under = BookManager.getBookPages(new ResourceLocation(location1_next));
            BookPage page2_prev = BookManager.getBookPages(new ResourceLocation(location2_next));
            this.drawPage(page1_under, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.LEFT_PAGE_UNDER, isItem, transformType, location2_back_p);
            this.drawPage(page2_under, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE_UNDER, isItem, transformType, location1_next_p);
            this.drawPage(page1_prev, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.LEFT_PAGE_PREV, isItem, transformType, location1_back_p);
            this.drawPage(page2_prev, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE_PREV, isItem, transformType, location2_next_p);
        } else {
            page1 = BookManager.getBookPages(new ResourceLocation("hexerei:book/book_pages/gui_page_1"));
            BookPage page2 = BookManager.getBookPages(new ResourceLocation("hexerei:book/book_pages/gui_page_1"));
            this.drawPage(page1, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.LEFT_PAGE, isItem, transformType, location1_p);
            this.drawPage(page2, tileEntityIn, matrixStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE, isItem, transformType, location2_p);
        }
        this.drawBaseButtons(tileEntityIn, matrixStack, bufferSource, light, overlay, !location1_next.equals(""), !location1_back.equals(""), chapter, page, isItem);
        MouseHandler handler = Minecraft.m_91087_().f_91067_;
        this.mouseXOld = handler.m_91589_();
        this.mouseYOld = handler.m_91594_();
        this.isRightPressedOld = handler.m_91584_();
        this.isLeftPressedOld = handler.m_91560_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBaseButtons(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int overlay, boolean drawNext, boolean drawBack, int chapter, int page, boolean isItem) {
        this.drawBaseButtons(tileEntityIn, matrixStack, bufferSource, light, overlay, drawNext, drawBack, chapter, page, isItem, ItemDisplayContext.NONE, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBaseButtons(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int overlay, boolean drawNext, boolean drawBack, int chapter, int page, boolean isItem, ItemDisplayContext transformType, boolean fullyExtended) {
        Player playerIn = null;
        if (tileEntityIn.m_58904_() != null && tileEntityIn.m_58904_().f_46443_) {
            playerIn = Hexerei.proxy.getPlayer();
        }
        if (playerIn != null) {
            Vec3 intersectionVec;
            boolean flag;
            BookImageEffect bookImageEffect_tilt;
            BookImageEffect bookImageEffect_scale;
            ArrayList<BookImageEffect> effects;
            AABB aabb;
            Vec3 vec;
            BlockPos blockPos;
            Vector3f vector3f_1;
            Vector3f vector3f;
            boolean drawBookmarkButton = chapter != 0;
            double reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
            Vec3 planeNormalRight = this.planeNormal(tileEntityIn, PageOn.RIGHT_PAGE);
            Vec3 planeNormalLeft = this.planeNormal(tileEntityIn, PageOn.LEFT_PAGE);
            CompoundTag tag = tileEntityIn.itemHandler.getStackInSlot(0).m_41784_();
            if (drawBookmarkButton && !isItem) {
                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                vector3f_1 = new Vector3f(0.382f, 0.561f, -0.03f);
                blockPos = tileEntityIn.m_58899_();
                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                vector3f.add((Vector3fc)vector3f_1);
                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                effects = new ArrayList();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                BookImageEffect bookImageEffect_hover_overlay = new BookImageEffect("hover_overlay", 35.0f, 10.0f, new BookImage(-0.5f, -1.0f, -1.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f, "hexerei:textures/book/bookmark_button_hover.png", effects));
                flag = false;
                intersectionVec = PageDrawing.intersectPoint(-0.5f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.LEFT_PAGE);
                if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                    flag = true;
                }
                if (flag) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    effects.add(bookImageEffect_hover_overlay);
                }
                if (tag.m_128441_("bookmarks") && tag.m_128471_("opened")) {
                    int bookmark_color = 0;
                    int bookmark_chapter = 0;
                    int bookmark_page = 0;
                    String bookmark_id = null;
                    boolean flag2 = false;
                    CompoundTag bookmarks = tag.m_128469_("bookmarks");
                    for (int i = 0; i < 20; ++i) {
                        if (!bookmarks.m_128441_("slot_" + i)) continue;
                        CompoundTag slot = bookmarks.m_128469_("slot_" + i);
                        bookmark_color = slot.m_128451_("color");
                        if (slot.m_128441_("id")) {
                            bookmark_id = slot.m_128461_("id");
                        }
                        boolean flag3 = false;
                        if (bookmark_id != null) {
                            block1: for (BookChapter chapterEntry : BookManager.getBookEntries().chapterList) {
                                for (BookPageEntry pageEntry : chapterEntry.pages) {
                                    if (!pageEntry.location.equals(bookmark_id)) continue;
                                    bookmark_chapter = pageEntry.chapterNum;
                                    bookmark_page = pageEntry.chapterPageNum;
                                    flag3 = true;
                                    continue block1;
                                }
                            }
                        }
                        if (!flag3 || chapter != bookmark_chapter || page != bookmark_page && page + 1 != bookmark_page) continue;
                        flag2 = true;
                        break;
                    }
                    if (flag2) {
                        if (flag) {
                            ArrayList<Component> list = new ArrayList<Component>();
                            DyeColor col = DyeColor.m_41053_((int)bookmark_color);
                            Object output = col.m_41065_().substring(0, 1).toUpperCase() + col.m_41065_().substring(1);
                            output = ((String)output).replaceAll("_", " ");
                            list.add((Component)Component.m_237110_((String)"Change Color - %s", (Object[])new Object[]{Component.m_237110_((String)"%s", (Object[])new Object[]{output}).m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col)))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                            this.tooltipText = list;
                            this.tooltipStack = ItemStack.f_41583_;
                            this.drawTooltipText = true;
                        }
                        bookImage = new BookImage(-0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f * 1.15f, "hexerei:textures/book/bookmark_button_underlay.png", effects);
                        BookImage bookImage_overlay = new BookImage(-0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f * 1.15f, "hexerei:textures/book/bookmark_button_overlay.png", effects);
                        this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, isItem);
                        this.drawImage(bookImage_overlay, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                    } else {
                        if (flag) {
                            ArrayList<Component> list = new ArrayList<Component>();
                            list.add((Component)Component.m_237115_((String)"Bookmark Page").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                            this.tooltipText = list;
                            this.tooltipStack = ItemStack.f_41583_;
                            this.drawTooltipText = true;
                        }
                        bookImage = new BookImage(-0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f * 1.15f, "hexerei:textures/book/bookmark_button.png", effects);
                        this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, isItem);
                    }
                }
            }
            if (tag.m_128441_("bookmarks")) {
                int i;
                int bookmark_color = 0;
                int bookmark_chapter = 0;
                int bookmark_page = 0;
                CompoundTag bookmarks = tag.m_128469_("bookmarks");
                for (i = 0; i < 20; ++i) {
                    boolean flag2 = false;
                    if (bookmarks.m_128441_("slot_" + i)) {
                        BookImage bookImageOverlay;
                        BookEntries bookEntries;
                        DyeColor col;
                        Vec3 intersectionVec2;
                        AABB aabb2;
                        BlockPos blockPos2;
                        CompoundTag slot = bookmarks.m_128469_("slot_" + i);
                        bookmark_color = slot.m_128451_("color");
                        bookmark_chapter = slot.m_128451_("chapter");
                        bookmark_page = slot.m_128451_("page");
                        ResourceLocation bookmark_id = slot.m_128441_("id") ? new ResourceLocation(slot.m_128461_("id")) : null;
                        boolean flag3 = false;
                        if (bookmark_id != null) {
                            block4: for (BookChapter chapterEntry : BookManager.getBookEntries().chapterList) {
                                for (BookPageEntry pageEntry : chapterEntry.pages) {
                                    if (!new ResourceLocation(pageEntry.location).equals((Object)bookmark_id)) continue;
                                    bookmark_chapter = pageEntry.chapterNum;
                                    bookmark_page = pageEntry.chapterPageNum;
                                    flag3 = true;
                                    continue block4;
                                }
                            }
                        }
                        ArrayList<BookImageEffect> effectsBookmark = new ArrayList<BookImageEffect>();
                        if (i < 5) {
                            float xIn = -0.4f - tileEntityIn.buttonScaleRender - 0.15f;
                            float yIn = (float)i * 1.5f;
                            if (fullyExtended) {
                                xIn = -1.05f;
                                yIn += 0.25f;
                            }
                            Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_12 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            blockPos2 = tileEntityIn.m_58899_();
                            vector3f_12.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                            vector3f_12.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f2.add((Vector3fc)vector3f_12);
                            vector3f2.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec2 = new Vec3((double)(vector3f2.x() + (float)blockPos2.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f2.y() + (float)blockPos2.m_123342_() + 1.125f), (double)(vector3f2.z() + (float)blockPos2.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb2 = new AABB(vec2.m_82520_(-0.03, -0.03, -0.03), vec2.m_82520_(0.03, 0.03, 0.03));
                            intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.LEFT_PAGE);
                            if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                tileEntityIn.bookmarkHoverAmount[i] = this.moveTo(tileEntityIn.bookmarkHoverAmount[i], 1.0f, 0.1f);
                                flag2 = true;
                            }
                            float bookX = xIn + 0.4f - tileEntityIn.bookmarkHoverAmount[i] / 3.0f * tileEntityIn.buttonScaleRender;
                            if (fullyExtended) {
                                bookX = xIn + 0.4f - 0.33f;
                            }
                            if (flag2) {
                                ArrayList<Component> list = new ArrayList<Component>();
                                col = DyeColor.m_41053_((int)bookmark_color);
                                bookEntries = BookManager.getBookEntries();
                                if (flag3) {
                                    list.add((Component)Component.m_237110_((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.m_237115_((String)"[").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col))), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).pageNum}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237115_((String)"]").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col)))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                                    this.tooltipText = list;
                                    this.tooltipStack = ItemStack.f_41583_;
                                    this.drawTooltipText = true;
                                }
                            }
                            BookImage bookImageUnderlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                            bookImageOverlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                            this.drawBookmark(bookImageUnderlay, tileEntityIn, matrixStack, bufferSource, -10.0f, 90.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                            this.drawBookmark(bookImageOverlay, tileEntityIn, matrixStack, bufferSource, -10.0f, 90.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                        }
                        if (i >= 5 && i < 10) {
                            float yIn = -0.95f - tileEntityIn.buttonScaleRender - 0.25f;
                            float xIn = -5.5f + (float)i * 1.15f;
                            if (fullyExtended) {
                                yIn = -1.5000001f;
                                xIn += 0.25f;
                            }
                            Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_13 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            blockPos2 = tileEntityIn.m_58899_();
                            vector3f_13.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                            vector3f_13.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f3.add((Vector3fc)vector3f_13);
                            vector3f3.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec3 = new Vec3((double)(vector3f3.x() + (float)blockPos2.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f3.y() + (float)blockPos2.m_123342_() + 1.125f), (double)(vector3f3.z() + (float)blockPos2.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb2 = new AABB(vec3.m_82520_(-0.03, -0.03, -0.03), vec3.m_82520_(0.03, 0.03, 0.03));
                            intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.LEFT_PAGE);
                            if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                tileEntityIn.bookmarkHoverAmount[i] = this.moveTo(tileEntityIn.bookmarkHoverAmount[i], 1.0f, 0.1f);
                                flag2 = true;
                            }
                            float bookY = yIn + 0.5f - tileEntityIn.bookmarkHoverAmount[i] / 3.0f * tileEntityIn.buttonScaleRender;
                            if (fullyExtended) {
                                bookY = yIn + 0.5f - 0.33f;
                            }
                            if (flag2) {
                                ArrayList<Component> list = new ArrayList<Component>();
                                col = DyeColor.m_41053_((int)bookmark_color);
                                bookEntries = BookManager.getBookEntries();
                                if (bookEntries != null) {
                                    list.add((Component)Component.m_237110_((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.m_237115_((String)"[").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col))), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)bookmark_chapter).name}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)bookmark_chapter).pages.get((int)bookmark_page).pageNum}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237115_((String)"]").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col)))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                                    this.tooltipText = list;
                                    this.tooltipStack = ItemStack.f_41583_;
                                    this.drawTooltipText = true;
                                }
                            }
                            BookImage bookImageUnderlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                            bookImageOverlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                            this.drawBookmark(bookImageUnderlay, tileEntityIn, matrixStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                            this.drawBookmark(bookImageOverlay, tileEntityIn, matrixStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                        }
                        if (i >= 10 && i < 15) {
                            float yIn = -0.95f - tileEntityIn.buttonScaleRender - 0.25f;
                            float xIn = -11.25f + (float)i * 1.15f;
                            if (fullyExtended) {
                                yIn = -1.5000001f;
                                xIn += 0.25f;
                            }
                            Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_14 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            blockPos2 = tileEntityIn.m_58899_();
                            vector3f_14.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                            vector3f_14.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f4.add((Vector3fc)vector3f_14);
                            vector3f4.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec4 = new Vec3((double)(vector3f4.x() + (float)blockPos2.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f4.y() + (float)blockPos2.m_123342_() + 1.125f), (double)(vector3f4.z() + (float)blockPos2.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb2 = new AABB(vec4.m_82520_(-0.03, -0.03, -0.03), vec4.m_82520_(0.03, 0.03, 0.03));
                            intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, PageOn.RIGHT_PAGE);
                            if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                tileEntityIn.bookmarkHoverAmount[i] = this.moveTo(tileEntityIn.bookmarkHoverAmount[i], 1.0f, 0.1f);
                                flag2 = true;
                            }
                            if (flag2) {
                                ArrayList<Component> list = new ArrayList<Component>();
                                DyeColor col2 = DyeColor.m_41053_((int)bookmark_color);
                                BookEntries bookEntries2 = BookManager.getBookEntries();
                                if (bookEntries2 != null) {
                                    list.add((Component)Component.m_237110_((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.m_237115_((String)"[").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col2))), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries2.chapterList.get((int)bookmark_chapter).name}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries2.chapterList.get((int)bookmark_chapter).pages.get((int)bookmark_page).pageNum}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237115_((String)"]").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col2)))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                                    this.tooltipText = list;
                                    this.tooltipStack = ItemStack.f_41583_;
                                    this.drawTooltipText = true;
                                }
                            }
                            float bookY = yIn + 0.5f - tileEntityIn.bookmarkHoverAmount[i] / 3.0f * tileEntityIn.buttonScaleRender;
                            if (fullyExtended) {
                                bookY = yIn + 0.5f - 0.33f;
                            }
                            BookImage bookImageUnderlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                            bookImageOverlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                            this.drawBookmark(bookImageUnderlay, tileEntityIn, matrixStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                            this.drawBookmark(bookImageOverlay, tileEntityIn, matrixStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                        }
                        if (i >= 15) {
                            float xIn = 5.5f + tileEntityIn.buttonScaleRender;
                            float yIn = (float)(i - 15) * 1.5f;
                            if (fullyExtended) {
                                xIn = 6.65f;
                                yIn -= 0.25f;
                            }
                            Vector3f vector3f5 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_15 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            blockPos2 = tileEntityIn.m_58899_();
                            vector3f_15.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                            vector3f_15.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f5.add((Vector3fc)vector3f_15);
                            vector3f5.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec5 = new Vec3((double)(vector3f5.x() + (float)blockPos2.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f5.y() + (float)blockPos2.m_123342_() + 1.125f), (double)(vector3f5.z() + (float)blockPos2.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb2 = new AABB(vec5.m_82520_(-0.03, -0.03, -0.03), vec5.m_82520_(0.03, 0.03, 0.03));
                            intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, PageOn.RIGHT_PAGE);
                            if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                tileEntityIn.bookmarkHoverAmount[i] = this.moveTo(tileEntityIn.bookmarkHoverAmount[i], 1.0f, 0.1f);
                                flag2 = true;
                            }
                            float bookX = xIn - 0.4f + tileEntityIn.bookmarkHoverAmount[i] / 3.0f * tileEntityIn.buttonScaleRender;
                            if (fullyExtended) {
                                bookX = xIn - 0.4f - 0.33f;
                            }
                            if (flag2) {
                                ArrayList<Component> list = new ArrayList<Component>();
                                col = DyeColor.m_41053_((int)bookmark_color);
                                bookEntries = BookManager.getBookEntries();
                                if (bookEntries != null) {
                                    list.add((Component)Component.m_237110_((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.m_237115_((String)"[").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col))), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)bookmark_chapter).name}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237110_((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)bookmark_chapter).pages.get((int)bookmark_page).pageNum}).m_130948_(Style.f_131099_.m_178520_(0x9D9D97)), Component.m_237115_((String)"]").m_130948_(Style.f_131099_.m_178520_(HexereiUtil.getColorValue(col)))}).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                                    this.tooltipText = list;
                                    this.tooltipStack = ItemStack.f_41583_;
                                    this.drawTooltipText = true;
                                }
                            }
                            BookImage bookImageUnderlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                            bookImageOverlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 48.0f, 64.0f, 48.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                            this.drawBookmark(bookImageUnderlay, tileEntityIn, matrixStack, bufferSource, -10.0f, -90.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                            this.drawBookmark(bookImageOverlay, tileEntityIn, matrixStack, bufferSource, -10.0f, -90.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(DyeColor.m_41053_((int)bookmark_color)), isItem, transformType);
                        }
                        if (chapter == bookmark_chapter && (page == bookmark_page || page + 1 == bookmark_page)) {
                            tileEntityIn.bookmarkHoverAmount[i] = this.moveTo(tileEntityIn.bookmarkHoverAmount[i], 1.0f, 0.1f);
                        }
                    }
                    if (chapter == bookmark_chapter && (page == bookmark_page || page + 1 == bookmark_page) || !(tileEntityIn.bookmarkHoverAmount[i] > 0.0f) || flag2) continue;
                    tileEntityIn.bookmarkHoverAmount[i] = this.moveTo(tileEntityIn.bookmarkHoverAmount[i], 0.0f, 0.05f);
                }
                if (tileEntityIn.slotClicked != -1) {
                    for (i = 0; i < 20; ++i) {
                        BookImage bookSelector;
                        AABB aabb3;
                        Vector3f vector3f6;
                        if (i == tileEntityIn.slotClicked) continue;
                        boolean flag2 = false;
                        ArrayList<BookImageEffect> effectsBookmark = new ArrayList<BookImageEffect>();
                        if (i < 5) {
                            float xIn = -1.4f;
                            float yIn = (float)i * 1.5f;
                            vector3f6 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_16 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            BlockPos blockPos3 = tileEntityIn.m_58899_();
                            vector3f_16.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                            vector3f_16.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f6.add((Vector3fc)vector3f_16);
                            vector3f6.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec6 = new Vec3((double)(vector3f6.x() + (float)blockPos3.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f6.y() + (float)blockPos3.m_123342_() + 1.125f), (double)(vector3f6.z() + (float)blockPos3.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb3 = new AABB(vec6.m_82520_(-0.04, -0.04, -0.04), vec6.m_82520_(0.04, 0.04, 0.04));
                            Vec3 intersectionVec3 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.LEFT_PAGE);
                            if (aabb3.m_82390_(intersectionVec3) && intersectionVec3.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                flag2 = true;
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * tileEntityIn.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, tileEntityIn, matrixStack, bufferSource, 1.0f, 90.0f, light, overlay, PageOn.LEFT_PAGE, -1, isItem, transformType);
                        }
                        if (i >= 5 && i < 10) {
                            float xIn = -5.5f + (float)i * 1.15f;
                            float yIn = -1.95f;
                            vector3f6 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_17 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            BlockPos blockPos4 = tileEntityIn.m_58899_();
                            vector3f_17.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                            vector3f_17.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f6.add((Vector3fc)vector3f_17);
                            vector3f6.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec7 = new Vec3((double)(vector3f6.x() + (float)blockPos4.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f6.y() + (float)blockPos4.m_123342_() + 1.125f), (double)(vector3f6.z() + (float)blockPos4.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb3 = new AABB(vec7.m_82520_(-0.04, -0.04, -0.04), vec7.m_82520_(0.04, 0.04, 0.04));
                            Vec3 intersectionVec4 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.LEFT_PAGE);
                            if (aabb3.m_82390_(intersectionVec4) && intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                flag2 = true;
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * tileEntityIn.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, tileEntityIn, matrixStack, bufferSource, 1.0f, 0.0f, light, overlay, PageOn.LEFT_PAGE, -1, isItem, transformType);
                        }
                        if (i >= 10 && i < 15) {
                            float xIn = -11.25f + (float)i * 1.15f;
                            float yIn = -1.95f;
                            vector3f6 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_18 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            BlockPos blockPos5 = tileEntityIn.m_58899_();
                            vector3f_18.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                            vector3f_18.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f6.add((Vector3fc)vector3f_18);
                            vector3f6.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec8 = new Vec3((double)(vector3f6.x() + (float)blockPos5.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f6.y() + (float)blockPos5.m_123342_() + 1.125f), (double)(vector3f6.z() + (float)blockPos5.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb3 = new AABB(vec8.m_82520_(-0.03, -0.03, -0.03), vec8.m_82520_(0.03, 0.03, 0.03));
                            Vec3 intersectionVec5 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, PageOn.RIGHT_PAGE);
                            if (aabb3.m_82390_(intersectionVec5) && intersectionVec5.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                flag2 = true;
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * tileEntityIn.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, tileEntityIn, matrixStack, bufferSource, 1.0f, 0.0f, light, overlay, PageOn.RIGHT_PAGE, -1, isItem, transformType);
                        }
                        if (i >= 15) {
                            float xIn = 6.5f;
                            float yIn = (float)(i - 15) * 1.5f;
                            vector3f6 = new Vector3f(0.0f, 0.0f, 0.0f);
                            Vector3f vector3f_19 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                            BlockPos blockPos6 = tileEntityIn.m_58899_();
                            vector3f_19.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                            vector3f_19.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                            vector3f6.add((Vector3fc)vector3f_19);
                            vector3f6.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                            Vec3 vec9 = new Vec3((double)(vector3f6.x() + (float)blockPos6.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f6.y() + (float)blockPos6.m_123342_() + 1.125f), (double)(vector3f6.z() + (float)blockPos6.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                            aabb3 = new AABB(vec9.m_82520_(-0.04, -0.04, -0.04), vec9.m_82520_(0.04, 0.04, 0.04));
                            Vec3 intersectionVec6 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, PageOn.RIGHT_PAGE);
                            if (aabb3.m_82390_(intersectionVec6) && intersectionVec6.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                flag2 = true;
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * tileEntityIn.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, tileEntityIn, matrixStack, bufferSource, 1.0f, -90.0f, light, overlay, PageOn.RIGHT_PAGE, -1, isItem, transformType);
                        }
                        if ((chapter != bookmark_chapter || page != bookmark_page && page + 1 != bookmark_page) && tileEntityIn.bookmarkHoverAmount[i] > 0.0f && flag2) continue;
                    }
                }
            }
            if (!isItem) {
                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                vector3f_1 = new Vector3f(0.382f, 0.057749987f, -0.03f);
                blockPos = tileEntityIn.m_58899_();
                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                vector3f.add((Vector3fc)vector3f_1);
                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                effects = new ArrayList();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                String loc = "hexerei:textures/book/font_button.png";
                if (drawBack) {
                    loc = "hexerei:textures/book/back_page.png";
                }
                flag = false;
                intersectionVec = PageDrawing.intersectPoint(-0.5f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.LEFT_PAGE);
                if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                    flag = true;
                }
                if (flag) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    ArrayList<Component> list = new ArrayList<Component>();
                    if (drawBack) {
                        list.add((Component)Component.m_237115_((String)"Back").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                        loc = "hexerei:textures/book/back_page_hover.png";
                    } else {
                        list.add((Component)Component.m_237115_((String)"Change Font").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                        loc = "hexerei:textures/book/font_button_hover.png";
                    }
                    this.tooltipText = list;
                    this.tooltipStack = ItemStack.f_41583_;
                    this.drawTooltipText = true;
                }
                BookImage bookImage = new BookImage(-0.5f, 7.25f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f, loc, effects);
                this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, isItem);
            }
            if (!isItem) {
                ArrayList<Object> list;
                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                vector3f_1 = new Vector3f(0.0f, 0.072999984f, -0.03f);
                blockPos = tileEntityIn.m_58899_();
                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                vector3f.add((Vector3fc)vector3f_1);
                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                effects = new ArrayList<BookImageEffect>();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                String loc_close = "hexerei:textures/book/close.png";
                String loc_del = "hexerei:textures/book/delete.png";
                boolean flag2 = false;
                Vec3 intersectionVec7 = PageDrawing.intersectPoint(0.0f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.MIDDLE_BUTTON);
                if (aabb.m_82390_(intersectionVec7) && intersectionVec7.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                    flag2 = true;
                }
                if (flag2) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    if (tileEntityIn.slotClicked != -1 && tileEntityIn.slotClickedTick > 5) {
                        loc_del = "hexerei:textures/book/delete_hover.png";
                        ArrayList<Component> list2 = new ArrayList<Component>();
                        list2.add((Component)Component.m_237115_((String)"Delete Bookmark").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                        this.tooltipText = list2;
                        this.drawTooltipText = true;
                        this.tooltipStack = ItemStack.f_41583_;
                    } else {
                        loc_close = "hexerei:textures/book/close_hover.png";
                        ArrayList<Component> list3 = new ArrayList<Component>();
                        list3.add((Component)Component.m_237115_((String)"Close Book").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                        this.tooltipText = list3;
                        this.drawTooltipText = true;
                        this.tooltipStack = ItemStack.f_41583_;
                    }
                }
                BookImage bookImage = tileEntityIn.slotClicked != -1 && tileEntityIn.slotClickedTick > 5 ? new BookImage(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.bookmarkSelectorScale / 1.5f, loc_del, effects) : new BookImage(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f, loc_close, effects);
                this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.MIDDLE_BUTTON, isItem);
                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                vector3f_1 = new Vector3f(0.0f, 0.561f, -0.03f);
                blockPos = tileEntityIn.m_58899_();
                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                vector3f.add((Vector3fc)vector3f_1);
                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                effects = new ArrayList();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                String loc = "hexerei:textures/book/home.png";
                flag2 = false;
                intersectionVec7 = PageDrawing.intersectPoint(0.0f, -1.0f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, PageOn.MIDDLE_BUTTON);
                if (aabb.m_82390_(intersectionVec7) && intersectionVec7.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                    flag2 = true;
                }
                if (flag2) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    loc = "hexerei:textures/book/home_hover.png";
                    list = new ArrayList<Component>();
                    list.add(Component.m_237115_((String)"Home").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                    this.tooltipText = list;
                    this.drawTooltipText = true;
                    this.tooltipStack = ItemStack.f_41583_;
                }
                bookImage = new BookImage(0.0f, -8.1f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f, loc, effects);
                this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.MIDDLE_BUTTON, isItem);
                if (drawNext) {
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.38f, 0.057749987f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                    effects = new ArrayList();
                    bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                    bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                    loc = "hexerei:textures/book/next_page.png";
                    flag2 = false;
                    intersectionVec7 = PageDrawing.intersectPoint(-0.5f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, PageOn.RIGHT_PAGE);
                    if (aabb.m_82390_(intersectionVec7) && intersectionVec7.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag2 = true;
                    }
                    if (flag2) {
                        effects.add(bookImageEffect_scale);
                        effects.add(bookImageEffect_tilt);
                        loc = "hexerei:textures/book/next_page_hover.png";
                        list = new ArrayList();
                        list.add((Component)Component.m_237115_((String)"Next").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9D9D97)));
                        this.tooltipText = list;
                        this.drawTooltipText = true;
                        this.tooltipStack = ItemStack.f_41583_;
                    }
                    bookImage = new BookImage(5.5f, 7.25f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, tileEntityIn.buttonScaleRender / 2.0f, loc, effects);
                    this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, isItem);
                }
            }
        }
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public float getAngle(Vec3 pos, BlockEntity blockEntity) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)blockEntity.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)blockEntity.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float moveToAngle(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (Math.abs(distance) < 180.0f ? (input += speed) : (input -= speed)) : (Math.abs(distance) < 180.0f ? (input -= speed) : (input += speed));
        if (input < -90.0f) {
            input += 360.0f;
        }
        if (input > 270.0f) {
            input -= 360.0f;
        }
        return input;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItemInSlot(BookOfShadowsAltarTile tileEntityIn, BookItemsAndFluids bookItemStackInSlot, PoseStack matrixStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, boolean isItem) {
        if (bookItemStackInSlot.type.equals("item") || bookItemStackInSlot.type.equals("tag")) {
            if (bookItemStackInSlot.show_slot) {
                this.drawSlot(tileEntityIn, matrixStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, isItem);
            }
            PageDrawing.renderItem(tileEntityIn, bookItemStackInSlot, matrixStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, isItem);
        } else if (bookItemStackInSlot.type.equals("fluid")) {
            this.drawFluidInSlot(tileEntityIn, bookItemStackInSlot, matrixStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, isItem);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBlock(BookOfShadowsAltarTile tileEntityIn, BookBlocks bookItemStackInSlot, PoseStack matrixStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn) {
        if (bookItemStackInSlot.type.equals("block") || bookItemStackInSlot.type.equals("tag")) {
            if (bookItemStackInSlot.show_slot) {
                this.drawSlot(tileEntityIn, matrixStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, false);
            }
            PageDrawing.renderBlock(tileEntityIn, bookItemStackInSlot, matrixStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getpositionAABBNext(BookOfShadowsAltarTile altarTile) {
        BlockPos blockPos = altarTile.m_58899_();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(-0.38f, 0.057749987f, -0.03f);
        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        return new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getpositionAABBBack(BookOfShadowsAltarTile altarTile) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(0.38f, 0.057749987f, -0.03f);
        BlockPos blockPos = altarTile.m_58899_();
        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        return new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getpositionAABBLeft(BookOfShadowsAltarTile altarTile, float xIn, float yIn) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
        BlockPos blockPos = altarTile.m_58899_();
        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        return new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getpositionAABBClose(BookOfShadowsAltarTile altarTile) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(0.0f, 0.072999984f, -0.03f);
        BlockPos blockPos = altarTile.m_58899_();
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        return new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getpositionAABBHome(BookOfShadowsAltarTile altarTile) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(0.0f, 0.561f, -0.03f);
        BlockPos blockPos = altarTile.m_58899_();
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        return new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static BlockHitResult getPlayerPOVHitResult(int i, Level level, Player player, ClipContext.Fluid p_41438_) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        if (i == 1) {
            vec3 = vec3.m_82492_(0.0, 1.0, 0.0);
        }
        if (i == 2) {
            vec3 = vec3.m_82492_(0.25, 1.0, 0.0);
        }
        if (i == 3) {
            vec3 = vec3.m_82492_(-0.25, 1.0, 0.0);
        }
        if (i == 4) {
            vec3 = vec3.m_82492_(0.0, 1.0, 0.25);
        }
        if (i == 5) {
            vec3 = vec3.m_82492_(0.0, 1.0, -0.25);
        }
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, null));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        this.drawTooltipScaleOld = this.drawTooltipScale;
        if (this.drawTooltipStack && this.drawTooltip) {
            this.drawTooltipStackFlag = true;
            this.drawTooltipTextFlag = false;
            this.drawTooltipScale = this.moveTo(this.drawTooltipScale, 1.0f, 0.1f);
        } else if (this.drawTooltipText && this.drawTooltip) {
            this.drawTooltipTextFlag = true;
            this.drawTooltipStackFlag = false;
            this.drawTooltipScale = this.moveTo(this.drawTooltipScale, 1.0f, 0.1f);
        } else {
            this.drawTooltipScale = this.moveTo(this.drawTooltipScale, 0.0f, 0.2f);
            if (this.drawTooltipScale == 0.0f) {
                this.drawTooltipStackFlag = false;
                this.drawTooltipTextFlag = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClickEvent(InputEvent.MouseButton event) {
        Player playerIn;
        block36: {
            Iterator<BlockPos> iterator;
            double reach;
            block35: {
                block34: {
                    playerIn = Hexerei.proxy.getPlayer();
                    if (event.getButton() != 1 || playerIn == null) break block34;
                    this.isRightPressedOld = false;
                    Hexerei.entityClicked = false;
                    if (Minecraft.m_91087_().f_91080_ != null) {
                        return;
                    }
                    reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
                    List<BlockPos> altars = this.getAltars(playerIn);
                    iterator = altars.iterator();
                    break block35;
                }
                if (event.getButton() != 0) break block36;
                this.isLeftPressedOld = event.getAction() == 1;
                break block36;
            }
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                BlockEntity blockEntity = playerIn.m_9236_().m_7702_(pos);
                if (!(blockEntity instanceof BookOfShadowsAltarTile)) continue;
                BookOfShadowsAltarTile altarTile = (BookOfShadowsAltarTile)blockEntity;
                if (altarTile.turnPage == 0 && event.getAction() == 1) {
                    CompoundTag tag;
                    if (altarTile.slotClicked != -1 && ++altarTile.slotClickedTick > 0) {
                        playerIn.f_20911_ = false;
                        event.setCanceled(true);
                        event.setResult(Event.Result.DENY);
                    }
                    if ((tag = altarTile.itemHandler.getStackInSlot(0).m_41784_()).m_128441_("opened") && tag.m_128471_("opened")) {
                        int clicked = this.checkClick(playerIn, altarTile);
                        if (clicked == 1 && altarTile.slotClicked == -1 && this.clickedNext(altarTile)) {
                            altarTile.setTurnPage(clicked);
                            playerIn.m_6674_(InteractionHand.MAIN_HAND);
                            event.setCanceled(true);
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                        if (clicked == 2) {
                            if (altarTile.slotClicked == -1 && this.clickedBack(altarTile)) {
                                altarTile.setTurnPage(clicked);
                                playerIn.m_6674_(InteractionHand.MAIN_HAND);
                                event.setCanceled(true);
                                event.setResult(Event.Result.DENY);
                                break;
                            }
                            if (altarTile.slotClicked == -1) {
                                ++ClientProxy.fontIndex;
                                playerIn.m_6674_(InteractionHand.MAIN_HAND);
                                event.setCanceled(true);
                                event.setResult(Event.Result.DENY);
                                break;
                            }
                        }
                        if (clicked == -2) {
                            altarTile.setTurnPage(clicked);
                            playerIn.m_6674_(InteractionHand.MAIN_HAND);
                            event.setCanceled(true);
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                        if (clicked == -1) {
                            playerIn.m_6674_(InteractionHand.MAIN_HAND);
                            event.setCanceled(true);
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                        if (clicked == -3) {
                            playerIn.m_6674_(InteractionHand.MAIN_HAND);
                            event.setCanceled(true);
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                        if (clicked == 3 && tag.m_128451_("chapter") != 0) {
                            altarTile.clickPageBookmark(tag.m_128451_("chapter"), tag.m_128451_("page"));
                            playerIn.m_6674_(InteractionHand.MAIN_HAND);
                            event.setCanceled(true);
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                        if (clicked == -5) {
                            playerIn.f_20911_ = false;
                            event.setCanceled(true);
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                    }
                }
                if (altarTile.turnPage != 0 || altarTile.slotClicked == -1 || event.getAction() != 0) continue;
                Vec3 planeNormalRight = this.planeNormal(altarTile, PageOn.RIGHT_PAGE);
                Vec3 planeNormalLeft = this.planeNormal(altarTile, PageOn.LEFT_PAGE);
                CompoundTag tag = altarTile.itemHandler.getStackInSlot(0).m_41784_();
                if (!tag.m_128441_("bookmarks")) continue;
                int bookmark_color = 0;
                int bookmark_chapter = 0;
                int bookmark_page = 0;
                ResourceLocation bookmark_id = null;
                boolean flag = false;
                int int_slot = 0;
                CompoundTag bookmarks = tag.m_128469_("bookmarks");
                if (altarTile.slotClicked != -1) {
                    Vec3 intersectionVec = PageDrawing.intersectPoint(0.0f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.MIDDLE_BUTTON);
                    AABB aabb = this.getpositionAABBClose(altarTile);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        altarTile.deleteBookmark(altarTile.slotClicked);
                    }
                }
                for (int i = 0; i < 20; ++i) {
                    block38: {
                        block37: {
                            Vec3 intersectionVec;
                            AABB aabb;
                            Vec3 vec;
                            BlockPos blockPos;
                            Vector3f vector3f_1;
                            Vector3f vector3f;
                            float yIn;
                            float xIn;
                            boolean flag2 = false;
                            if (bookmarks.m_128441_("slot_" + i)) {
                                CompoundTag slot = bookmarks.m_128469_("slot_" + i);
                                bookmark_color = slot.m_128451_("color");
                                if (slot.m_128441_("id")) {
                                    bookmark_id = new ResourceLocation(slot.m_128461_("id"));
                                }
                            }
                            ArrayList effectsBookmark = new ArrayList();
                            if (i < 5) {
                                xIn = -0.4f - altarTile.buttonScale - 0.15f;
                                yIn = (float)i * 1.5f;
                                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                                vector3f_1 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                                blockPos = altarTile.m_58899_();
                                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                                vector3f.add((Vector3fc)vector3f_1);
                                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                                intersectionVec = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                                if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                    flag2 = true;
                                }
                            }
                            if (i >= 5 && i < 10) {
                                xIn = -5.5f + (float)i * 1.15f;
                                yIn = -0.95f - altarTile.buttonScale - 0.25f;
                                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                                vector3f_1 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                                blockPos = altarTile.m_58899_();
                                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                                vector3f.add((Vector3fc)vector3f_1);
                                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                                intersectionVec = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                                if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                    flag2 = true;
                                }
                            }
                            if (i >= 10 && i < 15) {
                                xIn = -11.25f + (float)i * 1.15f;
                                yIn = -0.95f - altarTile.buttonScale - 0.25f;
                                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                                vector3f_1 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                                blockPos = altarTile.m_58899_();
                                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                                vector3f.add((Vector3fc)vector3f_1);
                                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                                intersectionVec = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                                if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                    flag2 = true;
                                }
                            }
                            if (i >= 15) {
                                xIn = 5.5f + altarTile.buttonScale + 0.15f;
                                yIn = (float)(i - 15) * 1.5f;
                                vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                                vector3f_1 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                                blockPos = altarTile.m_58899_();
                                vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                                vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                                vector3f.add((Vector3fc)vector3f_1);
                                vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                                vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                                aabb = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                                intersectionVec = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                                if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                                    flag2 = true;
                                }
                            }
                            if (!flag2) continue;
                            if (altarTile.slotClicked != i) break block37;
                            if (altarTile.slotClickedTick < 20) {
                                boolean flag3 = false;
                                if (bookmark_id != null) {
                                    for (BookChapter chapter : BookManager.getBookEntries().chapterList) {
                                        for (BookPageEntry pageEntry : chapter.pages) {
                                            if (!new ResourceLocation(pageEntry.location).equals((Object)bookmark_id)) continue;
                                            flag3 = true;
                                            altarTile.setTurnPage(-1, pageEntry.chapterNum, pageEntry.chapterPageNum);
                                            break;
                                        }
                                        if (!flag3) continue;
                                    }
                                }
                                if (!flag3) {
                                    altarTile.setTurnPage(-1, bookmark_chapter, bookmark_page);
                                }
                            }
                            break block38;
                        }
                        altarTile.swapBookmarks(altarTile.slotClicked, i);
                        altarTile.bookmarkHoverAmount[i] = 0.0f;
                        altarTile.bookmarkHoverAmount[altarTile.slotClicked] = 0.0f;
                    }
                    int_slot = i;
                    break;
                }
                if (int_slot != altarTile.slotClicked || altarTile.slotClickedTick > 5) {
                    playerIn.m_6674_(InteractionHand.MAIN_HAND);
                }
                altarTile.slotClicked = -1;
                altarTile.slotClickedTick = 0;
                break;
            }
        }
        if (playerIn != null && event.getButton() == 1) {
            this.isRightPressedOld = true;
        }
    }

    public String getModNameForModId(String modId) {
        ModList modList = ModList.get();
        return modList.getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    public List<BlockPos> getAltars(Player playerIn) {
        double reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        ArrayList<BlockPos> altars = new ArrayList<BlockPos>();
        float f = playerIn.m_146909_();
        float f1 = playerIn.m_146908_();
        Vec3 vec3 = playerIn.m_146892_();
        Vec3 vec31 = new Vec3(0.0, 0.0, 0.25);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        float section = 0.0f;
        while ((double)section <= reach) {
            BlockPos pos = BlockPos.m_274446_((Position)vec3.m_82520_((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section));
            BlockPos pos2 = BlockPos.m_274446_((Position)vec3.m_82520_((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).m_82549_(vec31.m_82524_(f1).m_82524_((float)Math.toRadians(90.0))));
            BlockPos pos3 = BlockPos.m_274446_((Position)vec3.m_82520_((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).m_82549_(vec31.m_82524_(f1).m_82524_((float)Math.toRadians(-90.0))));
            if (!altars.contains(pos)) {
                altars.add(pos);
            }
            if (!altars.contains(pos2)) {
                altars.add(pos2);
            }
            if (!altars.contains(pos3)) {
                altars.add(pos3);
            }
            if ((double)section > reach) {
                section = (float)reach;
                pos = BlockPos.m_274446_((Position)vec3.m_82520_((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section));
                pos2 = BlockPos.m_274446_((Position)vec3.m_82520_((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).m_82549_(vec31.m_82524_(f1).m_82524_((float)Math.toRadians(90.0))));
                pos3 = BlockPos.m_274446_((Position)vec3.m_82520_((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).m_82549_(vec31.m_82524_(f1).m_82524_((float)Math.toRadians(-90.0))));
                if (!altars.contains(pos)) {
                    altars.add(pos);
                }
                if (!altars.contains(pos2)) {
                    altars.add(pos2);
                }
                if (altars.contains(pos3)) break;
                altars.add(pos3);
                break;
            }
            section = (float)((double)section + 0.25);
        }
        return altars;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyEvent(InputEvent.Key event) {
        if (!HexereiJeiCompat.LOADED) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        Player playerIn = Hexerei.proxy.getPlayer();
        if (playerIn == null || event.getAction() == 0) {
            // empty if block
        }
        if (playerIn != null && event.getAction() == 1) {
            if (event.getKey() != ModKeyBindings.bookJEIShowUses.getKey().m_84873_() && event.getKey() != ModKeyBindings.bookJEIShowRecipe.getKey().m_84873_()) {
                return;
            }
            if (Minecraft.m_91087_().f_91080_ instanceof IRecipesGui) {
                return;
            }
            double reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
            List<BlockPos> altars = this.getAltars(playerIn);
            block0: for (BlockPos pos : altars) {
                Vec3 intersectionVec;
                AABB aabb;
                float size;
                Vec3 vec;
                BlockPos blockPos;
                Vector3f vector3f_1;
                Vector3f vector3f;
                BookItemsAndFluids bookItemStackInSlot;
                int i;
                CompoundTag tag;
                BlockEntity blockEntity = playerIn.m_9236_().m_7702_(pos);
                if (!(blockEntity instanceof BookOfShadowsAltarTile)) continue;
                BookOfShadowsAltarTile altarTile = (BookOfShadowsAltarTile)blockEntity;
                if (altarTile.turnPage != 0 || !(tag = altarTile.itemHandler.getStackInSlot(0).m_41784_()).m_128441_("opened") || !tag.m_128471_("opened")) continue;
                Vec3 planeNormalRight = this.planeNormal(altarTile, PageOn.RIGHT_PAGE);
                Vec3 planeNormalLeft = this.planeNormal(altarTile, PageOn.LEFT_PAGE);
                if (!tag.m_128441_("chapter")) continue;
                String location1 = "";
                String location2 = "";
                BookEntries bookEntries = BookManager.getBookEntries();
                if (bookEntries == null) continue;
                int chapter = tag.m_128451_("chapter");
                int page = tag.m_128451_("page");
                if (page % 2 == 1) {
                    --page;
                }
                int start = bookEntries.chapterList.get((int)chapter).startPage;
                int end = bookEntries.chapterList.get((int)chapter).endPage;
                if (page < bookEntries.chapterList.get((int)chapter).pages.size() && page >= 0) {
                    location1 = bookEntries.chapterList.get((int)chapter).pages.get((int)page).location;
                }
                if (end - start > page + 1) {
                    location2 = bookEntries.chapterList.get((int)chapter).pages.get((int)(page + 1)).location;
                }
                BookPage page1 = BookManager.getBookPages(new ResourceLocation(location1));
                BookPage page2 = BookManager.getBookPages(new ResourceLocation(location2));
                if (page1 != null) {
                    for (i = 0; i < page1.itemList.size(); ++i) {
                        bookItemStackInSlot = (BookItemsAndFluids)page1.itemList.toArray()[i];
                        if (bookItemStackInSlot.item != null && bookItemStackInSlot.item.m_41619_()) continue;
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - bookItemStackInSlot.x * 0.06f, 0.5f - bookItemStackInSlot.y * 0.061f, -0.03f);
                        blockPos = altarTile.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                        size = 0.03f;
                        aabb = new AABB(vec.m_82520_((double)(-size), (double)(-size), (double)(-size)), vec.m_82520_((double)size, (double)size, (double)size));
                        intersectionVec = PageDrawing.intersectPoint(bookItemStackInSlot.x, bookItemStackInSlot.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                        if (!aabb.m_82390_(intersectionVec) || !(intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                        if (event.getKey() == ModKeyBindings.bookJEIShowUses.getKey().m_84873_()) {
                            if (bookItemStackInSlot.item != null) {
                                HexereiJei.showUses(bookItemStackInSlot.item);
                            } else {
                                HexereiJei.showUses(bookItemStackInSlot.fluid);
                            }
                        }
                        if (event.getKey() != ModKeyBindings.bookJEIShowRecipe.getKey().m_84873_()) break;
                        if (bookItemStackInSlot.item != null) {
                            HexereiJei.showRecipe(bookItemStackInSlot.item);
                            break;
                        }
                        HexereiJei.showRecipe(bookItemStackInSlot.fluid);
                        break;
                    }
                }
                if (page2 == null) continue;
                for (i = 0; i < page2.itemList.size(); ++i) {
                    bookItemStackInSlot = (BookItemsAndFluids)page2.itemList.toArray()[i];
                    if (bookItemStackInSlot.item == null || bookItemStackInSlot.item.m_41619_()) continue;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f - bookItemStackInSlot.x * 0.06f, 0.5f - bookItemStackInSlot.y * 0.061f, -0.03f);
                    blockPos = altarTile.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                    size = 0.03f;
                    aabb = new AABB(vec.m_82520_((double)(-size), (double)(-size), (double)(-size)), vec.m_82520_((double)size, (double)size, (double)size));
                    intersectionVec = PageDrawing.intersectPoint(bookItemStackInSlot.x, bookItemStackInSlot.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                    if (!aabb.m_82390_(intersectionVec) || !(intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                    if (event.getKey() == ModKeyBindings.bookJEIShowUses.getKey().m_84873_()) {
                        if (bookItemStackInSlot.item != null) {
                            HexereiJei.showUses(bookItemStackInSlot.item);
                        } else {
                            HexereiJei.showUses(bookItemStackInSlot.fluid);
                        }
                    }
                    if (event.getKey() != ModKeyBindings.bookJEIShowRecipe.getKey().m_84873_()) continue block0;
                    if (bookItemStackInSlot.item != null) {
                        HexereiJei.showRecipe(bookItemStackInSlot.item);
                        continue block0;
                    }
                    HexereiJei.showRecipe(bookItemStackInSlot.fluid);
                    continue block0;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Vec3 intersectPoint(Vec3 rayVector, Vec3 rayPoint, Vec3 planeNormal, Vec3 planePoint) {
        Vec3 diff = rayPoint.m_82546_(planePoint);
        double prod1 = diff.m_82526_(planeNormal);
        double prod2 = rayVector.m_82526_(planeNormal);
        double prod3 = prod1 / prod2;
        return rayPoint.m_82546_(rayVector.m_82490_(prod3));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Vec3 intersectPoint(float xIn, float yIn, Vec3 rayVector, Vec3 rayPoint, Vec3 planeNormal, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        if (pageOn == PageOn.RIGHT_PAGE) {
            BlockPos blockPos = altarTile.m_58899_();
            Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f vector3f_1 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
            vector3f.add((Vector3fc)vector3f_1);
            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
            Vec3 planePoint = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
            Vec3 diff = rayPoint.m_82546_(planePoint);
            double prod1 = diff.m_82526_(planeNormal);
            double prod2 = rayVector.m_82526_(planeNormal);
            double prod3 = prod1 / prod2;
            return rayPoint.m_82546_(rayVector.m_82490_(prod3));
        }
        if (pageOn == PageOn.MIDDLE_BUTTON) {
            BlockPos blockPos = altarTile.m_58899_();
            Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f vector3f_1 = new Vector3f(0.0f, 0.5f - yIn * 0.061f, -0.03f);
            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
            vector3f.add((Vector3fc)vector3f_1);
            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
            Vec3 planePoint = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
            Vec3 diff = rayPoint.m_82546_(planePoint);
            double prod1 = diff.m_82526_(planeNormal);
            double prod2 = rayVector.m_82526_(planeNormal);
            double prod3 = prod1 / prod2;
            return rayPoint.m_82546_(rayVector.m_82490_(prod3));
        }
        BlockPos blockPos = altarTile.m_58899_();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 planePoint = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        Vec3 diff = rayPoint.m_82546_(planePoint);
        double prod1 = diff.m_82526_(planeNormal);
        double prod2 = rayVector.m_82526_(planeNormal);
        double prod3 = prod1 / prod2;
        return rayPoint.m_82546_(rayVector.m_82490_(prod3));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 planeNormal(BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        if (pageOn == PageOn.RIGHT_PAGE) {
            Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f vector3f_1 = new Vector3f(-0.020000001f, 0.069949985f, -0.03f);
            BlockPos blockPos = altarTile.m_58899_();
            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
            vector3f.add((Vector3fc)vector3f_1);
            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
            Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
            Vector3f vector3f_2 = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f vector3f_2_1 = new Vector3f(-0.05f, 0.5f, -0.03f);
            vector3f_2_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
            vector3f_2_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
            vector3f_2.add((Vector3fc)vector3f_2_1);
            vector3f_2.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
            Vec3 vec_2 = new Vec3((double)(vector3f_2.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f_2.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f_2.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
            Vector3f vector3f_3 = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f vector3f_3_1 = new Vector3f(-0.65f, -0.110000014f, -0.03f);
            vector3f_3_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
            vector3f_3_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
            vector3f_3.add((Vector3fc)vector3f_3_1);
            vector3f_3.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
            Vec3 vec_3 = new Vec3((double)(vector3f_3.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f_3.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f_3.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
            Vec3 vec3_pr = vec_2.m_82546_(vec);
            Vec3 vec3_pq = vec_3.m_82546_(vec);
            return vec3_pr.m_82537_(vec3_pq);
        }
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_1 = new Vector3f(0.38f, 0.069949985f, -0.03f);
        BlockPos blockPos = altarTile.m_58899_();
        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.add((Vector3fc)vector3f_1);
        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        Vector3f vector3f_2 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_2_1 = new Vector3f(0.35f, 0.5f, -0.03f);
        vector3f_2_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
        vector3f_2_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f_2.add((Vector3fc)vector3f_2_1);
        vector3f_2.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec_2 = new Vec3((double)(vector3f_2.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f_2.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f_2.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        Vector3f vector3f_3 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f_3_1 = new Vector3f(-0.24999997f, -0.110000014f, -0.03f);
        vector3f_3_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
        vector3f_3_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f_3.add((Vector3fc)vector3f_3_1);
        vector3f_3.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
        Vec3 vec_3 = new Vec3((double)(vector3f_3.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f_3.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f_3.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        Vec3 vec3_pr = vec_2.m_82546_(vec);
        Vec3 vec3_pq = vec_3.m_82546_(vec);
        return vec3_pr.m_82537_(vec3_pq);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int checkClick(Player playerIn, BookOfShadowsAltarTile altarTile) {
        ItemStack stack;
        CompoundTag tag;
        CompoundTag tag2;
        AABB aabb;
        Vec3 intersectionVec;
        int clicked = 0;
        double reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        Vec3 planeNormalRight = this.planeNormal(altarTile, PageOn.RIGHT_PAGE);
        Vec3 planeNormalLeft = this.planeNormal(altarTile, PageOn.LEFT_PAGE);
        if (!this.isRightPressedOld) {
            intersectionVec = PageDrawing.intersectPoint(-0.5f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
            aabb = this.getpositionAABBNext(altarTile);
            if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                clicked = 1;
                return clicked;
            }
            intersectionVec = PageDrawing.intersectPoint(-0.5f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
            aabb = this.getpositionAABBBack(altarTile);
            if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                clicked = 2;
                return clicked;
            }
            intersectionVec = PageDrawing.intersectPoint(0.0f, 7.05f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.MIDDLE_BUTTON);
            aabb = this.getpositionAABBClose(altarTile);
            if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                clicked = -2;
                return clicked;
            }
            intersectionVec = PageDrawing.intersectPoint(0.0f, -1.0f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.MIDDLE_BUTTON);
            aabb = this.getpositionAABBHome(altarTile);
            if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                clicked = -1;
                altarTile.setTurnPage(clicked, 0, 0);
                return clicked;
            }
        }
        if (!this.isRightPressedOld) {
            intersectionVec = PageDrawing.intersectPoint(-0.5f, -1.0f, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
            aabb = this.getpositionAABBLeft(altarTile, -0.5f, -1.0f);
            if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                clicked = 3;
                return clicked;
            }
        }
        if (!this.isRightPressedOld && (tag2 = altarTile.itemHandler.getStackInSlot(0).m_41784_()).m_128441_("bookmarks")) {
            int bookmark_color = 0;
            int bookmark_chapter = 0;
            int bookmark_page = 0;
            boolean flag = false;
            CompoundTag bookmarks = tag2.m_128469_("bookmarks");
            for (int i = 0; i < 20; ++i) {
                Vec3 intersectionVec2;
                AABB aabb2;
                Vec3 vec;
                BlockPos blockPos;
                Vector3f vector3f_1;
                Vector3f vector3f;
                float yIn;
                float xIn;
                if (!bookmarks.m_128441_("slot_" + i)) continue;
                boolean flag2 = false;
                CompoundTag slot = bookmarks.m_128469_("slot_" + i);
                bookmark_color = slot.m_128451_("color");
                bookmark_chapter = slot.m_128451_("chapter");
                bookmark_page = slot.m_128451_("page");
                ArrayList effectsBookmark = new ArrayList();
                if (i < 5) {
                    xIn = -0.4f - altarTile.buttonScale - 0.15f;
                    yIn = (float)i * 1.5f;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                    blockPos = altarTile.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                    aabb2 = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                    intersectionVec2 = PageDrawing.intersectPoint(xIn - altarTile.bookmarkHoverAmount[i] / 3.0f, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                    if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag2 = true;
                    }
                }
                if (i >= 5 && i < 10) {
                    xIn = -5.5f + (float)i * 1.15f;
                    yIn = -0.95f - altarTile.buttonScale - 0.25f;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(0.35f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                    blockPos = altarTile.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                    aabb2 = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                    intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                    if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag2 = true;
                    }
                }
                if (i >= 10 && i < 15) {
                    xIn = -11.25f + (float)i * 1.15f;
                    yIn = -0.95f - altarTile.buttonScale - 0.25f;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                    blockPos = altarTile.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                    aabb2 = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                    intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                    if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag2 = true;
                    }
                }
                if (i >= 15) {
                    xIn = 5.5f + altarTile.buttonScale + 0.15f;
                    yIn = (float)(i - 15) * 1.5f;
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f - xIn * 0.06f, 0.5f - yIn * 0.061f, -0.03f);
                    blockPos = altarTile.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                    aabb2 = new AABB(vec.m_82520_(-0.03, -0.03, -0.03), vec.m_82520_(0.03, 0.03, 0.03));
                    intersectionVec2 = PageDrawing.intersectPoint(xIn, yIn, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                    if (aabb2.m_82390_(intersectionVec2) && intersectionVec2.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag2 = true;
                    }
                }
                if (!flag2) continue;
                altarTile.slotClicked = i;
                clicked = -1;
            }
        }
        if ((tag = (stack = altarTile.itemHandler.getStackInSlot(0)).m_41784_()).m_128441_("chapter")) {
            String location1 = "";
            String location2 = "";
            BookEntries bookEntries = BookManager.getBookEntries();
            int chapter = tag.m_128451_("chapter");
            int page = tag.m_128451_("page");
            if (page % 2 == 1) {
                --page;
            }
            if (bookEntries != null) {
                BookEntity bookEntity;
                BookImage bookImage;
                BookPage page_check;
                String location3;
                int k;
                String itemRegistryName;
                Object intersectionVec3;
                AABB aabb3;
                BookItemsAndFluids bookItemStackInSlot;
                Vec3 intersectionVec4;
                Vec3 vec;
                BlockPos blockPos;
                Vector3f vector3f_1;
                Vector3f vector3f;
                BookNonItemTooltip bookNonItemTooltip;
                int start = bookEntries.chapterList.get((int)chapter).startPage;
                int end = bookEntries.chapterList.get((int)chapter).endPage;
                if (page < bookEntries.chapterList.get((int)chapter).pages.size() && page >= 0) {
                    location1 = bookEntries.chapterList.get((int)chapter).pages.get((int)page).location;
                }
                if (end - start > page + 1) {
                    location2 = bookEntries.chapterList.get((int)chapter).pages.get((int)(page + 1)).location;
                }
                BookPage page1 = BookManager.getBookPages(new ResourceLocation(location1));
                BookPage page2 = BookManager.getBookPages(new ResourceLocation(location2));
                if (page1 != null) {
                    int i;
                    if (!this.isRightPressedOld) {
                        for (int i2 = 0; i2 < page1.nonItemTooltipList.size(); ++i2) {
                            bookNonItemTooltip = (BookNonItemTooltip)page1.nonItemTooltipList.toArray()[i2];
                            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                            vector3f_1 = new Vector3f(0.35f - bookNonItemTooltip.x * 0.06f, 0.5f - bookNonItemTooltip.y * 0.061f, -0.03f);
                            blockPos = altarTile.m_58899_();
                            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                            vector3f.add((Vector3fc)vector3f_1);
                            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                            vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                            AABB aabb4 = new AABB(vec.m_82520_((double)(-bookNonItemTooltip.width), (double)(-bookNonItemTooltip.height), (double)(-bookNonItemTooltip.width)), vec.m_82520_((double)bookNonItemTooltip.width, (double)bookNonItemTooltip.height, (double)bookNonItemTooltip.width));
                            intersectionVec4 = PageDrawing.intersectPoint(bookNonItemTooltip.x, bookNonItemTooltip.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                            if (bookNonItemTooltip.hyperlink_id.isEmpty() && bookNonItemTooltip.hyperlink_url.equals("") || !aabb4.m_82390_(intersectionVec4) || !(intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                            clicked = -1;
                            if (!bookNonItemTooltip.hyperlink_url.equals("")) {
                                PageDrawing.showLinkScreenClient(bookNonItemTooltip.hyperlink_url);
                            }
                            if (bookNonItemTooltip.hyperlink_id.isEmpty()) break;
                            block2: for (BookChapter chapterEntry : BookManager.getBookEntries().chapterList) {
                                for (BookPageEntry pageEntry : chapterEntry.pages) {
                                    if (!pageEntry.location.equals(bookNonItemTooltip.hyperlink_id)) continue;
                                    altarTile.setTurnPage(clicked, pageEntry.chapterNum, pageEntry.chapterPageNum);
                                    continue block2;
                                }
                            }
                            break;
                        }
                    }
                    for (i = 0; i < page1.itemList.size(); ++i) {
                        bookItemStackInSlot = (BookItemsAndFluids)page1.itemList.toArray()[i];
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - bookItemStackInSlot.x * 0.06f, 0.5f - bookItemStackInSlot.y * 0.061f, -0.03f);
                        blockPos = altarTile.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpened / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                        float size = 0.03f;
                        aabb3 = new AABB(vec.m_82520_((double)(-size), (double)(-size), (double)(-size)), vec.m_82520_((double)size, (double)size, (double)size));
                        intersectionVec3 = PageDrawing.intersectPoint(bookItemStackInSlot.x, bookItemStackInSlot.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                        if (!aabb3.m_82390_((Vec3)intersectionVec3) || !(intersectionVec3.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                        clicked = -1;
                        itemRegistryName = bookItemStackInSlot.item != null ? HexereiUtil.getRegistryName(bookItemStackInSlot.item.m_41720_()).toString() : HexereiUtil.getRegistryName(bookItemStackInSlot.fluid.getFluid()).toString();
                        boolean flag = false;
                        if (BookManager.getBookItemHyperlinks().containsKey(itemRegistryName)) {
                            BookHyperlink hyperlink = BookManager.getBookItemHyperlinks().get(itemRegistryName);
                            if (chapter != hyperlink.chapter || page != hyperlink.page && page != hyperlink.page - 1) {
                                altarTile.setTurnPage(clicked, hyperlink.chapter, hyperlink.page);
                            }
                            flag = true;
                        }
                        if (!flag) {
                            block5: for (int j = 1; j < bookEntries.chapterList.size(); ++j) {
                                for (k = 0; k < bookEntries.chapterList.get((int)j).pages.size(); ++k) {
                                    location3 = bookEntries.chapterList.get((int)j).pages.get((int)k).location;
                                    page_check = BookManager.getBookPages(new ResourceLocation(location3));
                                    if (page_check == null || !page_check.itemHyperlink.equals(itemRegistryName)) continue;
                                    if (chapter != j || page != k && page != k - 1) {
                                        altarTile.setTurnPage(clicked, j, k);
                                    }
                                    BookManager.addBookItemHyperlink(itemRegistryName, new BookHyperlink(j, k));
                                    flag = true;
                                    continue block5;
                                }
                            }
                        }
                        if (flag) break;
                        break;
                    }
                    for (i = 0; i < page1.imageList.size(); ++i) {
                        bookImage = (BookImage)page1.imageList.toArray()[i];
                        vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                        vector3f_1 = new Vector3f(0.35f - bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                        blockPos = altarTile.m_58899_();
                        vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpenedRender / 1.12f));
                        vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpenedRender / 2.0f));
                        vector3f.add((Vector3fc)vector3f_1);
                        vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpunRender));
                        vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)));
                        AABB aabb5 = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                        intersectionVec4 = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                        if (!aabb5.m_82390_(intersectionVec4) || !(intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                        clicked = -1;
                        if (!bookImage.hyperlink_url.equals("")) {
                            PageDrawing.showLinkScreenClient(bookImage.hyperlink_url);
                        }
                        if (bookImage.hyperlink_id.isEmpty()) break;
                        block8: for (BookChapter chapterEntry : BookManager.getBookEntries().chapterList) {
                            for (BookPageEntry pageEntry : chapterEntry.pages) {
                                if (!pageEntry.location.equals(bookImage.hyperlink_id)) continue;
                                altarTile.setTurnPage(clicked, pageEntry.chapterNum, pageEntry.chapterPageNum);
                                continue block8;
                            }
                        }
                        break;
                    }
                    if (altarTile.slotClicked == -1) {
                        for (i = 0; i < page1.entityList.size(); ++i) {
                            bookEntity = (BookEntity)page1.entityList.toArray()[i];
                            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                            vector3f_1 = new Vector3f(0.35f - (bookEntity.x + bookEntity.offset.x) * 0.06f, 0.5f - (bookEntity.y + bookEntity.offset.y) * 0.061f, -0.03f);
                            blockPos = altarTile.m_58899_();
                            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + altarTile.degreesOpenedRender / 1.12f));
                            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpenedRender / 2.0f));
                            vector3f.add((Vector3fc)vector3f_1);
                            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpunRender));
                            vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)));
                            AABB aabb6 = new AABB(vec.m_82520_(-0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale), vec.m_82520_(0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale));
                            intersectionVec4 = PageDrawing.intersectPoint(bookEntity.x, bookEntity.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, altarTile, PageOn.LEFT_PAGE);
                            if (!aabb6.m_82390_(intersectionVec4) || !(intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                            if (!this.isRightPressedOld) {
                                playerIn.m_6674_(InteractionHand.MAIN_HAND);
                                Hexerei.entityClicked = true;
                            }
                            return -5;
                        }
                    }
                }
                if (page2 != null) {
                    if (!this.isRightPressedOld) {
                        int i;
                        for (i = 0; i < page2.nonItemTooltipList.size(); ++i) {
                            bookNonItemTooltip = (BookNonItemTooltip)page2.nonItemTooltipList.toArray()[i];
                            if (bookNonItemTooltip.hyperlink_id.isEmpty() && bookNonItemTooltip.hyperlink_url.equals("")) continue;
                            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                            vector3f_1 = new Vector3f(-0.05f - bookNonItemTooltip.x * 0.06f, 0.5f - bookNonItemTooltip.y * 0.061f, -0.03f);
                            blockPos = altarTile.m_58899_();
                            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                            vector3f.add((Vector3fc)vector3f_1);
                            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                            vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                            AABB aabb7 = new AABB(vec.m_82520_((double)(-bookNonItemTooltip.width), (double)(-bookNonItemTooltip.height), (double)(-bookNonItemTooltip.width)), vec.m_82520_((double)bookNonItemTooltip.width, (double)bookNonItemTooltip.height, (double)bookNonItemTooltip.width));
                            intersectionVec4 = PageDrawing.intersectPoint(bookNonItemTooltip.x, bookNonItemTooltip.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                            if (!aabb7.m_82390_(intersectionVec4) || !(intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                            clicked = -1;
                            if (!bookNonItemTooltip.hyperlink_url.equals("")) {
                                PageDrawing.showLinkScreenClient(bookNonItemTooltip.hyperlink_url);
                            }
                            if (bookNonItemTooltip.hyperlink_id.isEmpty()) break;
                            block12: for (BookChapter chapterEntry : BookManager.getBookEntries().chapterList) {
                                for (BookPageEntry pageEntry : chapterEntry.pages) {
                                    if (!pageEntry.location.equals(bookNonItemTooltip.hyperlink_id)) continue;
                                    altarTile.setTurnPage(clicked, pageEntry.chapterNum, pageEntry.chapterPageNum);
                                    continue block12;
                                }
                            }
                            break;
                        }
                        for (i = 0; i < page2.itemList.size(); ++i) {
                            bookItemStackInSlot = (BookItemsAndFluids)page2.itemList.toArray()[i];
                            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                            vector3f_1 = new Vector3f(-0.05f - bookItemStackInSlot.x * 0.06f, 0.5f - bookItemStackInSlot.y * 0.061f, -0.03f);
                            blockPos = altarTile.m_58899_();
                            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpened / 1.12f)));
                            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpened / 2.0f));
                            vector3f.add((Vector3fc)vector3f_1);
                            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpun));
                            vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.1f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
                            float size = 0.03f;
                            aabb3 = new AABB(vec.m_82520_((double)(-size), (double)(-size), (double)(-size)), vec.m_82520_((double)size, (double)size, (double)size));
                            intersectionVec3 = PageDrawing.intersectPoint(bookItemStackInSlot.x, bookItemStackInSlot.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                            if (!aabb3.m_82390_((Vec3)intersectionVec3) || !(intersectionVec3.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                            clicked = -1;
                            itemRegistryName = bookItemStackInSlot.item != null ? HexereiUtil.getRegistryName(bookItemStackInSlot.item.m_41720_()).toString() : HexereiUtil.getRegistryName(bookItemStackInSlot.fluid.getFluid()).toString();
                            boolean flag = false;
                            if (BookManager.getBookItemHyperlinks().containsKey(itemRegistryName)) {
                                BookHyperlink hyperlink = BookManager.getBookItemHyperlinks().get(itemRegistryName);
                                if (chapter != hyperlink.chapter || page != hyperlink.page && page != hyperlink.page - 1) {
                                    altarTile.setTurnPage(clicked, hyperlink.chapter, hyperlink.page);
                                }
                                flag = true;
                            }
                            if (!flag) {
                                block15: for (int j = 1; j < bookEntries.chapterList.size(); ++j) {
                                    for (k = 0; k < bookEntries.chapterList.get((int)j).pages.size(); ++k) {
                                        location3 = bookEntries.chapterList.get((int)j).pages.get((int)k).location;
                                        page_check = BookManager.getBookPages(new ResourceLocation(location3));
                                        if (page_check == null || !page_check.itemHyperlink.equals(itemRegistryName)) continue;
                                        if (chapter != j || page != k && page != k - 1) {
                                            altarTile.setTurnPage(clicked, j, k);
                                        }
                                        BookManager.addBookItemHyperlink(itemRegistryName, new BookHyperlink(j, k));
                                        flag = true;
                                        continue block15;
                                    }
                                }
                            }
                            if (flag) break;
                            break;
                        }
                        for (i = 0; i < page2.imageList.size(); ++i) {
                            bookImage = (BookImage)page2.imageList.toArray()[i];
                            if (bookImage.hyperlink_id.isEmpty() && bookImage.hyperlink_url.equals("")) continue;
                            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                            vector3f_1 = new Vector3f(-0.05f + -bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                            blockPos = altarTile.m_58899_();
                            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpenedRender / 1.12f)));
                            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpenedRender / 2.0f));
                            vector3f.add((Vector3fc)vector3f_1);
                            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpunRender));
                            vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)));
                            AABB aabb8 = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                            intersectionVec4 = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                            if (!aabb8.m_82390_(intersectionVec4) || !(intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                            clicked = -1;
                            if (!bookImage.hyperlink_url.equals("")) {
                                PageDrawing.showLinkScreenClient(bookImage.hyperlink_url);
                            }
                            if (bookImage.hyperlink_id.isEmpty()) break;
                            block18: for (BookChapter chapterEntry : BookManager.getBookEntries().chapterList) {
                                for (BookPageEntry pageEntry : chapterEntry.pages) {
                                    if (!pageEntry.location.equals(bookImage.hyperlink_id)) continue;
                                    altarTile.setTurnPage(clicked, pageEntry.chapterNum, pageEntry.chapterPageNum);
                                    continue block18;
                                }
                            }
                            break;
                        }
                    }
                    if (altarTile.slotClicked == -1) {
                        for (int i = 0; i < page2.entityList.size(); ++i) {
                            bookEntity = (BookEntity)page2.entityList.toArray()[i];
                            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                            vector3f_1 = new Vector3f(-0.05f + -(bookEntity.x + bookEntity.offset.x) * 0.06f, 0.5f - (bookEntity.y + bookEntity.offset.y) * 0.061f, -0.03f);
                            blockPos = altarTile.m_58899_();
                            vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + altarTile.degreesOpenedRender / 1.12f)));
                            vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - altarTile.degreesOpenedRender / 2.0f));
                            vector3f.add((Vector3fc)vector3f_1);
                            vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(altarTile.degreesSpunRender));
                            vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(altarTile.degreesSpunRender / 57.1f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f)));
                            AABB aabb9 = new AABB(vec.m_82520_(-0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, -0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale), vec.m_82520_(0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale, 0.03 * (double)bookEntity.scale * (double)bookEntity.offset.scale));
                            intersectionVec4 = PageDrawing.intersectPoint(bookEntity.x, bookEntity.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, altarTile, PageOn.RIGHT_PAGE);
                            if (!aabb9.m_82390_(intersectionVec4) || !(intersectionVec4.m_82546_(playerIn.m_146892_()).m_82553_() <= reach)) continue;
                            if (!this.isRightPressedOld) {
                                playerIn.m_6674_(InteractionHand.MAIN_HAND);
                                Hexerei.entityClicked = true;
                            }
                            return -5;
                        }
                    }
                }
            }
        }
        return clicked;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean clickedBack(BookOfShadowsAltarTile altarTile) {
        CompoundTag tag2 = altarTile.itemHandler.getStackInSlot(0).m_41784_();
        int currentPage = tag2.m_128451_("page");
        int currentChapter = tag2.m_128451_("chapter");
        return currentChapter > 0 || currentPage > 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean clickedNext(BookOfShadowsAltarTile altarTile) {
        CompoundTag tag2 = altarTile.itemHandler.getStackInSlot(0).m_41784_();
        int currentPage = tag2.m_128451_("page");
        int currentChapter = tag2.m_128451_("chapter");
        return currentChapter < BookManager.getBookEntries().chapterList.size() - 1 || currentPage < BookManager.getBookEntries().chapterList.get((int)currentChapter).pages.size() - 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showLinkScreenClient(String link) {
        ConfirmLinkScreen screen = new ConfirmLinkScreen(p_169232_ -> {
            if (p_169232_) {
                Util.m_137581_().m_137646_(link);
            }
            Minecraft.m_91087_().m_91152_(null);
        }, link, true);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSlot(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, boolean isItem) {
        matrixStack.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.5f, 0.34375f, -7.5E-4f);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStack.m_252880_(-0.001875f, -0.0033125f, 0.0f);
        matrixStack.m_252880_(xIn / 8.1f, yIn / 8.1f, 0.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        RenderSystem.setShader(GameRenderer::m_172667_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("hexerei:textures/book/slot.png")));
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        boolean u = false;
        boolean v = false;
        int imageWidth = 32;
        int imageHeight = 32;
        int width = 18;
        int height = 18;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.m_109911_();
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluidInSlot(BookOfShadowsAltarTile tileEntityIn, @NotNull BookItemsAndFluids bookItemsAndFluids, PoseStack matrixStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, boolean isItem) {
        matrixStack.m_85836_();
        FluidStack stack = bookItemsAndFluids.fluid;
        int capacity = bookItemsAndFluids.capacity;
        boolean showSlot = bookItemsAndFluids.show_slot;
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.5f, 0.34375f, -7.5E-4f);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStack.m_252880_(-0.001875f, -0.0033125f, 0.0f);
        matrixStack.m_252880_(xIn / 8.1f, yIn / 8.1f, 0.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        RenderSystem.setShader(GameRenderer::m_172667_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        if (showSlot) {
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("hexerei:textures/book/slot.png")));
            Matrix3f normal = matrixStack.m_85850_().m_252943_();
            boolean u = false;
            boolean v = false;
            int imageWidth = 18;
            int imageHeight = 18;
            int width = 18;
            int height = 18;
            float u1 = ((float)u + 0.0f) / (float)imageWidth;
            float u2 = ((float)u + (float)width) / (float)imageWidth;
            float v1 = ((float)v + 0.0f) / (float)imageHeight;
            float v2 = ((float)v + (float)height) / (float)imageHeight;
            buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        this.drawFluid(matrixStack, bufferSource, (int)bookItemsAndFluids.fluid_width, (int)bookItemsAndFluids.fluid_height, stack, capacity, light, overlay, bookItemsAndFluids.fluid_offset_x, bookItemsAndFluids.fluid_offset_y, bookItemsAndFluids.fluid_width, bookItemsAndFluids.fluid_height);
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawFluid(PoseStack poseStack, MultiBufferSource bufferSource, int tiledWidth, int tiledHeight, FluidStack fluidStack, int capacity, int light, int overlay, float x_offset, float y_offset, float width, float height) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = PageDrawing.getStillFluidSprite(fluidStack);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        int amount = fluidStack.getAmount();
        if (amount == 0) {
            amount = capacity > 0 ? capacity : 1000;
        }
        int scaledAmount = amount * tiledHeight / (capacity != 0 ? capacity : 1000);
        if (amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > tiledHeight) {
            scaledAmount = tiledHeight;
        }
        if (capacity == 0) {
            scaledAmount = tiledHeight;
        }
        PageDrawing.drawTiledSprite(poseStack, bufferSource, tiledWidth, tiledHeight, fluidColor, scaledAmount, fluidStillSprite, capacity, amount, light, overlay, x_offset, y_offset, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawTiledSprite(PoseStack poseStack, MultiBufferSource bufferSource, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite, int capacity, int amount, int light, int overlay, float x_offset, float y_offset, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width2 = xTile == xTileCount ? xRemainder : (int)width;
                int height2 = yTile == yTileCount ? yRemainder : (int)height;
                int x_tile = xTile * 16;
                int y_tile = tiledHeight - (yTile + 1) * (int)height;
                if (width2 <= 0 || height2 <= 0) continue;
                int maskTop = (int)height - height2;
                int maskRight = (int)width - width2;
                PageDrawing.drawTextureWithMasking(poseStack, bufferSource, capacity, amount, x_tile, y_tile, sprite, color, maskTop, maskRight, 1.0f, light, overlay, x_offset, y_offset, width, height);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Fluid fluid = fluidStack.getFluid();
        FluidType type = fluid.getFluidType();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawTextureWithMasking(PoseStack poseStack, MultiBufferSource bufferSource, int capacity, int amount, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int color, int maskTop, int maskRight, float zLevel, int light, int overlay, float x_offset, float y_offset, float width, float height) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / width * (uMax - uMin);
        vMax -= (float)maskTop / height * (vMax - vMin);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.001f, 0.0485f + y_offset * 0.005975f, x_offset * 0.005975f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        poseStack.m_85849_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * width, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * width, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * width, 0.006111111f * (height - (float)maskTop)).m_85950_(red, green, blue, alpha).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * width, 0.006111111f * (height - (float)maskTop)).m_85950_(red, green, blue, alpha).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    private float easeInOutElastic(double x) {
        double c5 = 1.3962634015954636;
        return (float)(x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? 4.0 * x * x * x : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * c5) / 2.0 + 1.0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltipImage(ItemStack stack, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, boolean isItem) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.5f, 1.125f, 0.5f);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        matrixStack.m_252880_(0.25f, -(1.0f - (this.drawTooltipScale < 0.5f ? this.drawTooltipScale * 2.0f : 1.0f)) / 12.0f, 0.0f);
        float scale = this.easeInOutElastic(this.drawTooltipScale);
        matrixStack.m_85841_(scale, scale, scale);
        RenderSystem.setShader(GameRenderer::m_172667_);
        this.tooltipStack = stack;
        if (!this.tooltipStack.m_41619_()) {
            List tooltip = stack.m_41651_(Hexerei.proxy.getPlayer(), (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
            if (tooltip.size() > 0) {
                tooltip.addAll(this.tooltipText);
            }
            String modId = HexereiUtil.getRegistryName(this.tooltipStack.m_41720_()).m_135827_();
            String modName = this.getModNameForModId(modId);
            MutableComponent modNameComponent = Component.m_237115_((String)modName);
            modNameComponent.m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x5555FF));
            if (!HexereiModNameTooltipCompat.LOADED) {
                tooltip.add(modNameComponent);
            }
            this.renderTooltip(this.tooltipStack, bufferSource, matrixStack, tooltip, stack.m_150921_(), 0, 0, overlay, light);
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getFluidTooltip(BookItemsAndFluids bookItemStackInSlot) {
        FluidStack fluidStack = bookItemStackInSlot.fluid;
        int capacity = bookItemStackInSlot.capacity;
        int amount = bookItemStackInSlot.amount;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluidType = fluidStack.getFluid();
        if (fluidType == null) {
            return tooltip;
        }
        MutableComponent displayName = (MutableComponent)fluidStack.getDisplayName();
        displayName.m_130940_(ChatFormatting.WHITE);
        tooltip.add((Component)displayName);
        if (capacity != 0) {
            amountString = Component.m_237110_((String)"book.hexerei.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{nf.format(amount), nf.format(capacity)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        } else if (amount != 0) {
            amountString = Component.m_237110_((String)"book.hexerei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(amount)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        }
        if (bookItemStackInSlot.extra_tooltips.size() > 0) {
            tooltip.addAll(bookItemStackInSlot.extra_tooltips);
        }
        String modId = HexereiUtil.getRegistryName(fluidStack.getFluid()).m_135827_();
        String modName = this.getModNameForModId(modId);
        MutableComponent modNameComponent = Component.m_237115_((String)modName);
        modNameComponent.m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x5555FF));
        tooltip.add((Component)modNameComponent);
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltipText(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, boolean isItem) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.5f, 1.125f, 0.5f);
        matrixStack.m_252880_((float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f));
        matrixStack.m_252880_(0.0f, -(tileEntityIn.degreesFloppedRender / 90.0f) / 16.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-(tileEntityIn.degreesOpenedRender / 2.0f + 45.0f)));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-tileEntityIn.degreesFloppedRender));
        matrixStack.m_252880_(0.0f, 0.0f, -(tileEntityIn.degreesFloppedRender / 10.0f) / 32.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        float scale = Math.min(this.drawTooltipScale, 1.0f);
        matrixStack.m_252880_(0.25f, -(1.0f - (scale < 0.5f ? scale * 2.0f : 1.0f)) / 12.0f, 0.0f);
        scale = this.easeInOutElastic(this.drawTooltipScale);
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        matrixStack.m_85841_(scale, scale, scale);
        this.renderTooltip(this.tooltipStack, bufferSource, matrixStack, this.tooltipText, Optional.empty(), 0, 0, overlay, light);
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(ItemStack stack, MultiBufferSource buffer, PoseStack p_169389_, List<Component> components, Optional<TooltipComponent> p_169391_, int p_169392_, int p_169393_, int overlay, int light) {
        List list = ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, components, p_169391_, (int)p_169392_, (int)300, (int)750, (Font)Minecraft.m_91087_().f_91062_);
        ArrayList<MutableComponent> newComponentList = new ArrayList<MutableComponent>();
        for (Component component : components) {
            newComponentList.add(Component.m_237115_((String)component.getString()).m_130948_(component.m_7383_().m_178520_(0x292929)));
        }
        List list2 = ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, newComponentList, p_169391_, (int)p_169392_, (int)300, (int)750, (Font)Minecraft.m_91087_().f_91062_);
        this.renderTooltipInternal(buffer, p_169389_, list, list2, p_169392_, p_169393_, overlay, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderTooltipInternal(MultiBufferSource bufferSource, PoseStack matrixStack, List<ClientTooltipComponent> clientTooltipComponentList, List<ClientTooltipComponent> clientTooltipComponentList2, int p_169386_, int p_169387_, int overlay, int light) {
        if (!clientTooltipComponentList.isEmpty()) {
            HexereiBookTooltip hexereiBookTooltip;
            ClientTooltipComponent clientTooltipComponent2;
            int l2;
            RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)this.tooltipStack, (GuiGraphics)new GuiGraphics(Minecraft.m_91087_(), (MultiBufferSource.BufferSource)bufferSource), (int)p_169386_, (int)p_169387_, (int)750, (int)750, clientTooltipComponentList, (Font)Minecraft.m_91087_().f_91062_, (ClientTooltipPositioner)DefaultTooltipPositioner.f_262752_);
            if (preEvent.isCanceled()) {
                return;
            }
            int i = 0;
            int j = clientTooltipComponentList.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clientTooltipComponent : clientTooltipComponentList) {
                int l = clientTooltipComponent.m_142069_(preEvent.getFont());
                if (l > i) {
                    i = l;
                }
                j += clientTooltipComponent.m_142103_();
            }
            int j2 = preEvent.getX() + 12;
            int k2 = preEvent.getY() - 12;
            if (j2 + i > 750) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > 750) {
                k2 = 750 - j - 6;
            }
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110467_((ResourceLocation)new ResourceLocation("hexerei:textures/book/blank.png")));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            matrixStack.m_85841_(0.003f, 0.003f, 0.003f);
            matrixStack.m_252880_((float)(-(i + 15)) / 2.0f, (float)(-(j + 15)) / 2.0f, -10.0f);
            RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)this.tooltipStack, (GuiGraphics)new GuiGraphics(Minecraft.m_91087_(), (MultiBufferSource.BufferSource)bufferSource), (int)j2, (int)k2, (Font)preEvent.getFont(), clientTooltipComponentList);
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 0.2f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 3, k2 - 4, j2 + i + 3, k2 - 2, 0.1f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundStart(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 4, 0.1f, colorEvent.getBackgroundEnd(), colorEvent.getBackgroundEnd(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 4, k2 - 3, j2 - 2, k2 + j + 3, 0.1f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 + i + 2, k2 - 3, j2 + i + 4, k2 + j + 3, 0.1f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), overlay, light);
            ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
            buffer = bufferSource.m_6299_(RenderType.m_110467_((ResourceLocation)new ResourceLocation("hexerei:textures/book/blank.png")));
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 0.0f, colorEvent.getBorderStart(), colorEvent.getBorderEnd(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 0.0f, colorEvent.getBorderStart(), colorEvent.getBorderEnd(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 0.0f, colorEvent.getBorderStart(), colorEvent.getBorderStart(), overlay, light);
            PageDrawing.fillGradient(matrixStack, buffer, j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 0.0f, colorEvent.getBorderEnd(), colorEvent.getBorderEnd(), overlay, light);
            RenderSystem.enableDepthTest();
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            matrixStack.m_85837_(0.0, 0.0, 0.01);
            matrixStack.m_85841_(1.0f, 1.0f, 1.0E-5f);
            int l1 = k2;
            Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
            for (l2 = 0; l2 < clientTooltipComponentList.size(); ++l2) {
                clientTooltipComponent2 = clientTooltipComponentList.get(l2);
                if (clientTooltipComponent2 instanceof HexereiBookTooltip) {
                    hexereiBookTooltip = (HexereiBookTooltip)clientTooltipComponent2;
                    hexereiBookTooltip.renderText(preEvent.getFont(), j2, l1, matrix4f, multibuffersource$buffersource, overlay, light);
                } else if (clientTooltipComponent2 instanceof ClientTextTooltip) {
                    ClientTextTooltip clientTextTooltip = (ClientTextTooltip)clientTooltipComponent2;
                    int r = 63;
                    int g = 63;
                    int b = 63;
                    int a = 255;
                    int col = a << 24 | r << 16 | g << 8 | b;
                    Font font = preEvent.getFont();
                    matrix4f = matrixStack.m_85850_().m_252922_();
                    font.m_272191_(clientTextTooltip.f_169936_, (float)j2, (float)l1, col, false, matrix4f, (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, light);
                    matrixStack.m_85836_();
                    matrixStack.m_252880_(0.5f, 0.5f, 7500.0f);
                    matrix4f = matrixStack.m_85850_().m_252922_();
                    font.m_272191_(((ClientTextTooltip)clientTooltipComponentList2.get((int)l2)).f_169936_, (float)j2, (float)l1, col, false, matrix4f, (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, light);
                    matrixStack.m_85849_();
                }
                l1 += clientTooltipComponent2.m_142103_() + (l2 == 0 ? 2 : 0);
            }
            multibuffersource$buffersource.m_109911_();
            l1 = k2;
            matrixStack.m_85841_(1.0f, 1.0f, 333.333f);
            for (l2 = 0; l2 < clientTooltipComponentList.size(); ++l2) {
                clientTooltipComponent2 = clientTooltipComponentList.get(l2);
                RenderSystem.enableDepthTest();
                if (clientTooltipComponent2 instanceof HexereiBookTooltip) {
                    hexereiBookTooltip = (HexereiBookTooltip)clientTooltipComponent2;
                    hexereiBookTooltip.renderImage(preEvent.getFont(), bufferSource, j2, l1, matrixStack, itemRenderer, 0, overlay, light);
                }
                l1 += clientTooltipComponent2.m_142103_() + (l2 == 0 ? 2 : 0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int adjustColor(int p_92720_) {
        return (p_92720_ & 0xFC000000) == 0 ? p_92720_ | 0xFF000000 : p_92720_;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void fillGradient(PoseStack poseStack, VertexConsumer buffer, int p_93126_, int p_93127_, int p_93128_, int p_93129_, float p_93130_, int pColorFrom, int pColorTo, int overlay, int light) {
        float fromAlpha = (float)FastColor.ARGB32.m_13655_((int)pColorFrom) / 255.0f * 0.9f;
        float f1 = (float)FastColor.ARGB32.m_13665_((int)pColorFrom) / 255.0f;
        float f2 = (float)FastColor.ARGB32.m_13667_((int)pColorFrom) / 255.0f;
        float f3 = (float)FastColor.ARGB32.m_13669_((int)pColorFrom) / 255.0f;
        float toAlpha = (float)FastColor.ARGB32.m_13655_((int)pColorTo) / 255.0f * 0.9f;
        float f5 = (float)FastColor.ARGB32.m_13665_((int)pColorTo) / 255.0f;
        float f6 = (float)FastColor.ARGB32.m_13667_((int)pColorTo) / 255.0f;
        float f7 = (float)FastColor.ARGB32.m_13669_((int)pColorTo) / 255.0f;
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        boolean u = false;
        boolean v = false;
        boolean imageWidth = true;
        boolean imageHeight = true;
        boolean width = true;
        boolean height = true;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        buffer.m_252986_(matrix4f, (float)p_93128_, (float)p_93127_, p_93130_).m_85950_(f1, f2, f3, fromAlpha).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, (float)p_93126_, (float)p_93127_, p_93130_).m_85950_(f1, f2, f3, fromAlpha).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, (float)p_93126_, (float)p_93129_, p_93130_).m_85950_(f5, f6, f7, toAlpha).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, (float)p_93128_, (float)p_93129_, p_93130_).m_85950_(f5, f6, f7, toAlpha).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBookmark(BookImage bookImage, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float zLevel, float rotate, int light, int overlay, PageOn pageOn, int color, boolean isItem, ItemDisplayContext transformType) {
        matrixStack.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(tileEntityIn, matrixStack, isItem, transformType);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.5f, 0.34375f, -7.5E-4f);
        matrixStack.m_85841_(0.5f * bookImage.scale, 0.5f * bookImage.scale, 0.5f * bookImage.scale);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStack.m_252880_((bookImage.x / 8.1f - 0.001875f) / bookImage.scale, (bookImage.y / 8.1f - 0.0033125f) / bookImage.scale, -zLevel / 1600.0f / bookImage.scale);
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("scale")) {
                float f = bookImageEffect.amount - 1.0f;
                float x = f / 2.0f + 1.0f + f / 2.0f * Mth.m_14031_((float)(Hexerei.getClientTicks() / bookImageEffect.speed));
                matrixStack.m_85841_(x, x, x);
            }
        });
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("tilt")) {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-bookImageEffect.amount * Mth.m_14031_((float)(Hexerei.getClientTicks() / bookImageEffect.speed))));
            }
        });
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(rotate));
        if (transformType != ItemDisplayContext.NONE) {
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(-35.0f));
        }
        RenderSystem.setShader(GameRenderer::m_172667_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation(bookImage.imageLoc)));
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        int u = (int)bookImage.u;
        int v = (int)bookImage.v;
        int imageWidth = (int)bookImage.imageWidth;
        int imageHeight = (int)bookImage.imageHeight;
        int width = (int)bookImage.width;
        int height = (int)bookImage.height;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        float a = 1.0f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (color != -1) {
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        if (transformType != ItemDisplayContext.NONE) {
            buffer.m_252986_(matrix, 0.0f, -0.006111111f * (float)height, -0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, -0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, -0.006111111f * (float)height, 0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, -0.006111111f * (float)height, 0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, -0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, -0.006111111f * (float)height, -0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        } else {
            buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(BookImage bookImage, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, boolean isItem) {
        this.drawImage(bookImage, tileEntityIn, matrixStack, bufferSource, zLevel, light, overlay, pageOn, -1, isItem, ItemDisplayContext.NONE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(BookImage bookImage, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color, boolean isItem, ItemDisplayContext transformType) {
        matrixStack.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(tileEntityIn, matrixStack, isItem, transformType);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.5f, 0.34375f, -7.5E-4f);
        matrixStack.m_85841_(0.5f * bookImage.scale, 0.5f * bookImage.scale, 0.5f * bookImage.scale);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStack.m_252880_((bookImage.x / 8.1f - 0.001875f) / bookImage.scale, (bookImage.y / 8.1f - 0.0033125f) / bookImage.scale, -(zLevel + bookImage.z) / 1600.0f);
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("scale")) {
                float f = bookImageEffect.amount - 1.0f;
                float x = f / 2.0f + 1.0f + f / 2.0f * Mth.m_14031_((float)(Hexerei.getClientTicks() / bookImageEffect.speed));
                matrixStack.m_85841_(x, x, x);
            }
        });
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("tilt")) {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-bookImageEffect.amount * Mth.m_14031_((float)(Hexerei.getClientTicks() / bookImageEffect.speed))));
            }
        });
        RenderSystem.setShader(GameRenderer::m_172667_);
        AtomicReference<String> loc = new AtomicReference<String>(bookImage.imageLoc);
        AtomicReference<BookImage> overlay_image = new AtomicReference<BookImage>(bookImage);
        AtomicReference<Boolean> overlay_draw = new AtomicReference<Boolean>(false);
        AtomicReference<Integer> u = new AtomicReference<Integer>((int)bookImage.u);
        AtomicReference<Integer> v = new AtomicReference<Integer>((int)bookImage.v);
        AtomicReference<Integer> imageWidth = new AtomicReference<Integer>((int)bookImage.imageWidth);
        AtomicReference<Integer> imageHeight = new AtomicReference<Integer>((int)bookImage.imageHeight);
        AtomicReference<Integer> width = new AtomicReference<Integer>((int)bookImage.width);
        AtomicReference<Integer> height = new AtomicReference<Integer>((int)bookImage.height);
        AtomicBoolean flag = new AtomicBoolean(false);
        bookImage.effects.forEach(bookImageEffect -> {
            Vec3 intersectionVec;
            AABB aabb;
            Vec3 vec;
            BlockPos blockPos;
            Vector3f vector3f_1;
            Vector3f vector3f;
            Vec3 planeNormalLeft;
            Vec3 planeNormalRight;
            double reach;
            LocalPlayer playerIn;
            if (bookImageEffect.type.equals("hover_change_texture")) {
                playerIn = (LocalPlayer)Hexerei.proxy.getPlayer();
                reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
                planeNormalRight = this.planeNormal(tileEntityIn, PageOn.RIGHT_PAGE);
                planeNormalLeft = this.planeNormal(tileEntityIn, PageOn.LEFT_PAGE);
                if (pageOn == PageOn.LEFT_PAGE) {
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(0.35f - bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                    intersectionVec = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag.set(true);
                        loc.set(bookImageEffect.hoverImage.imageLoc);
                    }
                } else if (pageOn == PageOn.RIGHT_PAGE) {
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f + -bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                    intersectionVec = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        flag.set(true);
                        loc.set(bookImageEffect.hoverImage.imageLoc);
                    }
                }
            }
            if (bookImageEffect.type.equals("hover_overlay")) {
                playerIn = (LocalPlayer)Hexerei.proxy.getPlayer();
                reach = playerIn.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
                planeNormalRight = this.planeNormal(tileEntityIn, PageOn.RIGHT_PAGE);
                planeNormalLeft = this.planeNormal(tileEntityIn, PageOn.LEFT_PAGE);
                if (pageOn == PageOn.LEFT_PAGE) {
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(0.35f - bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(10.0f + tileEntityIn.degreesOpenedRender / 1.12f));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                    intersectionVec = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalLeft, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        overlay_image.set(bookImageEffect.hoverImage);
                        overlay_draw.set(true);
                    }
                } else if (pageOn == PageOn.RIGHT_PAGE) {
                    vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                    vector3f_1 = new Vector3f(-0.05f + -bookImage.x * 0.06f, 0.5f - bookImage.y * 0.061f, -0.03f);
                    blockPos = tileEntityIn.m_58899_();
                    vector3f_1.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-(10.0f + tileEntityIn.degreesOpenedRender / 1.12f)));
                    vector3f_1.rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f - tileEntityIn.degreesOpenedRender / 2.0f));
                    vector3f.add((Vector3fc)vector3f_1);
                    vector3f.rotate((Quaternionfc)Axis.f_252436_.m_252977_(tileEntityIn.degreesSpunRender));
                    vec = new Vec3((double)(vector3f.x() + (float)blockPos.m_123341_() + 0.5f + (float)Math.sin(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)), (double)(vector3f.y() + (float)blockPos.m_123342_() + 1.125f), (double)(vector3f.z() + (float)blockPos.m_123343_() + 0.5f + (float)Math.cos(tileEntityIn.degreesSpunRender / 57.1f) / 32.0f * (tileEntityIn.degreesOpenedRender / 5.0f - 12.0f)));
                    aabb = new AABB(vec.m_82520_((double)(-bookImage.width / 850.0f * bookImage.scale), (double)(-bookImage.height / 850.0f * bookImage.scale), (double)(-bookImage.width / 850.0f * bookImage.scale)), vec.m_82520_((double)(bookImage.width / 850.0f * bookImage.scale), (double)(bookImage.height / 850.0f * bookImage.scale), (double)(bookImage.width / 850.0f * bookImage.scale)));
                    intersectionVec = PageDrawing.intersectPoint(bookImage.x, bookImage.y, playerIn.m_20154_(), playerIn.m_146892_(), planeNormalRight, tileEntityIn, pageOn);
                    if (aabb.m_82390_(intersectionVec) && intersectionVec.m_82546_(playerIn.m_146892_()).m_82553_() <= reach) {
                        overlay_image.set(bookImageEffect.hoverImage);
                        overlay_draw.set(true);
                    }
                }
            }
            if (flag.get()) {
                bookImageEffect.hoverImage.effects.forEach(bookHoverImageEffect -> {
                    if (bookHoverImageEffect.type.equals("scale")) {
                        float f = bookHoverImageEffect.amount - 1.0f;
                        float x = f / 2.0f + 1.0f + f / 2.0f * Mth.m_14031_((float)(Hexerei.getClientTicks() / bookHoverImageEffect.speed));
                        matrixStack.m_85841_(x, x, x);
                    }
                });
                bookImageEffect.hoverImage.effects.forEach(bookHoverImageEffect -> {
                    if (bookHoverImageEffect.type.equals("tilt")) {
                        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-bookHoverImageEffect.amount * Mth.m_14031_((float)(Hexerei.getClientTicks() / bookHoverImageEffect.speed))));
                    }
                });
            }
        });
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation(loc.get())));
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        float u1 = ((float)u.get().intValue() + 0.0f) / (float)imageWidth.get().intValue();
        float u2 = ((float)u.get().intValue() + (float)width.get().intValue()) / (float)imageWidth.get().intValue();
        float v1 = ((float)v.get().intValue() + 0.0f) / (float)imageHeight.get().intValue();
        float v2 = ((float)v.get().intValue() + (float)height.get().intValue()) / (float)imageHeight.get().intValue();
        float a = 1.0f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (color != -1) {
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height.get().intValue(), -0.0030555555f * (float)width.get().intValue()).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height.get().intValue(), -0.0030555555f * (float)width.get().intValue()).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height.get().intValue(), 0.0030555555f * (float)width.get().intValue()).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height.get().intValue(), 0.0030555555f * (float)width.get().intValue()).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        if (overlay_draw.get().booleanValue()) {
            BookImage ov_img = overlay_image.get();
            VertexConsumer buffer2 = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation(ov_img.imageLoc)));
            float overlay_u1 = (ov_img.u + 0.0f) / ov_img.imageWidth;
            float overlay_u2 = (ov_img.u + ov_img.width) / ov_img.imageWidth;
            float overlay_v1 = (ov_img.v + 0.0f) / ov_img.imageHeight;
            float overlay_v2 = (ov_img.v + ov_img.height) / ov_img.imageHeight;
            float overlay_a = 1.0f;
            float overlay_r = 1.0f;
            float overlay_g = 1.0f;
            float overlay_b = 1.0f;
            if (color != -1) {
                overlay_r = (float)(color >> 16 & 0xFF) / 255.0f;
                overlay_g = (float)(color >> 8 & 0xFF) / 255.0f;
                overlay_b = (float)(color & 0xFF) / 255.0f;
            }
            matrixStack.m_85836_();
            buffer2.m_252986_(matrix, ov_img.z / 2000.0f, -0.0030555555f * ov_img.height, -0.0030555555f * ov_img.width).m_85950_(overlay_r, overlay_g, overlay_b, overlay_a).m_7421_(overlay_u1, overlay_v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer2.m_252986_(matrix, ov_img.z / 2000.0f, 0.0030555555f * ov_img.height, -0.0030555555f * ov_img.width).m_85950_(overlay_r, overlay_g, overlay_b, overlay_a).m_7421_(overlay_u1, overlay_v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer2.m_252986_(matrix, ov_img.z / 2000.0f, 0.0030555555f * ov_img.height, 0.0030555555f * ov_img.width).m_85950_(overlay_r, overlay_g, overlay_b, overlay_a).m_7421_(overlay_u2, overlay_v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer2.m_252986_(matrix, ov_img.z / 2000.0f, -0.0030555555f * ov_img.height, 0.0030555555f * ov_img.width).m_85950_(overlay_r, overlay_g, overlay_b, overlay_a).m_7421_(overlay_u2, overlay_v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTitle(BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int overlay, PageOn pageOn, boolean isItem) {
        matrixStack.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.5f, 0.34375f, -7.5E-4f);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrixStack.m_252880_(-0.001875f, -0.0033125f, 0.0f);
        matrixStack.m_252880_(0.296875f, 0.0f, 0.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        RenderSystem.setShader(GameRenderer::m_172667_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("hexerei:textures/book/title.png")));
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        boolean u = false;
        boolean v = false;
        int imageWidth = 128;
        int imageHeight = 128;
        int width = 100;
        int height = 26;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawCharacter(char character, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float mouseX, float mouseY, int xIn, int yIn, float zLevel, int light, int overlay, PageOn pageOn, boolean isItem) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(ClientProxy.TEXT.get(Character.valueOf(character)));
        matrixStack.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.521875f, 0.34375f, -0.004375f);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252880_(this.lineHeight + (float)yIn * 0.05f, -this.lineWidth - ClientProxy.TEXT_WIDTH.get(Character.valueOf(character)).floatValue() / 2.0f - (float)xIn * 0.042f, 0.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        RenderSystem.setShader(GameRenderer::m_172667_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        buffer.m_252986_(matrix, -0.032f, -0.032f, 0.0f).m_85950_(0.12f, 0.12f, 0.12f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.032f, -0.032f, 0.0f).m_85950_(0.12f, 0.12f, 0.12f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.032f, 0.032f, 0.0f).m_85950_(0.12f, 0.12f, 0.12f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, -0.032f, 0.032f, 0.0f).m_85950_(0.12f, 0.12f, 0.12f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        matrixStack.m_85849_();
    }

    public void resetLines() {
        this.lineWidth = 0.0f;
        this.lineHeight = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BookParagraphElements resetLinesNewBox(BookParagraph bookParagraph, int boxOn) {
        this.lineWidth = 0.0f;
        this.lineHeight = 0.0f;
        if (boxOn + 1 < bookParagraph.paragraphElements.toArray().length) {
            return (BookParagraphElements)bookParagraph.paragraphElements.toArray()[boxOn + 1];
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(BookParagraph bookParagraph, BookOfShadowsAltarTile tileEntityIn, PoseStack matrixStack, MultiBufferSource bufferSource, float mouseX, float mouseY, float zLevel, int light, int overlay, PageOn pageOn, boolean isItem) {
        MutableComponent pageText = bookParagraph.translatablePassage;
        int wordNumber = -1;
        int boxOn = 0;
        BookParagraphElements activeElement = bookParagraph.paragraphElements.get(0);
        boolean drawSpecialFont = false;
        Font font = Hexerei.font();
        boolean findNewWord = true;
        String[] words = pageText.getString().trim().split("\\s+");
        String pageTextString = pageText.getString();
        int itor = -1;
        for (String word : words) {
            ++itor;
            if (word.length() <= 2) continue;
            StringBuilder stringBuilder = new StringBuilder();
            if (word.charAt(0) != '%' || word.charAt(1) != 'k') continue;
            for (int i = 2; i < word.length(); ++i) {
                stringBuilder.append(word.charAt(i));
            }
            String temp = stringBuilder.toString();
            String alt = "key." + temp;
            for (KeyMapping k : ClientProxy.keys) {
                String name = k.m_90860_();
                if (!name.equals(temp) && !name.equals(alt)) continue;
                String keyName = k.m_90863_().getString();
                if (keyName.length() <= 1) {
                    keyName = keyName.toUpperCase(Locale.ROOT);
                }
                words[itor] = keyName;
                pageTextString = pageTextString.replaceAll(word, words[itor]);
            }
        }
        char[] text = pageTextString.toCharArray();
        int[] wordLength = new int[words.length];
        float[] wordWidths = new float[words.length];
        for (int k = 0; k < words.length; ++k) {
            wordLength[k] = words[k].length();
            wordWidths[k] = font.m_92895_(words[k]);
        }
        boolean breakBool = false;
        ArrayList<String> strings = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < text.length && !breakBool) {
            if (text[i] == '\n') {
                this.lineWidth = 0.0f;
                this.lineHeight += 1.0f;
                strings.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (this.lineHeight >= activeElement.height && (activeElement = this.resetLinesNewBox(bookParagraph, boxOn++)) == null) {
                    breakBool = true;
                    break;
                }
                ++i;
                continue;
            }
            if (text[i] == ' ') {
                findNewWord = true;
                stringBuilder.append(' ');
                this.lineWidth += (float)font.m_92895_(" ");
                if (this.lineWidth > activeElement.width * 3.75f) {
                    this.lineWidth = 0.0f;
                    this.lineHeight += 1.0f;
                    strings.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    if (this.lineHeight >= activeElement.height && (activeElement = this.resetLinesNewBox(bookParagraph, boxOn++)) == null) {
                        breakBool = true;
                        break;
                    }
                }
                ++i;
                continue;
            }
            if (!findNewWord) continue;
            char[] wordText = words[++wordNumber].toCharArray();
            if (this.lineWidth > 0.0f && this.lineWidth + wordWidths[wordNumber] > activeElement.width * 3.75f) {
                this.lineWidth = 0.0f;
                this.lineHeight += 1.0f;
                strings.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (this.lineHeight >= activeElement.height && (activeElement = this.resetLinesNewBox(bookParagraph, boxOn++)) == null) {
                    breakBool = true;
                    break;
                }
            }
            for (char character : wordText) {
                stringBuilder.append(character);
                this.lineWidth += (float)font.m_92895_(String.valueOf(character));
                if (!(this.lineWidth > activeElement.width * 3.75f)) continue;
                this.lineWidth = 0.0f;
                this.lineHeight += 1.0f;
                strings.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (!(this.lineHeight >= activeElement.height) || (activeElement = this.resetLinesNewBox(bookParagraph, boxOn++)) != null) continue;
                breakBool = true;
                break;
            }
            i += wordLength[wordNumber];
        }
        if (!stringBuilder.toString().isEmpty()) {
            strings.add(stringBuilder.toString());
        }
        matrixStack.m_85836_();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(tileEntityIn, matrixStack, isItem, ItemDisplayContext.NONE);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-0.521875f, 0.28125f, -6.25E-4f);
        matrixStack.m_85841_(0.00272f, 0.00272f, 0.00272f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int boxId = 0;
        int linenumber = 0;
        boolean flag = true;
        while (flag) {
            ArrayList<String> remainder = new ArrayList<String>();
            if (bookParagraph.paragraphElements.size() > boxId && bookParagraph.paragraphElements.get(boxId) != null) {
                BookParagraphElements box = bookParagraph.paragraphElements.get(boxId);
                boolean alignVerticalMiddle = box.verticalAlign.equals("middle");
                float offsetY = 0.0f;
                if (alignVerticalMiddle) {
                    float f = box.height;
                    Objects.requireNonNull(font);
                    if (Math.round(f * 9.0f) + 1 > strings.size()) {
                        float f2 = box.height;
                        Objects.requireNonNull(font);
                        float f3 = f2 * 9.0f / 2.0f;
                        float f4 = (float)strings.size() / 2.0f;
                        Objects.requireNonNull(font);
                        offsetY = f3 - f4 * 9.0f;
                    }
                }
                for (String s1 : strings) {
                    Objects.requireNonNull(font);
                    float f = box.height;
                    Objects.requireNonNull(font);
                    if ((linenumber + 1) * 9 <= Math.round(f * 9.0f) + 1) {
                        float offsetX = 0.0f;
                        if (bookParagraph.align.equals("middle")) {
                            offsetX = font.m_92895_(s1) / 2;
                        }
                        float f5 = box.x * 8.0f - 24.0f - offsetX;
                        float f6 = box.y;
                        Objects.requireNonNull(font);
                        float f7 = f6 * 9.0f;
                        Objects.requireNonNull(font);
                        font.m_271703_(s1, f5, f7 + (float)Math.round(linenumber * 9) - 4.0f + offsetY, HexereiUtil.getColorValue(0.12f, 0.12f, 0.12f), false, matrixStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
                        matrixStack.m_85836_();
                        matrixStack.m_252880_(0.25f, 0.25f, 0.0625f);
                        float f8 = box.x * 8.0f - 24.0f - offsetX;
                        float f9 = box.y;
                        Objects.requireNonNull(font);
                        float f10 = f9 * 9.0f;
                        Objects.requireNonNull(font);
                        font.m_271703_(s1, f8, f10 + (float)Math.round(linenumber * 9) - 4.0f + offsetY, 0x1000000, false, matrixStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
                        matrixStack.m_85849_();
                    } else {
                        remainder.add(s1);
                    }
                    ++linenumber;
                }
            } else {
                flag = false;
            }
            if (remainder.isEmpty()) {
                flag = false;
                continue;
            }
            ++boxId;
            linenumber = 0;
            strings = remainder;
        }
        multibuffersource$buffersource.m_109911_();
        matrixStack.m_85849_();
        this.resetLines();
    }

    static {
        nf = NumberFormat.getIntegerInstance();
        SLOT_ATLAS = new ResourceLocation("hexerei", "book/slot");
        SLOT = new ResourceLocation("hexerei", "textures/book/slot.png");
        TITLE = new ResourceLocation("hexerei", "book/title");
        CORNERS = (float)MixingCauldron.SHAPE.m_83288_(Direction.Axis.X) + 0.1875f;
        ITEM_LIGHT_ROTATION_3D = (Quaternionf)Util.m_137537_(() -> {
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis(1.1344640137963142, 1.0, 0.0, 0.0);
            quaternion.rotateAxis(0.87266463f, 0.0f, 1.0f, 0.0f);
            return quaternion;
        });
        BLOCK_LIGHT_ROTATION_3D = (Quaternionf)Util.m_137537_(() -> {
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis(0.6108652381980153, 1.0, 0.0, 0.0);
            quaternion.rotateAxis(0.61086524f, 0.0f, 1.0f, 0.0f);
            return quaternion;
        });
        ITEM_LIGHT_ROTATION_FLAT = (Quaternionf)Util.m_137537_(() -> {
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis(-0.7853981633974483, 1.0, 0.0, 0.0);
            return quaternion;
        });
    }

    public static enum PageOn {
        LEFT_PAGE,
        LEFT_PAGE_UNDER,
        LEFT_PAGE_PREV,
        RIGHT_PAGE,
        RIGHT_PAGE_UNDER,
        RIGHT_PAGE_PREV,
        MIDDLE_BUTTON;

    }
}

