/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.CourierLetter;
import net.joefoxe.hexerei.block.custom.CourierPackage;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.OwlModel;
import net.joefoxe.hexerei.client.renderer.entity.render.OwlVariant;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;

public class OwlRenderer
extends MobRenderer<OwlEntity, OwlModel<OwlEntity>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/entity/owl.png");
    private static final Map<OwlVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(OwlVariant.class), p_114874_ -> {
        p_114874_.put(OwlVariant.GREAT_HORNED, new ResourceLocation("hexerei", "textures/entity/owl.png"));
        p_114874_.put(OwlVariant.BARN, new ResourceLocation("hexerei", "textures/entity/owl_barn.png"));
        p_114874_.put(OwlVariant.BARRED, new ResourceLocation("hexerei", "textures/entity/owl_barred.png"));
        p_114874_.put(OwlVariant.SNOWY, new ResourceLocation("hexerei", "textures/entity/owl_snowy.png"));
    });

    public OwlRenderer(EntityRendererProvider.Context erm) {
        super(erm, new OwlModel(erm.m_174023_(OwlModel.LAYER_LOCATION)), 0.25f);
        this.m_115326_(new LayerOwlItem(this));
        this.m_115326_(new LayerOwlCollar((RenderLayerParent<OwlEntity, OwlModel<OwlEntity>>)this));
        this.m_115326_(new LayerOwlHelmet(this, erm));
    }

    public ResourceLocation getTextureLocation(OwlEntity pEntity) {
        return LOCATION_BY_VARIANT.get((Object)pEntity.getVariant());
    }

    public void render(OwlEntity crowEntity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)crowEntity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void scale(OwlEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float f = 1.0f;
        if (entitylivingbaseIn.m_6162_()) {
            f *= 0.5f;
            this.f_114477_ = 0.125f;
        } else {
            this.f_114477_ = 0.25f;
        }
        matrixStackIn.m_85841_(f, f, f);
    }

    public static class LayerOwlItem
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        public LayerOwlItem(OwlRenderer render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity owl, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = owl.m_8020_(1);
            matrixStackIn.m_85836_();
            this.translateToHand(matrixStackIn);
            matrixStackIn.m_85837_(0.0, (double)0.075f, 0.05);
            if (itemstack.m_41720_() instanceof BroomItem) {
                matrixStackIn.m_252880_(0.1f, 0.12f, 0.06f);
            }
            if (owl.m_6162_()) {
                matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
            }
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-2.5f));
            if (itemstack.m_41720_() instanceof BroomItem) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-35.0f));
            matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
            ItemStack stack = itemstack.m_41777_();
            Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)owl, stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
            if (owl.messagingController.hasDelivery() && !owl.messagingController.getMessageStack().m_41619_()) {
                if (owl.messagingController.getMessageStack().m_41720_() == ModItems.COURIER_LETTER.get()) {
                    matrixStackIn.m_85836_();
                    this.translateToFeet(matrixStackIn);
                    matrixStackIn.m_252880_(0.0f, 0.1f, 0.0f);
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)owl.itemHeldSwingLast, (float)owl.itemHeldSwing) * 1.5f));
                    matrixStackIn.m_252880_(-0.42f, 0.0f, -0.7f);
                    matrixStackIn.m_85841_(1.0f, 1.0f, 1.0f);
                    this.renderBlock(matrixStackIn, bufferIn, packedLightIn, ((CourierLetter)ModBlocks.COURIER_LETTER.get()).m_49966_());
                    matrixStackIn.m_85849_();
                }
                if (owl.messagingController.getMessageStack().m_41720_() == ModItems.COURIER_PACKAGE.get()) {
                    matrixStackIn.m_85836_();
                    this.translateToFeet(matrixStackIn);
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)owl.itemHeldSwingLast, (float)owl.itemHeldSwing)));
                    matrixStackIn.m_252880_(0.57f, 0.35f, -0.175f);
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrixStackIn.m_85841_(1.0f, 1.0f, 1.0f);
                    this.renderBlock(matrixStackIn, bufferIn, packedLightIn, ((CourierPackage)ModBlocks.COURIER_PACKAGE.get()).m_49966_());
                    matrixStackIn.m_85849_();
                }
            }
        }

        private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((OwlModel)this.m_117386_()).owl.m_104299_(matrixStack);
            ((OwlModel)this.m_117386_()).owl.m_171324_("head").m_104299_(matrixStack);
            ((OwlModel)this.m_117386_()).owl.m_171324_("head").m_171324_("beak").m_104299_(matrixStack);
        }

        protected void translateToFeet(PoseStack matrixStack) {
            ((OwlModel)this.m_117386_()).owl.m_104299_(matrixStack);
            ((OwlModel)this.m_117386_()).owl.m_171324_("rightLeg").m_104299_(matrixStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayerOwlCollar
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private static final ResourceLocation OWL_DYE_LOCATION = new ResourceLocation("hexerei", "textures/entity/owl_dye.png");

        public LayerOwlCollar(RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> p_117707_) {
            super(p_117707_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity entity, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
            if (entity.m_21824_() && !entity.m_20145_() && (entity.getDyeColorId() != -1 || entity.m_7755_().getString().equals("jeb_") || entity.m_7755_().getString().equals("joe_"))) {
                float[] afloat = entity.getDyeColor().m_41068_();
                VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)OWL_DYE_LOCATION), (boolean)false, (boolean)false);
                ((OwlModel)this.m_117386_()).m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, afloat[0], afloat[1], afloat[2], 1.0f);
            }
        }
    }

    public static class LayerOwlHelmet
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private final RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> renderer;
        private final HumanoidModel<?> defaultBipedModel;
        private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

        public LayerOwlHelmet(OwlRenderer renderer, EntityRendererProvider.Context renderManagerIn) {
            super((RenderLayerParent)renderer);
            this.renderer = renderer;
            this.defaultBipedModel = new HumanoidModel(renderManagerIn.m_174023_(ModelLayers.f_171261_));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity crow, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
            matrixStackIn.m_85836_();
            ItemStack itemstack = crow.itemHandler.getStackInSlot(0);
            Item item = itemstack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armoritem = (ArmorItem)item;
                HumanoidModel<?> a = this.defaultBipedModel;
                boolean notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)crow, itemstack, EquipmentSlot.HEAD, a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                this.translateToHead(matrixStackIn);
                matrixStackIn.m_85841_(0.65f, 0.65f, 0.65f);
                matrixStackIn.m_252880_(0.0f, 0.2f, -0.05f);
                boolean flag1 = itemstack.m_41790_();
                if (armoritem instanceof DyeableLeatherItem) {
                    int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderHelmet(crow, matrixStackIn, bufferIn, packedLightIn, flag1, a, f, f1, f2, LayerOwlHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                    this.renderHelmet(crow, matrixStackIn, bufferIn, packedLightIn, flag1, a, 1.0f, 1.0f, 1.0f, LayerOwlHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, "overlay"), notAVanillaModel);
                } else {
                    this.renderHelmet(crow, matrixStackIn, bufferIn, packedLightIn, flag1, a, 1.0f, 1.0f, 1.0f, LayerOwlHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                }
            } else if (Block.m_49814_((Item)itemstack.m_41720_()) instanceof AbstractSkullBlock) {
                this.translateToHand(matrixStackIn);
                matrixStackIn.m_85841_(0.45f, 0.45f, 0.45f);
                matrixStackIn.m_252880_(0.0f, -0.25f, -0.2f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                this.renderItem(itemstack, crow.m_9236_(), matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.m_85849_();
        }

        private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
        }

        private void translateToHead(PoseStack matrixStackIn) {
            this.translateToChest(matrixStackIn);
            ((OwlModel)this.renderer.m_7200_()).head.m_104299_(matrixStackIn);
        }

        private void translateToChest(PoseStack matrixStackIn) {
            ((OwlModel)this.renderer.m_7200_()).owl.m_104299_(matrixStackIn);
        }

        private void renderHelmet(OwlEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
            VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
            ((OwlModel)this.renderer.m_7200_()).m_102624_((EntityModel)modelIn);
            modelIn.f_102808_.f_104203_ = 0.0f;
            modelIn.f_102808_.f_104204_ = 0.0f;
            modelIn.f_102808_.f_104205_ = 0.0f;
            modelIn.f_102809_.f_104203_ = 0.0f;
            modelIn.f_102809_.f_104204_ = 0.0f;
            modelIn.f_102809_.f_104205_ = 0.0f;
            modelIn.f_102808_.f_104200_ = 0.0f;
            modelIn.f_102808_.f_104201_ = 0.0f;
            modelIn.f_102808_.f_104202_ = 0.0f;
            modelIn.f_102809_.f_104200_ = 0.0f;
            modelIn.f_102809_.f_104201_ = 0.0f;
            modelIn.f_102809_.f_104202_ = 0.0f;
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
        }

        public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
            ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s1);
                ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
            }
            return resourcelocation;
        }

        protected void setModelSlotVisible(HumanoidModel humanoidModel, EquipmentSlot slotIn) {
            this.setModelVisible(humanoidModel);
            switch (slotIn) {
                case HEAD: {
                    humanoidModel.f_102808_.f_104207_ = true;
                    break;
                }
                case CHEST: {
                    humanoidModel.f_102810_.f_104207_ = true;
                    humanoidModel.f_102811_.f_104207_ = true;
                    humanoidModel.f_102812_.f_104207_ = true;
                    break;
                }
                case LEGS: {
                    humanoidModel.f_102810_.f_104207_ = true;
                    humanoidModel.f_102813_.f_104207_ = true;
                    humanoidModel.f_102814_.f_104207_ = true;
                    break;
                }
                case FEET: {
                    humanoidModel.f_102813_.f_104207_ = true;
                    humanoidModel.f_102814_.f_104207_ = true;
                }
            }
        }

        protected void setModelVisible(HumanoidModel model) {
            model.m_8009_(false);
        }

        protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
            Model basicModel = ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
            return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((OwlModel)this.m_117386_()).owl.m_104299_(matrixStack);
            ((OwlModel)this.m_117386_()).owl.m_171324_("head").m_104299_(matrixStack);
        }
    }
}

