/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.CrowModel;
import net.joefoxe.hexerei.client.renderer.entity.render.CrowVariant;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.AskForMapDataPacket;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EnergySwirlLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CrowRenderer
extends MobRenderer<CrowEntity, CrowModel<CrowEntity>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/entity/crow.png");
    private static final ResourceLocation CROW_COLLAR_LOCATION = new ResourceLocation("hexerei", "textures/entity/crow_collar.png");
    private static final ResourceLocation POWER_LOCATION = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private final HumanoidModel defaultBipedModel;
    public static Map<Item, ResourceLocation> TRINKET_LOCATION = (Map)Util.m_137537_(() -> {
        HashMap<Item, ResourceLocation> map = new HashMap<Item, ResourceLocation>();
        map.put((Item)ModItems.CROW_ANKH_AMULET.get(), new ResourceLocation("hexerei:textures/item/crow_ankh_amulet_trinket.png"));
        return map;
    });
    private static final Map<CrowVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(CrowVariant.class), p_114874_ -> {
        p_114874_.put(CrowVariant.BLACK, new ResourceLocation("hexerei", "textures/entity/crow.png"));
        p_114874_.put(CrowVariant.HOODED, new ResourceLocation("hexerei", "textures/entity/crow_hooded.png"));
        p_114874_.put(CrowVariant.NORTHWESTERN, new ResourceLocation("hexerei", "textures/entity/crow_northwestern.png"));
        p_114874_.put(CrowVariant.PIED, new ResourceLocation("hexerei", "textures/entity/crow_pied.png"));
        p_114874_.put(CrowVariant.ALBINO, new ResourceLocation("hexerei", "textures/entity/crow_albino.png"));
        p_114874_.put(CrowVariant.GRAY, new ResourceLocation("hexerei", "textures/entity/crow_gray.png"));
        p_114874_.put(CrowVariant.DARKBROWN, new ResourceLocation("hexerei", "textures/entity/crow.png"));
    });
    private final Pair<ResourceLocation, CrowModel<CrowEntity>> crowResources;

    public CrowRenderer(EntityRendererProvider.Context erm) {
        super(erm, new CrowModel(erm.m_174023_(CrowModel.LAYER_LOCATION)), 0.25f);
        this.crowResources = Pair.of((Object)TEXTURE, new CrowModel(erm.m_174023_(CrowModel.LAYER_LOCATION)));
        this.defaultBipedModel = new HumanoidModel(erm.m_174023_(ModelLayers.f_171261_));
        this.m_115326_(new LayerCrowItem(this));
        this.m_115326_(new LayerCrowCollar((RenderLayerParent<CrowEntity, CrowModel<CrowEntity>>)this));
        this.m_115326_(new LayerCrowMisc((RenderLayerParent<CrowEntity, CrowModel<CrowEntity>>)this));
        this.m_115326_(new LayerCrowHelmet(this, erm));
        this.m_115326_((RenderLayer)new CrowPowerLayer((RenderLayerParent<CrowEntity, CrowModel<CrowEntity>>)this, erm.m_174027_()));
    }

    public ResourceLocation getTextureLocation(CrowEntity pEntity) {
        return LOCATION_BY_VARIANT.get((Object)pEntity.getVariant());
    }

    public void render(CrowEntity crowEntity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        super.m_7392_((Mob)crowEntity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
    }

    protected void scale(CrowEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float f = 1.0f;
        if (entitylivingbaseIn.m_6162_()) {
            f *= 0.5f;
            this.f_114477_ = 0.125f;
        } else {
            this.f_114477_ = 0.25f;
        }
        matrixStackIn.m_85841_(f, f, f);
    }

    public class LayerCrowItem
    extends RenderLayer<CrowEntity, CrowModel<CrowEntity>> {
        public LayerCrowItem(CrowRenderer render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, CrowEntity crow, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = crow.m_8020_(1);
            matrixStackIn.m_85836_();
            this.translateToHand(matrixStackIn);
            matrixStackIn.m_252880_(0.0f, -0.065f, -0.265f);
            if (itemstack.m_41720_() instanceof BroomItem) {
                matrixStackIn.m_252880_(0.1f, 0.16f, 0.01f);
            }
            if (crow.m_6162_()) {
                matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
            }
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-2.5f));
            if (itemstack.m_41720_() instanceof BroomItem) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
            ItemStack stack = itemstack.m_41777_();
            if (itemstack.m_41720_() == ModItems.WARHAMMER.get() && crow.m_5446_().getString().equals("Thor") && !itemstack.m_41793_()) {
                stack = EnchantmentHelper.m_220292_((RandomSource)RandomSource.m_216327_(), (ItemStack)itemstack.m_41777_(), (int)1, (boolean)false);
            }
            Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)crow, stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((CrowModel)this.m_117386_()).body.m_104299_(matrixStack);
            ((CrowModel)this.m_117386_()).body.m_171324_("head").m_104299_(matrixStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LayerCrowCollar
    extends RenderLayer<CrowEntity, CrowModel<CrowEntity>> {
        private static final ResourceLocation CROW_COLLAR_LOCATION = new ResourceLocation("hexerei", "textures/entity/crow_collar.png");

        public LayerCrowCollar(RenderLayerParent<CrowEntity, CrowModel<CrowEntity>> p_117707_) {
            super(p_117707_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, CrowEntity entity, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
            if (entity.m_21824_() && !entity.m_20145_() && (entity.getDyeColorId() != -1 || entity.m_7755_().getString().equals("jeb_") || entity.m_7755_().getString().equals("joe_"))) {
                float[] afloat = entity.getDyeColor().m_41068_();
                VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)CROW_COLLAR_LOCATION), (boolean)false, (boolean)false);
                ((CrowModel)this.m_117386_()).m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, afloat[0], afloat[1], afloat[2], 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LayerCrowMisc
    extends RenderLayer<CrowEntity, CrowModel<CrowEntity>> {
        private static final ResourceLocation CROW_AMULET_LOCATION = new ResourceLocation("hexerei", "textures/entity/crow_amulet.png");

        public LayerCrowMisc(RenderLayerParent<CrowEntity, CrowModel<CrowEntity>> p_117707_) {
            super(p_117707_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, CrowEntity crow, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
            ItemStack itemstack = crow.m_8020_(2);
            if (!crow.m_20145_() && !itemstack.m_41619_()) {
                boolean renderNecklace = false;
                matrixStackIn.m_85836_();
                this.translateToBody(matrixStackIn);
                matrixStackIn.m_252880_(0.0f, -0.15f, -0.165f);
                if (itemstack.m_41720_() instanceof BroomItem) {
                    matrixStackIn.m_252880_(0.1f, 0.16f, 0.01f);
                }
                if (crow.m_6162_()) {
                    matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
                }
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                if (itemstack.m_41720_() instanceof BroomItem) {
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                }
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                matrixStackIn.m_85841_(0.1f, 0.1f, 0.1f);
                ItemStack stack = itemstack.m_41777_();
                BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0);
                ResourceLocation loc = TRINKET_LOCATION.getOrDefault(stack.m_41720_(), null);
                if (loc != null) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_252880_(0.0f, 0.0f, -0.02f);
                    matrixStackIn.m_85841_(10.0f, 10.0f, 10.0f);
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    Matrix4f matrix = matrixStackIn.m_85850_().m_252922_();
                    MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                    VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
                    matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f));
                    Matrix3f normal = matrixStackIn.m_85850_().m_252943_();
                    boolean u = false;
                    boolean v = false;
                    int imageWidth = 16;
                    int imageHeight = 16;
                    int width = 16;
                    int height = 16;
                    float u1 = ((float)u + 0.0f) / (float)imageWidth;
                    float u2 = ((float)u + (float)width) / (float)imageWidth;
                    float v1 = ((float)v + 0.0f) / (float)imageHeight;
                    float v2 = ((float)v + (float)height) / (float)imageHeight;
                    int temp = packedLightIn;
                    if (stack.m_41782_() && stack.m_41784_().m_128441_("Active") && stack.m_41784_().m_128471_("Active")) {
                        packedLightIn = 0xF000F0;
                    }
                    buffer.m_252986_(matrix, 0.0034375f * (float)width, -0.0034375f * (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix, 0.0034375f * (float)width, 0.0034375f * (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix, -0.0034375f * (float)width, 0.0034375f * (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix, -0.0034375f * (float)width, -0.0034375f * (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                    if (stack.m_41782_() && stack.m_41784_().m_128441_("Active") && stack.m_41784_().m_128471_("Active")) {
                        buffer = bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)new ResourceLocation("hexerei:textures/item/crow_active_amulet_trinket.png")));
                        matrixStackIn.m_252880_(0.0f, 0.0f, 0.002f);
                        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-Hexerei.getClientTicks() % 360.0f));
                        matrixStackIn.m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252529_.m_252977_(45.0f));
                        normal = matrixStackIn.m_85850_().m_252943_();
                        imageWidth = 32;
                        imageHeight = 32;
                        width = 32;
                        height = 32;
                        u1 = ((float)u + 0.0f) / (float)imageWidth;
                        u2 = ((float)u + (float)width) / (float)imageWidth;
                        v1 = ((float)v + 0.0f) / (float)imageHeight;
                        v2 = ((float)v + (float)height) / (float)imageHeight;
                        buffer.m_252986_(matrix, 0.0034375f * (float)width, -0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 100.0f)))).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(matrix, 0.0034375f * (float)width, 0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 100.0f)))).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(matrix, -0.0034375f * (float)width, 0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 100.0f)))).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(matrix, -0.0034375f * (float)width, -0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 100.0f)))).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        matrixStackIn.m_85841_(1.15f, 1.15f, 1.15f);
                        matrixStackIn.m_252880_(0.0f, 0.0f, -0.004f);
                        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(1.5f * Hexerei.getClientTicks() % 360.0f));
                        buffer.m_252986_(matrix, 0.0034375f * (float)width, -0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 75.0f)))).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(matrix, 0.0034375f * (float)width, 0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 75.0f)))).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(matrix, -0.0034375f * (float)width, 0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 75.0f)))).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                        buffer.m_252986_(matrix, -0.0034375f * (float)width, -0.0034375f * (float)height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, Math.abs(Mth.m_14089_((float)(Hexerei.getClientTicks() / 75.0f)))).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                    }
                    packedLightIn = temp;
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_252880_(0.0f, 0.0f, 0.03f);
                    matrixStackIn.m_85841_(1.15f, 1.15f, 1.15f);
                    Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)crow, new ItemStack((ItemLike)ModItems.CROW_BLANK_AMULET_TRINKET.get()), ItemDisplayContext.FIXED, false, matrixStackIn, bufferIn, packedLightIn);
                    renderNecklace = true;
                } else if (stack.m_150930_(Items.f_42573_)) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_252880_(-0.5f, -0.5f, 0.0f);
                    matrixStackIn.m_85841_(0.0078125f, 0.0078125f, 1.0f);
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrixStackIn.m_252880_(-128.0f, -128.0f, 0.0f);
                    MapItemSavedData mapitemsaveddata = MapItem.m_42853_((ItemStack)itemstack, (Level)crow.m_9236_());
                    if (mapitemsaveddata == null) {
                        HexereiPacketHandler.sendToServer(new AskForMapDataPacket(itemstack));
                    }
                    if (mapitemsaveddata != null && crow.getFramedMapId().isPresent()) {
                        Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(matrixStackIn, bufferIn, crow.getFramedMapId().getAsInt(), mapitemsaveddata, true, packedLightIn);
                    }
                    matrixStackIn.m_85849_();
                    matrixStackIn.m_252880_(0.0f, 0.0f, 0.03f);
                    matrixStackIn.m_85841_(1.15f, 1.15f, 1.15f);
                    Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)crow, new ItemStack((ItemLike)ModItems.CROW_BLANK_AMULET_TRINKET_FRAME.get()), ItemDisplayContext.FIXED, false, matrixStackIn, bufferIn, packedLightIn);
                    renderNecklace = true;
                } else if (stack.m_150930_((Item)ModItems.CROW_BLANK_AMULET.get())) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_252880_(0.0f, 0.0f, 0.03f);
                    matrixStackIn.m_85841_(1.15f, 1.15f, 1.15f);
                    Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)crow, stack, ItemDisplayContext.FIXED, false, matrixStackIn, bufferIn, packedLightIn);
                    matrixStackIn.m_85849_();
                    renderNecklace = true;
                }
                matrixStackIn.m_85849_();
                if (renderNecklace) {
                    VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)CROW_AMULET_LOCATION), (boolean)false, (boolean)false);
                    ((CrowModel)this.m_117386_()).m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }

        protected void translateToBody(PoseStack matrixStack) {
            ((CrowModel)this.m_117386_()).body.m_104299_(matrixStack);
        }
    }

    public class LayerCrowHelmet
    extends RenderLayer<CrowEntity, CrowModel<CrowEntity>> {
        private final RenderLayerParent<CrowEntity, CrowModel<CrowEntity>> renderer;
        private final HumanoidModel<?> defaultBipedModel;
        private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

        public LayerCrowHelmet(CrowRenderer renderer, EntityRendererProvider.Context renderManagerIn) {
            super((RenderLayerParent)renderer);
            this.renderer = renderer;
            this.defaultBipedModel = new HumanoidModel(renderManagerIn.m_174023_(ModelLayers.f_171261_));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, CrowEntity crow, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
            matrixStackIn.m_85836_();
            ItemStack itemstack = crow.itemHandler.getStackInSlot(0);
            Item item = itemstack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armoritem = (ArmorItem)item;
                HumanoidModel<?> a = this.defaultBipedModel;
                boolean notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)crow, itemstack, EquipmentSlot.HEAD, a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                this.translateToHead(matrixStackIn);
                matrixStackIn.m_85841_(0.35f, 0.35f, 0.35f);
                matrixStackIn.m_252880_(0.0f, -0.1f, -0.25f);
                boolean flag1 = itemstack.m_41790_();
                int clampedLight = packedLightIn;
                if (armoritem instanceof DyeableLeatherItem) {
                    int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderHelmet(crow, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerCrowHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                    this.renderHelmet(crow, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerCrowHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, "overlay"), notAVanillaModel);
                } else {
                    this.renderHelmet(crow, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerCrowHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                }
            } else if (Block.m_49814_((Item)itemstack.m_41720_()) instanceof AbstractSkullBlock) {
                this.translateToHand(matrixStackIn);
                matrixStackIn.m_85841_(0.45f, 0.45f, 0.45f);
                matrixStackIn.m_252880_(0.0f, -0.2f, -0.2f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                this.renderItem(itemstack, crow.m_9236_(), matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.m_85849_();
        }

        private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        }

        private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
        }

        private void renderArmor(CrowEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
            VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
            if (notAVanillaModel) {
                ((CrowModel)this.renderer.m_7200_()).m_102624_((EntityModel)modelIn);
                modelIn.f_102810_.f_104201_ = 0.0f;
                modelIn.f_102808_.m_104227_(0.0f, 1.0f, 0.0f);
                modelIn.f_102809_.f_104201_ = 0.0f;
                modelIn.f_102808_.f_104203_ = ((CrowModel)this.renderer.m_7200_()).body.f_104203_;
                modelIn.f_102808_.f_104204_ = ((CrowModel)this.renderer.m_7200_()).body.f_104204_;
                modelIn.f_102808_.f_104205_ = ((CrowModel)this.renderer.m_7200_()).body.f_104205_;
                modelIn.f_102808_.f_104200_ = ((CrowModel)this.renderer.m_7200_()).body.f_104200_;
                modelIn.f_102808_.f_104201_ = ((CrowModel)this.renderer.m_7200_()).body.f_104201_;
                modelIn.f_102808_.f_104202_ = ((CrowModel)this.renderer.m_7200_()).body.f_104202_;
                modelIn.f_102809_.m_104315_(modelIn.f_102808_);
                modelIn.f_102810_.m_104315_(modelIn.f_102808_);
            }
            modelIn.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
        }

        private void translateToHead(PoseStack matrixStackIn) {
            this.translateToChest(matrixStackIn);
            ((CrowModel)this.renderer.m_7200_()).head.m_104299_(matrixStackIn);
        }

        private void translateToChest(PoseStack matrixStackIn) {
            ((CrowModel)this.renderer.m_7200_()).body.m_104299_(matrixStackIn);
        }

        private void renderHelmet(CrowEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
            VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
            ((CrowModel)this.renderer.m_7200_()).m_102624_((EntityModel)modelIn);
            modelIn.f_102808_.f_104203_ = 0.0f;
            modelIn.f_102808_.f_104204_ = 0.0f;
            modelIn.f_102808_.f_104205_ = 0.0f;
            modelIn.f_102809_.f_104203_ = 0.0f;
            modelIn.f_102809_.f_104204_ = 0.0f;
            modelIn.f_102809_.f_104205_ = 0.0f;
            modelIn.f_102808_.f_104200_ = 0.0f;
            modelIn.f_102808_.f_104201_ = 0.0f;
            modelIn.f_102808_.f_104202_ = 0.0f;
            modelIn.f_102809_.f_104200_ = 0.0f;
            modelIn.f_102809_.f_104201_ = 0.0f;
            modelIn.f_102809_.f_104202_ = 0.0f;
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
        }

        public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
            ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s1);
                ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
            }
            return resourcelocation;
        }

        protected void setModelSlotVisible(HumanoidModel humanoidModel, EquipmentSlot slotIn) {
            this.setModelVisible(humanoidModel);
            switch (slotIn) {
                case HEAD: {
                    humanoidModel.f_102808_.f_104207_ = true;
                    break;
                }
                case CHEST: {
                    humanoidModel.f_102810_.f_104207_ = true;
                    humanoidModel.f_102811_.f_104207_ = true;
                    humanoidModel.f_102812_.f_104207_ = true;
                    break;
                }
                case LEGS: {
                    humanoidModel.f_102810_.f_104207_ = true;
                    humanoidModel.f_102813_.f_104207_ = true;
                    humanoidModel.f_102814_.f_104207_ = true;
                    break;
                }
                case FEET: {
                    humanoidModel.f_102813_.f_104207_ = true;
                    humanoidModel.f_102814_.f_104207_ = true;
                }
            }
        }

        protected void setModelVisible(HumanoidModel model) {
            model.m_8009_(false);
        }

        protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
            Model basicModel = ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
            return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((CrowModel)this.m_117386_()).body.m_104299_(matrixStack);
            ((CrowModel)this.m_117386_()).body.m_171324_("head").m_104299_(matrixStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CrowPowerLayer
    extends EnergySwirlLayer<CrowEntity, CrowModel<CrowEntity>> {
        private final CrowModel<CrowEntity> model;

        public CrowPowerLayer(RenderLayerParent<CrowEntity, CrowModel<CrowEntity>> p_174471_, EntityModelSet p_174472_) {
            super(p_174471_);
            this.model = new CrowModel(p_174472_.m_171103_(CrowModel.POWER_LAYER_LOCATION));
        }

        protected float m_7631_(float p_116683_) {
            return p_116683_ * 0.01f;
        }

        protected ResourceLocation m_7029_() {
            return POWER_LOCATION;
        }

        protected EntityModel<CrowEntity> m_7193_() {
            return this.model;
        }
    }
}

