/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.item.Item;

public record BroomType(String name, Item item, float speedMultiplier) {
    private static final Set<BroomType> VALUES = new HashSet<BroomType>();

    public static BroomType create(String name, Item item, float speedMultiplier) {
        BroomType broomType = new BroomType(name, item, speedMultiplier);
        VALUES.add(broomType);
        return broomType;
    }

    public static Set<BroomType> getValues() {
        return VALUES;
    }

    public static BroomType byName(String name) {
        for (BroomType type : VALUES) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return (BroomType)VALUES.stream().toList().get(0);
    }

    public static BroomType byId(int id) {
        if (id >= 0 && id < VALUES.size()) {
            return (BroomType)VALUES.stream().toList().get(id);
        }
        return (BroomType)VALUES.stream().toList().get(0);
    }
}

