/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICreativeTabMember;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ForbiddenAxe
extends SwordItem
implements ICreativeTabMember {
    public static Omniconfig.PerhapsParameter beheadingBase;
    public static Omniconfig.PerhapsParameter beheadingBonus;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ForbiddenAxe");
        beheadingBase = builder.comment("Default chance to behead an enemy with Axe of Executioner. Defined as percentage.").max(100.0).getPerhaps("BeheadingBase", 10);
        beheadingBonus = builder.comment("Bonus percantage to beheading chance from each Looting level applied to Axe of Executioner.").max(100.0).getPerhaps("BeheadingBonus", 5);
        builder.popPrefix();
    }

    public ForbiddenAxe() {
        super((Tier)EnigmaticMaterials.FORBIDDEN_AXE, 6, -2.4f, ItemBaseTool.getDefaultProperties().m_41499_(2000).m_41497_(Rarity.EPIC).m_41486_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ICuriosItemHandler handler;
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe2", ChatFormatting.GOLD, beheadingBonus.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        int looting = 0;
        if (worldIn != null) {
            looting = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)stack);
        }
        if (Minecraft.m_91087_().f_91074_ != null && (handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(null)) != null && worldIn != null) {
            looting += handler.getLootingLevel(worldIn.m_269111_().m_269264_(), (LivingEntity)Minecraft.m_91087_().f_91074_, looting);
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxeBeheadingChance", ChatFormatting.GOLD, beheadingBase.getValue().asPercentage() + beheadingBonus.getValue().asPercentage() * looting + "%");
    }

    public boolean m_8096_(BlockState blockIn) {
        return false;
    }

    @Override
    @Nullable
    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.MAIN;
    }
}

