/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.api.capabilities;

import com.aizistral.enigmaticlegacy.api.capabilities.EnigmaticCapabilities;
import com.aizistral.enigmaticlegacy.api.capabilities.IPlaytimeCounter;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPlaytimeCounter
implements IPlaytimeCounter {
    public static final ResourceLocation TIME_WITH_CURSES_STAT = new ResourceLocation("enigmaticlegacy", "play_time_with_seven_curses");
    public static final ResourceLocation TIME_WITHOUT_CURSES_STAT = new ResourceLocation("enigmaticlegacy", "play_time_without_seven_curses");
    private final Player player;
    private long timeWithCurses;
    private long timeWithoutCurses;

    public PlayerPlaytimeCounter(Player player) {
        this.player = player;
    }

    @Override
    public long getTimeWithoutCurses() {
        return this.timeWithoutCurses;
    }

    @Override
    public long getTimeWithCurses() {
        return this.timeWithCurses;
    }

    @Override
    public void setTimeWithoutCurses(long time) {
        if (time != this.timeWithoutCurses) {
            this.updateStat(TIME_WITHOUT_CURSES_STAT, (int)time);
        }
        this.timeWithoutCurses = time;
    }

    @Override
    public void setTimeWithCurses(long time) {
        if (time != this.timeWithCurses) {
            this.updateStat(TIME_WITH_CURSES_STAT, (int)time);
        }
        this.timeWithCurses = time;
    }

    @Override
    public void incrementTimeWithoutCurses() {
        this.updateStat(TIME_WITHOUT_CURSES_STAT, (int)(++this.timeWithoutCurses));
    }

    @Override
    public void incrementTimeWithCurses() {
        this.updateStat(TIME_WITH_CURSES_STAT, (int)(++this.timeWithCurses));
    }

    @Override
    public void matchStats() {
        this.updateStat(TIME_WITH_CURSES_STAT, (int)this.timeWithCurses);
        this.updateStat(TIME_WITHOUT_CURSES_STAT, (int)this.timeWithoutCurses);
    }

    private void updateStat(ResourceLocation stat, int value) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.m_8951_().m_6085_((Player)player2, Stats.f_12988_.m_12902_((Object)stat), value);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("timeWithCurses", this.timeWithCurses);
        tag.m_128356_("timeWithoutCurses", this.timeWithoutCurses);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.timeWithCurses = tag.m_128454_("timeWithCurses");
        this.timeWithoutCurses = tag.m_128454_("timeWithoutCurses");
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IPlaytimeCounter> counter = LazyOptional.of(() -> counter);

        public Provider(Player player) {
            this(new PlayerPlaytimeCounter(player));
        }

        public Provider(IPlaytimeCounter counter) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
            return EnigmaticCapabilities.PLAYTIME_COUNTER.orEmpty(capability, this.counter);
        }

        public CompoundTag serializeNBT() {
            return this.counter.map(IPlaytimeCounter::serializeNBT).orElseGet(CompoundTag::new);
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.counter.ifPresent(counter -> counter.deserializeNBT(nbt));
        }
    }
}

