/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oierbravo.createmechanicalextruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.requirements.BiomeRequirement;
import com.oierbravo.createmechanicalextruder.register.ModRecipes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.Nullable;

public class ExtrudingRecipeBuilder {
    protected ExtrudingRecipeParams params;
    protected List<RecipeRequirement> recipeRequirements;
    protected List<ICondition> recipeConditions;

    public ExtrudingRecipeBuilder(ResourceLocation recipeId) {
        this.params = new ExtrudingRecipeParams(recipeId);
        this.recipeRequirements = new ArrayList<RecipeRequirement>();
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public ExtrudingRecipeBuilder withItemIngredients(Ingredient ... itemIngredients) {
        return this.withItemIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])itemIngredients));
    }

    public ExtrudingRecipeBuilder withItemIngredients(NonNullList<Ingredient> itemIngredients) {
        this.params.itemIngredients = itemIngredients;
        return this;
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(ItemStack output) {
        this.params.result = new ProcessingOutput(output, 1.0f);
        return this;
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(ProcessingOutput output) {
        this.params.result = output;
        return this;
    }

    public ExtrudingRecipeBuilder withCatalyst(ItemStack catalyst) {
        this.params.catalyst = catalyst;
        return this;
    }

    public ExtrudingRecipeBuilder withCatalyst(Item catalyst) {
        this.params.catalyst = new ItemStack((ItemLike)catalyst, 1);
        return this;
    }

    public ExtrudingRecipeBuilder withCatalyst(ItemLike catalyst) {
        this.params.catalyst = new ItemStack(catalyst, 1);
        return this;
    }

    public ExtrudingRecipeBuilder withFluidIngredients(FluidIngredient ... ingredients) {
        return this.withFluidIngredients((NonNullList<FluidIngredient>)NonNullList.m_122783_((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ExtrudingRecipeBuilder withFluidIngredients(NonNullList<FluidIngredient> ingredients) {
        this.params.fluidIngredients = ingredients;
        return this;
    }

    public ExtrudingRecipeBuilder requiredBonks(int requiredBonks) {
        this.params.requiredBonks = requiredBonks;
        return this;
    }

    public ExtrudingRecipe build() {
        return new ExtrudingRecipe(this.params);
    }

    public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        pFinishedRecipeConsumer.accept(this.buildFinishedRecipe());
    }

    private FinishedRecipe buildFinishedRecipe() {
        return new FinishedExtrudingRecipe(this.build(), this.recipeConditions);
    }

    public ExtrudingRecipeBuilder withRequirement(RecipeRequirement requirement) {
        this.params.recipeRequirements.add(requirement);
        return this;
    }

    public ExtrudingRecipeBuilder withBiomeRequirement(BiomeRequirement biomeRequirement) {
        return this.withRequirement(biomeRequirement);
    }

    public ExtrudingRecipeBuilder withRequirements(List<RecipeRequirement> recipeRequirements) {
        recipeRequirements.forEach(this::withRequirement);
        return this;
    }

    public ExtrudingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public ExtrudingRecipeBuilder whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public ExtrudingRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public static class ExtrudingRecipeParams {
        protected ResourceLocation id;
        protected NonNullList<Ingredient> itemIngredients;
        protected ProcessingOutput result;
        protected NonNullList<FluidIngredient> fluidIngredients;
        protected ItemStack catalyst;
        protected int requiredBonks;
        protected BiomeRequirement biome;
        public ArrayList<RecipeRequirement> recipeRequirements;

        protected ExtrudingRecipeParams(ResourceLocation id) {
            assert (id != null);
            this.id = id;
            this.itemIngredients = NonNullList.m_122779_();
            this.result = ProcessingOutput.EMPTY;
            this.fluidIngredients = NonNullList.m_122779_();
            this.catalyst = ItemStack.f_41583_;
            this.requiredBonks = 1;
            this.biome = BiomeRequirement.EMPTY;
            this.recipeRequirements = new ArrayList();
        }
    }

    protected static class FinishedExtrudingRecipe
    implements FinishedRecipe {
        protected ResourceLocation id;
        protected ExtrudingRecipe recipe;
        private List<ICondition> recipeConditions;

        protected FinishedExtrudingRecipe(ExtrudingRecipe pRecipe, List<ICondition> pRecipeConditions) {
            this.recipe = pRecipe;
            this.id = pRecipe.m_6423_();
            this.recipeConditions = pRecipeConditions;
        }

        public void m_7917_(JsonObject pJson) {
            ExtrudingRecipe.Serializer.INSTANCE.toJson(pJson, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            pJson.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.EXTRUDING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

