/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.mojang.math.Axis;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtrudingBehaviour;
import com.oierbravo.createmechanicalextruder.register.ModPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ExtruderVisual
extends KineticBlockEntityVisual<ExtruderBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance extruderPole;
    protected final RotatingInstance shaft;
    final Direction direction;
    private final Direction opposite;

    public ExtruderVisual(VisualizationContext context, ExtruderBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.direction = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        this.opposite = this.direction.m_122424_();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
        this.shaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.extruderPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)ModPartials.MECHANICAL_EXTRUDER_POLE)).createInstance();
        Quaternionf q = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(MechanicalPressBlock.HORIZONTAL_FACING))));
        this.extruderPole.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    private void transformModels(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        this.extruderPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(float pt) {
        ExtrudingBehaviour extrudingBehaviour = ((ExtruderBlockEntity)this.blockEntity).getExtrudingBehaviour();
        return extrudingBehaviour.getRenderedPoleOffset(pt) * extrudingBehaviour.headOffset;
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.extruderPole});
        this.relight(new FlatLit[]{this.shaft});
    }

    protected void _delete() {
        this.extruderPole.delete();
        this.shaft.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.extruderPole);
        consumer.accept((Instance)this.shaft);
    }
}

