/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sirttas.dpanvil.api.codec.CodecHelper;

public class CodecRecipeSerializer<T extends Recipe<?>>
implements RecipeSerializer<T> {
    private final Codec<T> codec;
    private final BiConsumer<T, ResourceLocation> idSetter;

    public CodecRecipeSerializer(Codec<T> codec, BiConsumer<T, ResourceLocation> idSetter) {
        this.codec = codec;
        this.idSetter = idSetter;
    }

    @Nonnull
    public T m_6729_(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Recipe recipe = (Recipe)CodecHelper.decode(this.codec, (JsonElement)json);
        assert (recipe != null);
        this.idSetter.accept(recipe, recipeId);
        return (T)recipe;
    }

    @Nonnull
    public T m_8005_(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Recipe recipe = (Recipe)CodecHelper.decode(this.codec, buffer);
        assert (recipe != null);
        this.idSetter.accept(recipe, recipeId);
        return (T)recipe;
    }

    public void m_6178_(@Nonnull FriendlyByteBuf buffer, @Nonnull T recipe) {
        CodecHelper.encode(this.codec, recipe, buffer);
    }
}

