/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.modules.entities;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.foxmcloud.draconicadditions.lib.DADamage;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.foxmcloud.draconicadditions.modules.data.ChaosInjectorData;
import net.foxmcloud.draconicadditions.modules.data.StableChaosData;
import net.foxmcloud.draconicadditions.modules.entities.StableChaosEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class ChaosInjectorEntity
extends ModuleEntity<ChaosInjectorData>
implements Comparable {
    private static final int maxChaos = 40;
    private static final int hpDrainAmount = 1;
    private static final double shieldDrainDivider = 2.0;
    private static final boolean shieldCooldownWhenInjecting = true;
    private int chaos = 0;
    private boolean isChaotic = false;
    private float storedHP = 0.0f;
    private int prevRate = 0;
    private float prevHP = 1.0f;
    private int warningCountdown = 0;
    private int prevWarningCountdown = 0;
    private IntegerProperty rate;

    public ChaosInjectorEntity(Module<ChaosInjectorData> module) {
        super(module);
        this.rate = new IntegerProperty("chaos_injector.rate", 0).setFormatter(ConfigProperty.IntegerFormatter.RAW).range(-((ChaosInjectorData)module.getData()).getInjectRate(), ((ChaosInjectorData)module.getData()).getInjectRate());
        this.addProperty((ConfigProperty)this.rate);
        this.savePropertiesToItem = true;
    }

    public int getRate() {
        return this.rate.getValue();
    }

    public void tick(ModuleContext context) {
        if (context instanceof StackModuleContext) {
            boolean shouldTickChaos;
            Player player;
            LivingEntity entity;
            StackModuleContext stackContext = (StackModuleContext)context;
            if (!stackContext.isEquipped() && !this.isChaotic) {
                return;
            }
            if (this.warningCountdown > 0) {
                --this.warningCountdown;
            }
            if ((entity = stackContext.getEntity()) instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
                return;
            }
            ShieldControlEntity shield = this.host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
            if (this.getRate() == 0 && this.isChaotic) {
                this.rate.setValue(1);
            }
            boolean bl = shouldTickChaos = !entity.m_9236_().f_46443_ && this.getRate() != 0 && entity.f_19797_ % Math.max(20 / Math.abs(this.getRate()), 1) == 0;
            if (this.getRate() > 0 && shouldTickChaos) {
                if (!this.isChaotic) {
                    if (entity.m_21223_() < 1.0f) {
                        if (!entity.m_9236_().f_46443_) {
                            if (this.modifyChaosInStorage(-1) == -1) {
                                this.modifyChaos(1);
                            } else if (entity instanceof ServerPlayer) {
                                player = (ServerPlayer)entity;
                                player.m_5661_((Component)Component.m_237115_((String)"info.da.chaos_injector.storageEmpty").m_130940_(ChatFormatting.YELLOW), true);
                            }
                        }
                    } else {
                        this.drainBlood(entity, 1.0f);
                    }
                } else if (this.isChaotic && !entity.m_9236_().f_46443_) {
                    this.modifyChaos(1);
                }
            } else if (this.getRate() < 0 && shouldTickChaos) {
                if (!this.isChaotic && this.storedHP > 0.0f) {
                    this.drainBlood(entity, -1.0f);
                } else if (this.isChaotic && !entity.m_9236_().f_46443_) {
                    if (this.modifyChaosInStorage(1) == 1) {
                        this.modifyChaos(-1);
                    } else if (entity instanceof ServerPlayer) {
                        player = (ServerPlayer)entity;
                        StableChaosData allData = (StableChaosData)this.host.getModuleData(DAModuleTypes.STABLE_CHAOS);
                        player.m_5661_((Component)(allData != null && allData.getMaxChaos() > 0 ? Component.m_237115_((String)"info.da.chaos_injector.storageFull").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"info.da.chaos_injector.noStorage").m_130940_(ChatFormatting.RED)), true);
                    } else if (entity instanceof Player) {
                        Player player2 = (Player)entity;
                        player2.m_9236_().m_5594_(player2, player2.m_20183_(), (SoundEvent)DESounds.BEAM.get(), SoundSource.MASTER, 1.0f, 2.0f);
                    }
                    if (this.chaos == 0) {
                        entity.m_21153_(1.0f);
                        if (this.storedHP >= 1.0f) {
                            this.storedHP -= 1.0f;
                        }
                    }
                }
            }
            if (entity instanceof Player && (this.isChaotic || this.getRate() > 0)) {
                ((Player)entity).m_36324_().f_38699_ = 0;
            }
            if (this.isChaotic) {
                double pointsToDrain = (double)this.chaos / 8.0;
                if (shield != null && entity instanceof Player) {
                    double factor;
                    Player player3 = (Player)entity;
                    if (this.warningCountdown <= 0 && (factor = shield.getShieldPoints() / ((double)shield.getShieldCapacity() + 1000.0) * 2.0) <= 1.0 && pointsToDrain > 1.0) {
                        int cooldownAmount = Math.max((int)Math.round(factor * 40.0), 2);
                        float pitch = 1.5f + (float)(1.0 - factor) * 0.5f;
                        this.prevWarningCountdown = cooldownAmount;
                        if (player3.m_9236_().f_46443_) {
                            player3.m_9236_().m_5594_(player3, player3.m_20183_(), (SoundEvent)DESounds.BEAM.get(), SoundSource.MASTER, 1.0f, pitch);
                        } else {
                            ((ServerPlayer)player3).m_5661_((Component)Component.m_237115_((String)"info.da.chaos_injector.shieldLow").m_130940_(ChatFormatting.RED), true);
                        }
                        this.warningCountdown = cooldownAmount;
                    }
                }
                if (entity.m_9236_().f_46443_) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 2, 1, false, false, false));
                    entity.m_21153_((float)this.chaos / 2.0f);
                } else {
                    boolean shouldDie;
                    entity.m_21219_();
                    entity.m_21153_(0.001f);
                    boolean bl2 = shouldDie = !stackContext.isEquipped();
                    if (shield != null) {
                        if (shield.isShieldEnabled()) {
                            if (shield.getShieldPoints() <= pointsToDrain) {
                                shouldDie = true;
                            }
                            shield.subtractShieldPoints(pointsToDrain);
                            shield.setShieldCoolDown(1);
                        } else {
                            shouldDie = true;
                        }
                    } else {
                        shouldDie = true;
                    }
                    if (shouldDie) {
                        Level level = entity.m_9236_();
                        DamageSource damageSource = DADamage.injectionDeath(level);
                        entity.m_21231_().m_289194_(damageSource, 6.805647E37f);
                        DraconicNetwork.sendExplosionEffect((ResourceKey)((ServerLevel)entity.m_9236_()).m_46472_(), (BlockPos)entity.m_20183_(), (int)Math.min(10, this.chaos * 4), (boolean)false);
                        this.chaos = 0;
                        this.isChaotic = false;
                        this.rate.setValue(-1);
                        this.storedHP = 0.0f;
                        this.prevHP = 1.0f;
                        boolean hasActuallyDied = false;
                        int timesToKillEntity = 10;
                        while (!hasActuallyDied && timesToKillEntity-- >= 0) {
                            entity.m_21153_(0.0f);
                            entity.m_6667_(DADamage.injectionDeath(entity.m_9236_()));
                            hasActuallyDied = entity.m_21224_();
                        }
                    }
                }
            }
            if (!this.isChaotic) {
                if (this.getRate() <= 0) {
                    this.prevHP = entity.m_21223_();
                }
                if (this.getRate() < 0 && entity.m_21223_() <= 1.0f && entity.m_9236_().f_46443_) {
                    entity.m_6234_(MobEffects.f_19615_);
                }
                if (this.getRate() > 0) {
                    entity.m_21153_(this.prevHP);
                    if (entity instanceof Player) {
                        Player player4 = (Player)entity;
                        if (this.warningCountdown <= 0) {
                            int cooldownAmount = Math.max(Math.round(this.prevHP + 2.0f), 4);
                            float pitch = 1.5f + (1.0f - this.prevHP / entity.m_21233_()) * 0.5f;
                            this.prevWarningCountdown = cooldownAmount;
                            if (shield == null) {
                                if (player4.m_9236_().f_46443_) {
                                    player4.m_9236_().m_5594_(player4, player4.m_20183_(), (SoundEvent)DESounds.BEAM.get(), SoundSource.MASTER, 1.0f, pitch);
                                } else {
                                    ((ServerPlayer)player4).m_5661_((Component)Component.m_237115_((String)"info.da.chaos_injector.noShield").m_130940_(ChatFormatting.RED), true);
                                }
                                this.warningCountdown = cooldownAmount;
                            } else if (!shield.isShieldEnabled()) {
                                if (player4.m_9236_().f_46443_) {
                                    player4.m_9236_().m_5594_(player4, player4.m_20183_(), (SoundEvent)DESounds.BEAM.get(), SoundSource.MASTER, 1.0f, pitch);
                                } else {
                                    ((ServerPlayer)player4).m_5661_((Component)Component.m_237115_((String)"info.da.chaos_injector.shieldDisabled").m_130940_(ChatFormatting.RED), true);
                                }
                                this.warningCountdown = cooldownAmount;
                            } else if (shield.getShieldPoints() < 750.0) {
                                if (!player4.m_9236_().f_46443_) {
                                    ((ServerPlayer)player4).m_5661_((Component)Component.m_237115_((String)"info.da.chaos_injector.shieldCapacityLow").m_130940_(ChatFormatting.YELLOW), true);
                                }
                                this.prevWarningCountdown = this.warningCountdown = 20;
                            }
                        }
                    }
                }
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player5 = (ServerPlayer)entity;
                if (this.warningCountdown == this.prevWarningCountdown / 2) {
                    player5.m_5661_((Component)Component.m_237115_((String)""), true);
                }
            }
            this.prevRate = this.rate.getValue();
        }
    }

    private float drainBlood(LivingEntity entity, float amount) {
        float prevHP = entity.m_21223_();
        if (prevHP <= 1.0f && amount > 0.0f) {
            amount = entity.m_21223_() - 0.001f;
        }
        entity.m_21153_(entity.m_21223_() - Math.max(amount, -this.storedHP));
        float removedHP = prevHP - entity.m_21223_();
        this.storedHP += removedHP;
        this.prevHP = entity.m_21223_();
        return removedHP;
    }

    private int modifyChaosInStorage(int amount) {
        int chaosToModify = amount;
        StableChaosData allData = (StableChaosData)this.host.getModuleData(DAModuleTypes.STABLE_CHAOS);
        if (allData != null && allData.getMaxChaos() > 0) {
            Stream chaosEntities = this.host.getEntitiesByType(DAModuleTypes.STABLE_CHAOS);
            ArrayList<StableChaosEntity> sortedChaosEntities = StableChaosEntity.getSortedListFromStream(chaosEntities);
            for (StableChaosEntity ce : sortedChaosEntities) {
                StableChaosData data = (StableChaosData)ce.getModule().getData();
                if (chaosToModify > 0 && ce.getChaos() < data.getMaxChaos() || chaosToModify < 0 && ce.getChaos() > 0) {
                    chaosToModify -= ce.modifyChaos(chaosToModify);
                }
                if (chaosToModify != 0) continue;
                break;
            }
        }
        return amount - chaosToModify;
    }

    public int getChaos() {
        return this.chaos;
    }

    public float getStoredHP() {
        return this.storedHP;
    }

    public boolean isChaosInBlood() {
        return this.isChaotic;
    }

    public int modifyChaos(int amount) {
        int chaosToMod;
        if (amount >= 0) {
            this.isChaotic = true;
            chaosToMod = Math.min(40 - this.chaos, amount);
        } else {
            chaosToMod = Math.max(-this.chaos, amount);
        }
        this.chaos += chaosToMod;
        if (this.chaos <= 0) {
            this.isChaotic = false;
        }
        return chaosToMod;
    }

    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        super.writeToItemStack(stack, context);
        stack.m_41784_().m_128405_("chaos", this.chaos);
        stack.m_41784_().m_128379_("injecting", this.isChaotic);
        stack.m_41784_().m_128350_("storedHP", this.storedHP);
        stack.m_41784_().m_128350_("prevRate", (float)this.prevRate);
        stack.m_41784_().m_128350_("prevHP", this.prevHP);
        stack.m_41784_().m_128405_("warningCountdown", this.warningCountdown);
        stack.m_41784_().m_128405_("prevWarningCountdown", this.prevWarningCountdown);
    }

    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        super.readFromItemStack(stack, context);
        if (stack.m_41782_()) {
            this.chaos = stack.m_41784_().m_128451_("chaos");
            this.isChaotic = stack.m_41784_().m_128471_("injecting");
            this.storedHP = stack.m_41784_().m_128457_("storedHP");
            this.prevRate = stack.m_41784_().m_128451_("prevRate");
            this.prevHP = stack.m_41784_().m_128457_("prevHP");
            this.warningCountdown = stack.m_41784_().m_128451_("warningCountdown");
            this.prevWarningCountdown = stack.m_41784_().m_128451_("prevWarningCountdown");
        }
    }

    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("chaos", this.chaos);
        compound.m_128379_("injecting", this.isChaotic);
        compound.m_128350_("storedHP", this.storedHP);
        compound.m_128350_("prevRate", (float)this.prevRate);
        compound.m_128350_("prevHP", this.prevHP);
        compound.m_128405_("warningCountdown", this.warningCountdown);
        compound.m_128405_("prevWarningCountdown", this.prevWarningCountdown);
    }

    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.chaos = compound.m_128451_("chaos");
        this.isChaotic = compound.m_128471_("injecting");
        this.storedHP = compound.m_128457_("storedHP");
        this.prevRate = compound.m_128451_("prevRate");
        this.prevHP = compound.m_128457_("prevHP");
        this.warningCountdown = compound.m_128451_("warningCountdown");
        this.prevWarningCountdown = compound.m_128451_("prevWarningCountdown");
    }

    public int compareTo(@NotNull Object o) {
        ChaosInjectorData data = (ChaosInjectorData)this.module.getData();
        ChaosInjectorData otherData = (ChaosInjectorData)((ChaosInjectorEntity)o).getModule().getData();
        return data.getInjectRate() - otherData.getInjectRate();
    }

    public boolean moduleClicked(Player player, double x, double y, int button, ClickType clickType) {
        boolean cantInteract;
        boolean bl = cantInteract = this.isChaotic || this.getRate() > 0;
        if (cantInteract && player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            sPlayer.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.cantmove", (Object[])new Object[]{Component.m_237115_((String)"item.draconicadditions.chaos_injector_module").getString()}).m_130940_(ChatFormatting.RED), true);
        }
        return cantInteract;
    }

    public static ChaosInjectorEntity getInjectorEntity(LivingEntity entity) {
        List items = EquipmentManager.findItems(e -> e.m_41720_() instanceof IModularItem, (LivingEntity)entity);
        for (ItemStack stack : items) {
            ModuleHost host;
            ArrayList<ChaosInjectorEntity> entities;
            IModularItem item = (IModularItem)stack.m_41720_();
            LazyOptional cap = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
            if (!cap.isPresent() || (entities = ChaosInjectorEntity.getSortedListFromStream((host = (ModuleHost)cap.orElseThrow(IllegalStateException::new)).getEntitiesByType(DAModuleTypes.CHAOS_INJECTOR))).isEmpty()) continue;
            return entities.get(0);
        }
        return null;
    }

    public static ArrayList<ChaosInjectorEntity> getSortedListFromStream(Stream<ModuleEntity<?>> chaosEntities) {
        ArrayList<ChaosInjectorEntity> orderedInjectorEntities = new ArrayList<ChaosInjectorEntity>();
        chaosEntities.forEach(entity -> orderedInjectorEntities.add((ChaosInjectorEntity)entity));
        Collections.sort(orderedInjectorEntities);
        return orderedInjectorEntities;
    }
}

