/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.armor;

import codechicken.lib.item.SimpleArmorMaterial;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.LimitedModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.equipment.IDEEquipment;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.items.armor.InfusedPotatoArmorChest;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class InfusedPotatoArmor
extends ArmorItem
implements IModularItem,
IDEEquipment {
    protected static final TechLevel techLevel = TechLevel.WYVERN;
    protected ArmorItem.Type slotType;
    protected static final SimpleArmorMaterial armorMat = new SimpleArmorMaterial(new int[]{-1, -1, -1, -1}, new int[]{1, 1, 2, 1}, 0, SoundEvents.f_11678_, () -> Ingredient.f_43901_, "draconicadditions:infused_potato_armor", 0.0f, 0.0f);

    public InfusedPotatoArmor(Item.Properties props, ArmorItem.Type slotType) {
        super((ArmorMaterial)armorMat, slotType, props);
        this.slotType = slotType;
    }

    public TechLevel getTechLevel() {
        return techLevel;
    }

    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(techLevel, this.slotType == ArmorItem.Type.CHESTPLATE ? 2 : 1, this.slotType == ArmorItem.Type.CHESTPLATE ? 2 : 1, "infused", false, new ModuleCategory[0]);
        if (this.slotType == ArmorItem.Type.CHESTPLATE) {
            host.addModule(((Module)DEModules.WYVERN_SHIELD_CONTROL.get()).createEntity(), (ModuleContext)new LimitedModuleContext(ItemStack.f_41583_, null, null, null));
        } else {
            host.addModule(((Module)DEModules.WYVERN_SHIELD_RECOVERY.get()).createEntity(), (ModuleContext)new LimitedModuleContext(ItemStack.f_41583_, null, null, null));
        }
        host.setRemoveCheck((a, b) -> false);
        return host;
    }

    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        long capacity = (long)(432000.0 * DAConfig.infusedCapacityMultiplier);
        ModularOPStorage storage = new ModularOPStorage((ModuleHost)host, capacity, 0L, capacity / 64L);
        storage.setExtractOnly();
        storage.modifyEnergyStored(capacity);
        return storage;
    }

    public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        super.handleTick(stack, entity, slot, inEquipModSlot);
        LazyOptional energy = stack.getCapability(DECapabilities.OP_STORAGE);
        if (energy.isPresent()) {
            ItemStack chest;
            IOPStorage energyHost = (IOPStorage)energy.orElseThrow(IllegalStateException::new);
            if (energyHost.getOPStored() <= 1L) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    this.breakArmor(player, stack);
                }
            } else if (!(stack.m_41720_() instanceof InfusedPotatoArmorChest) && !(chest = InfusedPotatoArmorChest.getChestpiece(entity)).m_41619_()) {
                LazyOptional chestEnergy = chest.getCapability(DECapabilities.OP_STORAGE);
                if (energy.isPresent()) {
                    IOPStorage chestEnergyHost = (IOPStorage)chestEnergy.orElseThrow(IllegalStateException::new);
                    long energyDiff = energyHost.getOPStored() - chestEnergyHost.getOPStored();
                    if (energyDiff > 1L) {
                        chestEnergyHost.modifyEnergyStored(energyDiff / 2L);
                        energyHost.modifyEnergyStored(-energyDiff / 2L);
                        if (energyHost.getOPStored() < 1000L && entity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            this.breakArmor(player, stack);
                        }
                    }
                }
            }
        }
    }

    protected void breakArmor(ServerPlayer player, ItemStack stack) {
        player.m_213846_((Component)Component.m_237110_((String)"info.da.infusedArmor.break", (Object[])new Object[]{stack.m_41786_().getString()}));
        ItemStack draconiumDust = ((Item)DEContent.DUST_DRACONIUM.get()).m_7968_();
        draconiumDust.m_41764_(4);
        player.m_150109_().m_36054_(draconiumDust);
        player.m_150109_().m_36057_(stack);
    }

    public void initCapabilities(ItemStack stack, ModuleHostImpl host, MultiCapabilityProvider provider) {
        EquipmentManager.addCaps((ItemStack)stack, (MultiCapabilityProvider)provider);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }
}

