/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.handlers;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.event.ModularItemInitEvent;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.client.gui.modular.ModularItemGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import java.util.ArrayList;
import java.util.Arrays;
import net.covers1624.quack.util.SneakyUtils;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.items.IChaosContainer;
import net.foxmcloud.draconicadditions.items.curios.ModularHarness;
import net.foxmcloud.draconicadditions.items.tools.ChaosContainer;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.foxmcloud.draconicadditions.modules.entities.ChaosInjectorEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DAEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean handsAreEmpty;
        Level world = event.getLevel();
        if (world.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        boolean bl = handsAreEmpty = player.m_21205_().m_41619_() && player.m_21206_().m_41619_();
        if (!(handsAreEmpty && player.m_6144_() && event.getPos().m_203195_((Position)player.m_20182_(), 2.0))) {
            return;
        }
        ISlotType backSlot = (ISlotType)CuriosApi.getSlotHelper().getSlotType(SlotTypePreset.BACK.getIdentifier()).get();
        IDynamicStackHandler stackHandler = ((ICurioStacksHandler)((ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null)).getStacksHandler(backSlot.getIdentifier()).get()).getStacks();
        if (stackHandler.getSlots() == 0) {
            return;
        }
        ItemStack harness = ItemStack.f_41583_;
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            if (!(stackHandler.getStackInSlot(i).m_41720_() instanceof ModularHarness)) continue;
            harness = stackHandler.getStackInSlot(i);
            break;
        }
        if (harness.equals(ItemStack.f_41583_)) {
            return;
        }
        BlockPos abovePos = event.getPos().m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        if (ModularHarness.hasAttachedBlockEntity(harness, world)) {
            if (event.getFace() != Direction.UP || aboveState.m_60734_() != Blocks.f_50016_) {
                return;
            }
            Vec2 pRot = player.m_20155_();
            Vec2 rotation = new Vec2(-pRot.f_82470_, pRot.f_82471_ + 180.0f);
            String blockName = ModularHarness.getAttachedName(harness);
            if (CommonMethods.BlockStorage.restoreBlockFromTag(world, abovePos, rotation, harness.m_41783_(), true, true)) {
                player.m_5661_((Component)Component.m_237110_((String)"info.da.modular_harness.placeSuccess", (Object[])new Object[]{blockName}), true);
                event.setCanceled(true);
            }
        } else if (world.m_8055_(event.getPos()).m_155947_()) {
            if (ModularHarness.storeBlockEntity(world, event.getPos(), harness, (LivingEntity)player, true)) {
                player.m_5661_((Component)Component.m_237110_((String)"info.da.modular_harness.storeSuccess", (Object[])new Object[]{ModularHarness.getAttachedName(harness)}), true);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public boolean chaosInjectionDeath(LivingDeathEvent event) {
        ChaosInjectorEntity injector = ChaosInjectorEntity.getInjectorEntity(event.getEntity());
        if (injector != null && injector.isChaosInBlood()) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public boolean blockHealingWhenInjecting(LivingHealEvent event) {
        ChaosInjectorEntity injector = ChaosInjectorEntity.getInjectorEntity(event.getEntity());
        if (injector != null && (injector.getRate() > 0 || injector.isChaosInBlood())) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public boolean blockShieldDamageWhenInjecting(LivingAttackEvent event) {
        ChaosInjectorEntity injector = ChaosInjectorEntity.getInjectorEntity(event.getEntity());
        if (injector != null && injector.isChaosInBlood()) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public boolean blockShieldDamageWhenInjecting(LivingDamageEvent event) {
        ChaosInjectorEntity injector = ChaosInjectorEntity.getInjectorEntity(event.getEntity());
        if (injector != null && injector.isChaosInBlood()) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void blockChaosItemMoving(ScreenEvent.MouseButtonPressed.Pre event) {
        if (!(event.getScreen() instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen inventory = (AbstractContainerScreen)event.getScreen();
        Slot slot = inventory.getSlotUnderMouse();
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.m_7993_();
        if (stack == null) {
            return;
        }
        if ((inventory instanceof ModularItemGui.Screen || inventory instanceof ConfigurableItemGui.Screen) && event.getButton() != 1) {
            return;
        }
        Minecraft mc = inventory.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (stack.m_41720_() instanceof ChaosContainer && !player.m_7500_() && ((ChaosContainer)stack.m_41720_()).getChaos(stack) > 0) {
            player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.cantmove", (Object[])new Object[]{stack.m_41786_()}), true);
            event.setCanceled(true);
        } else if (stack.m_41720_() instanceof IModularArmor && !player.m_7500_()) {
            LazyOptional cap = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
            if (!cap.isPresent()) {
                return;
            }
            ModuleHost host = (ModuleHost)cap.orElseThrow(IllegalStateException::new);
            ArrayList<ChaosInjectorEntity> entities = ChaosInjectorEntity.getSortedListFromStream(host.getEntitiesByType(DAModuleTypes.CHAOS_INJECTOR));
            if (entities.isEmpty()) {
                return;
            }
            if (entities.get(0) != null && (entities.get(0).isChaosInBlood() || entities.get(0).getRate() > 0)) {
                player.m_5661_((Component)Component.m_237110_((String)"info.da.chaos.cantmove", (Object[])new Object[]{stack.m_41786_()}), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void addCategoriesToContainers(ModularItemInitEvent e) {
        ItemStack stack;
        ArrayList<Item> validChaosContainers = new ArrayList<Item>(Arrays.asList((Item)DEContent.AXE_CHAOTIC.get(), (Item)DEContent.BOW_CHAOTIC.get(), (Item)DEContent.CHESTPIECE_CHAOTIC.get(), (Item)DEContent.PICKAXE_CHAOTIC.get(), (Item)DEContent.SHOVEL_CHAOTIC.get(), (Item)DEContent.STAFF_CHAOTIC.get(), (Item)DEContent.SWORD_CHAOTIC.get()));
        if (validChaosContainers.contains((stack = e.getStack()).m_41720_())) {
            ModuleHostImpl host = (ModuleHostImpl)SneakyUtils.unsafeCast((Object)e.getHost());
            host.addCategories(new ModuleCategory[]{IChaosContainer.CHAOS_CONTAINER});
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinLevelEvent e) {
        if (!(e.getEntity() instanceof ItemEntity)) {
            return;
        }
        ItemEntity entity = (ItemEntity)e.getEntity();
        ItemStack stack = entity.m_32055_();
        if (stack.m_41720_() != DEContent.DRAGON_HEART.get()) {
            return;
        }
        CompoundTag nbt = entity.getPersistentData();
        if (nbt != null && nbt.m_128441_("guardian_heart") && nbt.m_128471_("guardian_heart")) {
            entity.m_32045_(((Item)DAContent.chaosHeart.get()).m_7968_());
        }
    }
}

