/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.datagen;

import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import javax.annotation.Nonnull;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.lib.DAModules;
import net.foxmcloud.draconicadditions.modules.DAModuleTypes;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class LangGenerator
extends LanguageProvider {
    public LangGenerator(PackOutput gen) {
        super(gen, "draconicadditions", "en_us");
    }

    private void blocks(PrefixHelper helper) {
        helper.add((Block)DAContent.chaosLiquifier.get(), "Chaos Liquifier");
        helper.add((Block)DAContent.chaosInfuser.get(), "Chaos Infuser");
        helper.add((Block)DAContent.chaosExtractor.get(), "Chaos Extractor");
        helper.add((Block)DAContent.chaosCrystalizer.get(), "Chaos Crystalizer");
    }

    private void items(PrefixHelper helper) {
        helper.setPrefix("item.draconicadditions");
        helper.add((Item)DAContent.chaosHeart.get(), "Chaos Heart");
        helper.add((Item)DAContent.inertPotatoHelm.get(), "Inert Potato Helmet");
        helper.add((Item)DAContent.inertPotatoChest.get(), "Inert Potato Chestplate");
        helper.add((Item)DAContent.inertPotatoLegs.get(), "Inert Potato Leggings");
        helper.add((Item)DAContent.inertPotatoBoots.get(), "Inert Potato Boots");
        helper.add((Item)DAContent.infusedPotatoHelm.get(), "Infused Potato Helmet");
        helper.add((Item)DAContent.infusedPotatoChest.get(), "Infused Potato Chestplate");
        helper.add((Item)DAContent.infusedPotatoLegs.get(), "Infused Potato Leggings");
        helper.add((Item)DAContent.infusedPotatoBoots.get(), "Infused Potato Boots");
        helper.add((Item)DAContent.chaosContainer.get(), "Chaos Container");
        helper.add((Item)DAContent.necklaceWyvern.get(), "Wyvern Necklace");
        helper.add((Item)DAContent.necklaceDraconic.get(), "Draconic Necklace");
        helper.add((Item)DAContent.necklaceChaotic.get(), "Chaotic Necklace");
        helper.add((Item)DAContent.harnessWyvern.get(), "Wyvern Harness");
        helper.add((Item)DAContent.harnessDraconic.get(), "Draconic Harness");
        helper.add((Item)DAContent.harnessChaotic.get(), "Chaotic Harness");
        helper.add((Item)DAContent.hermal.get(), "hermal");
        helper.add("hermal.desc", "hermal?");
    }

    private void itemGroups(PrefixHelper helper) {
        helper.setPrefix("itemGroup.draconicadditions");
        helper.add("items", "Draconic Additions");
    }

    private void modules(PrefixHelper helper) {
        helper.setPrefix("module.draconicadditions");
        helper.add((Module)DAModules.chaoticAutoFeed.get(), "Chaotic Auto Feed Module");
        helper.add(DAModuleTypes.TICK_ACCEL, "Tick Accelerator");
        helper.add((Module)DAModules.draconicTickAccel.get(), "Draconic Tick Accelerator");
        helper.add((Module)DAModules.chaoticTickAccel.get(), "Chaotic Tick Accelerator");
        helper.add("tick_accel.name", "Additional Ticks");
        helper.add("tick_accel.value", "%s Ticks");
        helper.add(DAModuleTypes.STABLE_CHAOS, "Chaos Stabilizer");
        helper.add((Module)DAModules.semiStableChaos.get(), "Semi-Stable Chaos Holder");
        helper.add((Module)DAModules.stableChaos.get(), "Stable Chaos Holder");
        helper.add((Module)DAModules.unstableChaos.get(), "Unstable Chaos Holder");
        helper.add("maxChaos.name", "Max Chaos Stored");
        helper.add("maxChaos.value", "%s mB");
        helper.add("maxInstability.name", "Instability");
        helper.add("maxInstability.value", "%s%%");
        helper.add(DAModuleTypes.CHAOS_INJECTOR, "Chaos Injection System");
        helper.add((Module)DAModules.chaosInjector.get(), "Chaos Injector");
        helper.add("chaos_injector.name", "Rate of Injection");
        helper.add("chaos_injector.value", "%s Hearts");
    }

    private void gui(PrefixHelper helper) {
        helper.setPrefix("gui.draconicadditions");
        helper.add("chaos_liquifier", "Chaos Liquifier");
        helper.add("chaos_liquifier.chaosSlot.hover", "Accepts Chaos Shards.");
        helper.add("chaos_infuser", "Chaos Infuser");
        helper.add("chaos_infuser.chaosSlot.hover", "Accepts Dragon Hearts and any modular item with a Chaos Stabilizer Module.");
        helper.add("chaos_extractor", "Chaos Extractor");
        helper.add("chaos_extractor.chaosSlot.hover", "Accepts Chaos Hearts and any modular item with a Chaos Stabilizer Module.");
        helper.add("chaos_crystalizer", "Chaos Crystalizer");
        helper.add("chaos_crystalizer.chaosSlot.hover", "Chaos Shards will crystalize here when enough LC is present.");
    }

    private void info(PrefixHelper helper) {
        helper.setPrefix("info.da");
        helper.add("storedChaos", "Stored Chaos: %s / %s mB");
        helper.add("maxChaos", "Max Chaos: %s B");
        helper.add("maxChaosInfo", "Accepts shield modules.");
        helper.add("chaos.noShield", "The Chaos Container requires shield boosting modules to operate.");
        helper.add("chaos.xfer.to", "Transferred %s mB to %s");
        helper.add("chaos.xfer.from", "Transferred %s mB from %s");
        helper.add("chaos.warning", "WARNING: Your %s is on the verge of exploding!");
        helper.add("chaos.explode", "The %s explodes in your hand!");
        helper.add("chaos.cantdrop", "Dropping this %s seems like a very bad idea right now.");
        helper.add("chaos.cantmove", "Moving this %s seems like a very bad idea right now.");
        helper.add("chaos_injector.noShield", "WARNING: No shield detected!");
        helper.add("chaos_injector.noStorage", "WARNING: You cannot inject or vent chaos without Chaos Holder Modules!");
        helper.add("chaos_injector.storageEmpty", "WARNING: Injection failed! Cause: No chaos found in Chaos Holder Modules.");
        helper.add("chaos_injector.storageFull", "WARNING: Unable to vent chaos; your Chaos Holder Modules are full!");
        helper.add("chaos_injector.shieldDisabled", "WARNING: Your shield is disabled!");
        helper.add("chaos_injector.shieldCapacityLow", "WARNING: Your shield might not be high enough to survive injection!");
        helper.add("chaos_injector.shieldLow", "WARNING: Your shielding is getting low!");
        helper.add("hermal.lore", "pls no eat");
        helper.add("hermal.craft", "Ultimate power in something so seemingly mundane.");
        helper.add("hermal.eat.attempt", "This seems like a bad idea...");
        helper.add("hermal.eat.success", "No one contests the power of hermal.");
        helper.add("infusedArmor.break", "Your %s breaks apart as the last of the energy reserves give out!");
        helper.add("instability", "Current Instability: %s%%");
        helper.add("modular_harness.cantmove", "This block doesn't seem to budge...");
        helper.add("modular_harness.storeSuccess", "You place the %s into your harness.");
        helper.add("modular_harness.placeSuccess", "You take the %s off of your harness and set it back down.");
        helper.add("modular_harness.storedBlock", "Currently Stored: ");
        helper.add("opCost", "OP Cost: %s OP/t");
    }

    private void deaths(PrefixHelper helper) {
        helper.setPrefix("death.attack");
        helper.add("chaos_injection", "%s exploded in a gory mess when trying to play with powers beyond their control");
    }

    private void itemProps(PrefixHelper helper) {
        helper.setPrefix("item_prop.draconicevolution");
        helper.add("receive_energy_from_machine", "Receive RF From Machine");
        helper.add("tick_accel.speed", "Additional Ticks");
        helper.add("chaos_injector.rate", "Blood | Injection Rate | Chaos");
    }

    protected void addTranslations() {
        PrefixHelper helper = new PrefixHelper(this);
        this.blocks(helper);
        this.items(helper);
        this.itemGroups(helper);
        this.modules(helper);
        this.gui(helper);
        this.info(helper);
        this.deaths(helper);
        this.itemProps(helper);
    }

    public void add(Block key, String name) {
        if (key != null) {
            super.add(key, name);
        }
    }

    public void add(Item key, String name) {
        if (key != null) {
            super.add(key, name);
        }
    }

    public static class PrefixHelper {
        private LangGenerator generator;
        private String prefix;

        public PrefixHelper(LangGenerator generator) {
            this.generator = generator;
        }

        public void setPrefix(@Nonnull String prefix) {
            this.prefix = prefix + (prefix == "" ? "" : ".");
        }

        public void add(String translationKey, String translation) {
            this.generator.add(this.prefix + translationKey, translation);
        }

        public void add(Block key, String name) {
            if (key != null) {
                this.generator.add(key, name);
            }
        }

        public void add(Item key, String name) {
            if (key != null) {
                this.generator.add(key, name);
            }
        }

        public void add(ModuleType<?> key, String name) {
            this.generator.add("module_type.draconicevolution." + key.getName() + ".name", name);
        }

        public void add(Module<?> key, String name) {
            this.generator.add(key.getItem(), name);
        }
    }
}

