/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual.rituals;

import com.google.gson.JsonObject;
import elucent.rootsclassic.ritual.RitualEffect;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualSummoning
extends RitualEffect<RitualSummoningConfig> {
    @Override
    public void doEffect(Level levelAccessor, BlockPos pos, Container inventory, List<ItemStack> incenses, RitualSummoningConfig config) {
        Entity toSpawn;
        if (!levelAccessor.f_46443_ && (toSpawn = config.entityType.m_20615_(levelAccessor)) != null) {
            if (toSpawn instanceof Mob) {
                Mob mob = (Mob)toSpawn;
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)levelAccessor;
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)sl, (DifficultyInstance)levelAccessor.m_6436_(pos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                }
            }
            toSpawn.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5);
            inventory.m_6211_();
            levelAccessor.m_7967_(toSpawn);
            BlockEntity tile = levelAccessor.m_7702_(pos);
            if (tile != null) {
                tile.m_6596_();
            }
        }
    }

    @Override
    public MutableComponent getInfoText(RitualSummoningConfig config) {
        SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(config.entityType);
        if (egg == null) {
            return Component.m_237119_();
        }
        return Component.m_237110_((String)"rootsclassic.jei.tooltip.summoning", (Object[])new Object[]{config.entityType.m_20676_()});
    }

    @Override
    public ItemStack getResult(RitualSummoningConfig config) {
        SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(config.entityType);
        if (egg == null) {
            return super.getResult(config);
        }
        MutableComponent display = this.getInfoText(config);
        return new ItemStack((ItemLike)egg).m_41714_((Component)display.m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false))));
    }

    @Override
    public RitualSummoningConfig fromJSON(JsonObject object) {
        String id = GsonHelper.m_13906_((JsonObject)object, (String)"entity");
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id));
        return new RitualSummoningConfig(type);
    }

    @Override
    public void toNetwork(RitualSummoningConfig config, FriendlyByteBuf buffer) {
        buffer.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(config.entityType));
    }

    @Override
    public RitualSummoningConfig fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
        return new RitualSummoningConfig(type);
    }

    public record RitualSummoningConfig(EntityType<?> entityType) {
    }
}

