/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelRegistryHelper {
    private final List<Pair<ModelResourceLocation, BakedModel>> registerModels = new LinkedList<Pair<ModelResourceLocation, BakedModel>>();

    public ModelRegistryHelper() {
        this(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public ModelRegistryHelper(IEventBus eventBus) {
        eventBus.register((Object)this);
    }

    public void register(ModelResourceLocation location, BakedModel model) {
        this.registerModels.add((Pair<ModelResourceLocation, BakedModel>)new ImmutablePair((Object)location, (Object)model));
    }

    @SubscribeEvent
    public void onModelBake(ModelEvent.ModifyBakingResult event) {
        for (Pair<ModelResourceLocation, BakedModel> pair : this.registerModels) {
            event.getModels().put((ResourceLocation)pair.getKey(), (BakedModel)pair.getValue());
        }
    }
}

