/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LootTableProvider
implements DataProvider {
    private static final Logger logger = LogManager.getLogger();
    private final PackOutput.PathProvider output;
    protected final String modId;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    protected LootTableProvider(PackOutput output, String modId) {
        this.output = output.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.modId = modId;
    }

    public CompletableFuture<Void> m_213708_(CachedOutput cache) {
        this.tables.clear();
        this.registerTables();
        ValidationContext validator = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){

            public <T> T m_278667_(LootDataId<T> pId) {
                return null;
            }
        });
        this.tables.forEach((name, table) -> table.m_79136_(validator));
        Multimap problems = validator.m_79352_();
        if (!problems.isEmpty()) {
            logger.warn("Problems detected for LootTableGenerator: " + this.m_6055_());
            problems.forEach((name, table) -> logger.warn("Found validation problem in {}: {}", name, table));
            throw new IllegalStateException("Failed to validate loot tables, see logs.");
        }
        LinkedList futures = new LinkedList();
        this.tables.forEach((name, table) -> {
            Path output = this.output.m_245731_(name);
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(table), (Path)output));
        });
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    protected abstract void registerTables();

    protected void registerTable(ResourceLocation name, LootTable table) {
        if (this.tables.put(name, table) != null) {
            throw new IllegalArgumentException("Duplicate loot table registered: " + name);
        }
    }

    public static abstract class BlockLootProvider
    extends LootTableProvider {
        protected static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        protected static final LootItemCondition.Builder NO_SILK_TOUCH = SILK_TOUCH.m_81807_();

        protected BlockLootProvider(PackOutput output, String modId) {
            super(output, modId);
        }

        protected LootPool.Builder singleItem(ItemLike item) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
        }

        protected LootPool.Builder singleItemOr(ItemLike failDrop, LootItemCondition.Builder condition, LootPoolEntryContainer.Builder<?> passDrop) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)failDrop).m_79080_(condition)).m_7170_(passDrop));
        }

        protected LootPool.Builder singleItemOrSilk(ItemLike silk, LootPoolSingletonContainer.Builder<?> drop) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootPoolEntryContainer.Builder<?>)drop);
        }

        protected LootPool.Builder singleItemOrSilk(ItemLike silk, ItemLike drop) {
            return this.singleItemOrSilk(silk, LootItem.m_79579_((ItemLike)drop));
        }

        protected LootPool.Builder valueRange(ItemLike item, int min, int max) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))));
        }

        protected LootPool.Builder valueRangeOrSilk(ItemLike silk, ItemLike drop, int min, int max) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootPoolEntryContainer.Builder<?>)LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))));
        }

        protected LootPool.Builder valueRangeOrSilkWithFortune(ItemLike silk, ItemLike drop, int min, int max) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootPoolEntryContainer.Builder<?>)LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)));
        }

        protected void register(Block block, LootPool.Builder ... pools) {
            LootTable.Builder builder = LootTable.m_79147_();
            for (LootPool.Builder pool : pools) {
                builder.m_79161_(pool);
            }
            this.register(block, builder);
        }

        public void register(Block block, LootTable.Builder builder) {
            this.register(ForgeRegistries.BLOCKS.getKey((Object)block), builder);
        }

        protected void register(ResourceLocation name, LootTable.Builder builder) {
            this.registerTable(new ResourceLocation(name.m_135827_(), "blocks/" + name.m_135815_()), builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }

        public String m_6055_() {
            return this.modId + " Block Loot Tables";
        }
    }
}

