/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.RegistryEntries;
import org.cyclops.commoncapabilities.api.capability.block.BlockCapabilities;
import org.cyclops.commoncapabilities.api.capability.block.IBlockCapabilityConstructor;
import org.cyclops.commoncapabilities.api.capability.block.IBlockCapabilityProvider;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.capability.recipehandler.RecipeHandlerConfig;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemFrameEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFrameFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaBlockComposterItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemFrameItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaItemBundleItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaItemShulkerBoxItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaBrewingStandRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaAbstractFurnaceTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaCampfireTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaUniversalBucketTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaAbstractFurnaceWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaBrewingStandWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaCampfireWorker;
import org.cyclops.cyclopscore.modcompat.ICompatInitializer;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class VanillaModCompat
implements IModCompat {
    public String getId() {
        return "minecraft";
    }

    public boolean isEnabledDefault() {
        return true;
    }

    public String getComment() {
        return "Furnace and Brewing stand capabilities.";
    }

    public ICompatInitializer createInitializer() {
        return () -> {
            CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
            registry.registerTile(FurnaceBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, FurnaceBlockEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(FurnaceBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceWorker((AbstractFurnaceBlockEntity)host));
                }
            });
            registry.registerTile(BlastFurnaceBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, BlastFurnaceBlockEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BlastFurnaceBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceWorker((AbstractFurnaceBlockEntity)host));
                }
            });
            registry.registerTile(SmokerBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, SmokerBlockEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(SmokerBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceWorker((AbstractFurnaceBlockEntity)host));
                }
            });
            registry.registerTile(BrewingStandBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, BrewingStandBlockEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(BrewingStandBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaBrewingStandWorker(host));
                }
            });
            registry.registerTile(CampfireBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, CampfireBlockEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(CampfireBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaCampfireWorker(host));
                }
            });
            registry.registerTile(FurnaceBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, FurnaceBlockEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(FurnaceBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceTemperature((AbstractFurnaceBlockEntity)host));
                }
            });
            registry.registerTile(BlastFurnaceBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, BlastFurnaceBlockEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BlastFurnaceBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceTemperature((AbstractFurnaceBlockEntity)host));
                }
            });
            registry.registerTile(SmokerBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, SmokerBlockEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(SmokerBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceTemperature((AbstractFurnaceBlockEntity)host));
                }
            });
            registry.registerTile(CampfireBlockEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, CampfireBlockEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(CampfireBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaCampfireTemperature(host));
                }
            });
            registry.registerItem(BucketItem.class, (ICapabilityConstructor)new ICapabilityConstructor<ITemperature, BucketItem, ItemStack>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(BucketItem hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaUniversalBucketTemperature(host));
                }
            });
            ICapabilityConstructor<IItemHandler, Item, ItemStack> shulkerboxConstructor = new ICapabilityConstructor<IItemHandler, Item, ItemStack>(){

                public Capability<IItemHandler> getCapability() {
                    return ForgeCapabilities.ITEM_HANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(Item hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaItemShulkerBoxItemHandler(host));
                }
            };
            registry.registerItem(() -> RegistryEntries.ITEM_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_WHITE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_ORANGE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_MAGENTA_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIGHT_BLUE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_YELLOW_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIME_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_PINK_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_GRAY_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIGHT_GRAY_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_CYAN_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_PURPLE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BLUE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BROWN_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_GREEN_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_RED_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BLACK_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BUNDLE, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, Item, ItemStack>(){

                public Capability<IItemHandler> getCapability() {
                    return ForgeCapabilities.ITEM_HANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(Item hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaItemBundleItemHandler(host));
                }
            });
            registry.registerEntity(ItemEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, ItemEntity, ItemEntity>(){

                public Capability<IItemHandler> getCapability() {
                    return ForgeCapabilities.ITEM_HANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemEntity hostType, final ItemEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == ForgeCapabilities.ITEM_HANDLER && host.m_32055_().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemItemHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemFrame.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, ItemFrame, ItemFrame>(){

                public Capability<IItemHandler> getCapability() {
                    return ForgeCapabilities.ITEM_HANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemFrame hostType, final ItemFrame host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == ForgeCapabilities.ITEM_HANDLER && host.m_31822_().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFrameItemHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return Blocks.f_50715_;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                                return LazyOptional.of(() -> new VanillaBlockComposterItemHandler(blockState, (LevelAccessor)world, pos, facing)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IFluidHandler, ItemEntity, ItemEntity>(){

                public Capability<IFluidHandler> getCapability() {
                    return ForgeCapabilities.FLUID_HANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemEntity hostType, final ItemEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == ForgeCapabilities.FLUID_HANDLER && host.m_32055_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFluidHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemFrame.class, (ICapabilityConstructor)new ICapabilityConstructor<IFluidHandler, ItemFrame, ItemFrame>(){

                public Capability<IFluidHandler> getCapability() {
                    return ForgeCapabilities.FLUID_HANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemFrame hostType, final ItemFrame host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == ForgeCapabilities.FLUID_HANDLER && host.m_31822_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFrameFluidHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IEnergyStorage, ItemEntity, ItemEntity>(){

                public Capability<IEnergyStorage> getCapability() {
                    return ForgeCapabilities.ENERGY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemEntity hostType, final ItemEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == ForgeCapabilities.ENERGY && host.m_32055_().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemEnergyStorage(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemFrame.class, (ICapabilityConstructor)new ICapabilityConstructor<IEnergyStorage, ItemFrame, ItemFrame>(){

                public Capability<IEnergyStorage> getCapability() {
                    return ForgeCapabilities.ENERGY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemFrame hostType, final ItemFrame host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == ForgeCapabilities.ENERGY && host.m_31822_().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFrameEnergyStorage(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerTile(BrewingStandBlockEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, BrewingStandBlockEntity, BrewingStandBlockEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BrewingStandBlockEntity hostType, BrewingStandBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)VanillaBrewingStandRecipeHandler.getInstance());
                }
            });
            registry.registerTile(FurnaceBlockEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, FurnaceBlockEntity, FurnaceBlockEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(FurnaceBlockEntity hostType, FurnaceBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((FurnaceBlockEntity)host).m_58904_(), RecipeType.f_44108_, size -> size == 1, true, false));
                }
            });
            registry.registerTile(BlastFurnaceBlockEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, BlastFurnaceBlockEntity, BlastFurnaceBlockEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BlastFurnaceBlockEntity hostType, BlastFurnaceBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((BlastFurnaceBlockEntity)host).m_58904_(), RecipeType.f_44109_, size -> size == 1, true, false));
                }
            });
            registry.registerTile(SmokerBlockEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, SmokerBlockEntity, SmokerBlockEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(SmokerBlockEntity hostType, SmokerBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((SmokerBlockEntity)host).m_58904_(), RecipeType.f_44110_, size -> size == 1, true, false));
                }
            });
            registry.registerTile(CampfireBlockEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, CampfireBlockEntity, CampfireBlockEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(CampfireBlockEntity hostType, CampfireBlockEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((CampfireBlockEntity)host).m_58904_(), RecipeType.f_44111_, size -> size == 1, true, false));
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return Blocks.f_50679_;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (capability == RecipeHandlerConfig.CAPABILITY) {
                                return LazyOptional.of(() -> new VanillaRecipeTypeRecipeHandler(() -> (Level)world, RecipeType.f_44112_, size -> size == 1, true, true)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return Blocks.f_50625_;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (capability == RecipeHandlerConfig.CAPABILITY) {
                                return LazyOptional.of(() -> new VanillaRecipeTypeRecipeHandler(() -> (Level)world, RecipeType.f_44113_, size -> size == 1, true, false)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return null;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (blockState.m_60734_() instanceof CraftingTableBlock && capability == RecipeHandlerConfig.CAPABILITY) {
                                return LazyOptional.of(() -> new VanillaRecipeTypeRecipeHandler(() -> (Level)world, RecipeType.f_44107_, size -> size > 0, false, false)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
        };
    }
}

